/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.view;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vg.lib.common.SplineInterpolator;
import vg.lib.model.graphics.VertexGraphics;

public class GraphViewUtils {
    private static final Logger log = LoggerFactory.getLogger(GraphViewUtils.class);
    private static final double epsilon = 1.0E-9;

    public static Point toMinimapCoordinate(Point pos, Point minimapSize, Point graphViewSize) {
        int x = Math.round((float)minimapSize.x * (float)pos.x / (float)graphViewSize.x);
        int y = Math.round((float)minimapSize.y * (float)pos.y / (float)graphViewSize.y);
        return new Point(x, y);
    }

    public static EdgeLabelPlacement calculateEdgeBoundingBoxAndLabelOffset(List<Point> points, int labelWidth, int labelHeight) {
        int i;
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        double totalLength = 0.0;
        ArrayList<Double> segmentLengths = new ArrayList<Double>();
        for (i = 0; i < points.size(); ++i) {
            Point p = points.get(i);
            minX = Math.min(minX, p.x);
            minY = Math.min(minY, p.y);
            maxX = Math.max(maxX, p.x);
            maxY = Math.max(maxY, p.y);
        }
        for (i = 0; i < points.size() - 1; ++i) {
            Point p1 = points.get(i);
            Point p2 = points.get(i + 1);
            double dx = p2.x - p1.x;
            double dy = p2.y - p1.y;
            double length = Math.hypot(dx, dy);
            segmentLengths.add(length);
            totalLength += length;
        }
        double halfLength = totalLength / 2.0;
        double accumulated = 0.0;
        Point midpoint = null;
        for (int i2 = 0; i2 < segmentLengths.size(); ++i2) {
            double segmentLength = (Double)segmentLengths.get(i2);
            Point p1 = points.get(i2);
            Point p2 = points.get(i2 + 1);
            if (accumulated + segmentLength >= halfLength) {
                double remaining = halfLength - accumulated;
                double ratio = remaining / segmentLength;
                int midX = (int)((double)p1.x + (double)(p2.x - p1.x) * ratio);
                int midY = (int)((double)p1.y + (double)(p2.y - p1.y) * ratio);
                midpoint = new Point(midX, midY);
                break;
            }
            accumulated += segmentLength;
        }
        Rectangle boundingBox = new Rectangle(minX, minY, maxX - minX, maxY - minY);
        if (midpoint != null) {
            int labelX = midpoint.x - labelWidth / 2;
            int labelY = midpoint.y - labelHeight / 2 - 6;
            int labelRight = labelX + labelWidth;
            int labelBottom = labelY + labelHeight;
            int newMinX = Math.min(boundingBox.x, labelX);
            int newMinY = Math.min(boundingBox.y, labelY);
            int newMaxX = Math.max(boundingBox.x + boundingBox.width, labelRight);
            int newMaxY = Math.max(boundingBox.y + boundingBox.height, labelBottom);
            boundingBox = new Rectangle(newMinX, newMinY, newMaxX - newMinX, newMaxY - newMinY);
        }
        Point labelOffset = midpoint != null ? new Point(midpoint.x - boundingBox.x - labelWidth / 2, midpoint.y - boundingBox.y - labelHeight / 2 - 6) : new Point(boundingBox.width / 2 - labelWidth / 2, boundingBox.height / 2 - labelHeight / 2 - 6);
        return new EdgeLabelPlacement(boundingBox, labelOffset);
    }

    public static VertexBoundingBoxAndLabelOffset calculateVertexBoundingBoxAndLabelOffset(VertexGraphics.ShapeType vertexShapeType, int border, int labelWidth, int labelHeight, VertexGraphics.LabelAlignment labelAlignment, Rectangle existingBoundingBox) {
        Rectangle boundingBox;
        return new VertexBoundingBoxAndLabelOffset(boundingBox, switch (vertexShapeType) {
            case VertexGraphics.ShapeType.CIRCLE -> {
                int paddedWidth = labelWidth + 2 * border;
                int paddedHeight = labelHeight + 2 * border;
                double percent = 1.05;
                int diameter = (int)Math.ceil(Math.sqrt(paddedWidth * paddedWidth + paddedHeight * paddedHeight) * percent);
                diameter = Math.max(diameter, Math.max(existingBoundingBox.width, existingBoundingBox.height));
                boundingBox = new Rectangle(existingBoundingBox.x, existingBoundingBox.y, diameter, diameter);
                yield new Point((diameter - labelWidth) / 2, (diameter - labelHeight) / 2);
            }
            case VertexGraphics.ShapeType.DIAMOND -> {
                double angleRadians = Math.toRadians(30.0);
                double percent = 1.05;
                double paddedWidth = (double)(labelWidth + 2 * border) * percent;
                double paddedHeight = (double)(labelHeight + 2 * border) * percent;
                double diagonalX = paddedWidth + paddedHeight / Math.tan(angleRadians);
                double diagonalY = diagonalX * Math.tan(angleRadians);
                int width = Math.max(existingBoundingBox.width, (int)Math.ceil(diagonalX));
                int height = Math.max(existingBoundingBox.height, (int)Math.ceil(diagonalY));
                if (width % 2 == 0) {
                    ++width;
                }
                if (height % 2 == 0) {
                    ++height;
                }
                boundingBox = new Rectangle(existingBoundingBox.x, existingBoundingBox.y, width, height);
                yield new Point((width - labelWidth) / 2, (height - labelHeight) / 2);
            }
            default -> {
                int width = Math.max(labelWidth + 2 * border, existingBoundingBox.width);
                int height = Math.max(labelHeight + 2 * border, existingBoundingBox.height);
                boundingBox = new Rectangle(existingBoundingBox.x, existingBoundingBox.y, width, height);
                if (Objects.requireNonNull(labelAlignment) == VertexGraphics.LabelAlignment.CENTER) {
                    yield new Point((width - labelWidth) / 2, (height - labelHeight) / 2);
                }
                yield new Point(border, border);
            }
        });
    }

    public static Point findPointOnVertexShape(DirectionType direction, VertexGraphics.ShapeType vertexShapeType, Rectangle boundingBox, Point externalPoint) {
        switch (vertexShapeType) {
            case DIAMOND: {
                int centerX = boundingBox.x + boundingBox.width / 2;
                int centerY = boundingBox.y + boundingBox.height / 2;
                double dx = externalPoint.x - centerX;
                double dy = externalPoint.y - centerY;
                double length = Math.sqrt(dx * dx + dy * dy);
                double dirX = dx / length;
                double dirY = dy / length;
                int halfWidth = boundingBox.width / 2;
                int halfHeight = boundingBox.height / 2;
                double scale = 1.0 / (Math.abs(dirX) / (double)halfWidth + Math.abs(dirY) / (double)halfHeight);
                int intersectX = (int)Math.round((double)centerX + dirX * scale);
                int intersectY = (int)Math.round((double)centerY + dirY * scale);
                return new Point(intersectX, intersectY);
            }
            case CIRCLE: {
                double centerX = (double)boundingBox.x + (double)boundingBox.width / 2.0;
                double centerY = (double)boundingBox.y + (double)boundingBox.height / 2.0;
                double radius = (double)boundingBox.width / 2.0;
                double dx = (double)externalPoint.x - centerX;
                double dy = (double)externalPoint.y - centerY;
                double length = Math.sqrt(dx * dx + dy * dy);
                if (length < radius - 1.0E-9) {
                    return externalPoint;
                }
                switch (direction) {
                    case VERTICAL: {
                        dy = Math.sqrt(radius * radius - dx * dx);
                        int intersectY = (double)externalPoint.y < centerY ? (int)Math.round(centerY - dy) : (int)Math.round(centerY + dy);
                        return new Point(externalPoint.x, intersectY);
                    }
                }
                double scale = radius / length;
                int intersectX = (int)Math.round(centerX + dx * scale);
                int intersectY = (int)Math.round(centerY + dy * scale);
                return new Point(intersectX, intersectY);
            }
        }
        int centerX = boundingBox.x + boundingBox.width / 2;
        int centerY = boundingBox.y + boundingBox.height / 2;
        double dx = externalPoint.x - centerX;
        double dy = externalPoint.y - centerY;
        double length = Math.sqrt(dx * dx + dy * dy);
        if (length == 0.0) {
            return new Point(centerX, centerY);
        }
        double dirX = dx / length;
        double dirY = dy / length;
        int halfWidth = boundingBox.width / 2;
        int halfHeight = boundingBox.height / 2;
        double scale = 1.0 / Math.max(Math.abs(dirX) / (double)halfWidth, Math.abs(dirY) / (double)halfHeight);
        int intersectX = (int)Math.round((double)centerX + dirX * scale);
        int intersectY = (int)Math.round((double)centerY + dirY * scale);
        return new Point(intersectX, intersectY);
    }

    public static boolean arePointsTooClose(Point a, Point b, int minDistancePixels) {
        int dx = b.x - a.x;
        int dy = b.y - a.y;
        int distanceSquared = dx * dx + dy * dy;
        return distanceSquared <= minDistancePixels * minDistancePixels;
    }

    public static List<Point> splineInterpolation(List<Point> points) {
        List<Point> re = points;
        try {
            re = GraphViewUtils.doSplineInterpolation(points);
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return re;
    }

    public static List<Point> doSplineInterpolation(List<Point> points) {
        ArrayList<Float> xPoints = new ArrayList<Float>(points.size());
        ArrayList<Float> yPoints = new ArrayList<Float>(points.size());
        for (int i = 0; i < points.size() - 1; ++i) {
            Point p1 = points.get(i);
            Point p2 = points.get(i + 1);
            float h = p2.y - p1.y;
            if (h > 0.0f) {
                xPoints.add(Float.valueOf(p1.y));
                yPoints.add(Float.valueOf(p1.x));
            }
            if (i != points.size() - 2) continue;
            xPoints.add(Float.valueOf(p2.y));
            yPoints.add(Float.valueOf(p2.x));
        }
        SplineInterpolator interpolator = SplineInterpolator.createMonotoneCubicSpline(xPoints, yPoints);
        int xPrev = Integer.MIN_VALUE;
        ArrayList<Point> result = new ArrayList<Point>();
        for (int i = 0; i < points.size() - 1; ++i) {
            Point p1 = points.get(i);
            Point p2 = points.get(i + 1);
            for (int j = 0; j <= 5; ++j) {
                boolean ignore = false;
                float xy = (float)p1.y + (float)(j * (p2.y - p1.y)) / 5.0f;
                int x = Math.round(interpolator.interpolate(xy));
                if (xPrev == x && j != 0 && j != 5) {
                    ignore = true;
                }
                int yPrev = Math.round(xy);
                xPrev = x;
                if (ignore) continue;
                result.add(new Point(xPrev, yPrev));
            }
        }
        return result;
    }

    public record EdgeLabelPlacement(Rectangle boundingBox, Point labelOffset) {
    }

    public record VertexBoundingBoxAndLabelOffset(Rectangle boundingBox, Point labelOffset) {
    }

    public static enum DirectionType {
        FROM_CENTER,
        VERTICAL;

    }
}

