/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.view;

import javax.swing.SwingUtilities;
import lombok.NonNull;
import vg.lib.storage.GraphStorage;
import vg.lib.view.GraphViewCachedCanvas;
import vg.lib.view.GraphViewCanvas;
import vg.lib.view.GraphViewComponent;

public class GraphViewFactory {
    public static GraphViewCanvas buildGraphViewCanvas(@NonNull String graphName) {
        if (graphName == null) {
            throw new NullPointerException("graphName is marked non-null but is null");
        }
        return new GraphViewCanvas(graphName);
    }

    public static GraphViewCanvas buildGraphViewCanvas(@NonNull GraphStorage graphStorage, int graphModelId) {
        if (graphStorage == null) {
            throw new NullPointerException("graphStorage is marked non-null but is null");
        }
        return new GraphViewCanvas(graphStorage, graphModelId);
    }

    public static GraphViewCachedCanvas buildGraphViewCachedCanvas(@NonNull GraphStorage graphStorage, int graphModelId) {
        if (graphStorage == null) {
            throw new NullPointerException("graphStorage is marked non-null but is null");
        }
        return new GraphViewCachedCanvas(graphStorage, graphModelId);
    }

    public static GraphViewComponent buildGraphViewComponent(@NonNull String graphName) {
        if (graphName == null) {
            throw new NullPointerException("graphName is marked non-null but is null");
        }
        if (SwingUtilities.isEventDispatchThread()) {
            return new GraphViewComponent(graphName);
        }
        try {
            GraphViewComponent[] graphViewHolder = new GraphViewComponent[1];
            SwingUtilities.invokeAndWait(() -> {
                graphViewHolder[0] = new GraphViewComponent(graphName);
            });
            return graphViewHolder[0];
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static GraphViewComponent buildGraphViewComponent(@NonNull GraphViewCachedCanvas graphViewCanvas) {
        if (graphViewCanvas == null) {
            throw new NullPointerException("graphViewCanvas is marked non-null but is null");
        }
        if (SwingUtilities.isEventDispatchThread()) {
            return new GraphViewComponent(graphViewCanvas);
        }
        try {
            GraphViewComponent[] graphViewHolder = new GraphViewComponent[1];
            SwingUtilities.invokeAndWait(() -> {
                graphViewHolder[0] = new GraphViewComponent(graphViewCanvas);
            });
            return graphViewHolder[0];
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

