/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vg.lib.common.JsonUtils;
import vg.lib.config.VGConfigSettings;
import vg.lib.config.VGModifierKeyConfig;
import vg.lib.model.graphics.EdgeGraphics;
import vg.lib.model.graphics.VertexGraphics;
import vg.lib.model.record.AttributeOwnerType;
import vg.lib.model.record.ElementType;
import vg.lib.storage.GraphStorage;
import vg.lib.view.GraphViewCachedCanvas;
import vg.lib.view.GraphViewCanvas;

public class GraphViewComponent
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(GraphViewComponent.class);
    private final GraphViewCanvas canvas;
    private final JComponent canvasView;
    private final JScrollPane canvasViewScrollPane;
    private final SelectionOverlay canvasViewSelectionOverlay;
    private final JLayeredPane layeredPane;
    private final JPanel controlsPanel;
    private Point viewportOffset;
    private Dimension viewportSize;
    private final UUID id = UUID.randomUUID();

    public GraphViewComponent(@NonNull String graphName) {
        this(new GraphViewCachedCanvas(graphName));
        if (graphName == null) {
            throw new NullPointerException("graphName is marked non-null but is null");
        }
    }

    public GraphViewComponent(@NonNull GraphViewCachedCanvas graphViewCanvas) {
        if (graphViewCanvas == null) {
            throw new NullPointerException("graphViewCanvas is marked non-null but is null");
        }
        this.canvas = graphViewCanvas;
        this.canvasView = new JComponent(){

            @Override
            protected void paintComponent(Graphics g) {
                BufferedImage scaledCanvasImage = GraphViewComponent.this.canvas.getScaledCanvasImage(GraphViewComponent.this.viewportOffset.x, GraphViewComponent.this.viewportOffset.y, GraphViewComponent.this.viewportSize.width, GraphViewComponent.this.viewportSize.height);
                g.drawImage(scaledCanvasImage, GraphViewComponent.this.viewportOffset.x, GraphViewComponent.this.viewportOffset.y, GraphViewComponent.this.viewportOffset.x + GraphViewComponent.this.viewportSize.width, GraphViewComponent.this.viewportOffset.y + GraphViewComponent.this.viewportSize.height, 0, 0, GraphViewComponent.this.viewportSize.width, GraphViewComponent.this.viewportSize.height, this);
                GraphViewCanvas.FindElementsResult selectedElements = GraphViewComponent.this.canvasViewSelectionOverlay.getSelectedElements();
                if (selectedElements == null) {
                    return;
                }
                int imageScalePercent = GraphViewComponent.this.canvas.getOrSetImageScalePercent();
                Graphics2D g2 = (Graphics2D)g;
                Stroke oldStroke = g2.getStroke();
                Object oldHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                for (VertexGraphics vertex : selectedElements.getSortedVertices().values()) {
                    Rectangle screenBounds = this.toScreen(vertex.getBoundingBox(), imageScalePercent);
                    GraphViewCanvas.drawVertexHighlighting(g2, screenBounds, VGConfigSettings.GRAPH_VIEW_VERTEX_DEFAULT_SELECT_HIGHLIGHTING_COLOR);
                }
                for (EdgeGraphics edge : selectedElements.getSortedEdges().values()) {
                    List<Point> screenPoints = this.toScreen(edge.getPoints(), imageScalePercent);
                    GraphViewCanvas.drawEdgeHighlighting(g2, screenPoints, VGConfigSettings.GRAPH_VIEW_EDGE_DEFAULT_SELECT_HIGHLIGHTING_COLOR);
                }
                g2.setStroke(oldStroke);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
            }

            @Override
            public Dimension getPreferredSize() {
                int imageScalePercent = GraphViewComponent.this.canvas.getOrSetImageScalePercent();
                return GraphViewCanvas.getScaledCanvasSize(GraphViewComponent.this.canvas.getCanvasSize(), imageScalePercent);
            }

            private Rectangle toScreen(Rectangle rectangle, int imageScalePercent) {
                double scale = (double)imageScalePercent / 100.0;
                int screenX = (int)((double)rectangle.x * scale);
                int screenY = (int)((double)rectangle.y * scale);
                int screenW = (int)((double)rectangle.width * scale);
                int screenH = (int)((double)rectangle.height * scale);
                return new Rectangle(screenX, screenY, screenW, screenH);
            }

            private List<Point> toScreen(List<Point> points, int imageScalePercent) {
                if (points == null) {
                    return List.of();
                }
                double scale = (double)imageScalePercent / 100.0;
                ArrayList<Point> screenPoints = new ArrayList<Point>(points.size());
                for (Point point : points) {
                    int screenX = (int)((double)point.x * scale);
                    int screenY = (int)((double)point.y * scale);
                    screenPoints.add(new Point(screenX, screenY));
                }
                return screenPoints;
            }
        };
        this.canvasViewScrollPane = new JScrollPane(this.canvasView);
        this.canvasViewScrollPane.getVerticalScrollBar().setUnitIncrement(18);
        this.canvasViewScrollPane.getHorizontalScrollBar().setUnitIncrement(24);
        final AtomicReference latestTaskIdOnSelectRef = new AtomicReference();
        this.canvasViewSelectionOverlay = new SelectionOverlay(this.canvasView, this.canvasViewScrollPane, selectionRectangle -> {
            final UUID taskId = UUID.randomUUID();
            latestTaskIdOnSelectRef.set(taskId);
            new SwingWorker<GraphViewCanvas.FindElementsResult, Void>(){

                @Override
                protected GraphViewCanvas.FindElementsResult doInBackground() {
                    if (!Objects.equals(latestTaskIdOnSelectRef.get(), taskId)) {
                        this.logSkipSelectionTask();
                        return null;
                    }
                    int imageScalePercent = GraphViewComponent.this.canvas.getOrSetImageScalePercent();
                    double normalizedScale = (double)imageScalePercent / 100.0;
                    int originalX = (int)((double)selectionRectangle.x / normalizedScale);
                    int originalY = (int)((double)selectionRectangle.y / normalizedScale);
                    int originalWidth = (int)((double)selectionRectangle.width / normalizedScale);
                    int originalHeight = (int)((double)selectionRectangle.height / normalizedScale);
                    GraphViewCanvas.SelectionMode selectionMode = GraphViewCanvas.SelectionMode.REPLACE;
                    if (VGModifierKeyConfig.getInstance().isCtrlPressed() || VGModifierKeyConfig.getInstance().isCommandPressed()) {
                        selectionMode = GraphViewCanvas.SelectionMode.ADD_OR_REMOVE;
                    }
                    if (VGModifierKeyConfig.getInstance().isShiftPressed()) {
                        selectionMode = GraphViewCanvas.SelectionMode.ADD;
                    }
                    return GraphViewComponent.this.canvas.findElements(originalX, originalY, originalWidth, originalHeight, selectionMode);
                }

                @Override
                protected void done() {
                    if (!Objects.equals(latestTaskIdOnSelectRef.get(), taskId)) {
                        this.logSkipSelectionTask();
                        return;
                    }
                    GraphViewComponent.this.canvasViewSelectionOverlay.updateSelectedElements((GraphViewCanvas.FindElementsResult)this.get());
                }

                private void logSkipSelectionTask() {
                    if (VGConfigSettings.DIAGNOSTIC_MODE) {
                        log.debug("Skip selection task: outdated \u2014 rectangle[x={}, y={}, w={}, h={}].", new Object[]{selectionRectangle.x, selectionRectangle.y, selectionRectangle.width, selectionRectangle.height});
                    }
                }
            }.execute();
        }, findElementsResult -> new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                List selectedVertexGlobalIds = Optional.ofNullable(findElementsResult).map(GraphViewCanvas.FindElementsResult::getVertexGlobalIds).orElse(null);
                List selectedEdgeGlobalIds = Optional.ofNullable(findElementsResult).map(GraphViewCanvas.FindElementsResult::getEdgeGlobalIds).orElse(null);
                GraphViewComponent.this.canvas.selectElements(selectedVertexGlobalIds, selectedEdgeGlobalIds);
                return null;
            }

            @Override
            protected void done() {
                GraphViewComponent.this.updateUI();
            }
        }.execute());
        this.canvasViewScrollPane.getViewport().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Point viewportOffset = GraphViewComponent.this.canvasViewScrollPane.getViewport().getViewPosition();
                Dimension viewportSize = GraphViewComponent.this.canvasViewScrollPane.getViewport().getExtentSize();
                int viewportWidth = viewportSize.width;
                int viewportHeight = viewportSize.height;
                JScrollBar hBar = GraphViewComponent.this.canvasViewScrollPane.getHorizontalScrollBar();
                JScrollBar vBar = GraphViewComponent.this.canvasViewScrollPane.getVerticalScrollBar();
                int imageScalePercent = GraphViewComponent.this.canvas.getOrSetImageScalePercent();
                Dimension preferredSize = GraphViewCanvas.getScaledCanvasSize(GraphViewComponent.this.canvas.getCanvasSize(), imageScalePercent);
                hBar.setMaximum(preferredSize.width);
                vBar.setMaximum(preferredSize.height);
                hBar.setVisibleAmount(viewportWidth);
                vBar.setVisibleAmount(viewportHeight);
                GraphViewComponent.this.setViewport(viewportOffset, viewportSize);
            }
        });
        this.canvasViewScrollPane.getHorizontalScrollBar().addAdjustmentListener(e -> {
            Point viewportOffset = this.canvasViewScrollPane.getViewport().getViewPosition();
            Dimension viewportSize = this.canvasViewScrollPane.getViewport().getExtentSize();
            this.setViewport(viewportOffset, viewportSize);
            this.repaint();
            this.canvasViewSelectionOverlay.updateSelection();
        });
        this.canvasViewScrollPane.getVerticalScrollBar().addAdjustmentListener(e -> {
            Point viewportOffset = this.canvasViewScrollPane.getViewport().getViewPosition();
            Dimension viewportSize = this.canvasViewScrollPane.getViewport().getExtentSize();
            this.setViewport(viewportOffset, viewportSize);
            this.repaint();
            this.canvasViewSelectionOverlay.updateSelection();
        });
        this.canvasView.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    MouseEvent converted = SwingUtilities.convertMouseEvent(GraphViewComponent.this.canvasView, e, GraphViewComponent.this);
                    GraphViewComponent.this.dispatchEvent(converted);
                    return;
                }
                GraphViewComponent.this.canvasViewSelectionOverlay.startSelection(e.getPoint());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    MouseEvent converted = SwingUtilities.convertMouseEvent(GraphViewComponent.this.canvasView, e, GraphViewComponent.this);
                    GraphViewComponent.this.dispatchEvent(converted);
                    return;
                }
                GraphViewComponent.this.canvasViewSelectionOverlay.finishSelection();
            }
        });
        this.canvasView.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    MouseEvent converted = SwingUtilities.convertMouseEvent(GraphViewComponent.this.canvasView, e, GraphViewComponent.this);
                    GraphViewComponent.this.dispatchEvent(converted);
                    return;
                }
                GraphViewComponent.this.canvasViewSelectionOverlay.updateSelection(e.getPoint());
            }
        });
        this.controlsPanel = new JPanel(new FlowLayout(2));
        this.controlsPanel.setOpaque(false);
        Dimension controlPanelButtonSize = new Dimension(32, 32);
        JButton controlPanelZoomIn = new JButton("+");
        controlPanelZoomIn.setPreferredSize(controlPanelButtonSize);
        controlPanelZoomIn.addActionListener(e -> this.zoomIn());
        JButton controlPanelZoomOut = new JButton("-");
        controlPanelZoomOut.setPreferredSize(controlPanelButtonSize);
        controlPanelZoomOut.addActionListener(e -> this.zoomOut());
        JButton controlPanelReset = new JButton("\u27f3");
        controlPanelReset.setPreferredSize(controlPanelButtonSize);
        controlPanelReset.addActionListener(e -> this.zoomReset());
        this.controlsPanel.add(controlPanelZoomIn);
        this.controlsPanel.add(controlPanelZoomOut);
        this.controlsPanel.add(controlPanelReset);
        this.layeredPane = new JLayeredPane();
        this.layeredPane.setLayout(null);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                GraphViewComponent.this.updateBounds();
            }
        });
        this.layeredPane.add((Component)this.canvasViewScrollPane, JLayeredPane.DEFAULT_LAYER);
        this.layeredPane.add((Component)this.canvasViewSelectionOverlay, JLayeredPane.PALETTE_LAYER);
        this.layeredPane.add((Component)this.controlsPanel, JLayeredPane.MODAL_LAYER);
        this.setLayout(new BorderLayout());
        this.add((Component)this.layeredPane, "Center");
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.updateBounds();
    }

    private void updateBounds() {
        if (this.layeredPane == null) {
            return;
        }
        this.layeredPane.setBounds(0, 0, this.getWidth(), this.getHeight());
        this.canvasViewScrollPane.setBounds(0, 0, this.getWidth(), this.getHeight());
        this.canvasViewSelectionOverlay.setBounds(0, 0, this.getWidth(), this.getHeight());
        int controlPanelX = Math.max(0, this.getWidth() - this.controlsPanel.getPreferredSize().width - 15);
        this.controlsPanel.setBounds(controlPanelX, 15, this.controlsPanel.getPreferredSize().width, this.controlsPanel.getPreferredSize().height);
        this.canvasView.revalidate();
    }

    private void setViewport(Point viewportOffset, Dimension viewportSize) {
        this.viewportOffset = viewportOffset;
        this.viewportSize = viewportSize;
    }

    public void scrollToElement(final UUID elementId, final ElementType elementType) {
        new SwingWorker<Point, Void>(){

            @Override
            protected Point doInBackground() {
                int graphModelId = GraphViewComponent.this.canvas.getGraphModelId();
                GraphStorage graphStorage = GraphViewComponent.this.canvas.getGraphStorage();
                Rectangle boundingBox = null;
                if (elementType == ElementType.VERTEX) {
                    boundingBox = GraphViewComponent.this.canvas.getGraphStorage().findVertexRecord(graphModelId, elementId).flatMap(it -> graphStorage.findAttributeRecordByOwnerAndName(graphModelId, it.getId(), AttributeOwnerType.VERTEX, "system_vertex_graphics")).map(it -> JsonUtils.fromJson(it.getStringValue(), VertexGraphics.class)).map(VertexGraphics::getBoundingBox).orElse(null);
                } else if (elementType == ElementType.EDGE) {
                    boundingBox = GraphViewComponent.this.canvas.getGraphStorage().findEdgeRecord(graphModelId, elementId).flatMap(it -> graphStorage.findAttributeRecordByOwnerAndName(graphModelId, it.getId(), AttributeOwnerType.EDGE, "system_edge_graphics")).map(it -> JsonUtils.fromJson(it.getStringValue(), EdgeGraphics.class)).map(EdgeGraphics::getBoundingBox).orElse(null);
                }
                if (boundingBox == null) {
                    return null;
                }
                int originalVertexX = boundingBox.x;
                int originalVertexY = boundingBox.y;
                int originalVertexWidth = boundingBox.width;
                int originalVertexHeight = boundingBox.height;
                int originalCenterX = originalVertexX + originalVertexWidth / 2;
                int originalCenterY = originalVertexY + originalVertexHeight / 2;
                int imageScalePercent = GraphViewComponent.this.canvas.getOrSetImageScalePercent();
                double normalizedScale = (double)imageScalePercent / 100.0;
                int x = (int)((double)originalCenterX * normalizedScale);
                int y = (int)((double)originalCenterY * normalizedScale);
                int scrollX = x - GraphViewComponent.this.viewportSize.width / 2;
                int scrollY = y - GraphViewComponent.this.viewportSize.height / 2;
                scrollX = Math.max(scrollX, 0);
                scrollY = Math.max(scrollY, 0);
                log.debug("Scroll viewport to {}: {}, scrollX={}, scrollY={}.", new Object[]{elementType, elementId, scrollX, scrollY});
                return new Point(scrollX, scrollY);
            }

            @Override
            protected void done() {
                Point scroll = (Point)this.get();
                if (scroll == null) {
                    return;
                }
                GraphViewComponent.this.canvasViewScrollPane.getViewport().setViewPosition(scroll);
            }
        }.execute();
    }

    public void zoomIn() {
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                int imageScalePercent = GraphViewComponent.this.canvas.getOrSetImageScalePercent();
                GraphViewComponent.this.canvas.updateImageScalePercent(imageScalePercent + 10);
                return null;
            }

            @Override
            protected void done() {
                GraphViewComponent.this.canvasView.revalidate();
                GraphViewComponent.this.updateUI();
            }
        }.execute();
    }

    public void zoomOut() {
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                int imageScalePercent = GraphViewComponent.this.canvas.getOrSetImageScalePercent();
                GraphViewComponent.this.canvas.updateImageScalePercent(imageScalePercent - 10);
                return null;
            }

            @Override
            protected void done() {
                GraphViewComponent.this.canvasView.revalidate();
                GraphViewComponent.this.updateUI();
            }
        }.execute();
    }

    public void zoomReset() {
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                GraphViewComponent.this.canvas.updateImageScalePercent(100);
                return null;
            }

            @Override
            protected void done() {
                GraphViewComponent.this.canvasView.revalidate();
                GraphViewComponent.this.updateUI();
            }
        }.execute();
    }

    public void showGrid() {
        this.showGrid(20);
    }

    public void showGrid(final int gridSize) {
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                GraphViewComponent.this.canvas.updateGridSize(gridSize);
                return null;
            }

            @Override
            protected void done() {
                GraphViewComponent.this.canvasView.revalidate();
                GraphViewComponent.this.updateUI();
            }
        }.execute();
    }

    public void hideGrid() {
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                GraphViewComponent.this.canvas.updateGridSize(0);
                return null;
            }

            @Override
            protected void done() {
                GraphViewComponent.this.canvasView.revalidate();
                GraphViewComponent.this.updateUI();
            }
        }.execute();
    }

    public GraphViewCanvas getCanvas() {
        return this.canvas;
    }

    public UUID getId() {
        return this.id;
    }

    private static class SelectionOverlay
    extends JComponent {
        private final JComponent canvasView;
        private final JScrollPane canvasViewScrollPane;
        private Point startPointInCanvas;
        private Point finishPointInCanvas;
        private Rectangle selectionRectangleInCanvas;
        private Point currentMousePosition;
        private Rectangle selectionRectangle;
        private GraphViewCanvas.FindElementsResult selectedElements;
        private final Consumer<Rectangle> asyncFindSelectedElements;
        private final Consumer<GraphViewCanvas.FindElementsResult> asyncSelectElements;

        public SelectionOverlay(JComponent canvasView, JScrollPane canvasViewScrollPane, Consumer<Rectangle> asyncFindSelectedElements, Consumer<GraphViewCanvas.FindElementsResult> asyncSelectElements) {
            this.canvasView = canvasView;
            this.canvasViewScrollPane = canvasViewScrollPane;
            this.asyncFindSelectedElements = asyncFindSelectedElements;
            this.asyncSelectElements = asyncSelectElements;
            this.setOpaque(false);
            new Timer(30, e -> {
                if (this.startPointInCanvas == null) {
                    return;
                }
                Point max = this.getMax();
                int margin = 20;
                int shift = 45;
                JScrollBar hBar = canvasViewScrollPane.getHorizontalScrollBar();
                JScrollBar vBar = canvasViewScrollPane.getVerticalScrollBar();
                if (this.currentMousePosition.x <= margin) {
                    hBar.setValue(hBar.getValue() - shift);
                } else if (this.currentMousePosition.x >= max.x - margin) {
                    hBar.setValue(hBar.getValue() + shift);
                }
                if (this.currentMousePosition.y <= margin) {
                    vBar.setValue(vBar.getValue() - shift);
                } else if (this.currentMousePosition.y >= max.y - margin) {
                    vBar.setValue(vBar.getValue() + shift);
                }
            }).start();
        }

        public GraphViewCanvas.FindElementsResult getSelectedElements() {
            if (this.startPointInCanvas == null) {
                return null;
            }
            return this.selectedElements;
        }

        public void startSelection(Point startPointInCanvas) {
            this.startPointInCanvas = startPointInCanvas;
            this.updateSelection(startPointInCanvas);
        }

        public void finishSelection() {
            this.asyncSelectElements.accept(this.selectedElements);
            this.startPointInCanvas = null;
            this.finishPointInCanvas = null;
            this.selectionRectangleInCanvas = null;
            this.selectionRectangle = null;
            this.selectedElements = null;
            this.repaint();
        }

        public void updateSelection() {
            if (this.startPointInCanvas == null) {
                return;
            }
            Point finishPointInCanvas = SwingUtilities.convertPoint(this, this.currentMousePosition, this.canvasView);
            this.updateSelection(finishPointInCanvas);
        }

        public void updateSelection(Point aFinishPointInCanvas) {
            if (this.startPointInCanvas == null) {
                return;
            }
            this.finishPointInCanvas = aFinishPointInCanvas;
            this.currentMousePosition = SwingUtilities.convertPoint(this.canvasView, this.finishPointInCanvas, this);
            Point max = this.getMax();
            boolean needToRepaint = true;
            if (!this.extendedContains(this.currentMousePosition, max)) {
                needToRepaint = false;
                if (this.currentMousePosition.x > max.x) {
                    this.currentMousePosition.x = max.x;
                    needToRepaint = true;
                }
                if (this.currentMousePosition.y > max.y) {
                    this.currentMousePosition.y = max.y;
                    needToRepaint = true;
                }
                if (this.currentMousePosition.x < 0) {
                    this.currentMousePosition.x = 0;
                    needToRepaint = true;
                }
                if (this.currentMousePosition.y < 0) {
                    this.currentMousePosition.y = 0;
                    needToRepaint = true;
                }
                this.finishPointInCanvas = SwingUtilities.convertPoint(this, this.currentMousePosition, this.canvasView);
            }
            if (!needToRepaint) {
                return;
            }
            int width = Math.abs(this.startPointInCanvas.x - this.finishPointInCanvas.x);
            int height = Math.abs(this.startPointInCanvas.y - this.finishPointInCanvas.y);
            int x1 = Math.min(this.currentMousePosition.x, max.x);
            int y1 = Math.min(this.currentMousePosition.y, max.y);
            int x2 = 0;
            x2 = this.finishPointInCanvas.x >= this.startPointInCanvas.x ? Math.max(0, x1 - width) : Math.min(max.x, x1 + width);
            int y2 = 0;
            y2 = this.finishPointInCanvas.y >= this.startPointInCanvas.y ? Math.max(0, y1 - height) : Math.min(max.y, y1 + height);
            this.selectionRectangleInCanvas = this.buildSelectionRectangle(this.startPointInCanvas.x, this.startPointInCanvas.y, this.finishPointInCanvas.x, this.finishPointInCanvas.y);
            this.selectionRectangle = this.buildSelectionRectangle(x1, y1, x2, y2);
            this.repaint();
            this.asyncFindSelectedElements.accept(this.selectionRectangleInCanvas);
        }

        public void updateSelectedElements(GraphViewCanvas.FindElementsResult selectedElements) {
            if (this.startPointInCanvas == null) {
                return;
            }
            this.selectedElements = selectedElements;
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.selectionRectangle == null) {
                return;
            }
            g.setColor(new Color(0, 120, 215, 50));
            g.fillRect(this.selectionRectangle.x, this.selectionRectangle.y, this.selectionRectangle.width, this.selectionRectangle.height);
            g.setColor(new Color(0, 120, 215));
            g.drawRect(this.selectionRectangle.x, this.selectionRectangle.y, this.selectionRectangle.width, this.selectionRectangle.height);
        }

        private boolean extendedContains(Point point, Point max) {
            if (point.x > max.x) {
                return false;
            }
            if (point.y > max.y) {
                return false;
            }
            if (point.x < 0) {
                return false;
            }
            return point.y >= 0;
        }

        private Point getMax() {
            JScrollBar verticalBar = this.canvasViewScrollPane.getVerticalScrollBar();
            JScrollBar horizontalBar = this.canvasViewScrollPane.getHorizontalScrollBar();
            int verticalScrollWidth = verticalBar.isVisible() ? verticalBar.getWidth() + 3 : 0;
            int horizontalScrollHeight = horizontalBar.isVisible() ? horizontalBar.getHeight() + 3 : 0;
            int xMax = this.getWidth() - verticalScrollWidth;
            int yMax = this.getHeight() - horizontalScrollHeight;
            return new Point(xMax, yMax);
        }

        private Rectangle buildSelectionRectangle(int x1, int y1, int x2, int y2) {
            int x = Math.min(x1, x2);
            int y = Math.min(y1, y2);
            int width = Math.abs(x2 - x1);
            int height = Math.abs(y2 - y1);
            return new Rectangle(x, y, width, height);
        }
    }
}

