/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.view;

import ar.com.hjg.pngj.FilterType;
import ar.com.hjg.pngj.IImageLine;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.ImageLineHelper;
import ar.com.hjg.pngj.ImageLineInt;
import ar.com.hjg.pngj.PngWriter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vg.lib.common.JsonUtils;
import vg.lib.common.X11Colors;
import vg.lib.config.VGConfigSettings;
import vg.lib.model.graphics.EdgeGraphics;
import vg.lib.model.graphics.GraphModelAttributesMapping;
import vg.lib.model.graphics.GraphModelSelectedElements;
import vg.lib.model.graphics.GraphModelViewSummary;
import vg.lib.model.graphics.VertexGraphics;
import vg.lib.model.record.AttributeOwnerType;
import vg.lib.model.record.AttributeRecord;
import vg.lib.model.record.AttributeRecordType;
import vg.lib.model.record.ElementType;
import vg.lib.model.record.GraphModelRecord;
import vg.lib.model.record.VertexRecord;
import vg.lib.storage.GraphStorage;
import vg.lib.storage.MemoryGraphStorage;
import vg.lib.view.GraphViewListener;
import vg.lib.view.GraphViewUtils;

public class GraphViewCanvas {
    private static final Logger log = LoggerFactory.getLogger(GraphViewCanvas.class);
    private static final String ERROR_GRAPH_MODEL_WAS_NOT_FOUND = "Graph model %s was not found.";
    private final int graphModelId;
    private final GraphStorage graphStorage;
    private final CopyOnWriteArrayList<GraphViewListener> listeners;
    private volatile Dimension size = new Dimension(0, 0);
    private volatile BufferedImage[][] tiles;
    private static final int TILE_SIZE = 256;

    public GraphViewCanvas(@NonNull GraphStorage graphStorage, int graphModelId) {
        if (graphStorage == null) {
            throw new NullPointerException("graphStorage is marked non-null but is null");
        }
        this.graphStorage = graphStorage;
        this.graphModelId = graphModelId;
        String graphName = graphStorage.findGraphModelRecord(graphModelId).map(GraphModelRecord::getName).orElse(null);
        if (graphName == null) {
            throw new IllegalArgumentException(String.format(ERROR_GRAPH_MODEL_WAS_NOT_FOUND, graphModelId));
        }
        this.listeners = new CopyOnWriteArrayList();
    }

    public GraphViewCanvas(@NonNull String graphName) {
        if (graphName == null) {
            throw new NullPointerException("graphName is marked non-null but is null");
        }
        this.graphStorage = new MemoryGraphStorage();
        this.graphModelId = this.graphStorage.createGraphModel(graphName);
        this.listeners = new CopyOnWriteArrayList();
    }

    public void addListener(GraphViewListener listener) {
        this.listeners.add(listener);
    }

    public void repaint() {
        long startTime = System.currentTimeMillis();
        this.createOrUpdate();
        this.size = this.calculateCanvasSize();
        this.patchViewSummary(GraphModelViewSummary.builder().canvasWidth(this.size.width).canvasHeight(this.size.height).build());
        this.tiles = this.getCanvasTiles(this.size, VGConfigSettings.GRAPH_VIEW_TILE_DIMENSION.width, VGConfigSettings.GRAPH_VIEW_TILE_DIMENSION.height);
        GraphViewListener.fireRepaint(this.listeners);
        long finishTime = System.currentTimeMillis();
        log.debug("GraphViewCanvas.createOrUpdate total: {} ms.", (Object)(finishTime - startTime));
    }

    public BufferedImage getScaledCanvasImage(int x, int y, int width, int height) {
        long finishTime;
        long startTime = System.currentTimeMillis();
        int imageScalePercent = this.getOrSetImageScalePercent();
        double normalizedScale = (double)imageScalePercent / 100.0;
        int originalX = (int)((double)x / normalizedScale);
        int originalY = (int)((double)y / normalizedScale);
        int originalWidth = (int)((double)width / normalizedScale);
        int originalHeight = (int)((double)height / normalizedScale);
        BufferedImage canvasImage = this.getCanvasImage(originalX, originalY, originalWidth, originalHeight);
        if (imageScalePercent != 100) {
            int newWidth = (int)((double)(canvasImage.getWidth() * imageScalePercent) / 100.0);
            int newHeight = (int)((double)(canvasImage.getHeight() * imageScalePercent) / 100.0);
            BufferedImage newScaledImage = new BufferedImage(newWidth, newHeight, canvasImage.getType());
            Graphics2D g2d = newScaledImage.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2d.drawImage(canvasImage, 0, 0, newWidth, newHeight, null);
            g2d.dispose();
            canvasImage = newScaledImage;
        }
        if ((finishTime = System.currentTimeMillis()) - startTime > 50L) {
            log.debug("GraphViewCanvas.getScaledCanvasImage total: {} ms.", (Object)(finishTime - startTime));
        }
        return canvasImage;
    }

    public BufferedImage getCanvasImage(int x, int y, int width, int height) {
        long startTime = System.currentTimeMillis();
        Dimension size = this.getCanvasSize();
        Rectangle requestedBounds = new Rectangle(x, y, width, height);
        Rectangle canvasBounds = new Rectangle(0, 0, size.width, size.height);
        Rectangle safeArea = requestedBounds.intersection(canvasBounds);
        if (safeArea.isEmpty()) {
            return new BufferedImage(width, height, 2);
        }
        x = safeArea.x;
        y = safeArea.y;
        width = safeArea.width;
        height = safeArea.height;
        BufferedImage result = new BufferedImage(width, height, 2);
        Graphics2D g = result.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width, height);
        BufferedImage[][] localTiles = this.tiles;
        if (localTiles == null) {
            return result;
        }
        int startCol = x / VGConfigSettings.GRAPH_VIEW_TILE_DIMENSION.width;
        int startRow = y / VGConfigSettings.GRAPH_VIEW_TILE_DIMENSION.height;
        int endCol = (x + width) / VGConfigSettings.GRAPH_VIEW_TILE_DIMENSION.width;
        int endRow = (y + height) / VGConfigSettings.GRAPH_VIEW_TILE_DIMENSION.height;
        for (int row = startRow; row <= endRow && row < localTiles.length; ++row) {
            for (int col = startCol; col <= endCol && col < localTiles[row].length; ++col) {
                BufferedImage tile = localTiles[row][col];
                if (tile == null) continue;
                int tileX = col * VGConfigSettings.GRAPH_VIEW_TILE_DIMENSION.width - x;
                int tileY = row * VGConfigSettings.GRAPH_VIEW_TILE_DIMENSION.height - y;
                g.drawImage((Image)tile, tileX, tileY, null);
            }
        }
        g.dispose();
        long finishTime = System.currentTimeMillis();
        if (finishTime - startTime > 40L) {
            log.debug("GraphViewCanvas.getCanvasImage total: {} ms.", (Object)(finishTime - startTime));
        }
        return result;
    }

    public static Dimension getScaledCanvasSize(Dimension originalCanvasSize, int imageScalePercent) {
        if (imageScalePercent == 100) {
            return originalCanvasSize;
        }
        int newWidth = (int)(originalCanvasSize.getWidth() * (double)imageScalePercent / 100.0);
        int newHeight = (int)(originalCanvasSize.getHeight() * (double)imageScalePercent / 100.0);
        return new Dimension(newWidth, newHeight);
    }

    public Dimension getCanvasSize() {
        return this.size;
    }

    public void selectElements(List<UUID> selectedVertexGlobalIds, List<UUID> selectedEdgeGlobalIds) {
        if (selectedVertexGlobalIds == null) {
            selectedVertexGlobalIds = Collections.emptyList();
        }
        if (selectedEdgeGlobalIds == null) {
            selectedEdgeGlobalIds = Collections.emptyList();
        }
        HashSet<UUID> selectedVertexGlobalIdsHashSet = new HashSet<UUID>(selectedVertexGlobalIds);
        HashSet<UUID> selectedEdgeGlobalIdsHashSet = new HashSet<UUID>(selectedEdgeGlobalIds);
        this.graphStorage.dfs(this.graphModelId, it -> {}, it -> {
            AttributeRecord vertexGraphicsAttributeRecord = this.graphStorage.findAttributeRecordByOwnerAndName(this.graphModelId, it.getId(), AttributeOwnerType.VERTEX, "system_vertex_graphics").orElse(null);
            if (vertexGraphicsAttributeRecord == null) {
                return;
            }
            VertexGraphics vertexGraphics = JsonUtils.fromJson(vertexGraphicsAttributeRecord.getStringValue(), VertexGraphics.class);
            boolean isSelectedOldValue = vertexGraphics.isSelected();
            vertexGraphics.setSelected(false);
            if (selectedVertexGlobalIdsHashSet.contains(it.getGlobalId())) {
                vertexGraphics.setSelected(true);
            }
            if (isSelectedOldValue != vertexGraphics.isSelected()) {
                this.graphStorage.createOrUpdateVertexAttribute(this.graphModelId, it.getId(), "system_vertex_graphics", JsonUtils.toJson(vertexGraphics), AttributeRecordType.JSON, false);
            }
        }, it -> {
            AttributeRecord edgeGraphicsAttributeRecord = this.graphStorage.findAttributeRecordByOwnerAndName(this.graphModelId, it.getId(), AttributeOwnerType.EDGE, "system_edge_graphics").orElse(null);
            if (edgeGraphicsAttributeRecord == null) {
                return;
            }
            EdgeGraphics edgeGraphics = JsonUtils.fromJson(edgeGraphicsAttributeRecord.getStringValue(), EdgeGraphics.class);
            boolean isSelectedOldValue = edgeGraphics.isSelected();
            edgeGraphics.setSelected(false);
            if (selectedEdgeGlobalIdsHashSet.contains(it.getGlobalId())) {
                edgeGraphics.setSelected(true);
            }
            if (isSelectedOldValue != edgeGraphics.isSelected()) {
                this.graphStorage.createOrUpdateEdgeAttribute(this.graphModelId, it.getId(), "system_edge_graphics", JsonUtils.toJson(edgeGraphics), AttributeRecordType.JSON, false);
            }
        });
        this.graphStorage.createOrUpdateGraphModelAttribute(this.graphModelId, "system_graph_model_selected_elements", JsonUtils.toJson(GraphModelSelectedElements.builder().selectedVertexGlobalIds(selectedVertexGlobalIds).selectedEdgeGlobalIds(selectedEdgeGlobalIds).build()), AttributeRecordType.JSON, false);
        GraphViewListener.fireSelectElements(this.listeners);
        this.repaint();
    }

    public FindElementsResult findElements(int x, int y, int width, int height, SelectionMode selectionMode) {
        FindElementsResult allElements = this.findElements(null, true, true, false, false, false);
        LinkedHashMap<UUID, VertexGraphics> allSortedVertices = allElements.sortedVertices;
        LinkedHashMap<UUID, EdgeGraphics> allSortedEdges = allElements.sortedEdges;
        LinkedHashMap<UUID, VertexGraphics> sortedVerticesResult = new LinkedHashMap<UUID, VertexGraphics>();
        LinkedHashMap<UUID, EdgeGraphics> sortedEdgesResult = new LinkedHashMap<UUID, EdgeGraphics>();
        if (selectionMode != SelectionMode.REPLACE) {
            GraphModelSelectedElements selectedElements = this.graphStorage.findAttributeRecordByOwnerAndName(this.graphModelId, this.graphModelId, AttributeOwnerType.GRAPH_MODEL, "system_graph_model_selected_elements").map(it -> JsonUtils.fromJson(it.getStringValue(), GraphModelSelectedElements.class)).orElse(null);
            if (selectedElements != null && selectedElements.getSelectedVertexGlobalIds() != null) {
                selectedElements.getSelectedVertexGlobalIds().forEach(vertexGlobalId -> {
                    VertexGraphics vertex = (VertexGraphics)allSortedVertices.get(vertexGlobalId);
                    if (vertex != null) {
                        sortedVerticesResult.put((UUID)vertexGlobalId, vertex);
                    }
                });
            }
            if (selectedElements != null && selectedElements.getSelectedEdgeGlobalIds() != null) {
                selectedElements.getSelectedEdgeGlobalIds().forEach(edgeGlobalId -> {
                    EdgeGraphics edge = (EdgeGraphics)allSortedEdges.get(edgeGlobalId);
                    if (edge != null) {
                        sortedEdgesResult.put((UUID)edgeGlobalId, edge);
                    }
                });
            }
        }
        Rectangle selectionRectangle = new Rectangle(x - 1, y - 1, width + 2, height + 2);
        AtomicBoolean stop = new AtomicBoolean(false);
        allSortedVertices.forEach((vertexGlobalId, vertexGraphics) -> {
            Rectangle vertexBoundingBox = vertexGraphics.getBoundingBox();
            if (!stop.get() && vertexBoundingBox.intersects(selectionRectangle)) {
                if (vertexGraphics.isSelected() && selectionMode == SelectionMode.ADD_OR_REMOVE) {
                    vertexGraphics.setSelected(false);
                    sortedVerticesResult.remove(vertexGlobalId);
                } else {
                    vertexGraphics.setSelected(true);
                    sortedVerticesResult.put((UUID)vertexGlobalId, (VertexGraphics)vertexGraphics);
                }
            } else if (selectionMode == SelectionMode.REPLACE) {
                vertexGraphics.setSelected(false);
            }
            if (vertexBoundingBox.contains(selectionRectangle)) {
                stop.set(true);
            }
        });
        allSortedEdges.forEach((edgeGlobalId, edgeGraphics) -> {
            boolean isSelected = false;
            List<Point> points = edgeGraphics.getPoints();
            for (int i = 0; i < points.size() - 1; ++i) {
                Point p1 = points.get(i);
                Point p2 = points.get(i + 1);
                Line2D.Float segment = new Line2D.Float(p1.x, p1.y, p2.x, p2.y);
                if (!segment.intersects(selectionRectangle)) continue;
                isSelected = true;
                break;
            }
            if (isSelected) {
                if (edgeGraphics.isSelected() && selectionMode == SelectionMode.ADD_OR_REMOVE) {
                    edgeGraphics.setSelected(false);
                    sortedEdgesResult.remove(edgeGlobalId);
                } else {
                    edgeGraphics.setSelected(true);
                    sortedEdgesResult.put((UUID)edgeGlobalId, (EdgeGraphics)edgeGraphics);
                }
            } else if (selectionMode == SelectionMode.REPLACE) {
                edgeGraphics.setSelected(false);
            }
        });
        ArrayList<Map.Entry<UUID, ElementType>> orderedElementGlobalIdsWithTypesResult = new ArrayList<Map.Entry<UUID, ElementType>>();
        sortedVerticesResult.keySet().forEach(id -> orderedElementGlobalIdsWithTypesResult.add(Map.entry(id, ElementType.VERTEX)));
        sortedEdgesResult.keySet().forEach(id -> orderedElementGlobalIdsWithTypesResult.add(Map.entry(id, ElementType.EDGE)));
        return FindElementsResult.builder().orderedElementGlobalIdsWithTypes(orderedElementGlobalIdsWithTypesResult).vertexGlobalIds(new ArrayList<UUID>(sortedVerticesResult.keySet())).edgeGlobalIds(new ArrayList<UUID>(sortedEdgesResult.keySet())).sortedVertices(sortedVerticesResult).sortedEdges(sortedEdgesResult).build();
    }

    public void highlightElements(List<UUID> highlightedVertexGlobalIds, List<UUID> highlightedEdgeGlobalIds) {
        if (highlightedVertexGlobalIds == null) {
            highlightedVertexGlobalIds = Collections.emptyList();
        }
        if (highlightedEdgeGlobalIds == null) {
            highlightedEdgeGlobalIds = Collections.emptyList();
        }
        HashSet<UUID> highlightedVertexGlobalIdsHashSet = new HashSet<UUID>(highlightedVertexGlobalIds);
        HashSet<UUID> highlightedEdgeGlobalIdsHashSet = new HashSet<UUID>(highlightedEdgeGlobalIds);
        this.graphStorage.dfs(this.graphModelId, it -> {}, it -> {
            AttributeRecord vertexGraphicsAttributeRecord = this.graphStorage.findAttributeRecordByOwnerAndName(this.graphModelId, it.getId(), AttributeOwnerType.VERTEX, "system_vertex_graphics").orElse(null);
            if (vertexGraphicsAttributeRecord == null) {
                return;
            }
            VertexGraphics vertexGraphics = JsonUtils.fromJson(vertexGraphicsAttributeRecord.getStringValue(), VertexGraphics.class);
            boolean isHighlightedOldValue = vertexGraphics.isHighlighted();
            vertexGraphics.setHighlighted(false);
            if (highlightedVertexGlobalIdsHashSet.contains(it.getGlobalId())) {
                vertexGraphics.setHighlighted(true);
            }
            if (isHighlightedOldValue != vertexGraphics.isHighlighted()) {
                this.graphStorage.createOrUpdateVertexAttribute(this.graphModelId, it.getId(), "system_vertex_graphics", JsonUtils.toJson(vertexGraphics), AttributeRecordType.JSON, false);
            }
        }, it -> {
            AttributeRecord edgeGraphicsAttributeRecord = this.graphStorage.findAttributeRecordByOwnerAndName(this.graphModelId, it.getId(), AttributeOwnerType.EDGE, "system_edge_graphics").orElse(null);
            if (edgeGraphicsAttributeRecord == null) {
                return;
            }
            EdgeGraphics edgeGraphics = JsonUtils.fromJson(edgeGraphicsAttributeRecord.getStringValue(), EdgeGraphics.class);
            boolean isHighlightedOldValue = edgeGraphics.isHighlighted();
            edgeGraphics.setHighlighted(false);
            if (highlightedEdgeGlobalIdsHashSet.contains(it.getGlobalId())) {
                edgeGraphics.setHighlighted(true);
            }
            if (isHighlightedOldValue != edgeGraphics.isHighlighted()) {
                this.graphStorage.createOrUpdateEdgeAttribute(this.graphModelId, it.getId(), "system_edge_graphics", JsonUtils.toJson(edgeGraphics), AttributeRecordType.JSON, false);
            }
        });
        this.repaint();
    }

    public FindElementsResult findElements(String searchQuery, boolean includeVertices, boolean includeEdges, boolean caseSensitive, boolean matchWholeWords, boolean useRegex) {
        ArrayList<UUID> vertexGlobalIds = new ArrayList<UUID>();
        LinkedHashMap<UUID, VertexGraphics> sortedVertices = new LinkedHashMap<UUID, VertexGraphics>();
        LinkedHashMap<UUID, EdgeGraphics> sortedEdges = new LinkedHashMap<UUID, EdgeGraphics>();
        ArrayList<UUID> edgeGlobalIds = new ArrayList<UUID>();
        ArrayList<Map.Entry<UUID, ElementType>> orderedElementGlobalIdsWithTypes = new ArrayList<Map.Entry<UUID, ElementType>>();
        this.graphStorage.dfs(this.graphModelId, it -> {}, it -> {
            if (!includeVertices) {
                return;
            }
            AttributeRecord vertexGraphicsAttributeRecord = this.graphStorage.findAttributeRecordByOwnerAndName(this.graphModelId, it.getId(), AttributeOwnerType.VERTEX, "system_vertex_graphics").orElse(null);
            if (vertexGraphicsAttributeRecord == null) {
                return;
            }
            VertexGraphics vertexGraphics = JsonUtils.fromJson(vertexGraphicsAttributeRecord.getStringValue(), VertexGraphics.class);
            boolean re = this.doSearchInContent(vertexGraphics.getLabel().getContent(), searchQuery, caseSensitive, matchWholeWords, useRegex);
            if (re) {
                vertexGlobalIds.add(it.getGlobalId());
                sortedVertices.put(it.getGlobalId(), vertexGraphics);
                orderedElementGlobalIdsWithTypes.add(Map.entry(it.getGlobalId(), ElementType.VERTEX));
            }
        }, it -> {
            if (!includeEdges) {
                return;
            }
            AttributeRecord edgeGraphicsAttributeRecord = this.graphStorage.findAttributeRecordByOwnerAndName(this.graphModelId, it.getId(), AttributeOwnerType.EDGE, "system_edge_graphics").orElse(null);
            if (edgeGraphicsAttributeRecord == null) {
                return;
            }
            EdgeGraphics edgeGraphics = JsonUtils.fromJson(edgeGraphicsAttributeRecord.getStringValue(), EdgeGraphics.class);
            boolean re = this.doSearchInContent(edgeGraphics.getLabel().getContent(), searchQuery, caseSensitive, matchWholeWords, useRegex);
            if (re) {
                edgeGlobalIds.add(it.getGlobalId());
                sortedEdges.put(it.getGlobalId(), edgeGraphics);
                orderedElementGlobalIdsWithTypes.add(Map.entry(it.getGlobalId(), ElementType.EDGE));
            }
        });
        return FindElementsResult.builder().orderedElementGlobalIdsWithTypes(orderedElementGlobalIdsWithTypes).vertexGlobalIds(vertexGlobalIds).edgeGlobalIds(edgeGlobalIds).sortedVertices(sortedVertices).sortedEdges(sortedEdges).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(OutputStream outputStream) {
        Dimension size = this.getCanvasSize();
        int fullW = size.width;
        int fullH = size.height;
        ImageInfo imageInfo = new ImageInfo(fullW, fullH, 8, true);
        PngWriter pngWriter = null;
        try {
            pngWriter = new PngWriter(outputStream, imageInfo);
            pngWriter.setFilterType(FilterType.FILTER_NONE);
            pngWriter.setIdatMaxSize(0x400000);
            pngWriter.setCompLevel(6);
            ImageLineInt imageLineInt = new ImageLineInt(imageInfo);
            for (int stripY = 0; stripY < fullH; stripY += 256) {
                int stripH = Math.min(256, fullH - stripY);
                int tilesInRow = (fullW + 256 - 1) / 256;
                Object[] rowTiles = new BufferedImage[tilesInRow];
                int[] tileWidths = new int[tilesInRow];
                for (int tx = 0; tx < tilesInRow; ++tx) {
                    int tileX = tx * 256;
                    int tileW = Math.min(256, fullW - tileX);
                    rowTiles[tx] = this.getCanvasImage(tileX, stripY, tileW, stripH);
                    if (rowTiles[tx] == null) {
                        rowTiles[tx] = new BufferedImage(tileW, stripH, 6);
                    }
                    tileWidths[tx] = tileW;
                }
                for (int rowInStrip = 0; rowInStrip < stripH; ++rowInStrip) {
                    int writeY = stripY + rowInStrip;
                    int dstX = 0;
                    for (int tx = 0; tx < tilesInRow; ++tx) {
                        Object tile = rowTiles[tx];
                        int tw = tileWidths[tx];
                        WritableRaster raster = ((BufferedImage)tile).getRaster();
                        int[] px = new int[4];
                        for (int x = 0; x < tw; ++x) {
                            raster.getPixel(x, rowInStrip, px);
                            ImageLineHelper.setPixelRGBA8((ImageLineInt)imageLineInt, (int)dstX++, (int)px[0], (int)px[1], (int)px[2], (int)px[3]);
                        }
                    }
                    pngWriter.writeRow((IImageLine)imageLineInt, writeY);
                }
                Arrays.fill(rowTiles, null);
            }
            pngWriter.end();
        }
        finally {
            if (pngWriter != null) {
                try {
                    pngWriter.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public int getOrSetDefaultVertexFontSize() {
        AttributeRecord defaultFontSizeRecord = this.graphStorage.findAttributeRecordByOwnerAndName(this.graphModelId, this.graphModelId, AttributeOwnerType.GRAPH_MODEL, "system_graph_model_default_vertex_font_size").orElse(null);
        if (defaultFontSizeRecord == null) {
            this.graphStorage.createGraphModelAttribute(this.graphModelId, "system_graph_model_default_vertex_font_size", Integer.toString(14), AttributeRecordType.INTEGER, false);
            return 14;
        }
        return defaultFontSizeRecord.getIntegerValue();
    }

    public int getOrSetDefaultEdgeFontSize() {
        AttributeRecord defaultFontSizeRecord = this.graphStorage.findAttributeRecordByOwnerAndName(this.graphModelId, this.graphModelId, AttributeOwnerType.GRAPH_MODEL, "system_graph_model_default_edge_font_size").orElse(null);
        if (defaultFontSizeRecord == null) {
            this.graphStorage.createGraphModelAttribute(this.graphModelId, "system_graph_model_default_edge_font_size", Integer.toString(10), AttributeRecordType.INTEGER, false);
            return 10;
        }
        return defaultFontSizeRecord.getIntegerValue();
    }

    public Color getOrSetDefaultVertexColor() {
        AttributeRecord defaultVertexColorRecord = this.graphStorage.findAttributeRecordByOwnerAndName(this.graphModelId, this.graphModelId, AttributeOwnerType.GRAPH_MODEL, "system_graph_model_default_vertex_color").orElse(null);
        if (defaultVertexColorRecord == null) {
            this.graphStorage.createGraphModelAttribute(this.graphModelId, "system_graph_model_default_vertex_color", "#ffff00", AttributeRecordType.STRING, false);
            return Color.decode("#ffff00");
        }
        return Color.decode(defaultVertexColorRecord.getStringValue());
    }

    public VertexGraphics.ShapeType getOrSetDefaultVertexShape() {
        AttributeRecord defaultVertexShapeRecord = this.graphStorage.findAttributeRecordByOwnerAndName(this.graphModelId, this.graphModelId, AttributeOwnerType.GRAPH_MODEL, "system_graph_model_default_vertex_shape").orElse(null);
        if (defaultVertexShapeRecord == null) {
            this.graphStorage.createGraphModelAttribute(this.graphModelId, "system_graph_model_default_vertex_shape", VGConfigSettings.GRAPH_VIEW_DEFAULT_VERTEX_SHAPE, AttributeRecordType.STRING, false);
            return VertexGraphics.ShapeType.valueOf(VGConfigSettings.GRAPH_VIEW_DEFAULT_VERTEX_SHAPE);
        }
        return VertexGraphics.ShapeType.valueOf(defaultVertexShapeRecord.getStringValue());
    }

    public String getOrSetDefaultVertexVisibleAttributesPattern() {
        AttributeRecord defaultVertexVisibleAttributesPattern = this.graphStorage.findAttributeRecordByOwnerAndName(this.graphModelId, this.graphModelId, AttributeOwnerType.GRAPH_MODEL, "system_graph_model_default_vertex_visible_attributes_pattern").orElse(null);
        if (defaultVertexVisibleAttributesPattern == null) {
            this.graphStorage.createGraphModelAttribute(this.graphModelId, "system_graph_model_default_vertex_visible_attributes_pattern", ".*", AttributeRecordType.STRING, false);
            return ".*";
        }
        return defaultVertexVisibleAttributesPattern.getStringValue();
    }

    public String getOrSetDefaultEdgeVisibleAttributesPattern() {
        AttributeRecord defaultEdgeVisibleAttributesPattern = this.graphStorage.findAttributeRecordByOwnerAndName(this.graphModelId, this.graphModelId, AttributeOwnerType.GRAPH_MODEL, "system_graph_model_default_edge_visible_attributes_pattern").orElse(null);
        if (defaultEdgeVisibleAttributesPattern == null) {
            this.graphStorage.createGraphModelAttribute(this.graphModelId, "system_graph_model_default_edge_visible_attributes_pattern", ".*", AttributeRecordType.STRING, false);
            return ".*";
        }
        return defaultEdgeVisibleAttributesPattern.getStringValue();
    }

    public GraphModelAttributesMapping getOrSetDefaultAttributesMapping() {
        GraphModelAttributesMapping defaultAttributesMapping = this.graphStorage.findAttributeRecordByOwnerAndName(this.graphModelId, this.graphModelId, AttributeOwnerType.GRAPH_MODEL, "system_graph_model_default_attributes_mapping").map(it -> JsonUtils.fromJson(it.getStringValue(), GraphModelAttributesMapping.class)).orElse(null);
        if (defaultAttributesMapping == null) {
            this.graphStorage.createGraphModelAttribute(this.graphModelId, "system_graph_model_default_attributes_mapping", JsonUtils.toJson(VGConfigSettings.GRAPH_VIEW_DEFAULT_GRAPH_MODEL_ATTRIBUTES_MAPPING), AttributeRecordType.JSON, false);
            return VGConfigSettings.GRAPH_VIEW_DEFAULT_GRAPH_MODEL_ATTRIBUTES_MAPPING;
        }
        return defaultAttributesMapping;
    }

    public int getOrSetImageScalePercent() {
        AttributeRecord imageScaleRecord = this.graphStorage.findAttributeRecordByOwnerAndName(this.graphModelId, this.graphModelId, AttributeOwnerType.GRAPH_MODEL, "system_graph_model_image_scale_percent").orElse(null);
        if (imageScaleRecord == null) {
            this.graphStorage.createGraphModelAttribute(this.graphModelId, "system_graph_model_image_scale_percent", Integer.toString(100), AttributeRecordType.INTEGER, false);
            return 100;
        }
        return imageScaleRecord.getIntegerValue();
    }

    public void updateImageScalePercent(int imageScalePercent) {
        if (imageScalePercent <= 0 || imageScalePercent > 200) {
            throw new IllegalArgumentException("Invalid image scale percent: " + imageScalePercent);
        }
        this.graphStorage.createOrUpdateGraphModelAttribute(this.graphModelId, "system_graph_model_image_scale_percent", Integer.toString(imageScalePercent), AttributeRecordType.INTEGER, false);
        GraphViewListener.fireImageScale(this.listeners);
    }

    public int getOrSetGridSize() {
        AttributeRecord gridSizeRecord = this.graphStorage.findAttributeRecordByOwnerAndName(this.graphModelId, this.graphModelId, AttributeOwnerType.GRAPH_MODEL, "system_graph_model_grid_size").orElse(null);
        if (gridSizeRecord == null) {
            this.graphStorage.createGraphModelAttribute(this.graphModelId, "system_graph_model_grid_size", Integer.toString(20), AttributeRecordType.INTEGER, false);
            return 20;
        }
        return gridSizeRecord.getIntegerValue();
    }

    public void updateGridSize(int gridSize) {
        if (gridSize < 0 || gridSize > 100) {
            throw new IllegalArgumentException("Invalid grid size: " + gridSize);
        }
        this.graphStorage.createOrUpdateGraphModelAttribute(this.graphModelId, "system_graph_model_grid_size", Integer.toString(gridSize), AttributeRecordType.INTEGER, false);
        this.repaint();
    }

    private void createOrUpdate() {
        int defaultVertexFontSize = this.getOrSetDefaultVertexFontSize();
        int defaultEdgeFontSize = this.getOrSetDefaultEdgeFontSize();
        Color defaultVertexColor = this.getOrSetDefaultVertexColor();
        VertexGraphics.ShapeType defaultVertexShape = this.getOrSetDefaultVertexShape();
        String defaultVertexVisibleAttributesPattern = this.getOrSetDefaultVertexVisibleAttributesPattern();
        String defaultEdgeVisibleAttributesPattern = this.getOrSetDefaultEdgeVisibleAttributesPattern();
        GraphModelAttributesMapping defaultAttributesMapping = this.getOrSetDefaultAttributesMapping();
        this.graphStorage.dfs(this.graphModelId, it -> {}, vertexRecord -> this.createOrUpdateVertexGraphics((VertexRecord)vertexRecord, defaultVertexFontSize, defaultVertexColor, defaultVertexShape, defaultVertexVisibleAttributesPattern, defaultAttributesMapping), edgeRecord -> this.createOrUpdateEdgeGraphics(edgeRecord.getId(), edgeRecord.getSourceId(), edgeRecord.getTargetId(), defaultEdgeFontSize, defaultEdgeVisibleAttributesPattern));
    }

    private Dimension calculateCanvasSize() {
        int gridSize;
        int[] mutableMaxX = new int[]{Integer.MIN_VALUE};
        int[] mutableMaxY = new int[]{Integer.MIN_VALUE};
        this.graphStorage.dfs(this.graphModelId, it -> {}, vertexRecord -> {
            VertexGraphics vertexGraphics = this.graphStorage.findAttributeRecordByOwnerAndName(this.graphModelId, vertexRecord.getId(), AttributeOwnerType.VERTEX, "system_vertex_graphics").map(it -> JsonUtils.fromJson(it.getStringValue(), VertexGraphics.class)).orElse(null);
            if (vertexGraphics == null) {
                return;
            }
            Rectangle vertexBoundingBox = vertexGraphics.getBoundingBox();
            int maxX = vertexBoundingBox.x + vertexBoundingBox.width;
            int maxY = vertexBoundingBox.y + vertexBoundingBox.height;
            if (maxX > mutableMaxX[0]) {
                mutableMaxX[0] = maxX;
            }
            if (maxY > mutableMaxY[0]) {
                mutableMaxY[0] = maxY;
            }
        }, edgeRecord -> {
            EdgeGraphics edgeGraphics = this.graphStorage.findAttributeRecordByOwnerAndName(this.graphModelId, edgeRecord.getId(), AttributeOwnerType.EDGE, "system_edge_graphics").map(it -> JsonUtils.fromJson(it.getStringValue(), EdgeGraphics.class)).orElse(null);
            if (edgeGraphics == null) {
                return;
            }
            Rectangle vertexBoundingBox = edgeGraphics.getBoundingBox();
            int maxX = vertexBoundingBox.x + vertexBoundingBox.width;
            int maxY = vertexBoundingBox.y + vertexBoundingBox.height;
            if (maxX > mutableMaxX[0]) {
                mutableMaxX[0] = maxX;
            }
            if (maxY > mutableMaxY[0]) {
                mutableMaxY[0] = maxY;
            }
        });
        int width = 0;
        int height = 0;
        if (mutableMaxX[0] != Integer.MIN_VALUE) {
            width = mutableMaxX[0];
        }
        if (mutableMaxY[0] != Integer.MIN_VALUE) {
            height = mutableMaxY[0];
        }
        if ((gridSize = this.getOrSetGridSize()) > 0) {
            if (width % gridSize != 0) {
                width = (width / gridSize + 1) * gridSize;
            }
            if (height % gridSize != 0) {
                height = (height / gridSize + 1) * gridSize;
            }
        }
        Dimension result = new Dimension(width + 1, height + 1);
        if (result.width > VGConfigSettings.GRAPH_VIEW_MAX_CANVAS_SIZE.width || result.height > VGConfigSettings.GRAPH_VIEW_MAX_CANVAS_SIZE.height) {
            throw new IllegalArgumentException(String.format("Canvas size exceeds maximum allowed: %d x %d (max %d x %d).", result.width, result.height, VGConfigSettings.GRAPH_VIEW_MAX_CANVAS_SIZE.width, VGConfigSettings.GRAPH_VIEW_MAX_CANVAS_SIZE.height));
        }
        return result;
    }

    private void createOrUpdateVertexGraphics(VertexRecord vertexRecord, int defaultVertexFontSize, Color defaultVertexColor, VertexGraphics.ShapeType defaultVertexShape, String defaultVertexVisibleAttributesPattern, GraphModelAttributesMapping defaultAttributesMapping) {
        int vertexId = vertexRecord.getId();
        List<AttributeRecord> attributeRecords = this.graphStorage.findAttributeRecordsByOwner(this.graphModelId, vertexId, AttributeOwnerType.VERTEX);
        VertexGraphics vertexGraphics = GraphStorage.findVertexGraphicsAttributeRecord(attributeRecords).map(it -> JsonUtils.fromJson(it.getStringValue(), VertexGraphics.class)).orElse(null);
        if (vertexGraphics == null) {
            String color = this.getOrDefaultVertexColorHex(attributeRecords, defaultAttributesMapping.getVertexColorRules(), defaultVertexColor);
            VertexGraphics.ShapeType shapeType = this.getOrDefaultVertexShapeType(attributeRecords, defaultAttributesMapping.getVertexShapeRules(), defaultVertexShape);
            this.updateVisibleAttributeRecords(attributeRecords, defaultVertexVisibleAttributesPattern);
            VertexGraphics.VertexLabel vertexLabel = this.buildVertexLabel(attributeRecords, defaultVertexFontSize, true, VertexGraphics.LabelAlignment.CENTER);
            GraphViewUtils.VertexBoundingBoxAndLabelOffset vertexBoundingBoxAndLabelOffset = GraphViewUtils.calculateVertexBoundingBoxAndLabelOffset(shapeType, 2, vertexLabel.getWidth(), vertexLabel.getHeight(), vertexLabel.getAlignment(), new Rectangle(0, 0, VGConfigSettings.GRAPH_VIEW_DEFAULT_VERTEX_MIN_SIZE.x, VGConfigSettings.GRAPH_VIEW_DEFAULT_VERTEX_MIN_SIZE.y));
            vertexGraphics = VertexGraphics.builder().boundingBox(vertexBoundingBoxAndLabelOffset.boundingBox()).border(2).shapeType(shapeType).color(color).label(vertexLabel).labelOffset(vertexBoundingBoxAndLabelOffset.labelOffset()).build();
            this.graphStorage.createVertexAttribute(this.graphModelId, vertexId, "system_vertex_graphics", JsonUtils.toJson(vertexGraphics), AttributeRecordType.JSON, false);
        } else {
            VertexGraphics.VertexLabel vertexLabel = this.buildVertexLabel(attributeRecords, vertexGraphics.getLabel().getFontSize(), vertexGraphics.getLabel().isVisible(), vertexGraphics.getLabel().getAlignment());
            GraphViewUtils.VertexBoundingBoxAndLabelOffset vertexBoundingBoxAndLabelOffset = GraphViewUtils.calculateVertexBoundingBoxAndLabelOffset(vertexGraphics.getShapeType(), 2, vertexLabel.getWidth(), vertexLabel.getHeight(), vertexLabel.getAlignment(), vertexGraphics.getBoundingBox());
            vertexGraphics.setBoundingBox(vertexBoundingBoxAndLabelOffset.boundingBox());
            vertexGraphics.setLabel(vertexLabel);
            vertexGraphics.setLabelOffset(vertexBoundingBoxAndLabelOffset.labelOffset());
            this.graphStorage.createOrUpdateVertexAttribute(this.graphModelId, vertexId, "system_vertex_graphics", JsonUtils.toJson(vertexGraphics), AttributeRecordType.JSON, false);
        }
    }

    private void createOrUpdateEdgeGraphics(int edgeId, int sourceId, int targetId, int defaultEdgeFontSize, String defaultEdgeVisibleAttributesPattern) {
        List<AttributeRecord> attributeRecords = this.graphStorage.findAttributeRecordsByOwner(this.graphModelId, edgeId, AttributeOwnerType.EDGE);
        Boolean isDirected = GraphStorage.findEdgeIsDirectedAttributeRecord(attributeRecords).map(AttributeRecord::getBooleanValue).orElse(false);
        EdgeGraphics edgeGraphics = GraphStorage.findEdgeGraphicsAttributeRecord(attributeRecords).map(it -> JsonUtils.fromJson(it.getStringValue(), EdgeGraphics.class)).orElse(null);
        if (edgeGraphics == null) {
            this.updateVisibleAttributeRecords(attributeRecords, defaultEdgeVisibleAttributesPattern);
            EdgeGraphics.EdgeLabel edgeLabel = this.buildEdgeLabel(attributeRecords, defaultEdgeFontSize);
            GraphViewUtils.EdgeLabelPlacement edgeBoundingBoxAndLabelOffset = GraphViewUtils.calculateEdgeBoundingBoxAndLabelOffset(Collections.emptyList(), edgeLabel.getWidth(), edgeLabel.getHeight());
            edgeGraphics = EdgeGraphics.builder().boundingBox(edgeBoundingBoxAndLabelOffset.boundingBox()).points(List.of()).lineType(EdgeGraphics.LineType.SOLID).lineStartType(EdgeGraphics.LineEndpointType.NONE).lineEndType(isDirected != false ? EdgeGraphics.LineEndpointType.ARROW : EdgeGraphics.LineEndpointType.NONE).label(edgeLabel).labelOffset(edgeBoundingBoxAndLabelOffset.labelOffset()).build();
            this.graphStorage.createEdgeAttribute(this.graphModelId, edgeId, "system_edge_graphics", JsonUtils.toJson(edgeGraphics), AttributeRecordType.JSON, false);
        } else {
            EdgeGraphics.EdgeLabel edgeLabel = this.buildEdgeLabel(attributeRecords, edgeGraphics.getLabel().getFontSize());
            GraphViewUtils.EdgeLabelPlacement edgeBoundingBoxAndLabelOffset = GraphViewUtils.calculateEdgeBoundingBoxAndLabelOffset(edgeGraphics.getPoints(), edgeLabel.getWidth(), edgeLabel.getHeight());
            edgeGraphics.setBoundingBox(edgeBoundingBoxAndLabelOffset.boundingBox());
            edgeGraphics.setLabel(edgeLabel);
            edgeGraphics.setLabelOffset(edgeBoundingBoxAndLabelOffset.labelOffset());
            this.graphStorage.createOrUpdateEdgeAttribute(this.graphModelId, edgeId, "system_edge_graphics", JsonUtils.toJson(edgeGraphics), AttributeRecordType.JSON, false);
        }
    }

    private VertexGraphics.VertexLabel buildVertexLabel(List<AttributeRecord> attributeRecords, int fontSize, boolean visible, VertexGraphics.LabelAlignment alignment) {
        String vertexOriginalId = GraphStorage.findVertexOriginalIdAttributeRecord(attributeRecords).map(AttributeRecord::getStringValue).orElse(null);
        String content = this.buildContent(vertexOriginalId, attributeRecords);
        String[] lines = content.isEmpty() ? new String[]{} : content.split("\n");
        Font font = VGConfigSettings.getFontResource("font/ubuntu-mono/UbuntuMono-R.ttf").deriveFont((float)fontSize);
        FontRenderContext frc = new FontRenderContext(null, true, true);
        int width = (int)Math.ceil(Arrays.stream(lines).mapToDouble(line -> font.getStringBounds((String)line, frc).getWidth()).max().orElse(0.0));
        LineMetrics lineMetrics = font.getLineMetrics("Tg", frc);
        int height = (int)Math.ceil(lineMetrics.getHeight() * (float)lines.length);
        return VertexGraphics.VertexLabel.builder().content(content).fontSize(fontSize).width(width).height(height).visible(visible).alignment(alignment).build();
    }

    private EdgeGraphics.EdgeLabel buildEdgeLabel(List<AttributeRecord> attributeRecords, int fontSize) {
        String edgeOriginalId = GraphStorage.findEdgeOriginalIdAttributeRecord(attributeRecords).map(AttributeRecord::getStringValue).orElse(null);
        String content = this.buildContent(edgeOriginalId, attributeRecords);
        String[] lines = content.isEmpty() ? new String[]{} : content.split("\n");
        Font font = VGConfigSettings.getFontResource("font/ubuntu-mono/UbuntuMono-R.ttf").deriveFont((float)fontSize);
        FontRenderContext frc = new FontRenderContext(null, true, true);
        int width = (int)Math.ceil(Arrays.stream(lines).mapToDouble(line -> font.getStringBounds((String)line, frc).getWidth()).max().orElse(0.0));
        LineMetrics lineMetrics = font.getLineMetrics("Tg", frc);
        int height = (int)Math.ceil(lineMetrics.getHeight() * (float)lines.length);
        return EdgeGraphics.EdgeLabel.builder().content(content).fontSize(fontSize).width(width).height(height).build();
    }

    private String buildContent(String originalId, List<AttributeRecord> attributeRecords) {
        int maxNameLength = 0;
        int maxValueLength = originalId == null ? 0 : originalId.length();
        for (AttributeRecord attributeRecord : attributeRecords) {
            if (attributeRecord.isSystem() || !attributeRecord.isVisible()) continue;
            maxNameLength = Math.max(maxNameLength, attributeRecord.getName().length());
            maxValueLength = Math.max(maxValueLength, Arrays.stream(attributeRecord.getStringValue().split("\n")).mapToInt(String::length).max().orElse(0));
        }
        int columnSize = maxNameLength + maxValueLength + ":".length();
        if (originalId != null && (columnSize - originalId.length()) % 2 == 1) {
            ++columnSize;
            ++maxValueLength;
        }
        StringBuilder contentBuilder = new StringBuilder();
        if (originalId != null) {
            char[] nameSpace = new char[(columnSize - originalId.length()) / 2];
            Arrays.fill(nameSpace, ' ');
            contentBuilder.append(nameSpace);
            contentBuilder.append(originalId);
            contentBuilder.append(nameSpace);
            contentBuilder.append("\n");
        }
        for (AttributeRecord attributeRecord : attributeRecords) {
            if (attributeRecord.isSystem() || !attributeRecord.isVisible()) continue;
            contentBuilder.append(attributeRecord.getName());
            contentBuilder.append(":");
            char[] nameSpace = new char[maxNameLength - attributeRecord.getName().length()];
            Arrays.fill(nameSpace, ' ');
            contentBuilder.append(nameSpace);
            if (!attributeRecord.getStringValue().contains("\n")) {
                char[] valueSpace = new char[maxValueLength - attributeRecord.getStringValue().length()];
                Arrays.fill(valueSpace, ' ');
                contentBuilder.append(valueSpace);
                contentBuilder.append(attributeRecord.getStringValue());
            } else {
                contentBuilder.append("\n");
                contentBuilder.append(attributeRecord.getStringValue());
            }
            contentBuilder.append("\n");
        }
        return contentBuilder.toString();
    }

    private void updateVisibleAttributeRecords(List<AttributeRecord> attributeRecords, String visibleAttributesPattern) {
        ArrayList<AttributeRecord> attributeRecordsForUpdating = new ArrayList<AttributeRecord>();
        for (AttributeRecord attributeRecord : attributeRecords) {
            boolean isVisible = attributeRecord.getName().matches(visibleAttributesPattern);
            if (isVisible == attributeRecord.isVisible()) continue;
            attributeRecord.setVisible(isVisible);
            attributeRecordsForUpdating.add(attributeRecord);
        }
        this.graphStorage.editAttributeRecords(this.graphModelId, attributeRecordsForUpdating);
    }

    private String getOrDefaultVertexColorHex(List<AttributeRecord> attributeRecords, List<GraphModelAttributesMapping.VertexColorRule> vertexColorRules, Color defaultColor) {
        for (GraphModelAttributesMapping.VertexColorRule vertexColorRule : vertexColorRules) {
            for (AttributeRecord attributeRecord : attributeRecords) {
                Color color;
                if (!vertexColorRule.getAttributeName().equalsIgnoreCase(attributeRecord.getName()) || (color = X11Colors.get(attributeRecord.getStringValue())) == null) continue;
                String colorHex = String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
                if (vertexColorRule.getExcludeColors().contains(colorHex)) continue;
                return colorHex;
            }
        }
        return String.format("#%02x%02x%02x", defaultColor.getRed(), defaultColor.getGreen(), defaultColor.getBlue());
    }

    private VertexGraphics.ShapeType getOrDefaultVertexShapeType(List<AttributeRecord> attributeRecords, List<GraphModelAttributesMapping.VertexShapeRule> vertexShapeRules, VertexGraphics.ShapeType defaultShapeType) {
        for (GraphModelAttributesMapping.VertexShapeRule vertexShapeRule : vertexShapeRules) {
            for (AttributeRecord attributeRecord : attributeRecords) {
                String value;
                if (!vertexShapeRule.getAttributeName().equalsIgnoreCase(attributeRecord.getName()) || (value = attributeRecord.getStringValue()) == null || !value.matches(vertexShapeRule.getAttributeValuePattern())) continue;
                return vertexShapeRule.getShapeType();
            }
        }
        return defaultShapeType;
    }

    private void drawGraphModel(Graphics2D graphics) {
        this.graphStorage.dfs(this.graphModelId, it -> {
            AttributeRecord vertexGraphicsAttributeRecord = this.graphStorage.findAttributeRecordByOwnerAndName(this.graphModelId, it.getId(), AttributeOwnerType.VERTEX, "system_vertex_graphics").orElse(null);
            if (vertexGraphicsAttributeRecord == null) {
                return;
            }
            VertexGraphics vertexGraphics = JsonUtils.fromJson(vertexGraphicsAttributeRecord.getStringValue(), VertexGraphics.class);
            this.drawVertex(vertexGraphics, graphics);
        }, it -> {}, it -> {
            AttributeRecord edgeGraphicsAttributeRecord = this.graphStorage.findAttributeRecordByOwnerAndName(this.graphModelId, it.getId(), AttributeOwnerType.EDGE, "system_edge_graphics").orElse(null);
            if (edgeGraphicsAttributeRecord == null) {
                return;
            }
            EdgeGraphics edgeGraphics = JsonUtils.fromJson(edgeGraphicsAttributeRecord.getStringValue(), EdgeGraphics.class);
            this.drawEdge(edgeGraphics, graphics);
        });
    }

    private void drawVertex(VertexGraphics vertexGraphics, Graphics2D graphics) {
        int diameter;
        if (vertexGraphics.isSelected()) {
            graphics.setColor(Color.RED);
        } else {
            graphics.setColor(Color.BLUE);
        }
        Rectangle boundingBox = vertexGraphics.getBoundingBox();
        int x = boundingBox.x;
        int y = boundingBox.y;
        int w = boundingBox.width;
        int h = boundingBox.height;
        int border = vertexGraphics.getBorder();
        switch (vertexGraphics.getShapeType()) {
            case RECTANGLE: {
                graphics.fillRect(x, y, w, h);
                break;
            }
            case CIRCLE: {
                diameter = Math.max(w, h);
                graphics.fillOval(x, y, diameter, diameter);
                break;
            }
            case DIAMOND: {
                Polygon diamond = new Polygon();
                diamond.addPoint(x + w / 2, y);
                diamond.addPoint(x + w, y + h / 2);
                diamond.addPoint(x + w / 2, y + h);
                diamond.addPoint(x, y + h / 2);
                graphics.fillPolygon(diamond);
            }
        }
        graphics.setColor(Color.decode(vertexGraphics.getColor()));
        switch (vertexGraphics.getShapeType()) {
            case RECTANGLE: {
                graphics.fillRect(x + border, y + border, w - 2 * border, h - 2 * border);
                break;
            }
            case CIRCLE: {
                diameter = Math.max(w, h) - 2 * border;
                graphics.fillOval(x + border, y + border, diameter, diameter);
                break;
            }
            case DIAMOND: {
                Polygon innerDiamond = new Polygon();
                innerDiamond.addPoint(x + w / 2, y + border);
                innerDiamond.addPoint(x + w - border, y + h / 2);
                innerDiamond.addPoint(x + w / 2, y + h - border);
                innerDiamond.addPoint(x + border, y + h / 2);
                graphics.fillPolygon(innerDiamond);
            }
        }
        if (vertexGraphics.isHighlighted()) {
            GraphViewCanvas.drawVertexHighlighting(graphics, vertexGraphics.getBoundingBox(), VGConfigSettings.GRAPH_VIEW_VERTEX_DEFAULT_HIGHLIGHTING_COLOR);
        }
        this.drawVertexLabel(vertexGraphics, graphics);
    }

    private void drawVertexLabel(VertexGraphics vertexGraphics, Graphics2D graphics) {
        if (vertexGraphics == null || vertexGraphics.getLabel() == null) {
            return;
        }
        VertexGraphics.VertexLabel vertexLabel = vertexGraphics.getLabel();
        if (!vertexLabel.isVisible() || vertexLabel.getContent() == null || vertexLabel.getContent().isEmpty()) {
            return;
        }
        Font font = VGConfigSettings.getFontResource("font/ubuntu-mono/UbuntuMono-R.ttf").deriveFont((float)vertexLabel.getFontSize());
        graphics.setFont(font);
        graphics.setColor(Color.BLACK);
        FontMetrics fm = graphics.getFontMetrics();
        String[] lines = vertexLabel.getContent().split("\n");
        int labelX = vertexGraphics.getBoundingBox().x + vertexGraphics.getLabelOffset().x;
        int labelY = vertexGraphics.getBoundingBox().y + vertexGraphics.getLabelOffset().y + fm.getAscent();
        for (String line : lines) {
            graphics.drawString(line, labelX, labelY);
            labelY += fm.getHeight();
        }
    }

    private void drawEdge(EdgeGraphics edgeGraphics, Graphics2D graphics) {
        if (edgeGraphics.getPoints() == null || edgeGraphics.getPoints().isEmpty()) {
            return;
        }
        if (edgeGraphics.isSelected()) {
            graphics.setColor(Color.RED);
        } else {
            graphics.setColor(Color.BLUE);
        }
        Stroke originalStroke = graphics.getStroke();
        BasicStroke stroke = edgeGraphics.getLineType() == EdgeGraphics.LineType.DASHED ? new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{8.0f, 6.0f}, 0.0f) : new BasicStroke(1.0f);
        graphics.setStroke(stroke);
        for (int i = 0; i < edgeGraphics.getPoints().size() - 1; ++i) {
            Point p1 = edgeGraphics.getPoints().get(i);
            Point p2 = edgeGraphics.getPoints().get(i + 1);
            graphics.drawLine(p1.x, p1.y, p2.x, p2.y);
            if (i == 0) {
                GraphViewCanvas.drawEndpoint(graphics, edgeGraphics.getLineStartType(), p1, p2);
            }
            if (i != edgeGraphics.getPoints().size() - 2) continue;
            GraphViewCanvas.drawEndpoint(graphics, edgeGraphics.getLineEndType(), p2, p1);
        }
        graphics.setStroke(originalStroke);
        if (edgeGraphics.isHighlighted()) {
            GraphViewCanvas.drawEdgeHighlighting(graphics, edgeGraphics.getPoints(), VGConfigSettings.GRAPH_VIEW_EDGE_DEFAULT_HIGHLIGHTING_COLOR);
        }
        this.drawEdgeLabel(edgeGraphics, graphics);
    }

    private void drawEdgeLabel(EdgeGraphics edgeGraphics, Graphics2D graphics) {
        if (edgeGraphics == null || edgeGraphics.getLabel() == null) {
            return;
        }
        EdgeGraphics.EdgeLabel edgeLabel = edgeGraphics.getLabel();
        if (edgeLabel.getContent() == null || edgeLabel.getContent().isEmpty()) {
            return;
        }
        Font font = VGConfigSettings.getFontResource("font/ubuntu-mono/UbuntuMono-R.ttf").deriveFont((float)edgeLabel.getFontSize());
        graphics.setFont(font);
        FontMetrics fm = graphics.getFontMetrics();
        String[] lines = edgeLabel.getContent().split("\n");
        int labelWidth = edgeLabel.getWidth();
        int labelHeight = edgeLabel.getHeight();
        int x = edgeGraphics.getBoundingBox().x + edgeGraphics.getLabelOffset().x;
        int y = edgeGraphics.getBoundingBox().y + edgeGraphics.getLabelOffset().y;
        int padding = 1;
        int arcSize = 3;
        graphics.setColor(Color.WHITE);
        graphics.fillRoundRect(x - padding, y - padding, labelWidth + 2 * padding, labelHeight + 2 * padding, arcSize, arcSize);
        graphics.setColor(Color.BLUE);
        graphics.drawRoundRect(x - padding, y - padding, labelWidth + 2 * padding, labelHeight + 2 * padding, arcSize, arcSize);
        graphics.setColor(Color.BLACK);
        int textY = y + fm.getAscent();
        for (String line : lines) {
            graphics.drawString(line, x, textY);
            textY += fm.getHeight();
        }
    }

    private static void drawEndpoint(Graphics2D g, EdgeGraphics.LineEndpointType type, Point tip, Point tail) {
        switch (type) {
            case ARROW: {
                GraphViewCanvas.drawArrow(g, tail.x, tail.y, tip.x, tip.y);
                break;
            }
        }
    }

    private static void drawArrow(Graphics2D g, int x1, int y1, int x2, int y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double angle = Math.atan2(dy, dx);
        double degrees = Math.toDegrees(angle);
        degrees = (degrees + 360.0) % 360.0;
        int arrowLength = 10;
        int arrowHalfWidth = 5;
        int lineThickness = 1;
        if (Math.abs(degrees - 0.0) < 5.0) {
            Polygon top = new Polygon();
            top.addPoint(x2, y2);
            top.addPoint(x2 - arrowLength, y2 - arrowHalfWidth);
            top.addPoint(x2 - arrowLength, y2);
            g.fillPolygon(top);
            Polygon bottom = new Polygon();
            bottom.addPoint(x2, y2);
            bottom.addPoint(x2 - arrowLength, y2 + arrowHalfWidth + lineThickness);
            bottom.addPoint(x2 - arrowLength, y2 + lineThickness);
            g.fillPolygon(bottom);
            return;
        }
        if (Math.abs(degrees - 90.0) < 5.0) {
            Polygon left = new Polygon();
            left.addPoint(x2 - arrowHalfWidth, y2 - arrowLength);
            left.addPoint(x2, y2 - arrowLength);
            left.addPoint(x2, y2 - lineThickness);
            g.fillPolygon(left);
            Polygon right = new Polygon();
            right.addPoint(x2 + lineThickness + arrowHalfWidth, y2 - arrowLength);
            right.addPoint(x2 + lineThickness, y2 - arrowLength);
            right.addPoint(x2 + lineThickness, y2 - lineThickness);
            g.fillPolygon(right);
            return;
        }
        if (Math.abs(degrees - 180.0) < 5.0) {
            Polygon top = new Polygon();
            top.addPoint(x2, y2);
            top.addPoint(x2 + arrowLength, y2 - arrowHalfWidth);
            top.addPoint(x2 + arrowLength, y2);
            g.fillPolygon(top);
            Polygon bottom = new Polygon();
            bottom.addPoint(x2, y2);
            bottom.addPoint(x2 + arrowLength, y2 + arrowHalfWidth + lineThickness);
            bottom.addPoint(x2 + arrowLength, y2 + lineThickness);
            g.fillPolygon(bottom);
            return;
        }
        if (Math.abs(degrees - 270.0) < 5.0) {
            Polygon left = new Polygon();
            left.addPoint(x2, y2);
            left.addPoint(x2 - arrowHalfWidth, y2 + arrowLength);
            left.addPoint(x2, y2 + arrowLength);
            g.fillPolygon(left);
            Polygon right = new Polygon();
            right.addPoint(x2, y2);
            right.addPoint(x2 + arrowHalfWidth + lineThickness, y2 + arrowLength);
            right.addPoint(x2 + lineThickness, y2 + arrowLength);
            g.fillPolygon(right);
            return;
        }
        double length = Math.hypot(dx, dy);
        if (length == 0.0) {
            return;
        }
        double unitX = dx / length;
        double unitY = dy / length;
        int baseX = (int)((double)x2 - (double)arrowLength * unitX);
        int baseY = (int)((double)y2 - (double)arrowLength * unitY);
        double perpX = -unitY;
        double perpY = unitX;
        int leftX = (int)((double)baseX + (double)arrowHalfWidth * perpX);
        int leftY = (int)((double)baseY + (double)arrowHalfWidth * perpY);
        int rightX = (int)((double)baseX - (double)arrowHalfWidth * perpX);
        int rightY = (int)((double)baseY - (double)arrowHalfWidth * perpY);
        Polygon arrowHead = new Polygon();
        arrowHead.addPoint(x2, y2);
        arrowHead.addPoint(leftX, leftY);
        arrowHead.addPoint(rightX, rightY);
        g.fillPolygon(arrowHead);
    }

    private void drawGrid(Graphics2D g, int width, int height) {
        int gridSize = this.getOrSetGridSize();
        if (gridSize <= 0) {
            return;
        }
        Color thinLine = new Color(230, 230, 230);
        Color boldLine = new Color(210, 210, 210);
        for (int x = 0; x < width; x += gridSize) {
            if (x % (gridSize * 5) == 0) {
                g.setColor(boldLine);
            } else {
                g.setColor(thinLine);
            }
            g.drawLine(x, 0, x, height);
        }
        for (int y = 0; y < height; y += gridSize) {
            if (y % (gridSize * 5) == 0) {
                g.setColor(boldLine);
            } else {
                g.setColor(thinLine);
            }
            g.drawLine(0, y, width, y);
        }
    }

    public String getGraphName() {
        return this.graphStorage.findGraphModelRecord(this.graphModelId).orElseThrow(() -> new IllegalArgumentException(ERROR_GRAPH_MODEL_WAS_NOT_FOUND.formatted(this.graphModelId))).getName();
    }

    public void setGraphName(@NonNull String graphName) {
        if (graphName == null) {
            throw new NullPointerException("graphName is marked non-null but is null");
        }
        GraphModelRecord graphModelRecord = this.graphStorage.findGraphModelRecord(this.graphModelId).orElseThrow(() -> new IllegalArgumentException(ERROR_GRAPH_MODEL_WAS_NOT_FOUND.formatted(this.graphModelId)));
        graphModelRecord.setName(graphName);
        this.graphStorage.editGraphModelRecord(graphModelRecord);
    }

    public void patchViewSummary(GraphModelViewSummary summary) {
        GraphModelViewSummary existingSummary = this.graphStorage.findAttributeRecordByOwnerAndName(this.graphModelId, this.graphModelId, AttributeOwnerType.GRAPH_MODEL, "system_graph_model_view_summary").map(it -> JsonUtils.fromJson(it.getStringValue(), GraphModelViewSummary.class)).orElse(null);
        if (existingSummary == null) {
            existingSummary = GraphModelViewSummary.builder().build();
        }
        if (summary != null) {
            if (summary.getTotalNumberOfCrosses() != null) {
                existingSummary.setTotalNumberOfCrosses(summary.getTotalNumberOfCrosses());
            }
            if (summary.getCanvasWidth() != null) {
                existingSummary.setCanvasWidth(summary.getCanvasWidth());
            }
            if (summary.getCanvasHeight() != null) {
                existingSummary.setCanvasHeight(summary.getCanvasHeight());
            }
        }
        this.graphStorage.createOrUpdateGraphModelAttribute(this.graphModelId, "system_graph_model_view_summary", JsonUtils.toJson(existingSummary), AttributeRecordType.JSON, false);
    }

    private boolean doSearchInContent(String content, String searchQuery, boolean caseSensitive, boolean matchWholeWords, boolean useRegex) {
        boolean check;
        if (searchQuery == null) {
            return true;
        }
        if (searchQuery.isBlank()) {
            check = false;
        } else if (useRegex) {
            Pattern regex = Pattern.compile(searchQuery, 32);
            check = regex.matcher(content).find();
        } else {
            int flags = 32;
            if (!caseSensitive) {
                flags |= 2;
            }
            if (matchWholeWords) {
                flags |= 0x10;
            }
            Pattern regex = Pattern.compile(searchQuery, flags);
            check = regex.matcher(content).find();
        }
        return check;
    }

    private BufferedImage[][] getCanvasTiles(Dimension canvasSize, int tileWidth, int tileHeight) {
        int cols = (int)Math.ceil((double)canvasSize.width / (double)tileWidth);
        int rows = (int)Math.ceil((double)canvasSize.height / (double)tileHeight);
        BufferedImage[][] tiles = new BufferedImage[rows][cols];
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                int x = col * tileWidth;
                int y = row * tileHeight;
                int w = Math.min(tileWidth, canvasSize.width - x);
                int h = Math.min(tileHeight, canvasSize.height - y);
                BufferedImage tile = new BufferedImage(w, h, 2);
                Graphics2D g = tile.createGraphics();
                g.setColor(Color.WHITE);
                g.fillRect(0, 0, w, h);
                g.translate(-x, -y);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                this.drawGrid(g, canvasSize.width, canvasSize.height);
                this.drawGraphModel(g);
                g.dispose();
                tiles[row][col] = tile;
            }
        }
        return tiles;
    }

    public static void drawVertexHighlighting(Graphics2D graphics, Rectangle boundingBox, Color highlightingColor) {
        Stroke originalStroke = graphics.getStroke();
        graphics.setColor(highlightingColor);
        graphics.setStroke(new BasicStroke(4.0f, 1, 1));
        graphics.drawRoundRect(boundingBox.x - 4, boundingBox.y - 4, boundingBox.width + 8, boundingBox.height + 8, 14, 14);
        graphics.setStroke(originalStroke);
    }

    public static void drawEdgeHighlighting(Graphics2D graphics, List<Point> points, Color highlightingColor) {
        if (points == null || points.size() < 2) {
            return;
        }
        Stroke originalStroke = graphics.getStroke();
        graphics.setColor(highlightingColor);
        graphics.setStroke(new BasicStroke(4.0f, 1, 1));
        Path2D.Float path = new Path2D.Float();
        Point p0 = points.get(0);
        ((Path2D)path).moveTo(p0.x, p0.y);
        for (int i = 1; i < points.size(); ++i) {
            Point p = points.get(i);
            ((Path2D)path).lineTo(p.x, p.y);
        }
        graphics.draw(path);
        graphics.setStroke(originalStroke);
    }

    public int getGraphModelId() {
        return this.graphModelId;
    }

    public GraphStorage getGraphStorage() {
        return this.graphStorage;
    }

    public static class FindElementsResult {
        private List<Map.Entry<UUID, ElementType>> orderedElementGlobalIdsWithTypes;
        private List<UUID> vertexGlobalIds;
        private List<UUID> edgeGlobalIds;
        private LinkedHashMap<UUID, VertexGraphics> sortedVertices;
        private LinkedHashMap<UUID, EdgeGraphics> sortedEdges;

        public static FindElementsResultBuilder builder() {
            return new FindElementsResultBuilder();
        }

        public List<Map.Entry<UUID, ElementType>> getOrderedElementGlobalIdsWithTypes() {
            return this.orderedElementGlobalIdsWithTypes;
        }

        public List<UUID> getVertexGlobalIds() {
            return this.vertexGlobalIds;
        }

        public List<UUID> getEdgeGlobalIds() {
            return this.edgeGlobalIds;
        }

        public LinkedHashMap<UUID, VertexGraphics> getSortedVertices() {
            return this.sortedVertices;
        }

        public LinkedHashMap<UUID, EdgeGraphics> getSortedEdges() {
            return this.sortedEdges;
        }

        public void setOrderedElementGlobalIdsWithTypes(List<Map.Entry<UUID, ElementType>> orderedElementGlobalIdsWithTypes) {
            this.orderedElementGlobalIdsWithTypes = orderedElementGlobalIdsWithTypes;
        }

        public void setVertexGlobalIds(List<UUID> vertexGlobalIds) {
            this.vertexGlobalIds = vertexGlobalIds;
        }

        public void setEdgeGlobalIds(List<UUID> edgeGlobalIds) {
            this.edgeGlobalIds = edgeGlobalIds;
        }

        public void setSortedVertices(LinkedHashMap<UUID, VertexGraphics> sortedVertices) {
            this.sortedVertices = sortedVertices;
        }

        public void setSortedEdges(LinkedHashMap<UUID, EdgeGraphics> sortedEdges) {
            this.sortedEdges = sortedEdges;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FindElementsResult)) {
                return false;
            }
            FindElementsResult other = (FindElementsResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Map.Entry<UUID, ElementType>> this$orderedElementGlobalIdsWithTypes = this.getOrderedElementGlobalIdsWithTypes();
            List<Map.Entry<UUID, ElementType>> other$orderedElementGlobalIdsWithTypes = other.getOrderedElementGlobalIdsWithTypes();
            if (this$orderedElementGlobalIdsWithTypes == null ? other$orderedElementGlobalIdsWithTypes != null : !((Object)this$orderedElementGlobalIdsWithTypes).equals(other$orderedElementGlobalIdsWithTypes)) {
                return false;
            }
            List<UUID> this$vertexGlobalIds = this.getVertexGlobalIds();
            List<UUID> other$vertexGlobalIds = other.getVertexGlobalIds();
            if (this$vertexGlobalIds == null ? other$vertexGlobalIds != null : !((Object)this$vertexGlobalIds).equals(other$vertexGlobalIds)) {
                return false;
            }
            List<UUID> this$edgeGlobalIds = this.getEdgeGlobalIds();
            List<UUID> other$edgeGlobalIds = other.getEdgeGlobalIds();
            if (this$edgeGlobalIds == null ? other$edgeGlobalIds != null : !((Object)this$edgeGlobalIds).equals(other$edgeGlobalIds)) {
                return false;
            }
            LinkedHashMap<UUID, VertexGraphics> this$sortedVertices = this.getSortedVertices();
            LinkedHashMap<UUID, VertexGraphics> other$sortedVertices = other.getSortedVertices();
            if (this$sortedVertices == null ? other$sortedVertices != null : !((Object)this$sortedVertices).equals(other$sortedVertices)) {
                return false;
            }
            LinkedHashMap<UUID, EdgeGraphics> this$sortedEdges = this.getSortedEdges();
            LinkedHashMap<UUID, EdgeGraphics> other$sortedEdges = other.getSortedEdges();
            return !(this$sortedEdges == null ? other$sortedEdges != null : !((Object)this$sortedEdges).equals(other$sortedEdges));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FindElementsResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Map.Entry<UUID, ElementType>> $orderedElementGlobalIdsWithTypes = this.getOrderedElementGlobalIdsWithTypes();
            result = result * 59 + ($orderedElementGlobalIdsWithTypes == null ? 43 : ((Object)$orderedElementGlobalIdsWithTypes).hashCode());
            List<UUID> $vertexGlobalIds = this.getVertexGlobalIds();
            result = result * 59 + ($vertexGlobalIds == null ? 43 : ((Object)$vertexGlobalIds).hashCode());
            List<UUID> $edgeGlobalIds = this.getEdgeGlobalIds();
            result = result * 59 + ($edgeGlobalIds == null ? 43 : ((Object)$edgeGlobalIds).hashCode());
            LinkedHashMap<UUID, VertexGraphics> $sortedVertices = this.getSortedVertices();
            result = result * 59 + ($sortedVertices == null ? 43 : ((Object)$sortedVertices).hashCode());
            LinkedHashMap<UUID, EdgeGraphics> $sortedEdges = this.getSortedEdges();
            result = result * 59 + ($sortedEdges == null ? 43 : ((Object)$sortedEdges).hashCode());
            return result;
        }

        public String toString() {
            return "GraphViewCanvas.FindElementsResult(orderedElementGlobalIdsWithTypes=" + this.getOrderedElementGlobalIdsWithTypes() + ", vertexGlobalIds=" + this.getVertexGlobalIds() + ", edgeGlobalIds=" + this.getEdgeGlobalIds() + ", sortedVertices=" + this.getSortedVertices() + ", sortedEdges=" + this.getSortedEdges() + ")";
        }

        public FindElementsResult(List<Map.Entry<UUID, ElementType>> orderedElementGlobalIdsWithTypes, List<UUID> vertexGlobalIds, List<UUID> edgeGlobalIds, LinkedHashMap<UUID, VertexGraphics> sortedVertices, LinkedHashMap<UUID, EdgeGraphics> sortedEdges) {
            this.orderedElementGlobalIdsWithTypes = orderedElementGlobalIdsWithTypes;
            this.vertexGlobalIds = vertexGlobalIds;
            this.edgeGlobalIds = edgeGlobalIds;
            this.sortedVertices = sortedVertices;
            this.sortedEdges = sortedEdges;
        }

        public static class FindElementsResultBuilder {
            private List<Map.Entry<UUID, ElementType>> orderedElementGlobalIdsWithTypes;
            private List<UUID> vertexGlobalIds;
            private List<UUID> edgeGlobalIds;
            private LinkedHashMap<UUID, VertexGraphics> sortedVertices;
            private LinkedHashMap<UUID, EdgeGraphics> sortedEdges;

            FindElementsResultBuilder() {
            }

            public FindElementsResultBuilder orderedElementGlobalIdsWithTypes(List<Map.Entry<UUID, ElementType>> orderedElementGlobalIdsWithTypes) {
                this.orderedElementGlobalIdsWithTypes = orderedElementGlobalIdsWithTypes;
                return this;
            }

            public FindElementsResultBuilder vertexGlobalIds(List<UUID> vertexGlobalIds) {
                this.vertexGlobalIds = vertexGlobalIds;
                return this;
            }

            public FindElementsResultBuilder edgeGlobalIds(List<UUID> edgeGlobalIds) {
                this.edgeGlobalIds = edgeGlobalIds;
                return this;
            }

            public FindElementsResultBuilder sortedVertices(LinkedHashMap<UUID, VertexGraphics> sortedVertices) {
                this.sortedVertices = sortedVertices;
                return this;
            }

            public FindElementsResultBuilder sortedEdges(LinkedHashMap<UUID, EdgeGraphics> sortedEdges) {
                this.sortedEdges = sortedEdges;
                return this;
            }

            public FindElementsResult build() {
                return new FindElementsResult(this.orderedElementGlobalIdsWithTypes, this.vertexGlobalIds, this.edgeGlobalIds, this.sortedVertices, this.sortedEdges);
            }

            public String toString() {
                return "GraphViewCanvas.FindElementsResult.FindElementsResultBuilder(orderedElementGlobalIdsWithTypes=" + this.orderedElementGlobalIdsWithTypes + ", vertexGlobalIds=" + this.vertexGlobalIds + ", edgeGlobalIds=" + this.edgeGlobalIds + ", sortedVertices=" + this.sortedVertices + ", sortedEdges=" + this.sortedEdges + ")";
            }
        }
    }

    public static enum SelectionMode {
        ADD_OR_REMOVE,
        ADD,
        REPLACE;

    }
}

