/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.view;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.NonNull;
import vg.lib.storage.GraphStorage;
import vg.lib.view.GraphViewCanvas;

public class GraphViewCachedCanvas
extends GraphViewCanvas {
    private volatile CacheState cacheState;
    private volatile int lastScalePercent = -1;
    private Future<?> futureCache;
    private final AtomicBoolean isUpdateInProgress = new AtomicBoolean(false);
    private final ExecutorService executor = ForkJoinPool.commonPool();

    public GraphViewCachedCanvas(@NonNull GraphStorage graphStorage, int graphModelId) {
        super(graphStorage, graphModelId);
        if (graphStorage == null) {
            throw new NullPointerException("graphStorage is marked non-null but is null");
        }
    }

    public GraphViewCachedCanvas(@NonNull String graphName) {
        super(graphName);
        if (graphName == null) {
            throw new NullPointerException("graphName is marked non-null but is null");
        }
    }

    @Override
    public void repaint() {
        this.clearCache();
        super.repaint();
    }

    private void clearCache() {
        this.cacheState = null;
        this.lastScalePercent = -1;
        if (this.futureCache != null && !this.futureCache.isDone()) {
            this.futureCache.cancel(false);
        }
        this.isUpdateInProgress.set(false);
    }

    @Override
    public BufferedImage getScaledCanvasImage(int scaledX, int scaledY, int scaledW, int scaledH) {
        int currentScalePercent = this.getOrSetImageScalePercent();
        double scaleFactor = (double)currentScalePercent / 100.0;
        if (this.lastScalePercent != currentScalePercent) {
            this.clearCache();
            this.lastScalePercent = currentScalePercent;
        }
        Rectangle requestScaled = new Rectangle(scaledX, scaledY, scaledW, scaledH);
        Rectangle requestOriginal = this.toOriginalRect(requestScaled, scaleFactor);
        Dimension canvasSize = this.getCanvasSize();
        Rectangle canvasBounds = new Rectangle(0, 0, canvasSize.width, canvasSize.height);
        Rectangle safeRequestOriginal = requestOriginal.intersection(canvasBounds);
        if (safeRequestOriginal.isEmpty()) {
            return new BufferedImage(1, 1, 2);
        }
        CacheState state = this.cacheState;
        if (state != null && state.scaledImage != null) {
            if (state.originalSafeRegion.contains(safeRequestOriginal)) {
                return this.cropImageSafe(state, requestScaled);
            }
            if (state.originalRegion.contains(safeRequestOriginal)) {
                this.scheduleAsyncUpdate(safeRequestOriginal, canvasBounds, scaleFactor);
                return this.cropImageSafe(state, requestScaled);
            }
            if (this.waitForPendingUpdate(safeRequestOriginal)) {
                return this.cropImageSafe(this.cacheState, requestScaled);
            }
        }
        return this.buildCacheSynchronously(safeRequestOriginal, canvasBounds, scaleFactor);
    }

    @Override
    public BufferedImage getCanvasImage(int x, int y, int width, int height) {
        return super.getCanvasImage(x, y, width, height);
    }

    private BufferedImage cropImageSafe(CacheState state, Rectangle requestScaled) {
        if (state == null || state.scaledImage == null) {
            return new BufferedImage(1, 1, 2);
        }
        int srcX = requestScaled.x - state.scaledRegion.x;
        int srcY = requestScaled.y - state.scaledRegion.y;
        int availableW = state.scaledImage.getWidth() - srcX;
        int availableH = state.scaledImage.getHeight() - srcY;
        int finalW = Math.max(1, Math.min(requestScaled.width, availableW));
        int finalH = Math.max(1, Math.min(requestScaled.height, availableH));
        if (srcX < 0 || srcY < 0) {
            return new BufferedImage(1, 1, 2);
        }
        return state.scaledImage.getSubimage(srcX, srcY, finalW, finalH);
    }

    private void scheduleAsyncUpdate(Rectangle requestOriginal, Rectangle canvasBounds, double scale) {
        if (this.isUpdateInProgress.compareAndSet(false, true)) {
            this.futureCache = this.executor.submit(() -> {
                try {
                    this.updateCacheInternal(requestOriginal, canvasBounds, scale);
                }
                finally {
                    this.isUpdateInProgress.set(false);
                }
            });
        }
    }

    private boolean waitForPendingUpdate(Rectangle requestOriginal) {
        Future<?> currentTask = this.futureCache;
        if (currentTask != null) {
            try {
                currentTask.get();
                CacheState newState = this.cacheState;
                return newState != null && newState.originalRegion.contains(requestOriginal);
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private BufferedImage buildCacheSynchronously(Rectangle requestOriginal, Rectangle canvasBounds, double scale) {
        this.updateCacheInternal(requestOriginal, canvasBounds, scale);
        Rectangle requestScaled = this.toScaledRect(requestOriginal, scale);
        return this.cropImageSafe(this.cacheState, requestScaled);
    }

    private void updateCacheInternal(Rectangle safeRequestOriginal, Rectangle canvasBounds, double scale) {
        int idealX = safeRequestOriginal.x - 2500;
        int idealY = safeRequestOriginal.y - 2500;
        int idealW = safeRequestOriginal.width + 5000;
        int idealH = safeRequestOriginal.height + 5000;
        Rectangle finalOriginalRect = new Rectangle(idealX, idealY, idealW, idealH).intersection(canvasBounds);
        if (finalOriginalRect.isEmpty()) {
            return;
        }
        int safeX = safeRequestOriginal.x - 900;
        int safeY = safeRequestOriginal.y - 900;
        int safeW = safeRequestOriginal.width + 1800;
        int safeH = safeRequestOriginal.height + 1800;
        Rectangle safeRegionRect = new Rectangle(safeX, safeY, safeW, safeH);
        Rectangle scaledRect = this.toScaledRect(finalOriginalRect, scale);
        BufferedImage newImage = super.getScaledCanvasImage(scaledRect.x, scaledRect.y, scaledRect.width, scaledRect.height);
        this.cacheState = new CacheState(newImage, scaledRect, finalOriginalRect, safeRegionRect);
    }

    private Rectangle toOriginalRect(Rectangle scaled, double scale) {
        if (scale == 0.0) {
            scale = 1.0;
        }
        return new Rectangle((int)((double)scaled.x / scale), (int)((double)scaled.y / scale), (int)((double)scaled.width / scale), (int)((double)scaled.height / scale));
    }

    private Rectangle toScaledRect(Rectangle original, double scale) {
        return new Rectangle((int)((double)original.x * scale), (int)((double)original.y * scale), (int)((double)original.width * scale), (int)((double)original.height * scale));
    }

    private record CacheState(BufferedImage scaledImage, Rectangle scaledRegion, Rectangle originalRegion, Rectangle originalSafeRegion) {
    }
}

