/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.storage;

import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vg.lib.model.record.AttributeOwnerType;
import vg.lib.model.record.AttributeRecord;
import vg.lib.model.record.AttributeRecordType;
import vg.lib.model.record.EdgeRecord;
import vg.lib.model.record.GraphModelRecord;
import vg.lib.model.record.VertexRecord;
import vg.lib.storage.GraphStorage;

public class SQLiteGraphStorage
implements GraphStorage {
    private static final Logger log = LoggerFactory.getLogger(SQLiteGraphStorage.class);
    private static final int BATCH_SIZE = 500;
    private static final int SQLITE_MAX_VARIABLE_NUMBER = 20000;
    private static final String GRAPH_MODEL_TABLE = "graph_model";
    private static final String GRAPH_TABLE_ID = "id";
    private static final String GRAPH_TABLE_NAME = "name";
    private static final String TABLE_VERTEX = "vertex";
    private static final String VERTEX_TABLE_ID = "id";
    private static final String VERTEX_TABLE_GRAPH_MODEL_ID = "graph_model_id";
    private static final String VERTEX_TABLE_GLOBAL_ID = "global_id";
    private static final String VERTEX_TABLE_PARENT_ID = "parent_id";
    private static final String VERTEX_TABLE_IS_COMPOSITE = "is_composite";
    private static final String VERTEX_TABLE_DELETED = "deleted";
    private static final String EDGE_TABLE_ID = "id";
    private static final String EDGE_TABLE_GRAPH_MODEL_ID = "graph_model_id";
    private static final String EDGE_TABLE_GLOBAL_ID = "global_id";
    private static final String EDGE_TABLE_PARENT_ID = "parent_id";
    private static final String EDGE_TABLE_SOURCE_VERTEX = "source_id";
    private static final String EDGE_TABLE_TARGET_VERTEX = "target_id";
    private static final String EDGE_TABLE_VISIBLE = "visible";
    private static final String EDGE_TABLE_DELETED = "deleted";
    private static final String ATTRIBUTE_TABLE = "attribute";
    private static final String ATTRIBUTE_TABLE_ID = "id";
    private static final String ATTRIBUTE_TABLE_GRAPH_MODEL_ID = "graph_model_id";
    private static final String ATTRIBUTE_TABLE_OWNER_ID = "owner_id";
    private static final String ATTRIBUTE_TABLE_OWNER_TYPE = "owner_type";
    private static final String ATTRIBUTE_TABLE_NAME = "name";
    private static final String ATTRIBUTE_TABLE_VALUE = "value";
    private static final String ATTRIBUTE_TABLE_VISIBLE = "visible";
    private static final String ATTRIBUTE_TABLE_VALUE_TYPE = "value_type";
    private static final String CREATE_GRAPH_MODEL_TABLE = "        create table graph_model (\n        id INT PRIMARY KEY,\n        name VARCHAR);\n";
    private static final String CREATE_VERTEX_TABLE = "            CREATE TABLE vertex (\n            graph_model_id INT NOT NULL,\n            id INT NOT NULL,\n            global_id BLOB NOT NULL UNIQUE,\n            parent_id INT NOT NULL,\n            is_composite BOOL NOT NULL,\n            deleted BOOL NOT NULL,\n            PRIMARY KEY (graph_model_id, id));\n";
    private static final String CREATE_EDGE_TABLE = "    create table edge (\n        graph_model_id INT NOT NULL,\n        id INT NOT NULL,\n        global_id BLOB NOT NULL,\n        parent_id INT NOT NULL,\n        source_id INT NOT NULL,\n        target_id INT NOT NULL,\n        visible BOOL NOT NULL,\n        deleted BOOL NOT NULL,\n        PRIMARY KEY (graph_model_id, id));\n";
    private static final String CREATE_ATTRIBUTE_TABLE = "    create table attribute (\n        graph_model_id INT NOT NULL,\n        id INT NOT NULL,\n        owner_id INT,\n        owner_type INT,\n        value_type INT,\n        visible BOOL,\n        name VARCHAR,\n        value VARCHAR,\n        PRIMARY KEY (graph_model_id, id));\n";
    private static final String CREATE_IDX_VERTEX_GRAPH_MODEL_ID_AND_ID = "CREATE INDEX idx_vertex_graph_model_id_and_id ON vertex(graph_model_id, id);";
    private static final String CREATE_IDX_ATTRIBUTE_GRAPH_MODEL_ID_OWNER_AND_NAME_TABLE = "CREATE INDEX idx_attribute_graph_model_id_owner_and_name ON attribute(graph_model_id, owner_type, owner_id, name);";
    private static final String INSERT_GRAPH_MODEL = "insert into graph_model values(?, ?)";
    private static final String INSERT_VERTEX = "insert into vertex values(?, ?, ?, ?, ?, ?)";
    private static final String INSERT_EDGE = "insert into edge values(?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String INSERT_ATTRIBUTE = "insert into attribute values(?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_VERTEX_BY_GRAPH_MODEL_ID_AND_ID = "UPDATE vertex set is_composite=? where graph_model_id=? AND id=?";
    private static final String UPDATE_VERTEX_DELETED_BY_GRAPH_MODEL_ID_AND_ID = "UPDATE vertex set deleted=? where graph_model_id=? AND id=?";
    private static final String UPDATE_EDGE_DELETED_BY_GRAPH_MODEL_ID_AND_ID = "UPDATE edge SET deleted=? WHERE graph_model_id=? AND id=?";
    private static final String UPDATE_ATTRIBUTE_BY_GRAPH_MODEL_ID_AND_ID = "UPDATE attribute SET name=?, value=?, value_type=? WHERE graph_model_id=? AND id=?";
    private static final String SELECT_VERTICES_BY_GRAPH_MODEL_ID_AND_PARENT_ID = "SELECT * FROM vertex WHERE graph_model_id=%d AND parent_id=%d";
    private static final String SELECT_TOTAL_VERTICES_BY_GRAPH_MODEL_ID = "SELECT COUNT(*) FROM vertex WHERE graph_model_id=?";
    private static final String SELECT_TOTAL_EDGES_BY_GRAPH_MODEL_ID = "SELECT COUNT(*) FROM edge WHERE graph_model_id=? AND deleted=false";
    private static final String SELECT_TOTAL_VISIBLE_EDGES_BY_GRAPH_MODEL_ID = "SELECT COUNT(*) FROM edge WHERE graph_model_id=? AND deleted=false AND visible=true";
    private static final String SELECT_EDGE_BY_GRAPH_MODEL_ID_AND_ID = "SELECT * FROM edge WHERE graph_model_id=? AND id=?";
    private static final String SELECT_EDGE_BY_GLOBAL_ID = "SELECT * FROM edge WHERE global_id=?";
    private static final String SELECT_EDGES_BY_GRAPH_MODEL_ID_AND_PARENT_ID = "SELECT * FROM edge WHERE graph_model_id=? AND parent_id=?";
    private static final String SELECT_EDGES_BY_GRAPH_MODEL_ID = "SELECT * FROM edge WHERE graph_model_id=? AND visible=true";
    private static final String SELECT_EDGES_BY_GRAPH_MODEL_ID_VERTEX_ID = "SELECT * FROM edge WHERE graph_model_id=? AND (source_id=? or target_id=?) AND visible=true";
    private static final String SELECT_ROOTS_BY_GRAPH_MODEL_ID = "SELECT * FROM vertex WHERE graph_model_id=%d and parent_id < 0";
    private static final String SELECT_GRAPH_MODEL_BY_ID = "SELECT * FROM graph_model s1 WHERE s1.id=%d;";
    private static final String SELECT_GRAPH_MODELS = " SELECT *  FROM graph_model s1;";
    private static final String SELECT_VERTEX_BY_GRAPH_MODEL_ID_AND_ID = "SELECT * FROM vertex WHERE graph_model_id=? AND id=?";
    private static final String SELECT_VERTEX_BY_GLOBAL_ID = "SELECT * FROM vertex WHERE global_id=?";
    private static final String SELECT_ATTRIBUTE_BY_GRAPH_MODEL_ID_AND_ID = "SELECT * FROM attribute WHERE graph_model_id=%d AND id=%d;";
    private static final String SELECT_ATTRIBUTES_BY_GRAPH_MODEL_ID_AND_OWNER_AND_NAME = "SELECT * FROM attribute WHERE graph_model_id=%d AND owner_id=%d AND owner_type=%d AND name='%s';";
    private static final String SELECT_ATTRIBUTES_BY_GRAPH_MODEL_ID_AND_OWNERS = "SELECT * FROM attribute WHERE graph_model_id=%d AND owner_type=%d AND owner_id in (%s)";
    private static final String SELECT_ATTRIBUTES_BY_GRAPH_MODEL_ID_AND_NAME_AND_VALUE = "SELECT * FROM attribute WHERE graph_model_id=%d AND name='%s' AND value='%s';";
    private final Connection connection;
    private final AtomicInteger graphModelIdCounter;
    private final ConcurrentHashMap<Integer, GraphModelCounter> graphModelCounters;
    private final ConcurrentHashMap<Integer, ConcurrentHashMap<Integer, VertexRecord>> cachedVertexRecords = new ConcurrentHashMap();

    public SQLiteGraphStorage(String dataBaseFileName) {
        this.graphModelIdCounter = new AtomicInteger(1);
        this.graphModelCounters = new ConcurrentHashMap();
        try {
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + dataBaseFileName);
        }
        catch (ClassNotFoundException | SQLException ex) {
            throw new RuntimeException(ex);
        }
        try (Statement statement = this.connection.createStatement();){
            statement.execute("PRAGMA journal_mode = OFF");
            statement.execute("PRAGMA synchronous = OFF");
            statement.execute(CREATE_GRAPH_MODEL_TABLE);
            statement.execute(CREATE_VERTEX_TABLE);
            statement.execute(CREATE_EDGE_TABLE);
            statement.execute(CREATE_ATTRIBUTE_TABLE);
            statement.execute(CREATE_IDX_VERTEX_GRAPH_MODEL_ID_AND_ID);
            statement.execute(CREATE_IDX_ATTRIBUTE_GRAPH_MODEL_ID_OWNER_AND_NAME_TABLE);
            this.connection.setAutoCommit(false);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void close() {
        try {
            this.connection.commit();
            this.connection.close();
        }
        catch (SQLException ex) {
            log.warn("Problem with database disconnection.", (Throwable)ex);
        }
    }

    @Override
    public int createGraphModel(String name) {
        int n;
        block8: {
            int graphModelId = this.graphModelIdCounter.getAndIncrement();
            this.graphModelCounters.put(graphModelId, new GraphModelCounter());
            PreparedStatement preparedStatement = this.connection.prepareStatement(INSERT_GRAPH_MODEL);
            try {
                preparedStatement.setInt(1, graphModelId);
                preparedStatement.setString(2, name);
                preparedStatement.executeUpdate();
                n = graphModelId;
                if (preparedStatement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new RuntimeException(ex);
                }
            }
            preparedStatement.close();
        }
        return n;
    }

    @Override
    public List<Integer> doCreateVertices(int graphModelId, @NonNull List<Integer> parentIds) {
        if (parentIds == null) {
            throw new NullPointerException("parentIds is marked non-null but is null");
        }
        return this.doCreateVertices(graphModelId, parentIds, GraphStorage.generateGlobalIds(parentIds.size()));
    }

    @Override
    public List<Integer> doCreateVertices(int graphModelId, @NonNull List<Integer> parentIds, @NonNull List<UUID> globalIds) {
        if (parentIds == null) {
            throw new NullPointerException("parentIds is marked non-null but is null");
        }
        if (globalIds == null) {
            throw new NullPointerException("globalIds is marked non-null but is null");
        }
        if (parentIds.isEmpty() || globalIds.isEmpty() || parentIds.size() != globalIds.size()) {
            throw new IllegalArgumentException("Parent IDs and Global IDs must be non-empty and of equal size.");
        }
        ConcurrentHashMap localCachedVertexRecords = this.cachedVertexRecords.computeIfAbsent(graphModelId, k -> new ConcurrentHashMap());
        ArrayList<Integer> result = new ArrayList<Integer>(parentIds.size());
        AtomicInteger counter = this.graphModelCounters.get(graphModelId).getVertexIdCounter();
        try (PreparedStatement insertPreparedStatement = this.connection.prepareStatement(INSERT_VERTEX);
             PreparedStatement updatePreparedStatement = this.connection.prepareStatement(UPDATE_VERTEX_BY_GRAPH_MODEL_ID_AND_ID);){
            for (int i = 0; i < parentIds.size(); ++i) {
                Integer parentId = parentIds.get(i);
                UUID globalId = globalIds.get(i);
                int vertexId = counter.getAndIncrement();
                result.add(vertexId);
                insertPreparedStatement.setInt(1, graphModelId);
                insertPreparedStatement.setInt(2, vertexId);
                insertPreparedStatement.setBytes(3, SQLiteGraphStorage.globalIdToBytes(globalId));
                insertPreparedStatement.setInt(4, parentId);
                insertPreparedStatement.setBoolean(5, false);
                insertPreparedStatement.setBoolean(6, false);
                insertPreparedStatement.addBatch();
                if (parentId > 0) {
                    updatePreparedStatement.setBoolean(1, true);
                    updatePreparedStatement.setInt(2, graphModelId);
                    updatePreparedStatement.setInt(3, parentId);
                    updatePreparedStatement.addBatch();
                }
                if ((i + 1) % 500 == 0) {
                    insertPreparedStatement.executeBatch();
                    updatePreparedStatement.executeBatch();
                    insertPreparedStatement.clearBatch();
                    updatePreparedStatement.clearBatch();
                }
                VertexRecord vertexRecord = new VertexRecord(vertexId, graphModelId, globalId, parentId, false);
                localCachedVertexRecords.put(vertexId, vertexRecord);
                if (parentId <= 0) continue;
                VertexRecord parentVertexRecord = (VertexRecord)localCachedVertexRecords.get(parentId);
                parentVertexRecord.setComposite(true);
            }
            insertPreparedStatement.executeBatch();
            updatePreparedStatement.executeBatch();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    @Override
    public int doCreateEdge(int graphModelId, int parentId, int sourceVertexId, int targetVertexId, boolean visible) {
        return this.doCreateEdge(graphModelId, parentId, GraphStorage.generateGlobalId(), sourceVertexId, targetVertexId, visible);
    }

    @Override
    public int doCreateEdge(int graphModelId, int parentId, UUID globalId, int sourceVertexId, int targetVertexId, boolean visible) {
        int n;
        block8: {
            int edgeId = this.graphModelCounters.get(graphModelId).getEdgeIdCounter().getAndIncrement();
            PreparedStatement preparedStatement = this.connection.prepareStatement(INSERT_EDGE);
            try {
                preparedStatement.setInt(1, graphModelId);
                preparedStatement.setInt(2, edgeId);
                preparedStatement.setBytes(3, SQLiteGraphStorage.globalIdToBytes(globalId));
                preparedStatement.setInt(4, parentId);
                preparedStatement.setInt(5, sourceVertexId);
                preparedStatement.setInt(6, targetVertexId);
                preparedStatement.setBoolean(7, visible);
                preparedStatement.setBoolean(8, false);
                preparedStatement.executeUpdate();
                n = edgeId;
                if (preparedStatement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new RuntimeException(ex);
                }
            }
            preparedStatement.close();
        }
        return n;
    }

    @Override
    public List<Integer> doCreateAttributes(int graphModelId, @NonNull List<AttributeRecord> attributeRecords) {
        if (attributeRecords == null) {
            throw new NullPointerException("attributeRecords is marked non-null but is null");
        }
        if (attributeRecords.isEmpty()) {
            return List.of();
        }
        ArrayList<Integer> result = new ArrayList<Integer>(attributeRecords.size());
        AtomicInteger counter = this.graphModelCounters.get(graphModelId).getAttributeIdCounter();
        try (PreparedStatement insertPreparedStatement = this.connection.prepareStatement(INSERT_ATTRIBUTE);){
            for (int i = 0; i < attributeRecords.size(); ++i) {
                AttributeRecord record = attributeRecords.get(i);
                int attributeId = counter.getAndIncrement();
                result.add(attributeId);
                insertPreparedStatement.setInt(1, graphModelId);
                insertPreparedStatement.setInt(2, attributeId);
                insertPreparedStatement.setInt(3, record.getOwnerId());
                insertPreparedStatement.setInt(4, record.getOwnerType().getId());
                insertPreparedStatement.setInt(5, record.getType().getId());
                insertPreparedStatement.setBoolean(6, record.isVisible());
                insertPreparedStatement.setString(7, record.getName());
                insertPreparedStatement.setString(8, record.getStringValue());
                insertPreparedStatement.addBatch();
                if ((i + 1) % 500 != 0) continue;
                insertPreparedStatement.executeBatch();
                insertPreparedStatement.clearBatch();
            }
            insertPreparedStatement.executeBatch();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    @Override
    public void editGraphModelRecord(GraphModelRecord graphModelRecord) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void editAttributeRecords(int graphModelId, @NonNull List<AttributeRecord> attributeRecords) {
        if (attributeRecords == null) {
            throw new NullPointerException("attributeRecords is marked non-null but is null");
        }
        if (attributeRecords.isEmpty()) {
            return;
        }
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(UPDATE_ATTRIBUTE_BY_GRAPH_MODEL_ID_AND_ID);){
            for (int i = 0; i < attributeRecords.size(); ++i) {
                AttributeRecord record = attributeRecords.get(i);
                preparedStatement.setString(1, record.getName());
                preparedStatement.setString(2, record.getStringValue());
                preparedStatement.setInt(3, record.getType().getId());
                preparedStatement.setInt(4, graphModelId);
                preparedStatement.setInt(5, record.getId());
                preparedStatement.addBatch();
                if ((i + 1) % 500 != 0) continue;
                preparedStatement.executeBatch();
                preparedStatement.clearBatch();
            }
            preparedStatement.executeBatch();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void doDeleteVertexRecordById(int graphModelId, int vertexId) {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(UPDATE_VERTEX_DELETED_BY_GRAPH_MODEL_ID_AND_ID);){
            preparedStatement.setBoolean(1, true);
            preparedStatement.setInt(2, graphModelId);
            preparedStatement.setInt(3, vertexId);
            preparedStatement.executeUpdate();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void doDeleteEdgeRecordById(int graphModelId, int edgeId) {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(UPDATE_EDGE_DELETED_BY_GRAPH_MODEL_ID_AND_ID);){
            preparedStatement.setBoolean(1, true);
            preparedStatement.setInt(2, graphModelId);
            preparedStatement.setInt(3, edgeId);
            preparedStatement.executeUpdate();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int findTotalNumberOfVertices(int graphModelId) {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(SELECT_TOTAL_VERTICES_BY_GRAPH_MODEL_ID);){
            preparedStatement.setInt(1, graphModelId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    int n = resultSet.getInt(1);
                    return n;
                }
            }
            int n = 0;
            return n;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int findTotalNumberOfEdges(int graphModelId, boolean includeInvisible) {
        String sql = includeInvisible ? SELECT_TOTAL_EDGES_BY_GRAPH_MODEL_ID : SELECT_TOTAL_VISIBLE_EDGES_BY_GRAPH_MODEL_ID;
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(sql);){
            preparedStatement.setInt(1, graphModelId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    int n = resultSet.getInt(1);
                    return n;
                }
            }
            int n = 0;
            return n;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public List<GraphModelRecord> findGraphModelRecords() {
        ArrayList<GraphModelRecord> arrayList;
        block9: {
            Statement statement = this.connection.createStatement();
            try {
                ResultSet resultSet = statement.executeQuery(SELECT_GRAPH_MODELS);
                ArrayList<GraphModelRecord> result = new ArrayList<GraphModelRecord>(this.graphModelCounters.size());
                while (resultSet.next()) {
                    result.add(new GraphModelRecord(resultSet.getInt("id"), resultSet.getString("name")));
                }
                arrayList = result;
                if (statement == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new RuntimeException(ex);
                }
            }
            statement.close();
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<GraphModelRecord> findGraphModelRecord(int graphModelId) {
        String query = String.format(SELECT_GRAPH_MODEL_BY_ID, graphModelId);
        try (Statement statement = this.connection.createStatement();){
            ResultSet resultSet = statement.executeQuery(query);
            if (!resultSet.next()) {
                Optional<GraphModelRecord> optional2 = Optional.empty();
                return optional2;
            }
            GraphModelRecord result = new GraphModelRecord(resultSet.getInt("id"), resultSet.getString("name"));
            Optional<GraphModelRecord> optional = Optional.of(result);
            return optional;
        }
        catch (SQLException ex) {
            this.handleSQLException(query, ex);
            return Optional.empty();
        }
    }

    @Override
    public List<VertexRecord> findRootRecords(int graphModelId) {
        return this.doGetVertexRecords(String.format(SELECT_ROOTS_BY_GRAPH_MODEL_ID, graphModelId));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<VertexRecord> findVertexRecord(int graphModelId, int vertexId) {
        ConcurrentHashMap localCachedVertexRecords = this.cachedVertexRecords.computeIfAbsent(graphModelId, k -> new ConcurrentHashMap());
        VertexRecord vertexRecord = (VertexRecord)localCachedVertexRecords.get(vertexId);
        if (vertexRecord != null) {
            return Optional.of(vertexRecord);
        }
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(SELECT_VERTEX_BY_GRAPH_MODEL_ID_AND_ID);){
            preparedStatement.setInt(1, graphModelId);
            preparedStatement.setInt(2, vertexId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    VertexRecord result = new VertexRecord(resultSet.getInt("id"), resultSet.getInt("graph_model_id"), SQLiteGraphStorage.globalIdFromBytes(resultSet.getBytes("global_id")), resultSet.getInt("parent_id"), resultSet.getBoolean(VERTEX_TABLE_IS_COMPOSITE));
                    localCachedVertexRecords.put(vertexId, result);
                    Optional<VertexRecord> optional = Optional.of(result);
                    return optional;
                }
            }
            Optional<VertexRecord> optional = Optional.empty();
            return optional;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<VertexRecord> findVertexRecord(int graphModelId, UUID vertexGlobalId) {
        if (vertexGlobalId == null) {
            return Optional.empty();
        }
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(SELECT_VERTEX_BY_GLOBAL_ID);){
            preparedStatement.setBytes(1, SQLiteGraphStorage.globalIdToBytes(vertexGlobalId));
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    Optional<VertexRecord> optional = Optional.of(new VertexRecord(resultSet.getInt("id"), resultSet.getInt("graph_model_id"), SQLiteGraphStorage.globalIdFromBytes(resultSet.getBytes("global_id")), resultSet.getInt("parent_id"), resultSet.getBoolean(VERTEX_TABLE_IS_COMPOSITE)));
                    return optional;
                }
            }
            Optional<VertexRecord> optional = Optional.empty();
            return optional;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public List<VertexRecord> findVertexRecordsByParentId(int graphModelId, int parentId) {
        return this.doGetVertexRecords(String.format(SELECT_VERTICES_BY_GRAPH_MODEL_ID_AND_PARENT_ID, graphModelId, parentId));
    }

    private List<VertexRecord> doGetVertexRecords(String query) {
        ArrayList<VertexRecord> arrayList;
        block9: {
            Statement statement = this.connection.createStatement();
            try {
                ResultSet resultSet = statement.executeQuery(query);
                ArrayList<VertexRecord> result = new ArrayList<VertexRecord>();
                while (resultSet.next()) {
                    result.add(new VertexRecord(resultSet.getInt("id"), resultSet.getInt("graph_model_id"), SQLiteGraphStorage.globalIdFromBytes(resultSet.getBytes("global_id")), resultSet.getInt("parent_id"), resultSet.getBoolean(VERTEX_TABLE_IS_COMPOSITE)));
                }
                arrayList = result;
                if (statement == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new RuntimeException(ex);
                }
            }
            statement.close();
        }
        return arrayList;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<EdgeRecord> findAllEdgeRecordsByGraphModelId(int graphModelId) {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(SELECT_EDGES_BY_GRAPH_MODEL_ID);){
            List<EdgeRecord> list;
            block14: {
                preparedStatement.setInt(1, graphModelId);
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    list = this.readEdgeRecords(resultSet);
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return list;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<EdgeRecord> findEdgeRecord(int graphModelId, int edgeId) {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(SELECT_EDGE_BY_GRAPH_MODEL_ID_AND_ID);){
            Optional<EdgeRecord> optional;
            block14: {
                preparedStatement.setInt(1, graphModelId);
                preparedStatement.setInt(2, edgeId);
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    optional = Optional.ofNullable(this.readNextEdgeRecord(resultSet));
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return optional;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<EdgeRecord> findEdgeRecord(int graphModelId, UUID edgeGlobalId) {
        if (edgeGlobalId == null) {
            return Optional.empty();
        }
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(SELECT_EDGE_BY_GLOBAL_ID);){
            Optional<EdgeRecord> optional;
            block15: {
                preparedStatement.setBytes(1, SQLiteGraphStorage.globalIdToBytes(edgeGlobalId));
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    optional = Optional.ofNullable(this.readNextEdgeRecord(resultSet));
                    if (resultSet == null) break block15;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return optional;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<EdgeRecord> findEdgeRecordsByParentId(int graphModelId, int parentId, boolean includeInvisible) {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(SELECT_EDGES_BY_GRAPH_MODEL_ID_AND_PARENT_ID);){
            List<EdgeRecord> list;
            block14: {
                preparedStatement.setInt(1, graphModelId);
                preparedStatement.setInt(2, parentId);
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    list = this.readEdgeRecords(resultSet).stream().filter(it -> includeInvisible || !it.isVisible()).toList();
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return list;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<EdgeRecord> findEdgeRecordsByVertexId(int graphModelId, int vertexId) {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(SELECT_EDGES_BY_GRAPH_MODEL_ID_VERTEX_ID);){
            List<EdgeRecord> list;
            block14: {
                preparedStatement.setInt(1, graphModelId);
                preparedStatement.setInt(2, vertexId);
                preparedStatement.setInt(3, vertexId);
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    list = this.readEdgeRecords(resultSet);
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return list;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<AttributeRecord> findAttributeRecord(int graphModelId, int attributeId) {
        try (Statement statement = this.connection.createStatement();){
            ResultSet resultSet = statement.executeQuery(String.format(SELECT_ATTRIBUTE_BY_GRAPH_MODEL_ID_AND_ID, graphModelId, attributeId));
            if (resultSet.next()) {
                Optional<AttributeRecord> optional2 = Optional.of(new AttributeRecord(resultSet.getInt("graph_model_id"), resultSet.getInt("id"), resultSet.getInt(ATTRIBUTE_TABLE_OWNER_ID), AttributeOwnerType.valueOf(resultSet.getInt(ATTRIBUTE_TABLE_OWNER_TYPE)), resultSet.getString("name"), resultSet.getString(ATTRIBUTE_TABLE_VALUE), AttributeRecordType.valueOf(resultSet.getInt(ATTRIBUTE_TABLE_VALUE_TYPE)), resultSet.getBoolean("visible")));
                return optional2;
            }
            Optional<AttributeRecord> optional = Optional.empty();
            return optional;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<AttributeRecord> findAttributeRecordByOwnerAndName(int graphModelId, int ownerId, AttributeOwnerType ownerType, String name) {
        try (Statement statement = this.connection.createStatement();){
            ResultSet resultSet = statement.executeQuery(String.format(SELECT_ATTRIBUTES_BY_GRAPH_MODEL_ID_AND_OWNER_AND_NAME, graphModelId, ownerId, ownerType.getId(), name));
            if (resultSet.next()) {
                Optional<AttributeRecord> optional2 = Optional.of(new AttributeRecord(resultSet.getInt("graph_model_id"), resultSet.getInt("id"), resultSet.getInt(ATTRIBUTE_TABLE_OWNER_ID), AttributeOwnerType.valueOf(resultSet.getInt(ATTRIBUTE_TABLE_OWNER_TYPE)), resultSet.getString("name"), resultSet.getString(ATTRIBUTE_TABLE_VALUE), AttributeRecordType.valueOf(resultSet.getInt(ATTRIBUTE_TABLE_VALUE_TYPE)), resultSet.getBoolean("visible")));
                return optional2;
            }
            Optional<AttributeRecord> optional = Optional.empty();
            return optional;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Map<Integer, List<AttributeRecord>> findAttributeRecordsByOwners(int graphModelId, Set<Integer> ownerIds, AttributeOwnerType ownerType) {
        HashMap<Integer, List<AttributeRecord>> result = new HashMap<Integer, List<AttributeRecord>>();
        ownerIds.forEach(ownerId -> result.put((Integer)ownerId, Collections.emptyList()));
        ArrayList<Integer> ownerIdsList = new ArrayList<Integer>(ownerIds);
        for (int i = 0; i < ownerIdsList.size(); i += 20000) {
            List<Integer> chunk = ownerIdsList.subList(i, Math.min(i + 20000, ownerIdsList.size()));
            try (Statement statement = this.connection.createStatement();){
                String ownerIdsStr = chunk.stream().map(String::valueOf).collect(Collectors.joining(","));
                ResultSet resultSet = statement.executeQuery(String.format(SELECT_ATTRIBUTES_BY_GRAPH_MODEL_ID_AND_OWNERS, graphModelId, ownerType.getId(), ownerIdsStr));
                result.putAll(this.readAttributeRecords(resultSet).stream().collect(Collectors.groupingBy(AttributeRecord::getOwnerId, Collectors.toList())));
                continue;
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }
        return result;
    }

    @Override
    public List<AttributeRecord> findAttributeRecordsByNameAndValue(int graphModelId, String name, String value) {
        ArrayList<AttributeRecord> arrayList;
        block9: {
            Statement statement = this.connection.createStatement();
            try {
                ResultSet resultSet = statement.executeQuery(String.format(SELECT_ATTRIBUTES_BY_GRAPH_MODEL_ID_AND_NAME_AND_VALUE, graphModelId, name, value));
                ArrayList<AttributeRecord> result = new ArrayList<AttributeRecord>();
                while (resultSet.next()) {
                    result.add(new AttributeRecord(resultSet.getInt("graph_model_id"), resultSet.getInt("id"), resultSet.getInt(ATTRIBUTE_TABLE_OWNER_ID), AttributeOwnerType.valueOf(resultSet.getInt(ATTRIBUTE_TABLE_OWNER_TYPE)), resultSet.getString("name"), resultSet.getString(ATTRIBUTE_TABLE_VALUE), AttributeRecordType.valueOf(resultSet.getInt(ATTRIBUTE_TABLE_VALUE_TYPE)), resultSet.getBoolean("visible")));
                }
                arrayList = result;
                if (statement == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new RuntimeException(ex);
                }
            }
            statement.close();
        }
        return arrayList;
    }

    private List<AttributeRecord> readAttributeRecords(ResultSet resultSet) throws SQLException {
        AttributeRecord attributeRecord;
        ArrayList<AttributeRecord> result = new ArrayList<AttributeRecord>();
        while ((attributeRecord = this.readNextAttributeRecord(resultSet)) != null) {
            result.add(attributeRecord);
        }
        return result;
    }

    private AttributeRecord readNextAttributeRecord(ResultSet resultSet) throws SQLException {
        if (resultSet.next()) {
            return new AttributeRecord(resultSet.getInt("graph_model_id"), resultSet.getInt("id"), resultSet.getInt(ATTRIBUTE_TABLE_OWNER_ID), AttributeOwnerType.valueOf(resultSet.getInt(ATTRIBUTE_TABLE_OWNER_TYPE)), resultSet.getString("name"), resultSet.getString(ATTRIBUTE_TABLE_VALUE), AttributeRecordType.valueOf(resultSet.getInt(ATTRIBUTE_TABLE_VALUE_TYPE)), resultSet.getBoolean("visible"));
        }
        return null;
    }

    private List<EdgeRecord> readEdgeRecords(ResultSet resultSet) throws SQLException {
        EdgeRecord edgeRecord;
        ArrayList<EdgeRecord> result = new ArrayList<EdgeRecord>();
        while ((edgeRecord = this.readNextEdgeRecord(resultSet)) != null) {
            result.add(edgeRecord);
        }
        return result;
    }

    private EdgeRecord readNextEdgeRecord(ResultSet resultSet) throws SQLException {
        if (resultSet.next()) {
            return new EdgeRecord(resultSet.getInt("id"), resultSet.getInt("graph_model_id"), SQLiteGraphStorage.globalIdFromBytes(resultSet.getBytes("global_id")), resultSet.getInt("parent_id"), resultSet.getInt(EDGE_TABLE_SOURCE_VERTEX), resultSet.getInt(EDGE_TABLE_TARGET_VERTEX), resultSet.getBoolean("visible"), resultSet.getBoolean("deleted"));
        }
        return null;
    }

    private void handleSQLException(String query, SQLException ex) {
        log.debug("Problem with execution of following query '{}', message: '{}'.", (Object)query, (Object)ex.getMessage());
        throw new RuntimeException(ex);
    }

    private static byte[] globalIdToBytes(UUID globalId) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(globalId.getMostSignificantBits());
        bb.putLong(globalId.getLeastSignificantBits());
        return bb.array();
    }

    public static UUID globalIdFromBytes(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        long high = bb.getLong();
        long low = bb.getLong();
        return new UUID(high, low);
    }

    private static class GraphModelCounter {
        private final AtomicInteger vertexIdCounter = new AtomicInteger(1);
        private final AtomicInteger edgeIdCounter = new AtomicInteger(1);
        private final AtomicInteger attributeIdCounter = new AtomicInteger(1);

        public AtomicInteger getVertexIdCounter() {
            return this.vertexIdCounter;
        }

        public AtomicInteger getEdgeIdCounter() {
            return this.edgeIdCounter;
        }

        public AtomicInteger getAttributeIdCounter() {
            return this.attributeIdCounter;
        }
    }
}

