/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.storage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vg.lib.model.record.AttributeOwnerType;
import vg.lib.model.record.AttributeRecord;
import vg.lib.model.record.EdgeRecord;
import vg.lib.model.record.GraphModelRecord;
import vg.lib.model.record.VertexRecord;
import vg.lib.storage.GraphStorage;

public class MemoryGraphStorage
implements GraphStorage {
    private static final Logger log = LoggerFactory.getLogger(MemoryGraphStorage.class);
    private int graphModelIdCounter = 1;
    private final Map<Integer, GraphModel> graphModels = new LinkedHashMap<Integer, GraphModel>();

    @Override
    public void close() {
    }

    @Override
    public int createGraphModel(String name) {
        GraphModelRecord graphModelRecord = new GraphModelRecord(this.graphModelIdCounter++);
        graphModelRecord.setName(name);
        GraphModel graphModel = new GraphModel(graphModelRecord);
        this.graphModels.put(graphModelRecord.getId(), graphModel);
        return graphModelRecord.getId();
    }

    @Override
    public List<Integer> doCreateVertices(int graphModelId, @NonNull List<Integer> parentIds) {
        if (parentIds == null) {
            throw new NullPointerException("parentIds is marked non-null but is null");
        }
        return this.doCreateVertices(graphModelId, parentIds, GraphStorage.generateGlobalIds(parentIds.size()));
    }

    @Override
    public List<Integer> doCreateVertices(int graphModelId, @NonNull List<Integer> parentIds, @NonNull List<UUID> globalIds) {
        if (parentIds == null) {
            throw new NullPointerException("parentIds is marked non-null but is null");
        }
        if (globalIds == null) {
            throw new NullPointerException("globalIds is marked non-null but is null");
        }
        return this.graphModels.get(graphModelId).createVertices(parentIds, globalIds);
    }

    @Override
    public int doCreateEdge(int graphModelId, int parentId, int sourceVertexId, int targetVertexId, boolean visible) {
        return this.doCreateEdge(graphModelId, parentId, GraphStorage.generateGlobalId(), sourceVertexId, targetVertexId, visible);
    }

    @Override
    public int doCreateEdge(int graphModelId, int parentId, UUID globalId, int sourceVertexId, int targetVertexId, boolean visible) {
        return this.graphModels.get(graphModelId).createEdge(parentId, globalId, sourceVertexId, targetVertexId, visible);
    }

    @Override
    public List<Integer> doCreateAttributes(int graphModelId, @NonNull List<AttributeRecord> attributeRecords) {
        if (attributeRecords == null) {
            throw new NullPointerException("attributeRecords is marked non-null but is null");
        }
        return this.graphModels.get(graphModelId).createAttributes(attributeRecords);
    }

    @Override
    public int findTotalNumberOfVertices(int graphModelId) {
        return this.graphModels.get(graphModelId).findTotalNumberOfVertices();
    }

    @Override
    public int findTotalNumberOfEdges(int graphModelId, boolean includeInvisible) {
        return this.graphModels.get(graphModelId).findTotalNumberOfEdges(includeInvisible);
    }

    @Override
    public List<GraphModelRecord> findGraphModelRecords() {
        return this.graphModels.values().stream().map(GraphModel::getGraphModelRecord).toList();
    }

    @Override
    public Optional<GraphModelRecord> findGraphModelRecord(int graphModelId) {
        return Optional.ofNullable(this.graphModels.get(graphModelId)).map(GraphModel::getGraphModelRecord);
    }

    @Override
    public List<VertexRecord> findRootRecords(int graphModelId) {
        return Optional.ofNullable(this.graphModels.get(graphModelId)).map(GraphModel::findRootRecords).orElse(Collections.emptyList());
    }

    @Override
    public Optional<VertexRecord> findVertexRecord(int graphModelId, int vertexId) {
        return Optional.ofNullable(this.graphModels.get(graphModelId)).flatMap(it -> it.findVertexRecord(vertexId));
    }

    @Override
    public Optional<VertexRecord> findVertexRecord(int graphModelId, UUID globalId) {
        return Optional.ofNullable(this.graphModels.get(graphModelId)).flatMap(it -> it.findVertexRecord(globalId));
    }

    @Override
    public List<VertexRecord> findVertexRecordsByParentId(int graphModelId, int parentId) {
        return Optional.ofNullable(this.graphModels.get(graphModelId)).map(it -> it.findVertexRecordsByParentId(parentId)).orElse(Collections.emptyList());
    }

    @Override
    public List<EdgeRecord> findAllEdgeRecordsByGraphModelId(int graphModelId) {
        return Optional.ofNullable(this.graphModels.get(graphModelId)).map(GraphModel::findAllEdgeRecords).orElse(Collections.emptyList());
    }

    @Override
    public Optional<EdgeRecord> findEdgeRecord(int graphModelId, int edgeId) {
        return Optional.ofNullable(this.graphModels.get(graphModelId)).flatMap(it -> it.findEdgeRecord(edgeId));
    }

    @Override
    public Optional<EdgeRecord> findEdgeRecord(int graphModelId, UUID edgeGlobalId) {
        return Optional.ofNullable(this.graphModels.get(graphModelId)).flatMap(it -> it.findEdgeRecord(edgeGlobalId));
    }

    @Override
    public List<EdgeRecord> findEdgeRecordsByParentId(int graphModelId, int parentId, boolean includeInvisible) {
        return Optional.ofNullable(this.graphModels.get(graphModelId)).map(it -> it.findEdgeRecordsByParentId(parentId, includeInvisible)).orElse(Collections.emptyList());
    }

    @Override
    public List<EdgeRecord> findEdgeRecordsByVertexId(int graphModelId, int vertexId) {
        return Optional.ofNullable(this.graphModels.get(graphModelId)).map(it -> it.findEdgeRecordsByVertexId(vertexId)).orElse(Collections.emptyList());
    }

    @Override
    public Optional<AttributeRecord> findAttributeRecord(int graphModelId, int attributeId) {
        return Optional.ofNullable(this.graphModels.get(graphModelId)).flatMap(it -> it.findAttributeRecord(attributeId));
    }

    @Override
    public Optional<AttributeRecord> findAttributeRecordByOwnerAndName(int graphModelId, int ownerId, AttributeOwnerType ownerType, String name) {
        return Optional.ofNullable(this.graphModels.get(graphModelId)).flatMap(it -> it.findAttributeRecordByOwnerAndName(ownerId, ownerType, name));
    }

    @Override
    public Map<Integer, List<AttributeRecord>> findAttributeRecordsByOwners(int graphModelId, Set<Integer> ownerIds, AttributeOwnerType ownerType) {
        return Optional.ofNullable(this.graphModels.get(graphModelId)).map(it -> it.findAttributeRecordsByOwners(ownerIds, ownerType)).orElse(Collections.emptyMap());
    }

    @Override
    public List<AttributeRecord> findAttributeRecordsByNameAndValue(int graphModelId, String name, String value) {
        return Optional.ofNullable(this.graphModels.get(graphModelId)).map(it -> it.findAttributeRecordsByNameAndValue(name, value)).orElse(Collections.emptyList());
    }

    @Override
    public void editGraphModelRecord(GraphModelRecord graphModelRecord) {
        Optional.ofNullable(this.graphModels.get(graphModelRecord.getId())).ifPresent(it -> it.editGraphModelRecord(graphModelRecord));
    }

    @Override
    public void editAttributeRecords(int graphModelId, @NonNull List<AttributeRecord> attributeRecords) {
        if (attributeRecords == null) {
            throw new NullPointerException("attributeRecords is marked non-null but is null");
        }
        Optional.ofNullable(this.graphModels.get(graphModelId)).ifPresent(it -> it.editAttributeRecords(attributeRecords));
    }

    @Override
    public void doDeleteVertexRecordById(int graphModelId, int vertexId) {
        Optional.ofNullable(this.graphModels.get(graphModelId)).ifPresent(it -> it.deleteVertexRecordById(vertexId));
    }

    @Override
    public void doDeleteEdgeRecordById(int graphModelId, int edgeId) {
        Optional.ofNullable(this.graphModels.get(graphModelId)).ifPresent(it -> it.deleteEdgeRecordById(edgeId));
    }

    private static class GraphModel {
        private int vertexIdCounter;
        private int edgeIdCounter;
        private int attributeIdCounter;
        private final Map<Integer, VertexRecord> vertices;
        private final Map<Integer, EdgeRecord> edges;
        private final Map<Integer, AttributeRecord> attributes;
        private final Map<Integer, Map<Integer, Map<Integer, AttributeRecord>>> attributesByOwnerAndId;
        private final GraphModelRecord graphModelRecord;

        public GraphModel(GraphModelRecord graphModelRecord) {
            this.graphModelRecord = graphModelRecord;
            this.vertices = new LinkedHashMap<Integer, VertexRecord>();
            this.edges = new LinkedHashMap<Integer, EdgeRecord>();
            this.attributes = new LinkedHashMap<Integer, AttributeRecord>();
            this.attributesByOwnerAndId = new LinkedHashMap<Integer, Map<Integer, Map<Integer, AttributeRecord>>>();
            this.vertexIdCounter = 1;
            this.edgeIdCounter = 1;
            this.attributeIdCounter = 1;
        }

        public List<Integer> createVertices(@NonNull List<Integer> parentIds, @NonNull List<UUID> globalIds) {
            if (parentIds == null) {
                throw new NullPointerException("parentIds is marked non-null but is null");
            }
            if (globalIds == null) {
                throw new NullPointerException("globalIds is marked non-null but is null");
            }
            if (parentIds.isEmpty() || globalIds.isEmpty() || parentIds.size() != globalIds.size()) {
                throw new IllegalArgumentException("Parent IDs and Global IDs must be non-empty and of equal size.");
            }
            ArrayList<Integer> result = new ArrayList<Integer>(parentIds.size());
            for (int index = 0; index < parentIds.size(); ++index) {
                Integer parentId = parentIds.get(index);
                UUID globalId = globalIds.get(index);
                VertexRecord vertexRecord = new VertexRecord(this.vertexIdCounter++, this.graphModelRecord.getId(), globalId, parentId, false);
                this.vertices.put(vertexRecord.getId(), vertexRecord);
                VertexRecord parent = this.vertices.get(parentId);
                if (parent != null) {
                    parent.setComposite(true);
                }
                result.add(vertexRecord.getId());
            }
            return result;
        }

        public int createEdge(int parentId, UUID globalId, int sourceVertexId, int targetVertexId, boolean visible) {
            VertexRecord sourceVertexRecord = this.vertices.get(sourceVertexId);
            VertexRecord targetVertexRecord = this.vertices.get(targetVertexId);
            Validate.notNull((Object)sourceVertexRecord);
            Validate.notNull((Object)targetVertexRecord);
            if (sourceVertexRecord.getGraphModelId() != targetVertexRecord.getGraphModelId()) {
                throw new IllegalArgumentException(String.format("Source graph model id is '%d', target graph model id is '%d'. But they should have same graph model id.", sourceVertexRecord.getGraphModelId(), targetVertexRecord.getGraphModelId()));
            }
            if (sourceVertexRecord.getParentId() != targetVertexRecord.getParentId() && visible) {
                throw new IllegalArgumentException(String.format("Source parent id is '%d', target parent id is '%d'. But they should have same parent id.", sourceVertexRecord.getParentId(), targetVertexRecord.getParentId()));
            }
            if (parentId != targetVertexRecord.getParentId() && visible) {
                throw new IllegalArgumentException(String.format("Parent id is '%d', source parent id is '%d', target parent id is '%d'.", parentId, sourceVertexRecord.getParentId(), targetVertexRecord.getParentId()));
            }
            EdgeRecord edgeRecord = new EdgeRecord(this.edgeIdCounter++, this.graphModelRecord.getId(), globalId, parentId, sourceVertexId, targetVertexId, visible, false);
            this.edges.put(edgeRecord.getId(), edgeRecord);
            return edgeRecord.getId();
        }

        public List<Integer> createAttributes(@NonNull List<AttributeRecord> attributeRecords) {
            if (attributeRecords == null) {
                throw new NullPointerException("attributeRecords is marked non-null but is null");
            }
            ArrayList<Integer> result = new ArrayList<Integer>(attributeRecords.size());
            attributeRecords.forEach(it -> {
                int attributeId = this.attributeIdCounter++;
                AttributeRecord attributeRecord = new AttributeRecord(it.getGraphModelId(), attributeId, it.getOwnerId(), it.getOwnerType(), it.getName(), it.getStringValue(), it.getType(), it.isVisible());
                this.attributes.put(attributeId, attributeRecord);
                this.attributesByOwnerAndId.computeIfAbsent(it.getOwnerType().getId(), k -> new LinkedHashMap()).computeIfAbsent(it.getOwnerId(), k -> new LinkedHashMap()).put(attributeId, attributeRecord);
                result.add(attributeId);
            });
            return result;
        }

        public int findTotalNumberOfVertices() {
            return this.vertices.size();
        }

        public int findTotalNumberOfEdges(boolean includeInvisible) {
            if (includeInvisible) {
                return (int)this.edges.values().stream().filter(it -> !it.isDeleted()).count();
            }
            return (int)this.edges.values().stream().filter(it -> !it.isDeleted()).filter(EdgeRecord::isVisible).count();
        }

        public List<VertexRecord> findAllVertexRecords() {
            return this.vertices.values().stream().toList();
        }

        public List<VertexRecord> findRootRecords() {
            return this.vertices.values().stream().filter(VertexRecord::isRoot).toList();
        }

        public Optional<VertexRecord> findVertexRecord(int vertexId) {
            return Optional.ofNullable(this.vertices.get(vertexId));
        }

        public Optional<VertexRecord> findVertexRecord(UUID vertexGlobalId) {
            return this.vertices.values().stream().filter(it -> it.getGlobalId().equals(vertexGlobalId)).findFirst();
        }

        public List<VertexRecord> findVertexRecordsByParentId(int parentId) {
            return this.vertices.values().stream().filter(it -> it.getParentId() == parentId).toList();
        }

        public List<EdgeRecord> findAllEdgeRecords() {
            return this.edges.values().stream().toList();
        }

        public Optional<EdgeRecord> findEdgeRecord(int edgeId) {
            return Optional.ofNullable(this.edges.get(edgeId));
        }

        public Optional<EdgeRecord> findEdgeRecord(UUID edgeGlobalId) {
            return this.edges.values().stream().filter(it -> it.getGlobalId().equals(edgeGlobalId)).findFirst();
        }

        public List<EdgeRecord> findEdgeRecordsByParentId(int parentId, boolean includeInvisible) {
            return this.edges.values().stream().filter(it -> it.getParentId() == parentId).filter(it -> includeInvisible || it.isVisible()).toList();
        }

        public List<EdgeRecord> findEdgeRecordsByVertexId(int vertexId) {
            return this.edges.values().stream().filter(it -> it.getSourceId() == vertexId || it.getTargetId() == vertexId).filter(EdgeRecord::isVisible).toList();
        }

        public Optional<AttributeRecord> findAttributeRecord(int attributeId) {
            return Optional.ofNullable(this.attributes.get(attributeId));
        }

        public Map<Integer, List<AttributeRecord>> findAttributeRecordsByOwners(Set<Integer> ownerIds, AttributeOwnerType ownerType) {
            HashMap<Integer, List<AttributeRecord>> result = new HashMap<Integer, List<AttributeRecord>>();
            ownerIds.forEach(ownerId -> {
                Map<Integer, Map<Integer, AttributeRecord>> resultsByOwnerIdAndId = this.attributesByOwnerAndId.get(ownerType.getId());
                if (resultsByOwnerIdAndId == null) {
                    result.put((Integer)ownerId, Collections.emptyList());
                    return;
                }
                Map<Integer, AttributeRecord> resultsById = resultsByOwnerIdAndId.get(ownerId);
                if (resultsById == null) {
                    result.put((Integer)ownerId, Collections.emptyList());
                    return;
                }
                List<AttributeRecord> copiedValues = resultsById.values().stream().map(AttributeRecord::clone).toList();
                result.put((Integer)ownerId, copiedValues);
            });
            return result;
        }

        public Optional<AttributeRecord> findAttributeRecordByOwnerAndName(int ownerId, AttributeOwnerType ownerType, String name) {
            Map<Integer, Map<Integer, AttributeRecord>> resultsByOwnerIdAndId = this.attributesByOwnerAndId.get(ownerType.getId());
            if (resultsByOwnerIdAndId == null) {
                return Optional.empty();
            }
            Map<Integer, AttributeRecord> resultsById = resultsByOwnerIdAndId.get(ownerId);
            if (resultsById == null) {
                return Optional.empty();
            }
            return resultsById.values().stream().filter(ar -> Objects.equals(name, ar.getName())).findFirst();
        }

        public List<AttributeRecord> findAttributeRecordsByNameAndValue(String name, String value) {
            return this.attributes.values().stream().filter(it -> Objects.equals(name, it.getName())).filter(it -> Objects.equals(value, it.getStringValue())).toList();
        }

        public void editGraphModelRecord(@NonNull GraphModelRecord graphModelRecord) {
            if (graphModelRecord == null) {
                throw new NullPointerException("graphModelRecord is marked non-null but is null");
            }
            this.graphModelRecord.setName(graphModelRecord.getName());
        }

        public void editAttributeRecords(@NonNull List<AttributeRecord> attributeRecords) {
            if (attributeRecords == null) {
                throw new NullPointerException("attributeRecords is marked non-null but is null");
            }
            attributeRecords.forEach(attributeRecord -> {
                AttributeRecord existingAttributeRecord = this.attributes.get(attributeRecord.getId());
                if (existingAttributeRecord != null) {
                    existingAttributeRecord.setValue(attributeRecord.getStringValue(), attributeRecord.getType());
                    existingAttributeRecord.setVisible(attributeRecord.isVisible());
                }
            });
        }

        public void deleteVertexRecordById(int vertexId) {
        }

        public void deleteEdgeRecordById(int edgeId) {
            this.edges.remove(edgeId);
        }

        public GraphModelRecord getGraphModelRecord() {
            return this.graphModelRecord;
        }
    }
}

