/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.storage;

import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;
import vg.lib.common.JsonUtils;
import vg.lib.common.VGUtils;
import vg.lib.model.graph.Attribute;
import vg.lib.model.graph.Edge;
import vg.lib.model.graph.Graph;
import vg.lib.model.graph.Vertex;
import vg.lib.model.graphics.GraphModelSummary;
import vg.lib.model.record.AttributeOwnerType;
import vg.lib.model.record.AttributeRecord;
import vg.lib.model.record.AttributeRecordType;
import vg.lib.model.record.EdgeRecord;
import vg.lib.model.record.GraphModelRecord;
import vg.lib.model.record.VertexRecord;

public interface GraphStorage {
    public static final String SYSTEM_GRAPH_MODEL_DEFAULT_VERTEX_FONT_SIZE_NAME = "system_graph_model_default_vertex_font_size";
    public static final String SYSTEM_GRAPH_MODEL_DEFAULT_EDGE_FONT_SIZE_NAME = "system_graph_model_default_edge_font_size";
    public static final String SYSTEM_GRAPH_MODEL_DEFAULT_VERTEX_COLOR_NAME = "system_graph_model_default_vertex_color";
    public static final String SYSTEM_GRAPH_MODEL_DEFAULT_VERTEX_SHAPE_NAME = "system_graph_model_default_vertex_shape";
    public static final String SYSTEM_GRAPH_MODEL_DEFAULT_VERTEX_VISIBLE_ATTRIBUTES_PATTERN_NAME = "system_graph_model_default_vertex_visible_attributes_pattern";
    public static final String SYSTEM_GRAPH_MODEL_DEFAULT_EDGE_VISIBLE_ATTRIBUTES_PATTERN_NAME = "system_graph_model_default_edge_visible_attributes_pattern";
    public static final String SYSTEM_GRAPH_MODEL_DEFAULT_ATTRIBUTES_MAPPING_NAME = "system_graph_model_default_attributes_mapping";
    public static final String SYSTEM_GRAPH_MODEL_GRID_SIZE_NAME = "system_graph_model_grid_size";
    public static final String SYSTEM_GRAPH_MODEL_SELECTED_ELEMENTS_NAME = "system_graph_model_selected_elements";
    public static final String SYSTEM_GRAPH_MODEL_SUMMARY_NAME = "system_graph_model_summary";
    public static final String SYSTEM_GRAPH_MODEL_IMAGE_SCALE_PERCENT_NAME = "system_graph_model_image_scale_percent";
    public static final String SYSTEM_GRAPH_MODEL_VIEW_SUMMARY_NAME = "system_graph_model_view_summary";
    public static final String SYSTEM_VERTEX_ORIGINAL_ID_NAME = "system_vertex_original_id";
    public static final String SYSTEM_VERTEX_NESTED_GRAPH_ORIGINAL_ID_NAME = "system_vertex_nested_graph_original_id";
    public static final String SYSTEM_VERTEX_TYPE_NAME = "system_vertex_type";
    public static final int SYSTEM_VERTEX_TYPE_VALUE_VERTEX = 8;
    public static final int SYSTEM_VERTEX_TYPE_VALUE_CONTAINS_NESTED_GRAPH = 4;
    public static final int SYSTEM_VERTEX_TYPE_VALUE_CONTAINS_PORTS = 2;
    public static final int SYSTEM_VERTEX_TYPE_VALUE_PORT = 128;
    public static final int SYSTEM_VERTEX_TYPE_VALUE_FAKE_PORT = 64;
    public static final int SYSTEM_VERTEX_TYPE_VALUE_INPUT_PORT = 32;
    public static final int SYSTEM_VERTEX_TYPE_VALUE_OUTPUT_PORT = 16;
    public static final String SYSTEM_VERTEX_GRAPHICS_NAME = "system_vertex_graphics";
    public static final String SYSTEM_EDGE_ORIGINAL_ID_NAME = "system_edge_original_id";
    public static final String SYSTEM_EDGE_TYPE_NAME = "system_edge_type";
    public static final int SYSTEM_EDGE_TYPE_VALUE_EDGE = 2048;
    public static final int SYSTEM_EDGE_TYPE_VALUE_CHAIN_SEGMENT = 512;
    public static final String SYSTEM_EDGE_IS_DIRECTED_NAME = "system_edge_is_directed";
    public static final String SYSTEM_EDGE_STORAGE_SOURCE_PORT_GLOBAL_ID = "system_edge_storage_source_port_global_id";
    public static final String SYSTEM_EDGE_STORAGE_TARGET_PORT_GLOBAL_ID = "system_edge_storage_target_port_global_id";
    public static final String SYSTEM_EDGE_STORAGE_CHAIN_GLOBAL_ID = "system_edge_storage_chain_global_id";
    public static final String SYSTEM_EDGE_GRAPHICS_NAME = "system_edge_graphics";

    public void close();

    public int createGraphModel(String var1);

    public List<Integer> doCreateVertices(int var1, @NonNull List<Integer> var2);

    public List<Integer> doCreateVertices(int var1, @NonNull List<Integer> var2, @NonNull List<UUID> var3);

    public int doCreateEdge(int var1, int var2, int var3, int var4, boolean var5);

    public int doCreateEdge(int var1, int var2, UUID var3, int var4, int var5, boolean var6);

    public List<Integer> doCreateAttributes(int var1, @NonNull List<AttributeRecord> var2);

    default public List<Integer> createVertices(int graphModelId, @NonNull List<Integer> parentIds) {
        if (parentIds == null) {
            throw new NullPointerException("parentIds is marked non-null but is null");
        }
        List<Integer> result = this.doCreateVertices(graphModelId, parentIds);
        List<AttributeRecord> vertexTypeAttributeRecords = result.stream().map(it -> new AttributeRecord(graphModelId, (int)it, AttributeOwnerType.VERTEX, SYSTEM_VERTEX_TYPE_NAME, Integer.toString(8), AttributeRecordType.INTEGER, false)).toList();
        this.createAttributes(graphModelId, vertexTypeAttributeRecords);
        HashSet<Integer> parentIdsSet = new HashSet<Integer>(parentIds);
        parentIdsSet.remove(-1);
        Map<Integer, List<AttributeRecord>> vertexIdToAttributeRecords = this.findAttributeRecordsByOwners(graphModelId, parentIdsSet, AttributeOwnerType.VERTEX);
        ArrayList<AttributeRecord> vertexAttributeRecordsForUpdating = new ArrayList<AttributeRecord>();
        vertexIdToAttributeRecords.forEach((vertexId, attributeRecords) -> {
            AttributeRecord vertexTypeAttributeRecord = GraphStorage.findVertexTypeAttributeRecord(attributeRecords).orElse(null);
            if (vertexTypeAttributeRecord != null) {
                Integer value = vertexTypeAttributeRecord.getIntegerValue();
                if (!Objects.equals(value = Integer.valueOf(value | 4), vertexTypeAttributeRecord.getIntegerValue())) {
                    vertexTypeAttributeRecord.setIntegerValue(value);
                    vertexAttributeRecordsForUpdating.add(vertexTypeAttributeRecord);
                }
            } else {
                throw new IllegalArgumentException("Can't find vertex type attribute record for vertex id " + vertexId + ".");
            }
        });
        this.editAttributeRecords(graphModelId, vertexAttributeRecordsForUpdating);
        return result;
    }

    default public int createVertex(int graphModelId, int parentId) {
        return this.createVertices(graphModelId, List.of(Integer.valueOf(parentId))).get(0);
    }

    default public int createPort(int graphModelId, int vertexId, boolean isFake) {
        return this.createPort(graphModelId, vertexId, isFake, -1);
    }

    default public int createPort(int graphModelId, int vertexId, boolean isFake, int index) {
        List<Integer> result = this.doCreateVertices(graphModelId, List.of(Integer.valueOf(vertexId)));
        int vertexType = isFake ? 200 : 136;
        List<AttributeRecord> vertexTypeAttributeRecords = result.stream().map(it -> new AttributeRecord(graphModelId, (int)it, AttributeOwnerType.VERTEX, SYSTEM_VERTEX_TYPE_NAME, Integer.toString(vertexType), AttributeRecordType.INTEGER, false)).toList();
        this.createAttributes(graphModelId, vertexTypeAttributeRecords);
        HashSet<Integer> parentIdsSet = new HashSet<Integer>();
        parentIdsSet.add(vertexId);
        parentIdsSet.remove(-1);
        Map<Integer, List<AttributeRecord>> vertexIdToAttributeRecords = this.findAttributeRecordsByOwners(graphModelId, parentIdsSet, AttributeOwnerType.VERTEX);
        ArrayList<AttributeRecord> vertexAttributeRecordsForUpdating = new ArrayList<AttributeRecord>();
        vertexIdToAttributeRecords.forEach((it, attributeRecords) -> {
            AttributeRecord vertexTypeAttributeRecord = GraphStorage.findVertexTypeAttributeRecord(attributeRecords).orElse(null);
            if (vertexTypeAttributeRecord != null) {
                Integer value = vertexTypeAttributeRecord.getIntegerValue();
                if (!Objects.equals(value = Integer.valueOf(value | 2), vertexTypeAttributeRecord.getIntegerValue())) {
                    vertexTypeAttributeRecord.setIntegerValue(value);
                    vertexAttributeRecordsForUpdating.add(vertexTypeAttributeRecord);
                }
            } else {
                throw new IllegalArgumentException("Can't find vertex type attribute record for vertex id " + it + ".");
            }
        });
        this.editAttributeRecords(graphModelId, vertexAttributeRecordsForUpdating);
        return result.get(0);
    }

    default public int createEdge(int graphModelId, int parentId, int sourceVertexId, int targetVertexId, int sourcePortId, int targetPortId, boolean directed, boolean visible) {
        int edgeId = this.doCreateEdge(graphModelId, parentId, sourceVertexId, targetVertexId, visible);
        this.createOrUpdateEdgeTypeAttributeRecord(graphModelId, edgeId, 2048);
        this.createEdgeAttribute(graphModelId, edgeId, SYSTEM_EDGE_IS_DIRECTED_NAME, Boolean.toString(directed), AttributeRecordType.BOOLEAN, false);
        if (sourcePortId > 0) {
            UUID sourcePortGlobalId = this.findVertexRecord(graphModelId, sourcePortId).orElseThrow(() -> new IllegalStateException("Source port not found.")).getGlobalId();
            this.createEdgeAttribute(graphModelId, edgeId, SYSTEM_EDGE_STORAGE_SOURCE_PORT_GLOBAL_ID, sourcePortGlobalId.toString(), AttributeRecordType.UUID, false);
            if (visible) {
                this.createOrUpdateVertexTypeAttributeRecord(graphModelId, sourcePortId, 16);
            }
        }
        if (targetPortId > 0) {
            UUID targetPortGlobalId = this.findVertexRecord(graphModelId, targetPortId).orElseThrow(() -> new IllegalStateException("Target port not found.")).getGlobalId();
            this.createEdgeAttribute(graphModelId, edgeId, SYSTEM_EDGE_STORAGE_TARGET_PORT_GLOBAL_ID, targetPortGlobalId.toString(), AttributeRecordType.UUID, false);
            if (visible) {
                this.createOrUpdateVertexTypeAttributeRecord(graphModelId, targetPortId, 32);
            }
        }
        return edgeId;
    }

    default public int createEdge(int graphModelId, int sourceVertexId, int targetVertexId, int sourcePortId, int targetPortId, boolean directed) {
        EdgeRecord chainEdgeRecord;
        int portId;
        int i;
        Map<Integer, List<Integer>> parentIds = this.findParents(graphModelId, Arrays.asList(sourceVertexId, targetVertexId));
        Validate.isTrue((parentIds.size() == 2 || parentIds.size() == 1 && sourceVertexId == targetVertexId ? 1 : 0) != 0);
        List<Integer> sourceParentIds = parentIds.get(sourceVertexId);
        List<Integer> targetParentIds = parentIds.get(targetVertexId);
        if (sourceParentIds.size() == 1 && targetParentIds.size() == 1) {
            return this.createEdge(graphModelId, sourceParentIds.get(0), sourceVertexId, targetVertexId, sourcePortId, targetPortId, directed, true);
        }
        ArrayList<Integer> edgeIds = new ArrayList<Integer>();
        int edgeId = -1;
        int bufSourceVertexId = sourceVertexId;
        int bufTargetVertexId = targetVertexId;
        int bufSourcePortId = sourcePortId;
        int bufTargetPortId = targetPortId;
        for (i = 0; i < sourceParentIds.size() - 1; ++i) {
            int sourceParentId = sourceParentIds.get(i);
            if (sourceParentIds.contains(targetVertexId) && i == sourceParentIds.size() - 2 && targetPortId >= 0) {
                portId = targetPortId;
                this.createOrUpdateVertexTypeAttributeRecord(graphModelId, targetPortId, 16);
            } else {
                portId = this.createPort(graphModelId, sourceParentId, true, -1);
            }
            edgeId = this.createEdge(graphModelId, sourceParentId, bufSourceVertexId, portId, bufSourcePortId, -1, directed, true);
            bufSourceVertexId = sourceParentId;
            bufSourcePortId = portId;
            edgeIds.add(edgeId);
        }
        for (i = 0; i < targetParentIds.size() - 1; ++i) {
            int targetParentId = targetParentIds.get(i);
            if (targetParentIds.contains(sourceVertexId) && i == targetParentIds.size() - 2 && sourcePortId >= 0) {
                portId = sourcePortId;
                this.createOrUpdateVertexTypeAttributeRecord(graphModelId, sourcePortId, 32);
            } else {
                portId = this.createPort(graphModelId, targetParentId, true, -1);
            }
            edgeId = this.createEdge(graphModelId, targetParentId, portId, bufTargetVertexId, -1, bufTargetPortId, directed, true);
            bufTargetVertexId = targetParentId;
            bufTargetPortId = portId;
            edgeIds.add(edgeId);
        }
        if (!sourceParentIds.contains(targetVertexId) && !targetParentIds.contains(sourceVertexId)) {
            edgeId = this.createEdge(graphModelId, sourceParentIds.get(sourceParentIds.size() - 1), bufSourceVertexId, bufTargetVertexId, bufSourcePortId, bufTargetPortId, directed, true);
            edgeIds.add(edgeId);
        }
        if ((chainEdgeRecord = (EdgeRecord)this.findEdgeRecord(graphModelId, edgeId).orElse(null)) == null) {
            throw new IllegalArgumentException(String.format("Edge record %s not found.", edgeId));
        }
        edgeIds.forEach(it -> {
            this.createOrUpdateEdgeTypeAttributeRecord(graphModelId, (int)it, 512);
            this.createEdgeAttribute(graphModelId, (int)it, SYSTEM_EDGE_STORAGE_CHAIN_GLOBAL_ID, chainEdgeRecord.getGlobalId().toString(), AttributeRecordType.UUID, false);
        });
        return chainEdgeRecord.getId();
    }

    default public List<Integer> createAttributes(int graphModelId, @NonNull List<AttributeRecord> attributeRecords) {
        if (attributeRecords == null) {
            throw new NullPointerException("attributeRecords is marked non-null but is null");
        }
        return this.doCreateAttributes(graphModelId, attributeRecords);
    }

    default public int createAttribute(int graphModelId, int elementId, AttributeOwnerType elementType, String name, String value, AttributeRecordType valueType, boolean visible) {
        return this.createAttributes(graphModelId, List.of(new AttributeRecord(graphModelId, -1, elementId, elementType, name, value, valueType, visible))).get(0);
    }

    default public int createGraphModelAttribute(int graphModelId, String name, String strValue, AttributeRecordType valueType, boolean visible) {
        return this.createAttribute(graphModelId, graphModelId, AttributeOwnerType.GRAPH_MODEL, name, strValue, valueType, visible);
    }

    default public int createOrUpdateGraphModelAttribute(int graphModelId, String name, String newStrValue, AttributeRecordType newValueType, boolean visible) {
        AttributeRecord attributeRecord = this.findAttributeRecordByOwnerAndName(graphModelId, graphModelId, AttributeOwnerType.GRAPH_MODEL, name).orElse(null);
        if (attributeRecord == null) {
            return this.createGraphModelAttribute(graphModelId, name, newStrValue, newValueType, visible);
        }
        attributeRecord.setValue(newStrValue, newValueType);
        attributeRecord.setVisible(visible);
        this.editAttributeRecords(graphModelId, List.of(attributeRecord));
        return attributeRecord.getId();
    }

    default public int createVertexAttribute(int graphModelId, int vertexId, String name, String strValue, AttributeRecordType valueType, boolean visible) {
        return this.createAttribute(graphModelId, vertexId, AttributeOwnerType.VERTEX, name, strValue, valueType, visible);
    }

    default public int createOrUpdateVertexAttribute(int graphModelId, int vertexId, String name, String newStrValue, AttributeRecordType newValueType, boolean visible) {
        AttributeRecord attributeRecord = this.findAttributeRecordByOwnerAndName(graphModelId, vertexId, AttributeOwnerType.VERTEX, name).orElse(null);
        if (attributeRecord == null) {
            return this.createVertexAttribute(graphModelId, vertexId, name, newStrValue, newValueType, visible);
        }
        attributeRecord.setValue(newStrValue, newValueType);
        attributeRecord.setVisible(visible);
        this.editAttributeRecords(graphModelId, List.of(attributeRecord));
        return attributeRecord.getId();
    }

    default public int createEdgeAttribute(int graphModelId, int edgeId, String name, String strValue, AttributeRecordType valueType, boolean visible) {
        return this.createAttribute(graphModelId, edgeId, AttributeOwnerType.EDGE, name, strValue, valueType, visible);
    }

    default public int createOrUpdateEdgeAttribute(int graphModelId, int edgeId, String name, String newStrValue, AttributeRecordType newValueType, boolean visible) {
        AttributeRecord attributeRecord = this.findAttributeRecordByOwnerAndName(graphModelId, edgeId, AttributeOwnerType.EDGE, name).orElse(null);
        if (attributeRecord == null) {
            return this.createEdgeAttribute(graphModelId, edgeId, name, newStrValue, newValueType, visible);
        }
        attributeRecord.setValue(newStrValue, newValueType);
        attributeRecord.setVisible(visible);
        this.editAttributeRecords(graphModelId, List.of(attributeRecord));
        return attributeRecord.getId();
    }

    public int findTotalNumberOfVertices(int var1);

    public int findTotalNumberOfEdges(int var1, boolean var2);

    public List<GraphModelRecord> findGraphModelRecords();

    public Optional<GraphModelRecord> findGraphModelRecord(int var1);

    public List<VertexRecord> findRootRecords(int var1);

    public Optional<VertexRecord> findVertexRecord(int var1, int var2);

    public Optional<VertexRecord> findVertexRecord(int var1, UUID var2);

    public List<VertexRecord> findVertexRecordsByParentId(int var1, int var2);

    default public List<VertexRecord> findVertexRecordsByParentIdAndVertexType(int graphModelId, int parentId, int vertexType) {
        return this.findVertexRecordsByParentId(graphModelId, parentId).stream().filter(it -> {
            AttributeRecord vertexTypeAttributeRecord = this.findAttributeRecordByOwnerAndName(it.getGraphModelId(), it.getId(), AttributeOwnerType.VERTEX, SYSTEM_VERTEX_TYPE_NAME).orElse(null);
            if (vertexTypeAttributeRecord == null) {
                return false;
            }
            return (vertexTypeAttributeRecord.getIntegerValue() & vertexType) > 0;
        }).toList();
    }

    public List<EdgeRecord> findAllEdgeRecordsByGraphModelId(int var1);

    public Optional<EdgeRecord> findEdgeRecord(int var1, int var2);

    public Optional<EdgeRecord> findEdgeRecord(int var1, UUID var2);

    public List<EdgeRecord> findEdgeRecordsByParentId(int var1, int var2, boolean var3);

    public List<EdgeRecord> findEdgeRecordsByVertexId(int var1, int var2);

    public Optional<AttributeRecord> findAttributeRecord(int var1, int var2);

    public Optional<AttributeRecord> findAttributeRecordByOwnerAndName(int var1, int var2, AttributeOwnerType var3, String var4);

    public Map<Integer, List<AttributeRecord>> findAttributeRecordsByOwners(int var1, Set<Integer> var2, AttributeOwnerType var3);

    default public List<AttributeRecord> findAttributeRecordsByOwner(int graphModelId, int ownerId, AttributeOwnerType ownerType) {
        return this.findAttributeRecordsByOwners(graphModelId, Set.of(Integer.valueOf(ownerId)), ownerType).getOrDefault(ownerId, List.of());
    }

    public List<AttributeRecord> findAttributeRecordsByNameAndValue(int var1, String var2, String var3);

    default public Graph findGraph(int graphModelId, int parentId) {
        return this.findGraph(graphModelId, parentId, false);
    }

    default public Graph findGraph(int graphModelId, int parentId, boolean withChildren) {
        List<Vertex> vertices = this.findVertexRecordsByParentId(graphModelId, parentId).stream().map(it -> new Vertex(this.findAttributesByOwner(graphModelId, it.getId(), AttributeOwnerType.VERTEX), (VertexRecord)it)).toList();
        Map.Entry<List<Edge>, Set<Edge>> entryEdges = this.findEdges(graphModelId, vertices);
        List<AttributeRecord> attributeRecords = this.findAttributeRecordsByOwner(graphModelId, parentId, AttributeOwnerType.VERTEX);
        List<Attribute> attributes = VGUtils.convertToAttributes(attributeRecords);
        Graph result = new Graph(vertices, (Collection<Edge>)entryEdges.getKey(), entryEdges.getValue(), attributes);
        if (withChildren) {
            this.enrichGraph(result);
        }
        return result;
    }

    default public void enrichGraph(Graph graph) {
        ArrayDeque<Vertex> vertices = new ArrayDeque<Vertex>(graph.getAllVertices());
        while (!vertices.isEmpty()) {
            Vertex vertex = vertices.poll();
            if (vertex.getLinkToVertexRecord() == null) continue;
            int graphModelId = vertex.getLinkToVertexRecord().getGraphModelId();
            List<Vertex> tmpVertices = this.findVerticesByParentId(graphModelId, vertex.getLinkToVertexRecord().getId());
            for (Vertex tmpVertex : tmpVertices) {
                graph.insertVertex(tmpVertex, vertex);
            }
            vertices.addAll(tmpVertices);
            graph.addEdges((Collection<Edge>)this.findEdges(graphModelId, tmpVertices).getKey());
        }
    }

    default public Optional<Vertex> findVertex(int graphModelId, int vertexId) {
        return this.findVertexRecord(graphModelId, vertexId).map(it -> new Vertex(this.findAttributesByOwner(graphModelId, vertexId, AttributeOwnerType.VERTEX), (VertexRecord)it));
    }

    default public Optional<Edge> findEdge(int graphModelId, int edgeId) {
        return this.findEdgeRecord(graphModelId, edgeId).map(it -> new Edge((Vertex)this.findVertex(graphModelId, it.getSourceId()).orElse(null), (Vertex)this.findVertex(graphModelId, it.getTargetId()).orElse(null), this.findAttributesByOwner(graphModelId, edgeId, AttributeOwnerType.EDGE), (EdgeRecord)it));
    }

    default public List<Attribute> findAttributesByOwner(int graphModelId, int ownerId, AttributeOwnerType ownerType) {
        return this.findAttributeRecordsByOwner(graphModelId, ownerId, ownerType).stream().map(VGUtils::convertToAttribute).collect(Collectors.toList());
    }

    public void editGraphModelRecord(GraphModelRecord var1);

    public void editAttributeRecords(int var1, @NonNull List<AttributeRecord> var2);

    public void doDeleteVertexRecordById(int var1, int var2);

    public void doDeleteEdgeRecordById(int var1, int var2);

    default public void deleteVertexRecordById(int graphModelId, int vertexId) {
        this.doDeleteVertexRecordById(graphModelId, vertexId);
    }

    default public void deleteEdgeRecordById(int graphModelId, int edgeId) {
        this.doDeleteEdgeRecordById(graphModelId, edgeId);
    }

    private List<Vertex> findVerticesByParentId(int graphModelId, int parentId) {
        return this.findVertexRecordsByParentId(graphModelId, parentId).stream().map(it -> new Vertex(this.findAttributesByOwner(graphModelId, it.getId(), AttributeOwnerType.VERTEX), (VertexRecord)it)).toList();
    }

    private Map.Entry<List<Edge>, Set<Edge>> findEdges(int graphModelId, List<Vertex> vertices) {
        Validate.isTrue((graphModelId > 0 ? 1 : 0) != 0);
        boolean precondition = vertices.stream().allMatch(vertex -> {
            VertexRecord vertexRecord = vertex.getLinkToVertexRecord();
            return vertexRecord != null && vertexRecord.getGraphModelId() == graphModelId;
        });
        Validate.isTrue((boolean)precondition);
        ArrayList<Edge> edges = new ArrayList<Edge>();
        LinkedHashSet<Edge> outsideEdges = new LinkedHashSet<Edge>();
        List<EdgeRecord> edgeRecords = this.findAllEdgeRecordsByGraphModelId(graphModelId);
        for (EdgeRecord edgeRecord : edgeRecords) {
            Vertex src = null;
            Vertex trg = null;
            for (Vertex vertex2 : vertices) {
                if (vertex2.getLinkToVertexRecord().getId() == edgeRecord.getSourceId()) {
                    src = vertex2;
                }
                if (vertex2.getLinkToVertexRecord().getId() != edgeRecord.getTargetId()) continue;
                trg = vertex2;
            }
            if (src == null && trg == null) continue;
            List<Attribute> attributes = this.findAttributesByOwner(graphModelId, edgeRecord.getId(), AttributeOwnerType.EDGE);
            Edge edge = new Edge(src, trg, attributes, edgeRecord);
            if (src != null && trg != null) {
                edges.add(edge);
                continue;
            }
            outsideEdges.add(edge);
        }
        return new AbstractMap.SimpleEntry<List<Edge>, Set<Edge>>(edges, outsideEdges);
    }

    private void createOrUpdateVertexTypeAttributeRecord(int graphModelId, int ownerId, int vertexTypeValueForPatching) {
        AttributeRecord attributeRecord = this.findAttributeRecordByOwnerAndName(graphModelId, ownerId, AttributeOwnerType.VERTEX, SYSTEM_VERTEX_TYPE_NAME).orElse(null);
        if (attributeRecord == null) {
            this.createVertexAttribute(graphModelId, ownerId, SYSTEM_VERTEX_TYPE_NAME, Integer.toString(vertexTypeValueForPatching), AttributeRecordType.INTEGER, false);
        } else {
            Integer value = attributeRecord.getIntegerValue();
            value = value | vertexTypeValueForPatching;
            attributeRecord.setIntegerValue(value);
            this.editAttributeRecords(graphModelId, List.of(attributeRecord));
        }
    }

    private void createOrUpdateEdgeTypeAttributeRecord(int graphModelId, int ownerId, int edgeTypeValueForPatching) {
        AttributeRecord attributeRecord = this.findAttributeRecordByOwnerAndName(graphModelId, ownerId, AttributeOwnerType.EDGE, SYSTEM_EDGE_TYPE_NAME).orElse(null);
        if (attributeRecord == null) {
            this.createEdgeAttribute(graphModelId, ownerId, SYSTEM_EDGE_TYPE_NAME, Integer.toString(edgeTypeValueForPatching), AttributeRecordType.INTEGER, false);
        } else {
            Integer value = attributeRecord.getIntegerValue();
            value = value | edgeTypeValueForPatching;
            attributeRecord.setIntegerValue(value);
            this.editAttributeRecords(graphModelId, List.of(attributeRecord));
        }
    }

    default public void setVertexOriginalIdAttribute(int graphModelId, int vertexId, String originalId) {
        this.createOrUpdateVertexAttribute(graphModelId, vertexId, SYSTEM_VERTEX_ORIGINAL_ID_NAME, originalId, AttributeRecordType.STRING, false);
    }

    default public void setEdgeOriginalIdAttribute(int graphModelId, int dbEdgeId, String originalId) {
        this.createEdgeAttribute(graphModelId, dbEdgeId, SYSTEM_EDGE_ORIGINAL_ID_NAME, originalId, AttributeRecordType.STRING, false);
    }

    default public void dfs(int graphModelId, Consumer<VertexRecord> vertexRecordStartConsumer, Consumer<VertexRecord> vertexRecordEndConsumer, Consumer<EdgeRecord> edgeRecordConsumer) {
        this.dfs(graphModelId, -1, vertexRecordStartConsumer, vertexRecordEndConsumer, edgeRecordConsumer);
    }

    default public void dfs(int graphModelId, int parentId, Consumer<VertexRecord> vertexRecordStartConsumer, Consumer<VertexRecord> vertexRecordEndConsumer, Consumer<EdgeRecord> edgeRecordConsumer) {
        this.dfs(graphModelId, parentId, it -> {}, it -> {}, vertexRecordStartConsumer, vertexRecordEndConsumer, edgeRecordConsumer, null, null, null);
    }

    default public void dfs(int graphModelId, int parentId, Consumer<GraphModelRecord> graphModelRecordStartConsumer, Consumer<GraphModelRecord> graphModelRecordEndConsumer, Consumer<VertexRecord> vertexRecordStartConsumer, Consumer<VertexRecord> vertexRecordEndConsumer, Consumer<EdgeRecord> edgeRecordConsumer) {
        this.dfs(graphModelId, parentId, graphModelRecordStartConsumer, graphModelRecordEndConsumer, vertexRecordStartConsumer, vertexRecordEndConsumer, edgeRecordConsumer, null, null, null);
    }

    default public void dfs(int graphModelId, int parentId, Consumer<GraphModelRecord> graphModelRecordStartConsumer, Consumer<GraphModelRecord> graphModelRecordEndConsumer, Consumer<VertexRecord> vertexRecordStartConsumer, Consumer<VertexRecord> vertexRecordEndConsumer, Consumer<EdgeRecord> edgeRecordConsumer, Map<Integer, List<AttributeRecord>> cachedGraphModelAttributeRecords, Map<Integer, List<AttributeRecord>> cachedVertexAttributeRecords, Map<Integer, List<AttributeRecord>> cachedEdgeAttributeRecords) {
        GraphModelRecord graphModelRecord = this.findGraphModelRecord(graphModelId).orElseThrow(IllegalArgumentException::new);
        graphModelRecordStartConsumer.accept(graphModelRecord);
        Stack<AbstractMap.SimpleEntry<VertexRecord, Boolean>> stack = new Stack<AbstractMap.SimpleEntry<VertexRecord, Boolean>>();
        if (parentId == -1) {
            stack.addAll(this.findVertexRecordsByParentId(graphModelId, -1).stream().map(it -> new AbstractMap.SimpleEntry<VertexRecord, Boolean>((VertexRecord)it, false)).toList());
        } else {
            VertexRecord parentVertexRecord = this.findVertexRecord(graphModelId, parentId).orElseThrow(IllegalArgumentException::new);
            stack.add(new AbstractMap.SimpleEntry<VertexRecord, Boolean>(parentVertexRecord, false));
        }
        while (!stack.isEmpty()) {
            Map.Entry vertexRecordWithState = (Map.Entry)stack.peek();
            VertexRecord vertexRecord = (VertexRecord)vertexRecordWithState.getKey();
            Boolean state = (Boolean)vertexRecordWithState.getValue();
            if (state.booleanValue()) {
                if (vertexRecord.isComposite()) {
                    List<EdgeRecord> edgeRecords = this.findEdgeRecordsByParentId(graphModelId, vertexRecord.getId(), true);
                    if (cachedEdgeAttributeRecords != null && !edgeRecords.isEmpty()) {
                        cachedEdgeAttributeRecords.putAll(this.findAttributeRecordsByOwners(graphModelId, edgeRecords.stream().map(EdgeRecord::getId).collect(Collectors.toSet()), AttributeOwnerType.EDGE));
                    }
                    edgeRecords.forEach(edgeRecordConsumer);
                }
                stack.pop();
                vertexRecordEndConsumer.accept(vertexRecord);
                continue;
            }
            vertexRecordWithState.setValue(true);
            vertexRecordStartConsumer.accept(vertexRecord);
            if (!vertexRecord.isComposite()) continue;
            List<VertexRecord> vertexRecords = this.findVertexRecordsByParentId(graphModelId, vertexRecord.getId());
            if (cachedVertexAttributeRecords != null && !vertexRecords.isEmpty()) {
                cachedVertexAttributeRecords.putAll(this.findAttributeRecordsByOwners(graphModelId, vertexRecords.stream().map(VertexRecord::getId).collect(Collectors.toSet()), AttributeOwnerType.VERTEX));
            }
            for (int vertexRecordIndex = vertexRecords.size() - 1; vertexRecordIndex >= 0; --vertexRecordIndex) {
                stack.add(new AbstractMap.SimpleEntry<VertexRecord, Boolean>(vertexRecords.get(vertexRecordIndex), false));
            }
        }
        if (parentId == -1) {
            this.findEdgeRecordsByParentId(graphModelId, -1, true).forEach(edgeRecordConsumer);
        }
        graphModelRecordEndConsumer.accept(graphModelRecord);
    }

    default public void copyGraphFrom(int sourceGraphModelId, int sourceParentId, Set<UUID> sourceVertexGlobalIds, GraphStorage sourceGraphStorage, int targetGraphModelId, boolean includeParent, boolean includeAllNestedGraphs) {
        HashMap sourceVertexIdToTargetVertexId = new HashMap();
        sourceGraphStorage.dfs(sourceGraphModelId, sourceParentId, it -> sourceGraphStorage.findAttributeRecordsByOwner(sourceGraphModelId, it.getId(), AttributeOwnerType.GRAPH_MODEL).forEach(attributeRecord -> this.createGraphModelAttribute(targetGraphModelId, attributeRecord.getName(), attributeRecord.getStringValue(), attributeRecord.getType(), attributeRecord.isVisible())), it -> {}, it -> {
            if (sourceVertexGlobalIds == null && !includeParent && it.getId() == sourceParentId) {
                return;
            }
            if (sourceVertexGlobalIds == null && !includeAllNestedGraphs && it.getId() != sourceParentId && it.getParentId() != sourceParentId) {
                return;
            }
            if (sourceVertexGlobalIds != null && !sourceVertexGlobalIds.contains(it.getGlobalId())) {
                return;
            }
            UUID sourceGlobalId = it.getGlobalId();
            Integer targetParentId = sourceVertexIdToTargetVertexId.getOrDefault(it.getParentId(), -1);
            Integer targetVertexId = this.doCreateVertices(targetGraphModelId, List.of(targetParentId), List.of(sourceGlobalId)).get(0);
            sourceVertexIdToTargetVertexId.put(it.getId(), targetVertexId);
            sourceGraphStorage.findAttributeRecordsByOwner(sourceGraphModelId, it.getId(), AttributeOwnerType.VERTEX).forEach(attributeRecord -> this.createVertexAttribute(targetGraphModelId, targetVertexId, attributeRecord.getName(), attributeRecord.getStringValue(), attributeRecord.getType(), attributeRecord.isVisible()));
        }, it -> {}, it -> {
            Integer targetParentId = sourceVertexIdToTargetVertexId.getOrDefault(it.getParentId(), -1);
            Integer targetSourceVertexId = (Integer)sourceVertexIdToTargetVertexId.get(it.getSourceId());
            Integer targetTargetVertexId = (Integer)sourceVertexIdToTargetVertexId.get(it.getTargetId());
            if (targetSourceVertexId == null || targetTargetVertexId == null) {
                return;
            }
            UUID sourceGlobalId = it.getGlobalId();
            int targetEdgeId = this.doCreateEdge(targetGraphModelId, targetParentId, sourceGlobalId, targetSourceVertexId, targetTargetVertexId, it.isVisible());
            List<AttributeRecord> sourceEdgeAttributeRecords = sourceGraphStorage.findAttributeRecordsByOwner(sourceGraphModelId, it.getId(), AttributeOwnerType.EDGE);
            for (AttributeRecord sourceEdgeAttributeRecord : sourceEdgeAttributeRecords) {
                this.createEdgeAttribute(targetGraphModelId, targetEdgeId, sourceEdgeAttributeRecord.getName(), sourceEdgeAttributeRecord.getStringValue(), sourceEdgeAttributeRecord.getType(), sourceEdgeAttributeRecord.isVisible());
            }
        }, null, null, null);
        int totalNumberOfVertices = this.findTotalNumberOfVertices(targetGraphModelId);
        int totalNumberOfEdges = this.findTotalNumberOfEdges(targetGraphModelId, false);
        this.createOrUpdateGraphModelAttribute(targetGraphModelId, SYSTEM_GRAPH_MODEL_SUMMARY_NAME, JsonUtils.toJson(GraphModelSummary.builder().totalNumberOfVertices(totalNumberOfVertices).totalNumberOfEdges(totalNumberOfEdges).build()), AttributeRecordType.JSON, false);
    }

    public static Optional<AttributeRecord> findVertexNestedGraphOriginalIdAttributeRecord(List<AttributeRecord> attributeRecords) {
        return Optional.ofNullable(attributeRecords).orElse(Collections.emptyList()).stream().filter(it -> SYSTEM_VERTEX_NESTED_GRAPH_ORIGINAL_ID_NAME.equals(it.getName())).findFirst();
    }

    public static Optional<AttributeRecord> findVertexOriginalIdAttributeRecord(List<AttributeRecord> attributeRecords) {
        return Optional.ofNullable(attributeRecords).orElse(Collections.emptyList()).stream().filter(it -> SYSTEM_VERTEX_ORIGINAL_ID_NAME.equals(it.getName())).findFirst();
    }

    public static Optional<AttributeRecord> findVertexTypeAttributeRecord(List<AttributeRecord> attributeRecords) {
        return Optional.ofNullable(attributeRecords).orElse(Collections.emptyList()).stream().filter(it -> SYSTEM_VERTEX_TYPE_NAME.equals(it.getName())).findFirst();
    }

    public static Optional<AttributeRecord> findVertexGraphicsAttributeRecord(List<AttributeRecord> attributeRecords) {
        return Optional.ofNullable(attributeRecords).orElse(Collections.emptyList()).stream().filter(it -> SYSTEM_VERTEX_GRAPHICS_NAME.equals(it.getName())).findFirst();
    }

    public static Optional<AttributeRecord> findEdgeOriginalIdAttributeRecord(List<AttributeRecord> attributeRecords) {
        return Optional.ofNullable(attributeRecords).orElse(Collections.emptyList()).stream().filter(it -> SYSTEM_EDGE_ORIGINAL_ID_NAME.equals(it.getName())).findFirst();
    }

    public static Optional<AttributeRecord> findEdgeTypeAttributeRecord(List<AttributeRecord> attributeRecords) {
        return Optional.ofNullable(attributeRecords).orElse(Collections.emptyList()).stream().filter(it -> SYSTEM_EDGE_TYPE_NAME.equals(it.getName())).findFirst();
    }

    public static Optional<AttributeRecord> findEdgeIsDirectedAttributeRecord(List<AttributeRecord> attributeRecords) {
        return Optional.ofNullable(attributeRecords).orElse(Collections.emptyList()).stream().filter(it -> SYSTEM_EDGE_IS_DIRECTED_NAME.equals(it.getName())).findFirst();
    }

    public static Optional<AttributeRecord> findEdgeStorageSourcePortGlobalIdAttributeRecord(List<AttributeRecord> attributeRecords) {
        return Optional.ofNullable(attributeRecords).orElse(Collections.emptyList()).stream().filter(it -> SYSTEM_EDGE_STORAGE_SOURCE_PORT_GLOBAL_ID.equals(it.getName())).findFirst();
    }

    public static Optional<AttributeRecord> findEdgeStorageTargetPortGlobalIdAttributeRecord(List<AttributeRecord> attributeRecords) {
        return Optional.ofNullable(attributeRecords).orElse(Collections.emptyList()).stream().filter(it -> SYSTEM_EDGE_STORAGE_TARGET_PORT_GLOBAL_ID.equals(it.getName())).findFirst();
    }

    public static Optional<AttributeRecord> findEdgeGraphicsAttributeRecord(List<AttributeRecord> attributeRecords) {
        return Optional.ofNullable(attributeRecords).orElse(Collections.emptyList()).stream().filter(it -> SYSTEM_EDGE_GRAPHICS_NAME.equals(it.getName())).findFirst();
    }

    public static UUID generateGlobalId() {
        return UUID.randomUUID();
    }

    public static List<UUID> generateGlobalIds(int count) {
        return IntStream.range(0, count).mapToObj(i -> UUID.randomUUID()).toList();
    }

    private Map<Integer, List<Integer>> findParents(int graphModelId, List<Integer> vertexIds) {
        int index;
        HashMap hierarchies = new HashMap();
        for (int vertexId : vertexIds) {
            ArrayList<Integer> hierarchy = new ArrayList<Integer>();
            int tempVertexId = vertexId;
            do {
                tempVertexId = this.findVertexRecord(graphModelId, tempVertexId).map(VertexRecord::getParentId).orElse(-1);
                hierarchy.add(tempVertexId);
            } while (tempVertexId > -1);
            Collections.reverse(hierarchy);
            hierarchies.put(vertexId, hierarchy);
        }
        List parentIds = (List)hierarchies.get(vertexIds.get(0));
        for (index = 0; index < parentIds.size(); ++index) {
            int currentParentId = (Integer)parentIds.get(index);
            boolean check = false;
            for (List hierarchy : hierarchies.values()) {
                if (index >= hierarchy.size()) {
                    check = true;
                    break;
                }
                if ((Integer)hierarchy.get(index) == currentParentId) continue;
                check = true;
                break;
            }
            if (check) break;
        }
        --index;
        HashMap<Integer, List<Integer>> result = new HashMap<Integer, List<Integer>>();
        for (int vertexId : vertexIds) {
            List hierarchy;
            hierarchy = (List)hierarchies.get(vertexId);
            ArrayList<Integer> newHierarchy = new ArrayList<Integer>();
            for (int i = index; i < hierarchy.size(); ++i) {
                newHierarchy.add((Integer)hierarchy.get(i));
            }
            Collections.reverse(newHierarchy);
            result.put(vertexId, newHierarchy);
        }
        return result;
    }

    private int findCommonParentId(int graphModelId, int sourceVertexId, int targetVertexId) {
        int[] targetParentIds;
        int[] sourceParentIds = this.findParents(graphModelId, sourceVertexId);
        int min = Math.min(sourceParentIds.length, (targetParentIds = this.findParents(graphModelId, targetVertexId)).length);
        if (min == 0) {
            throw new IllegalArgumentException(String.format("No parents found for vertices. Arguments: graphModelId=%d, sourceVertexId=%d, targetVertexId=%d. Data: sourceParents=%s, targetParents=%s.", graphModelId, sourceVertexId, targetVertexId, Arrays.toString(sourceParentIds), Arrays.toString(targetParentIds)));
        }
        if (sourceParentIds[0] != targetParentIds[0]) {
            throw new IllegalArgumentException(String.format("The vertices have different root parents. Arguments: graphModelId=%d, sourceVertexId=%d, targetVertexId=%d. Root parents: root source parent=%d, root target parent=%d. Data: sourceParents=%s, targetParents=%s.", graphModelId, sourceVertexId, targetVertexId, sourceParentIds[0], targetParentIds[0], Arrays.toString(sourceParentIds), Arrays.toString(targetParentIds)));
        }
        int commonParentId = sourceParentIds[0];
        for (int index = 1; index < min && sourceParentIds[index] == targetParentIds[index]; ++index) {
            commonParentId = sourceParentIds[index];
        }
        return commonParentId;
    }

    private int[] findParents(int graphModelId, int vertexId) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        do {
            vertexId = this.findVertexRecord(graphModelId, vertexId).map(VertexRecord::getParentId).orElse(-1);
            result.add(vertexId);
        } while (vertexId > -1);
        Collections.reverse(result);
        return result.stream().mapToInt(i -> i).toArray();
    }
}

