/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.model.record;

import java.io.Serializable;
import java.util.UUID;

public class VertexRecord
implements Cloneable,
Serializable,
Comparable<VertexRecord> {
    public static final int NO_PARENT_ID = -1;
    private final int id;
    private int graphModelId;
    private final UUID globalId;
    private int parentId;
    private boolean composite;

    public VertexRecord(int id, int graphModelId, UUID globalId, int parentId, boolean composite) {
        this.id = id;
        this.graphModelId = graphModelId;
        this.globalId = globalId;
        this.parentId = parentId;
        this.composite = composite;
    }

    public boolean isRoot() {
        return this.parentId == -1;
    }

    public VertexRecord clone() {
        return new VertexRecord(this.id, this.graphModelId, this.globalId, this.parentId, this.composite);
    }

    @Override
    public int compareTo(VertexRecord o) {
        return Integer.compare(this.id, o.id);
    }

    public int getId() {
        return this.id;
    }

    public int getGraphModelId() {
        return this.graphModelId;
    }

    public void setGraphModelId(int graphModelId) {
        this.graphModelId = graphModelId;
    }

    public UUID getGlobalId() {
        return this.globalId;
    }

    public int getParentId() {
        return this.parentId;
    }

    public void setParentId(int parentId) {
        this.parentId = parentId;
    }

    public boolean isComposite() {
        return this.composite;
    }

    public void setComposite(boolean composite) {
        this.composite = composite;
    }
}

