/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.model.record;

import java.io.Serializable;
import java.util.UUID;
import org.apache.commons.lang3.Validate;
import vg.lib.model.record.AttributeOwnerType;
import vg.lib.model.record.AttributeRecordType;

public class AttributeRecord
implements Cloneable,
Serializable,
Comparable<AttributeRecord> {
    private final int graphModelId;
    private int id;
    private int ownerId;
    private AttributeOwnerType ownerType;
    private String name;
    private Object value;
    private AttributeRecordType type;
    private boolean visible;

    public AttributeRecord(int graphModelId, int ownerId, AttributeOwnerType ownerType, String name, String value, AttributeRecordType type, boolean visible) {
        this(graphModelId, -1, ownerId, ownerType, name, value, type, visible);
    }

    public AttributeRecord(int graphModelId, int id, int ownerId, AttributeOwnerType ownerType, String name, String value, AttributeRecordType type, boolean visible) {
        this.graphModelId = graphModelId;
        this.id = id;
        this.ownerId = ownerId;
        this.ownerType = ownerType;
        this.name = name;
        this.visible = visible;
        this.setValue(value, type);
    }

    public boolean isSystem() {
        return this.getName().startsWith("system_");
    }

    public void update(String strValue, AttributeRecordType type, boolean visible) {
        this.setValue(strValue, type);
        this.setVisible(visible);
    }

    public int getId() {
        return this.id;
    }

    public int getOwnerId() {
        return this.ownerId;
    }

    public String getName() {
        return this.name;
    }

    public UUID getUUIDValue() {
        if (this.type == AttributeRecordType.UUID) {
            return (UUID)this.value;
        }
        return null;
    }

    public String getStringValue() {
        return this.value.toString();
    }

    public Integer getIntegerValue() {
        if (this.type == AttributeRecordType.INTEGER) {
            return (Integer)this.value;
        }
        return null;
    }

    public Boolean getBooleanValue() {
        if (this.type == AttributeRecordType.BOOLEAN) {
            return (Boolean)this.value;
        }
        return null;
    }

    public Double getDoubleValue() {
        if (this.type == AttributeRecordType.DOUBLE) {
            return (Double)this.value;
        }
        return null;
    }

    public Double getRealValue() {
        if (this.isIntegerType()) {
            return ((Integer)this.value).doubleValue();
        }
        if (this.isDoubleType()) {
            return (Double)this.value;
        }
        return null;
    }

    public boolean isStringType() {
        return this.getType() == AttributeRecordType.STRING;
    }

    public boolean isBooleanType() {
        return this.getType() == AttributeRecordType.BOOLEAN;
    }

    public boolean isIntegerType() {
        return this.getType() == AttributeRecordType.INTEGER;
    }

    public boolean isDoubleType() {
        return this.getType() == AttributeRecordType.DOUBLE;
    }

    public boolean isRealType() {
        return this.isDoubleType() || this.isIntegerType();
    }

    public void setName(String newName) {
        Validate.notNull((Object)newName);
        this.name = newName;
    }

    public void setStringValue(String newValue) {
        Validate.notNull((Object)newValue);
        this.type = AttributeRecordType.STRING;
        this.value = newValue;
    }

    public void setJsonValue(String newValue) {
        Validate.notNull((Object)newValue);
        this.type = AttributeRecordType.JSON;
        this.value = newValue;
    }

    public void setBooleanValue(Boolean newValue) {
        Validate.notNull((Object)newValue);
        this.type = AttributeRecordType.BOOLEAN;
        this.value = newValue;
    }

    public void setIntegerValue(Integer newValue) {
        Validate.notNull((Object)newValue);
        this.type = AttributeRecordType.INTEGER;
        this.value = newValue;
    }

    public void setDoubleValue(Double newValue) {
        Validate.notNull((Object)newValue);
        this.type = AttributeRecordType.DOUBLE;
        this.value = newValue;
    }

    public void setUUIDValue(UUID newValue) {
        Validate.notNull((Object)newValue);
        this.type = AttributeRecordType.UUID;
        this.value = newValue;
    }

    public void setValue(String newValue, AttributeRecordType newType) {
        switch (newType) {
            case BOOLEAN: {
                this.setBooleanValue(Boolean.valueOf(newValue));
                break;
            }
            case DOUBLE: {
                this.setDoubleValue(Double.valueOf(newValue));
                break;
            }
            case INTEGER: {
                this.setIntegerValue(Integer.valueOf(newValue));
                break;
            }
            case UUID: {
                this.setUUIDValue(UUID.fromString(newValue));
                break;
            }
            case JSON: {
                this.setJsonValue(newValue);
                break;
            }
            default: {
                this.setStringValue(String.valueOf(newValue));
            }
        }
    }

    public AttributeRecord clone() {
        return new AttributeRecord(this.graphModelId, this.id, this.ownerId, this.ownerType, this.name, this.value.toString(), this.type, this.visible);
    }

    @Override
    public int compareTo(AttributeRecord o) {
        return Integer.compare(this.id, o.id);
    }

    public int getGraphModelId() {
        return this.graphModelId;
    }

    public AttributeOwnerType getOwnerType() {
        return this.ownerType;
    }

    public AttributeRecordType getType() {
        return this.type;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

