/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.model.graphics;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.awt.Point;
import java.awt.Rectangle;
import vg.lib.model.graphics.GraphicsJsonAdapter;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class VertexGraphics {
    @JsonSerialize(using=GraphicsJsonAdapter.RectangleSerializer.class)
    @JsonDeserialize(using=GraphicsJsonAdapter.RectangleDeserializer.class)
    private Rectangle boundingBox;
    @JsonProperty
    private int border;
    @JsonProperty
    private ShapeType shapeType;
    @JsonProperty
    private String color;
    @JsonProperty
    private boolean selected;
    @JsonProperty
    private boolean highlighted;
    @JsonProperty
    private VertexLabel label;
    @JsonSerialize(using=GraphicsJsonAdapter.PointSerializer.class)
    @JsonDeserialize(using=GraphicsJsonAdapter.PointDeserializer.class)
    private Point labelOffset;

    public VertexGraphics() {
    }

    public static VertexGraphicsBuilder builder() {
        return new VertexGraphicsBuilder();
    }

    public Rectangle getBoundingBox() {
        return this.boundingBox;
    }

    public int getBorder() {
        return this.border;
    }

    public ShapeType getShapeType() {
        return this.shapeType;
    }

    public String getColor() {
        return this.color;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public VertexLabel getLabel() {
        return this.label;
    }

    public Point getLabelOffset() {
        return this.labelOffset;
    }

    @JsonDeserialize(using=GraphicsJsonAdapter.RectangleDeserializer.class)
    public void setBoundingBox(Rectangle boundingBox) {
        this.boundingBox = boundingBox;
    }

    @JsonProperty
    public void setBorder(int border) {
        this.border = border;
    }

    @JsonProperty
    public void setShapeType(ShapeType shapeType) {
        this.shapeType = shapeType;
    }

    @JsonProperty
    public void setColor(String color) {
        this.color = color;
    }

    @JsonProperty
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @JsonProperty
    public void setHighlighted(boolean highlighted) {
        this.highlighted = highlighted;
    }

    @JsonProperty
    public void setLabel(VertexLabel label) {
        this.label = label;
    }

    @JsonDeserialize(using=GraphicsJsonAdapter.PointDeserializer.class)
    public void setLabelOffset(Point labelOffset) {
        this.labelOffset = labelOffset;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VertexGraphics)) {
            return false;
        }
        VertexGraphics other = (VertexGraphics)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBorder() != other.getBorder()) {
            return false;
        }
        if (this.isSelected() != other.isSelected()) {
            return false;
        }
        if (this.isHighlighted() != other.isHighlighted()) {
            return false;
        }
        Rectangle this$boundingBox = this.getBoundingBox();
        Rectangle other$boundingBox = other.getBoundingBox();
        if (this$boundingBox == null ? other$boundingBox != null : !((Object)this$boundingBox).equals(other$boundingBox)) {
            return false;
        }
        ShapeType this$shapeType = this.getShapeType();
        ShapeType other$shapeType = other.getShapeType();
        if (this$shapeType == null ? other$shapeType != null : !((Object)((Object)this$shapeType)).equals((Object)other$shapeType)) {
            return false;
        }
        String this$color = this.getColor();
        String other$color = other.getColor();
        if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
            return false;
        }
        VertexLabel this$label = this.getLabel();
        VertexLabel other$label = other.getLabel();
        if (this$label == null ? other$label != null : !((Object)this$label).equals(other$label)) {
            return false;
        }
        Point this$labelOffset = this.getLabelOffset();
        Point other$labelOffset = other.getLabelOffset();
        return !(this$labelOffset == null ? other$labelOffset != null : !((Object)this$labelOffset).equals(other$labelOffset));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VertexGraphics;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBorder();
        result = result * 59 + (this.isSelected() ? 79 : 97);
        result = result * 59 + (this.isHighlighted() ? 79 : 97);
        Rectangle $boundingBox = this.getBoundingBox();
        result = result * 59 + ($boundingBox == null ? 43 : ((Object)$boundingBox).hashCode());
        ShapeType $shapeType = this.getShapeType();
        result = result * 59 + ($shapeType == null ? 43 : ((Object)((Object)$shapeType)).hashCode());
        String $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : $color.hashCode());
        VertexLabel $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : ((Object)$label).hashCode());
        Point $labelOffset = this.getLabelOffset();
        result = result * 59 + ($labelOffset == null ? 43 : ((Object)$labelOffset).hashCode());
        return result;
    }

    public String toString() {
        return "VertexGraphics(boundingBox=" + this.getBoundingBox() + ", border=" + this.getBorder() + ", shapeType=" + this.getShapeType() + ", color=" + this.getColor() + ", selected=" + this.isSelected() + ", highlighted=" + this.isHighlighted() + ", label=" + this.getLabel() + ", labelOffset=" + this.getLabelOffset() + ")";
    }

    public VertexGraphics(Rectangle boundingBox, int border, ShapeType shapeType, String color, boolean selected, boolean highlighted, VertexLabel label, Point labelOffset) {
        this.boundingBox = boundingBox;
        this.border = border;
        this.shapeType = shapeType;
        this.color = color;
        this.selected = selected;
        this.highlighted = highlighted;
        this.label = label;
        this.labelOffset = labelOffset;
    }

    public static class VertexGraphicsBuilder {
        private Rectangle boundingBox;
        private int border;
        private ShapeType shapeType;
        private String color;
        private boolean selected;
        private boolean highlighted;
        private VertexLabel label;
        private Point labelOffset;

        VertexGraphicsBuilder() {
        }

        @JsonDeserialize(using=GraphicsJsonAdapter.RectangleDeserializer.class)
        public VertexGraphicsBuilder boundingBox(Rectangle boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        @JsonProperty
        public VertexGraphicsBuilder border(int border) {
            this.border = border;
            return this;
        }

        @JsonProperty
        public VertexGraphicsBuilder shapeType(ShapeType shapeType) {
            this.shapeType = shapeType;
            return this;
        }

        @JsonProperty
        public VertexGraphicsBuilder color(String color) {
            this.color = color;
            return this;
        }

        @JsonProperty
        public VertexGraphicsBuilder selected(boolean selected) {
            this.selected = selected;
            return this;
        }

        @JsonProperty
        public VertexGraphicsBuilder highlighted(boolean highlighted) {
            this.highlighted = highlighted;
            return this;
        }

        @JsonProperty
        public VertexGraphicsBuilder label(VertexLabel label) {
            this.label = label;
            return this;
        }

        @JsonDeserialize(using=GraphicsJsonAdapter.PointDeserializer.class)
        public VertexGraphicsBuilder labelOffset(Point labelOffset) {
            this.labelOffset = labelOffset;
            return this;
        }

        public VertexGraphics build() {
            return new VertexGraphics(this.boundingBox, this.border, this.shapeType, this.color, this.selected, this.highlighted, this.label, this.labelOffset);
        }

        public String toString() {
            return "VertexGraphics.VertexGraphicsBuilder(boundingBox=" + this.boundingBox + ", border=" + this.border + ", shapeType=" + this.shapeType + ", color=" + this.color + ", selected=" + this.selected + ", highlighted=" + this.highlighted + ", label=" + this.label + ", labelOffset=" + this.labelOffset + ")";
        }
    }

    public static enum ShapeType {
        RECTANGLE,
        CIRCLE,
        DIAMOND;

    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class VertexLabel {
        @JsonProperty
        private String content;
        @JsonProperty
        private int fontSize;
        @JsonProperty
        private boolean visible;
        @JsonProperty
        private String fontColor;
        @JsonProperty
        private int width;
        @JsonProperty
        private int height;
        @JsonProperty
        private LabelAlignment alignment;

        public VertexLabel() {
        }

        public static VertexLabelBuilder builder() {
            return new VertexLabelBuilder();
        }

        public String getContent() {
            return this.content;
        }

        public int getFontSize() {
            return this.fontSize;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public String getFontColor() {
            return this.fontColor;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public LabelAlignment getAlignment() {
            return this.alignment;
        }

        @JsonProperty
        public void setContent(String content) {
            this.content = content;
        }

        @JsonProperty
        public void setFontSize(int fontSize) {
            this.fontSize = fontSize;
        }

        @JsonProperty
        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        @JsonProperty
        public void setFontColor(String fontColor) {
            this.fontColor = fontColor;
        }

        @JsonProperty
        public void setWidth(int width) {
            this.width = width;
        }

        @JsonProperty
        public void setHeight(int height) {
            this.height = height;
        }

        @JsonProperty
        public void setAlignment(LabelAlignment alignment) {
            this.alignment = alignment;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VertexLabel)) {
                return false;
            }
            VertexLabel other = (VertexLabel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getFontSize() != other.getFontSize()) {
                return false;
            }
            if (this.isVisible() != other.isVisible()) {
                return false;
            }
            if (this.getWidth() != other.getWidth()) {
                return false;
            }
            if (this.getHeight() != other.getHeight()) {
                return false;
            }
            String this$content = this.getContent();
            String other$content = other.getContent();
            if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
                return false;
            }
            String this$fontColor = this.getFontColor();
            String other$fontColor = other.getFontColor();
            if (this$fontColor == null ? other$fontColor != null : !this$fontColor.equals(other$fontColor)) {
                return false;
            }
            LabelAlignment this$alignment = this.getAlignment();
            LabelAlignment other$alignment = other.getAlignment();
            return !(this$alignment == null ? other$alignment != null : !((Object)((Object)this$alignment)).equals((Object)other$alignment));
        }

        protected boolean canEqual(Object other) {
            return other instanceof VertexLabel;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getFontSize();
            result = result * 59 + (this.isVisible() ? 79 : 97);
            result = result * 59 + this.getWidth();
            result = result * 59 + this.getHeight();
            String $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            String $fontColor = this.getFontColor();
            result = result * 59 + ($fontColor == null ? 43 : $fontColor.hashCode());
            LabelAlignment $alignment = this.getAlignment();
            result = result * 59 + ($alignment == null ? 43 : ((Object)((Object)$alignment)).hashCode());
            return result;
        }

        public String toString() {
            return "VertexGraphics.VertexLabel(content=" + this.getContent() + ", fontSize=" + this.getFontSize() + ", visible=" + this.isVisible() + ", fontColor=" + this.getFontColor() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", alignment=" + this.getAlignment() + ")";
        }

        public VertexLabel(String content, int fontSize, boolean visible, String fontColor, int width, int height, LabelAlignment alignment) {
            this.content = content;
            this.fontSize = fontSize;
            this.visible = visible;
            this.fontColor = fontColor;
            this.width = width;
            this.height = height;
            this.alignment = alignment;
        }

        public static class VertexLabelBuilder {
            private String content;
            private int fontSize;
            private boolean visible;
            private String fontColor;
            private int width;
            private int height;
            private LabelAlignment alignment;

            VertexLabelBuilder() {
            }

            @JsonProperty
            public VertexLabelBuilder content(String content) {
                this.content = content;
                return this;
            }

            @JsonProperty
            public VertexLabelBuilder fontSize(int fontSize) {
                this.fontSize = fontSize;
                return this;
            }

            @JsonProperty
            public VertexLabelBuilder visible(boolean visible) {
                this.visible = visible;
                return this;
            }

            @JsonProperty
            public VertexLabelBuilder fontColor(String fontColor) {
                this.fontColor = fontColor;
                return this;
            }

            @JsonProperty
            public VertexLabelBuilder width(int width) {
                this.width = width;
                return this;
            }

            @JsonProperty
            public VertexLabelBuilder height(int height) {
                this.height = height;
                return this;
            }

            @JsonProperty
            public VertexLabelBuilder alignment(LabelAlignment alignment) {
                this.alignment = alignment;
                return this;
            }

            public VertexLabel build() {
                return new VertexLabel(this.content, this.fontSize, this.visible, this.fontColor, this.width, this.height, this.alignment);
            }

            public String toString() {
                return "VertexGraphics.VertexLabel.VertexLabelBuilder(content=" + this.content + ", fontSize=" + this.fontSize + ", visible=" + this.visible + ", fontColor=" + this.fontColor + ", width=" + this.width + ", height=" + this.height + ", alignment=" + this.alignment + ")";
            }
        }
    }

    public static enum LabelAlignment {
        LEFT,
        CENTER;

    }
}

