/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.model.graphics;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;

public class GraphicsJsonAdapter {

    public static class PointDeserializer
    extends JsonDeserializer<Point> {
        public Point deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            return new Point(node.get("x").asInt(), node.get("y").asInt());
        }
    }

    public static class PointSerializer
    extends JsonSerializer<Point> {
        public void serialize(Point value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            gen.writeNumberField("x", value.x);
            gen.writeNumberField("y", value.y);
            gen.writeEndObject();
        }
    }

    public static class RectangleDeserializer
    extends JsonDeserializer<Rectangle> {
        public Rectangle deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            return new Rectangle(node.get("x").asInt(), node.get("y").asInt(), node.get("width").asInt(), node.get("height").asInt());
        }
    }

    public static class RectangleSerializer
    extends JsonSerializer<Rectangle> {
        public void serialize(Rectangle value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            gen.writeNumberField("x", value.x);
            gen.writeNumberField("y", value.y);
            gen.writeNumberField("width", value.width);
            gen.writeNumberField("height", value.height);
            gen.writeEndObject();
        }
    }
}

