/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.model.graphics;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import vg.lib.model.graphics.GraphicsJsonAdapter;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class EdgeGraphics {
    @JsonSerialize(using=GraphicsJsonAdapter.RectangleSerializer.class)
    @JsonDeserialize(using=GraphicsJsonAdapter.RectangleDeserializer.class)
    private Rectangle boundingBox;
    @JsonSerialize(contentUsing=GraphicsJsonAdapter.PointSerializer.class)
    @JsonDeserialize(contentUsing=GraphicsJsonAdapter.PointDeserializer.class)
    private List<Point> points;
    @JsonProperty
    private LineType lineType;
    @JsonProperty
    private LineEndpointType lineStartType;
    @JsonProperty
    private LineEndpointType lineEndType;
    @JsonProperty
    private boolean selected;
    @JsonProperty
    private boolean highlighted;
    @JsonProperty
    private EdgeLabel label;
    @JsonSerialize(using=GraphicsJsonAdapter.PointSerializer.class)
    @JsonDeserialize(using=GraphicsJsonAdapter.PointDeserializer.class)
    private Point labelOffset;

    public EdgeGraphics() {
    }

    public static EdgeGraphicsBuilder builder() {
        return new EdgeGraphicsBuilder();
    }

    public Rectangle getBoundingBox() {
        return this.boundingBox;
    }

    public List<Point> getPoints() {
        return this.points;
    }

    public LineType getLineType() {
        return this.lineType;
    }

    public LineEndpointType getLineStartType() {
        return this.lineStartType;
    }

    public LineEndpointType getLineEndType() {
        return this.lineEndType;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public EdgeLabel getLabel() {
        return this.label;
    }

    public Point getLabelOffset() {
        return this.labelOffset;
    }

    @JsonDeserialize(using=GraphicsJsonAdapter.RectangleDeserializer.class)
    public void setBoundingBox(Rectangle boundingBox) {
        this.boundingBox = boundingBox;
    }

    @JsonDeserialize(contentUsing=GraphicsJsonAdapter.PointDeserializer.class)
    public void setPoints(List<Point> points) {
        this.points = points;
    }

    @JsonProperty
    public void setLineType(LineType lineType) {
        this.lineType = lineType;
    }

    @JsonProperty
    public void setLineStartType(LineEndpointType lineStartType) {
        this.lineStartType = lineStartType;
    }

    @JsonProperty
    public void setLineEndType(LineEndpointType lineEndType) {
        this.lineEndType = lineEndType;
    }

    @JsonProperty
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @JsonProperty
    public void setHighlighted(boolean highlighted) {
        this.highlighted = highlighted;
    }

    @JsonProperty
    public void setLabel(EdgeLabel label) {
        this.label = label;
    }

    @JsonDeserialize(using=GraphicsJsonAdapter.PointDeserializer.class)
    public void setLabelOffset(Point labelOffset) {
        this.labelOffset = labelOffset;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EdgeGraphics)) {
            return false;
        }
        EdgeGraphics other = (EdgeGraphics)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSelected() != other.isSelected()) {
            return false;
        }
        if (this.isHighlighted() != other.isHighlighted()) {
            return false;
        }
        Rectangle this$boundingBox = this.getBoundingBox();
        Rectangle other$boundingBox = other.getBoundingBox();
        if (this$boundingBox == null ? other$boundingBox != null : !((Object)this$boundingBox).equals(other$boundingBox)) {
            return false;
        }
        List<Point> this$points = this.getPoints();
        List<Point> other$points = other.getPoints();
        if (this$points == null ? other$points != null : !((Object)this$points).equals(other$points)) {
            return false;
        }
        LineType this$lineType = this.getLineType();
        LineType other$lineType = other.getLineType();
        if (this$lineType == null ? other$lineType != null : !((Object)((Object)this$lineType)).equals((Object)other$lineType)) {
            return false;
        }
        LineEndpointType this$lineStartType = this.getLineStartType();
        LineEndpointType other$lineStartType = other.getLineStartType();
        if (this$lineStartType == null ? other$lineStartType != null : !((Object)((Object)this$lineStartType)).equals((Object)other$lineStartType)) {
            return false;
        }
        LineEndpointType this$lineEndType = this.getLineEndType();
        LineEndpointType other$lineEndType = other.getLineEndType();
        if (this$lineEndType == null ? other$lineEndType != null : !((Object)((Object)this$lineEndType)).equals((Object)other$lineEndType)) {
            return false;
        }
        EdgeLabel this$label = this.getLabel();
        EdgeLabel other$label = other.getLabel();
        if (this$label == null ? other$label != null : !((Object)this$label).equals(other$label)) {
            return false;
        }
        Point this$labelOffset = this.getLabelOffset();
        Point other$labelOffset = other.getLabelOffset();
        return !(this$labelOffset == null ? other$labelOffset != null : !((Object)this$labelOffset).equals(other$labelOffset));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EdgeGraphics;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSelected() ? 79 : 97);
        result = result * 59 + (this.isHighlighted() ? 79 : 97);
        Rectangle $boundingBox = this.getBoundingBox();
        result = result * 59 + ($boundingBox == null ? 43 : ((Object)$boundingBox).hashCode());
        List<Point> $points = this.getPoints();
        result = result * 59 + ($points == null ? 43 : ((Object)$points).hashCode());
        LineType $lineType = this.getLineType();
        result = result * 59 + ($lineType == null ? 43 : ((Object)((Object)$lineType)).hashCode());
        LineEndpointType $lineStartType = this.getLineStartType();
        result = result * 59 + ($lineStartType == null ? 43 : ((Object)((Object)$lineStartType)).hashCode());
        LineEndpointType $lineEndType = this.getLineEndType();
        result = result * 59 + ($lineEndType == null ? 43 : ((Object)((Object)$lineEndType)).hashCode());
        EdgeLabel $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : ((Object)$label).hashCode());
        Point $labelOffset = this.getLabelOffset();
        result = result * 59 + ($labelOffset == null ? 43 : ((Object)$labelOffset).hashCode());
        return result;
    }

    public String toString() {
        return "EdgeGraphics(boundingBox=" + this.getBoundingBox() + ", points=" + this.getPoints() + ", lineType=" + this.getLineType() + ", lineStartType=" + this.getLineStartType() + ", lineEndType=" + this.getLineEndType() + ", selected=" + this.isSelected() + ", highlighted=" + this.isHighlighted() + ", label=" + this.getLabel() + ", labelOffset=" + this.getLabelOffset() + ")";
    }

    public EdgeGraphics(Rectangle boundingBox, List<Point> points, LineType lineType, LineEndpointType lineStartType, LineEndpointType lineEndType, boolean selected, boolean highlighted, EdgeLabel label, Point labelOffset) {
        this.boundingBox = boundingBox;
        this.points = points;
        this.lineType = lineType;
        this.lineStartType = lineStartType;
        this.lineEndType = lineEndType;
        this.selected = selected;
        this.highlighted = highlighted;
        this.label = label;
        this.labelOffset = labelOffset;
    }

    public static class EdgeGraphicsBuilder {
        private Rectangle boundingBox;
        private List<Point> points;
        private LineType lineType;
        private LineEndpointType lineStartType;
        private LineEndpointType lineEndType;
        private boolean selected;
        private boolean highlighted;
        private EdgeLabel label;
        private Point labelOffset;

        EdgeGraphicsBuilder() {
        }

        @JsonDeserialize(using=GraphicsJsonAdapter.RectangleDeserializer.class)
        public EdgeGraphicsBuilder boundingBox(Rectangle boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        @JsonDeserialize(contentUsing=GraphicsJsonAdapter.PointDeserializer.class)
        public EdgeGraphicsBuilder points(List<Point> points) {
            this.points = points;
            return this;
        }

        @JsonProperty
        public EdgeGraphicsBuilder lineType(LineType lineType) {
            this.lineType = lineType;
            return this;
        }

        @JsonProperty
        public EdgeGraphicsBuilder lineStartType(LineEndpointType lineStartType) {
            this.lineStartType = lineStartType;
            return this;
        }

        @JsonProperty
        public EdgeGraphicsBuilder lineEndType(LineEndpointType lineEndType) {
            this.lineEndType = lineEndType;
            return this;
        }

        @JsonProperty
        public EdgeGraphicsBuilder selected(boolean selected) {
            this.selected = selected;
            return this;
        }

        @JsonProperty
        public EdgeGraphicsBuilder highlighted(boolean highlighted) {
            this.highlighted = highlighted;
            return this;
        }

        @JsonProperty
        public EdgeGraphicsBuilder label(EdgeLabel label) {
            this.label = label;
            return this;
        }

        @JsonDeserialize(using=GraphicsJsonAdapter.PointDeserializer.class)
        public EdgeGraphicsBuilder labelOffset(Point labelOffset) {
            this.labelOffset = labelOffset;
            return this;
        }

        public EdgeGraphics build() {
            return new EdgeGraphics(this.boundingBox, this.points, this.lineType, this.lineStartType, this.lineEndType, this.selected, this.highlighted, this.label, this.labelOffset);
        }

        public String toString() {
            return "EdgeGraphics.EdgeGraphicsBuilder(boundingBox=" + this.boundingBox + ", points=" + this.points + ", lineType=" + this.lineType + ", lineStartType=" + this.lineStartType + ", lineEndType=" + this.lineEndType + ", selected=" + this.selected + ", highlighted=" + this.highlighted + ", label=" + this.label + ", labelOffset=" + this.labelOffset + ")";
        }
    }

    public static enum LineType {
        SOLID,
        DASHED;

    }

    public static enum LineEndpointType {
        NONE,
        ARROW;

    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class EdgeLabel {
        @JsonProperty
        private String content;
        @JsonProperty
        private int fontSize;
        @JsonProperty
        private String fontColor;
        @JsonProperty
        private int width;
        @JsonProperty
        private int height;

        public EdgeLabel() {
        }

        public static EdgeLabelBuilder builder() {
            return new EdgeLabelBuilder();
        }

        public String getContent() {
            return this.content;
        }

        public int getFontSize() {
            return this.fontSize;
        }

        public String getFontColor() {
            return this.fontColor;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        @JsonProperty
        public void setContent(String content) {
            this.content = content;
        }

        @JsonProperty
        public void setFontSize(int fontSize) {
            this.fontSize = fontSize;
        }

        @JsonProperty
        public void setFontColor(String fontColor) {
            this.fontColor = fontColor;
        }

        @JsonProperty
        public void setWidth(int width) {
            this.width = width;
        }

        @JsonProperty
        public void setHeight(int height) {
            this.height = height;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EdgeLabel)) {
                return false;
            }
            EdgeLabel other = (EdgeLabel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getFontSize() != other.getFontSize()) {
                return false;
            }
            if (this.getWidth() != other.getWidth()) {
                return false;
            }
            if (this.getHeight() != other.getHeight()) {
                return false;
            }
            String this$content = this.getContent();
            String other$content = other.getContent();
            if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
                return false;
            }
            String this$fontColor = this.getFontColor();
            String other$fontColor = other.getFontColor();
            return !(this$fontColor == null ? other$fontColor != null : !this$fontColor.equals(other$fontColor));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EdgeLabel;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getFontSize();
            result = result * 59 + this.getWidth();
            result = result * 59 + this.getHeight();
            String $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            String $fontColor = this.getFontColor();
            result = result * 59 + ($fontColor == null ? 43 : $fontColor.hashCode());
            return result;
        }

        public String toString() {
            return "EdgeGraphics.EdgeLabel(content=" + this.getContent() + ", fontSize=" + this.getFontSize() + ", fontColor=" + this.getFontColor() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ")";
        }

        public EdgeLabel(String content, int fontSize, String fontColor, int width, int height) {
            this.content = content;
            this.fontSize = fontSize;
            this.fontColor = fontColor;
            this.width = width;
            this.height = height;
        }

        public static class EdgeLabelBuilder {
            private String content;
            private int fontSize;
            private String fontColor;
            private int width;
            private int height;

            EdgeLabelBuilder() {
            }

            @JsonProperty
            public EdgeLabelBuilder content(String content) {
                this.content = content;
                return this;
            }

            @JsonProperty
            public EdgeLabelBuilder fontSize(int fontSize) {
                this.fontSize = fontSize;
                return this;
            }

            @JsonProperty
            public EdgeLabelBuilder fontColor(String fontColor) {
                this.fontColor = fontColor;
                return this;
            }

            @JsonProperty
            public EdgeLabelBuilder width(int width) {
                this.width = width;
                return this;
            }

            @JsonProperty
            public EdgeLabelBuilder height(int height) {
                this.height = height;
                return this;
            }

            public EdgeLabel build() {
                return new EdgeLabel(this.content, this.fontSize, this.fontColor, this.width, this.height);
            }

            public String toString() {
                return "EdgeGraphics.EdgeLabel.EdgeLabelBuilder(content=" + this.content + ", fontSize=" + this.fontSize + ", fontColor=" + this.fontColor + ", width=" + this.width + ", height=" + this.height + ")";
            }
        }
    }
}

