/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.model.graph;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import vg.lib.model.graph.Attribute;
import vg.lib.model.graph.AttributedItem;
import vg.lib.model.record.VertexRecord;

public class Vertex
extends AttributedItem {
    protected List<Vertex> vertices = Lists.newArrayList();
    private VertexRecord linkToVertexRecord;

    public Vertex() {
    }

    public Vertex(List<Attribute> attributes) {
        this(attributes, null);
    }

    public Vertex(List<Attribute> attributes, VertexRecord vertexRecord) {
        super(attributes);
        this.setLinkToVertexRecord(vertexRecord);
    }

    public Vertex(AttributedItem attributedItem, VertexRecord vertexRecord) {
        super(attributedItem);
        this.setLinkToVertexRecord(vertexRecord);
    }

    public Vertex(AttributedItem attributedItem) {
        this(attributedItem, null);
    }

    protected boolean insertVertex(Vertex vertex, Vertex parent) {
        if (this == parent || parent == null) {
            return this.vertices.add(vertex);
        }
        for (Vertex bufVertex : this.vertices) {
            if (!bufVertex.insertVertex(vertex, parent)) continue;
            return true;
        }
        return false;
    }

    public Vertex cloneWithoutChildren() {
        return new Vertex(this, this.linkToVertexRecord);
    }

    public VertexRecord getLinkToVertexRecord() {
        return this.linkToVertexRecord;
    }

    public void setLinkToVertexRecord(VertexRecord linkToVertexRecord) {
        this.linkToVertexRecord = linkToVertexRecord;
    }

    public List<Vertex> getChildVertices() {
        return Collections.unmodifiableList(this.vertices);
    }

    public boolean hasChildren() {
        return this.vertices.size() != 0;
    }
}

