/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.model.graph;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import vg.lib.model.graph.Attribute;
import vg.lib.model.graph.Edge;
import vg.lib.model.graph.Vertex;
import vg.lib.model.record.GraphModelRecord;

public class Graph
extends Vertex
implements Cloneable {
    private static final int ANY_NEIGHBORHOOD = 0;
    private static final int SRC_NEIGHBORHOOD = 1;
    private static final int TRG_NEIGHBORHOOD = 2;
    private BiMap<Vertex, Integer> vertexToId = HashBiMap.create();
    private BiMap<Edge, Integer> edgeToId = HashBiMap.create();
    private int vertexCounter = 0;
    private int edgeCounter = 0;
    private GraphModelRecord linkToGraphModelRecord;
    private List<Edge> edges;
    private Set<Edge> outEdges;

    public Graph() {
        this(new ArrayList<Vertex>(), new ArrayList<Edge>(), new HashSet<Edge>(), null, null);
    }

    public Graph(Collection<Vertex> vertices, Collection<Edge> edges) {
        this(vertices, edges, null, null, null);
    }

    public Graph(Collection<Vertex> vertices, Collection<Edge> edges, Set<Edge> outEdges, List<Attribute> attributes) {
        this(vertices, edges, outEdges, attributes, null);
    }

    public Graph(Collection<Vertex> vertices, Collection<Edge> edges, Set<Edge> outEdges, List<Attribute> attributes, GraphModelRecord linkToGraphModelRecord) {
        this.vertices = Lists.newArrayList();
        this.edges = Lists.newArrayList();
        this.outEdges = new HashSet<Edge>();
        this.attributes = Lists.newArrayList();
        if (vertices != null) {
            for (Vertex vertex : vertices) {
                this.insertVertex(vertex, null);
            }
        }
        if (edges != null) {
            for (Edge edge : edges) {
                this.addEdge(edge);
            }
        }
        if (outEdges != null) {
            this.outEdges.addAll(outEdges);
        }
        this.addAttributes(attributes);
        this.setLinkToGraphRecord(linkToGraphModelRecord);
    }

    public Integer getIdByVertex(Vertex vertex) {
        return (Integer)this.vertexToId.get((Object)vertex);
    }

    public Vertex getVertexById(int id) {
        return (Vertex)this.vertexToId.inverse().get((Object)id);
    }

    public Integer getIdByEdge(Edge edge) {
        return (Integer)this.edgeToId.get((Object)edge);
    }

    public Edge getEdgeById(int id) {
        return (Edge)this.edgeToId.inverse().get((Object)id);
    }

    public GraphModelRecord getLinkToGraphRecord() {
        return this.linkToGraphModelRecord;
    }

    public void setLinkToGraphRecord(GraphModelRecord linkToGraphModelRecord) {
        this.linkToGraphModelRecord = linkToGraphModelRecord;
    }

    public void setVertexId(Vertex vertex, int id) {
        if (this.vertexToId.remove((Object)vertex) == null) {
            throw new IllegalArgumentException("Vertex was not found");
        }
        this.vertexToId.put((Object)vertex, (Object)id);
        if (id > this.vertexCounter) {
            this.vertexCounter = id + 1;
        }
    }

    public void setEdgeId(Edge edge, int id) {
        if (this.edgeToId.remove((Object)edge) == null) {
            throw new IllegalArgumentException("Edge was not found");
        }
        this.edgeToId.put((Object)edge, (Object)id);
        if (id > this.edgeCounter) {
            this.edgeCounter = id + 1;
        }
    }

    @Override
    public boolean insertVertex(Vertex vertex, Vertex parent) {
        this.vertexToId.put((Object)vertex, (Object)this.vertexCounter++);
        if (parent == null) {
            return this.vertices.add(vertex);
        }
        if (!super.insertVertex(vertex, parent)) {
            this.vertices.add(vertex);
        }
        return true;
    }

    public boolean addEdge(Edge edge) {
        this.edgeToId.put((Object)edge, (Object)this.edgeCounter++);
        return this.edges.add(edge);
    }

    public void addEdges(Collection<Edge> edges) {
        edges.forEach(this::addEdge);
    }

    public Collection<Vertex> getAllVertices() {
        return this.vertexToId.keySet();
    }

    public Set<String> getAllVertexAttributeNames(boolean onlyVisible) {
        HashSet attrNames = Sets.newHashSet();
        this.vertexToId.keySet().forEach(vertex -> vertex.getAttributes().forEach(attribute -> {
            if (!onlyVisible || attribute.isVisible()) {
                attrNames.add(attribute.getName());
            }
        }));
        return attrNames;
    }

    public Set<String> getAllEdgeAttributeNames(boolean onlyVisible) {
        HashSet attrNames = Sets.newHashSet();
        this.edgeToId.keySet().forEach(edge -> edge.getAttributes().forEach(attribute -> {
            if (!onlyVisible || attribute.isVisible()) {
                attrNames.add(attribute.getName());
            }
        }));
        return attrNames;
    }

    @Override
    public boolean isEmpty() {
        return this.vertices.isEmpty() && this.edges.isEmpty();
    }

    public Collection<Edge> getAllEdges() {
        return this.edges;
    }

    public Collection<Vertex> getSrcNeighborhoods(Vertex vertex) {
        return this.getNeighborhoods(vertex, 1);
    }

    public Collection<Vertex> getTrgNeighborhoods(Vertex vertex) {
        return this.getNeighborhoods(vertex, 2);
    }

    public Collection<Vertex> getAnyNeighborhoods(Vertex vertex) {
        return this.getNeighborhoods(vertex, 0);
    }

    public int getIncomingEdgeCount(Vertex vertex) {
        return this.getSrcNeighborhoods(vertex).size();
    }

    public int getOutgoingEdgeCount(Vertex vertex) {
        return this.getTrgNeighborhoods(vertex).size();
    }

    public int getEdgeCount(Vertex vertex) {
        return this.getAnyNeighborhoods(vertex).size();
    }

    public Set<Edge> getEdgeNeighborhoods(Vertex vertex) {
        return this.getEdgeNeighborhoods(Collections.singletonList(vertex));
    }

    public Set<Edge> getEdgeNeighborhoods(Collection<Vertex> vertices) {
        if (vertices == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<Edge> result = new LinkedHashSet<Edge>(this.edges.size());
        for (Edge edge : this.edges) {
            for (Vertex vertex : vertices) {
                if (edge.getSource().hashCode() == vertex.hashCode() && edge.getSource().equals(vertex)) {
                    result.add(edge);
                }
                if (edge.getTarget().hashCode() != vertex.hashCode() || !edge.getTarget().equals(vertex)) continue;
                result.add(edge);
            }
        }
        return result;
    }

    public boolean isAdjacentVertices(Vertex source, Vertex target) {
        return !this.findEdgesBetweenVertices(source, target).isEmpty();
    }

    public List<Edge> findEdgesBetweenVertices(Vertex source, Vertex target) {
        ArrayList result = Lists.newArrayList();
        for (Edge edge : this.edges) {
            if (edge.getSource().hashCode() == source.hashCode() && edge.getTarget().hashCode() == target.hashCode() && edge.getSource().equals(source) && edge.getTarget().equals(target)) {
                result.add(edge);
            }
            if (source.hashCode() == target.hashCode() || source.equals(target) || edge.getSource().hashCode() != target.hashCode() || edge.getTarget().hashCode() != source.hashCode() || !edge.getSource().equals(target) || !edge.getTarget().equals(source)) continue;
            result.add(edge);
        }
        return result;
    }

    @Override
    public Graph clone() {
        final Graph cloneGraph = new Graph();
        this.bfs(new GraphSearchListener(){

            @Override
            public void onVertex(Vertex vertex, Vertex parent) {
                Vertex cloneVertex = new Vertex(vertex.getAttributes(), vertex.getLinkToVertexRecord());
                Vertex cloneParent = parent;
                if (cloneParent != null) {
                    cloneParent = cloneGraph.getVertexById(Graph.this.getIdByVertex(parent));
                }
                cloneGraph.insertVertex(cloneVertex, cloneParent);
                cloneGraph.setVertexId(cloneVertex, Graph.this.getIdByVertex(vertex));
            }
        });
        for (Edge edge : this.edges) {
            Vertex srcCloneVertex = cloneGraph.getVertexById(this.getIdByVertex(edge.getSource()));
            Vertex trgCloneVertex = cloneGraph.getVertexById(this.getIdByVertex(edge.getTarget()));
            Edge cloneEdge = new Edge(srcCloneVertex, trgCloneVertex, edge.getAttributes(), edge.getLinkToEdgeRecord());
            cloneGraph.addEdge(cloneEdge);
            cloneGraph.setEdgeId(cloneEdge, this.getIdByEdge(edge));
        }
        cloneGraph.setLinkToGraphRecord(this.getLinkToGraphRecord());
        return cloneGraph;
    }

    public Graph getSubGraph(List<Vertex> vertices) {
        return new Graph(vertices, this.getEdgeNeighborhoods(vertices));
    }

    public void changeParent(Vertex srcParent, Vertex trgParent) {
        if (trgParent != null) {
            trgParent.getChildVertices().addAll(srcParent.getChildVertices());
        } else {
            this.vertices.addAll(srcParent.getChildVertices());
        }
        srcParent.getChildVertices().clear();
    }

    public void bfs(GraphSearchListener graphSearchListener) {
        ArrayDeque queue = Queues.newArrayDeque();
        queue.add(this);
        while (!queue.isEmpty()) {
            Vertex curr = (Vertex)queue.poll();
            for (Vertex vertex : curr.getChildVertices()) {
                queue.add(vertex);
                graphSearchListener.onVertex(vertex, curr == this ? null : curr);
            }
        }
        for (Edge edge : this.edges) {
            graphSearchListener.onEdge(edge);
        }
    }

    public void dfs(GraphSearchListener graphSearchListener) {
        ArrayList calls = Lists.newArrayList();
        for (Vertex vertex : this.vertices) {
            this.doDFS(graphSearchListener, vertex, null, calls);
        }
        for (Map.Entry call : calls) {
            graphSearchListener.onVertex((Vertex)call.getKey(), (Vertex)call.getValue());
        }
        for (Edge edge : Lists.newArrayList(this.edges)) {
            graphSearchListener.onEdge(edge);
        }
    }

    public void removeVertex(Vertex vertex, Vertex parent) {
        if (parent == null) {
            this.vertices.remove(vertex);
        }
        if (parent != null) {
            parent.getChildVertices().remove(vertex);
        }
        this.vertexToId.remove((Object)vertex);
        ArrayList newEdges = Lists.newArrayList();
        for (Edge edge : this.edges) {
            if (edge.getSource() != vertex && edge.getTarget() != vertex) {
                newEdges.add(edge);
                continue;
            }
            this.edgeToId.remove((Object)edge);
        }
        this.edges = newEdges;
    }

    private void doDFS(GraphSearchListener graphSearchListener, Vertex vertex, Vertex parent, List<Map.Entry<Vertex, Vertex>> calls) {
        for (Vertex child : vertex.getChildVertices()) {
            this.doDFS(graphSearchListener, child, vertex, calls);
        }
        calls.add(new AbstractMap.SimpleEntry<Vertex, Vertex>(vertex, parent));
    }

    private Collection<Vertex> getNeighborhoods(Vertex vertex, int neighborhoodType) {
        if (vertex == null) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        for (Edge edge : this.edges) {
            Vertex src = edge.getSource();
            Vertex trg = edge.getTarget();
            if ((neighborhoodType == 0 || neighborhoodType == 2) && vertex.hashCode() == src.hashCode() && vertex.equals(src)) {
                result.add(trg);
            }
            if (neighborhoodType != 0 && neighborhoodType != 1 || vertex.hashCode() != trg.hashCode() || !vertex.equals(trg)) continue;
            result.add(src);
        }
        return result;
    }

    public static abstract class GraphSearchListener {
        public void onEdge(Edge edge) {
        }

        public void onVertex(Vertex vertex, Vertex parent) {
        }
    }
}

