/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.model.graph;

import java.util.ArrayList;
import java.util.List;
import vg.lib.model.graph.Attribute;
import vg.lib.model.graph.AttributedItem;
import vg.lib.model.graph.Vertex;
import vg.lib.model.record.EdgeRecord;

public class Edge
extends AttributedItem {
    private Vertex source;
    private Vertex target;
    private EdgeRecord linkToEdgeRecord;

    public Edge(Vertex source, Vertex target) {
        this(source, target, new ArrayList<Attribute>());
    }

    public Edge(Vertex source, Vertex target, List<Attribute> attributes) {
        this(source, target, new AttributedItem(attributes), null);
    }

    public Edge(Vertex source, Vertex target, List<Attribute> attributes, EdgeRecord linkToEdgeRecord) {
        this(source, target, new AttributedItem(attributes), linkToEdgeRecord);
    }

    public Edge(Vertex source, Vertex target, AttributedItem item, EdgeRecord linkToEdgeRecord) {
        super(item);
        this.setNodes(source, target);
        this.setLinkToEdgeRecord(linkToEdgeRecord);
    }

    public EdgeRecord getLinkToEdgeRecord() {
        return this.linkToEdgeRecord;
    }

    public void setLinkToEdgeRecord(EdgeRecord linkToEdgeRecord) {
        this.linkToEdgeRecord = linkToEdgeRecord;
    }

    public Vertex getSource() {
        return this.source;
    }

    public Vertex getTarget() {
        return this.target;
    }

    public void setSource(Vertex source) {
        this.setNodes(source, this.target);
    }

    public void setTarget(Vertex target) {
        this.setNodes(this.source, target);
    }

    public void setNodes(Vertex source, Vertex target) {
        this.source = source;
        this.target = target;
    }
}

