/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.model.graph;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import vg.lib.common.TypeComparatorUtils;
import vg.lib.model.graph.Attribute;
import vg.lib.model.record.AttributeRecordType;

public class AttributedItem
implements Cloneable,
Serializable {
    protected List<Attribute> attributes;

    public AttributedItem() {
        this((List<Attribute>)null);
    }

    public AttributedItem(List<Attribute> attributes) {
        this.attributes = attributes != null ? attributes : Lists.newArrayList();
    }

    public AttributedItem(AttributedItem item) {
        this.attributes = item != null ? Lists.newArrayList(item.attributes) : Lists.newArrayList();
    }

    public void addAttributes(Collection<Attribute> attributes) {
        if (attributes == null || attributes.size() == 0) {
            return;
        }
        for (Attribute attr : attributes) {
            this.addAttribute(attr);
        }
    }

    public void removeAllAttributes(String key) {
        this.attributes.removeIf(attribute -> Objects.equals(key, attribute.getName()));
    }

    public boolean addAttribute(String key, String value) {
        return this.attributes.add(new Attribute(key, value, AttributeRecordType.STRING, true));
    }

    public Attribute addAttribute(String key, Object value, AttributeRecordType type) {
        return this.addAttribute(key, value, type, true);
    }

    public Attribute addInvisibleAttribute(String key, Object value, AttributeRecordType type) {
        return this.addAttribute(key, value, type, false);
    }

    public Attribute addAttribute(String key, Object value, AttributeRecordType type, boolean visible) {
        return this.addAttribute(new Attribute(key, value, type, visible));
    }

    public Attribute addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
        return attribute;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public Attribute getAttribute(String name) {
        return AttributedItem.getAttribute(name, this.attributes);
    }

    public static Attribute getAttribute(String name, Collection<Attribute> attributes) {
        return attributes.stream().filter(x -> Objects.equals(x.getName(), name)).findFirst().orElse(null);
    }

    public List<Attribute> getAttributes(String name) {
        return this.attributes.stream().filter(x -> x.getName().equals(name)).collect(Collectors.toList());
    }

    public boolean isEmpty() {
        return this.attributes.size() == 0;
    }

    public AttributedItem clone() {
        return new AttributedItem(this);
    }

    public static float getSimilarityPercentage(AttributedItem attributeItem1, AttributedItem attributeItem2, Map<String, Float> weights, boolean enableStrongComparison) {
        float currResult = 0.0f;
        float maxResult = 0.0f;
        for (Map.Entry<String, Float> weightEntry : weights.entrySet()) {
            float match = 0.0f;
            Attribute attribute1 = attributeItem1.getAttribute(weightEntry.getKey());
            Attribute attribute2 = attributeItem2.getAttribute(weightEntry.getKey());
            if (attribute1 == null && attribute2 == null) continue;
            if (attribute1 != null && attribute2 != null) {
                if (attribute1.isRealType() && attribute2.isRealType()) {
                    match = enableStrongComparison ? TypeComparatorUtils.strongDoubleComparison(attribute1.getRealValue(), attribute2.getRealValue()) : TypeComparatorUtils.flexibleDoubleComparison(attribute1.getRealValue(), attribute2.getRealValue());
                } else if (attribute1.isStringType() && attribute2.isStringType()) {
                    match = enableStrongComparison ? TypeComparatorUtils.strongStringComparison(attribute1.getStringValue(), attribute2.getStringValue()) : TypeComparatorUtils.flexibleStringComparison(attribute1.getStringValue(), attribute2.getStringValue());
                } else if (attribute1.isBooleanType() && attribute2.isBooleanType() && attribute1.getBooleanValue() == attribute2.getBooleanValue()) {
                    match = 1.0f;
                }
            }
            maxResult += weightEntry.getValue().floatValue();
            currResult += match * weightEntry.getValue().floatValue();
        }
        currResult = maxResult != 0.0f ? (currResult /= maxResult) : 1.0f;
        if (currResult > 1.0f) {
            currResult = 1.0f;
        }
        if (currResult < 0.0f) {
            currResult = 0.0f;
        }
        return currResult;
    }
}

