/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.model.graph;

import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.Validate;
import vg.lib.model.record.AttributeRecordType;

public class Attribute
implements Cloneable,
Serializable {
    private String name = null;
    private Object value = null;
    private boolean visible = true;
    private AttributeRecordType type = AttributeRecordType.STRING;

    public Attribute(String name, Object value, AttributeRecordType type, boolean visible) {
        Validate.notNull((Object)name);
        Validate.notNull((Object)value);
        this.setName(name);
        this.setValue(value.toString(), type);
        this.setVisible(visible);
    }

    public Attribute(String name, String value, boolean visible) {
        this(name, value, AttributeRecordType.STRING, visible);
    }

    public Attribute(String name, Integer value) {
        this(name, value, AttributeRecordType.INTEGER, true);
    }

    public Attribute(String name, Float value) {
        this(name, value, AttributeRecordType.DOUBLE, true);
    }

    public Attribute(String name, Double value) {
        this(name, value, AttributeRecordType.DOUBLE, true);
    }

    public Attribute(String name, Boolean value) {
        this(name, value, AttributeRecordType.BOOLEAN, true);
    }

    public Attribute(String name, UUID value) {
        this(name, value, AttributeRecordType.UUID, true);
    }

    public Attribute(Attribute attribute) {
        this(attribute.name, attribute.value, attribute.getType(), attribute.isVisible());
    }

    public String getName() {
        return this.name;
    }

    public AttributeRecordType getType() {
        return this.type;
    }

    public String getStringValue() {
        return this.value.toString();
    }

    public Integer getIntegerValue() {
        if (this.type == AttributeRecordType.INTEGER) {
            return (Integer)this.value;
        }
        throw new RuntimeException("Value type isn't integer");
    }

    public Boolean getBooleanValue() {
        if (this.type == AttributeRecordType.BOOLEAN) {
            return (Boolean)this.value;
        }
        throw new RuntimeException("Value type isn't boolean");
    }

    public Double getDoubleValue() {
        if (this.type == AttributeRecordType.DOUBLE) {
            return (Double)this.value;
        }
        throw new RuntimeException("Value type isn't double");
    }

    public Double getRealValue() {
        if (this.isIntegerType()) {
            return ((Integer)this.value).doubleValue();
        }
        if (this.isDoubleType()) {
            return (Double)this.value;
        }
        throw new RuntimeException("Value type isn't real");
    }

    public UUID getUUIDValue() {
        if (this.type == AttributeRecordType.UUID) {
            return (UUID)this.value;
        }
        throw new RuntimeException("Type of value should be uuid.");
    }

    public boolean isStringType() {
        return this.getType() == AttributeRecordType.STRING;
    }

    public boolean isBooleanType() {
        return this.getType() == AttributeRecordType.BOOLEAN;
    }

    public boolean isIntegerType() {
        return this.getType() == AttributeRecordType.INTEGER;
    }

    public boolean isDoubleType() {
        return this.getType() == AttributeRecordType.DOUBLE;
    }

    public boolean isUUIDType() {
        return this.getType() == AttributeRecordType.UUID;
    }

    public void setName(String name) {
        Validate.notNull((Object)name);
        this.name = name;
    }

    public boolean isRealType() {
        return this.isDoubleType() || this.isIntegerType();
    }

    public void setStringValue(String value) {
        Validate.notNull((Object)value);
        this.type = AttributeRecordType.STRING;
        this.value = value;
    }

    public void setBooleanValue(Boolean value) {
        Validate.notNull((Object)value);
        this.type = AttributeRecordType.BOOLEAN;
        this.value = value;
    }

    public void setIntegerValue(String value) {
        Validate.notNull((Object)value);
        this.type = AttributeRecordType.INTEGER;
        this.value = Integer.parseInt(value);
    }

    public void setIntegerValue(Integer value) {
        Validate.notNull((Object)value);
        this.type = AttributeRecordType.INTEGER;
        this.value = value;
    }

    public void setUUIDValue(UUID value) {
        Validate.notNull((Object)value);
        this.type = AttributeRecordType.UUID;
        this.value = value;
    }

    public void setDoubleValue(Double value) {
        Validate.notNull((Object)value);
        this.type = AttributeRecordType.DOUBLE;
        this.value = value;
    }

    public void setValue(String strValue, AttributeRecordType type) {
        switch (type) {
            case BOOLEAN: {
                this.setBooleanValue(Boolean.valueOf(strValue));
                break;
            }
            case DOUBLE: {
                this.setDoubleValue(Double.valueOf(strValue));
                break;
            }
            case INTEGER: {
                this.setIntegerValue(Integer.valueOf(strValue));
                break;
            }
            case STRING: {
                this.setStringValue(String.valueOf(strValue));
                break;
            }
            case UUID: {
                this.setUUIDValue(UUID.fromString(strValue));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown attribute type");
            }
        }
    }

    public Double castValueToReal() {
        if (this.isRealType()) {
            return this.getRealValue();
        }
        try {
            return Double.valueOf(this.getStringValue());
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public Attribute clone() {
        return new Attribute(this);
    }

    public String toString() {
        return "name = " + this.name + ", value = " + this.value + ", visible = " + this.visible;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        return Objects.equals(this.name, attribute.name);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }
}

