/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.random;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vg.lib.common.JsonUtils;
import vg.lib.layout.LayoutResult;
import vg.lib.model.graphics.EdgeGraphics;
import vg.lib.model.graphics.VertexGraphics;
import vg.lib.model.record.AttributeOwnerType;
import vg.lib.model.record.AttributeRecord;
import vg.lib.model.record.AttributeRecordType;
import vg.lib.model.record.VertexRecord;
import vg.lib.storage.GraphStorage;
import vg.lib.view.GraphViewUtils;

public class RandomLayout {
    private static final Logger log = LoggerFactory.getLogger(RandomLayout.class);
    private final GraphStorage graphStorage;
    private static final double PADDING_FACTOR = 1.25;
    private static final double JITTER_FACTOR = 0.2;
    private static final double SPARSENESS_FACTOR = 2.0;
    private static final double EDGE_OFFSET_FACTOR = 0.2;

    public RandomLayout(GraphStorage graphStorage) {
        this.graphStorage = graphStorage;
    }

    public void execute() {
        HashMap portIdToPos = new HashMap();
        HashMap portIdToSize = new HashMap();
        ArrayList<Integer> parentIds = new ArrayList<Integer>();
        int graphModelId = this.graphStorage.findGraphModelRecords().get(0).getId();
        this.graphStorage.dfs(graphModelId, -1, graphModelRecord -> {}, graphModelRecord -> this.executePlainLayout(graphModelId, -1, this.graphStorage, portIdToPos, portIdToSize), vertexRecord -> {
            if (!vertexRecord.isComposite()) {
                return;
            }
            parentIds.add(vertexRecord.getId());
        }, vertexRecord -> {
            if (!vertexRecord.isComposite()) {
                return;
            }
            this.executePlainLayout(graphModelId, vertexRecord.getId(), this.graphStorage, portIdToPos, portIdToSize);
        }, edgeRecord -> {});
        parentIds.forEach(parentId -> {
            List<AttributeRecord> parentAttributeRecords = this.graphStorage.findAttributeRecordsByOwner(graphModelId, (int)parentId, AttributeOwnerType.VERTEX);
            VertexGraphics parentVertexGraphics = GraphStorage.findVertexGraphicsAttributeRecord(parentAttributeRecords).map(it -> JsonUtils.fromJson(it.getStringValue(), VertexGraphics.class)).orElseThrow(IllegalArgumentException::new);
            Rectangle parentBoundingBox = parentVertexGraphics.getBoundingBox();
            int parentX = parentBoundingBox.x;
            int parentY = parentBoundingBox.y;
            int border = parentVertexGraphics.getBorder();
            this.graphStorage.findVertexRecordsByParentId(graphModelId, (int)parentId).forEach(vertexRecord -> {
                VertexGraphics vertexGraphics = this.graphStorage.findAttributeRecordByOwnerAndName(graphModelId, vertexRecord.getId(), AttributeOwnerType.VERTEX, "system_vertex_graphics").map(it -> JsonUtils.fromJson(it.getStringValue(), VertexGraphics.class)).orElseThrow(IllegalArgumentException::new);
                Rectangle vertexBoundingBox = vertexGraphics.getBoundingBox();
                int vertexX = vertexBoundingBox.x + parentX + border;
                int vertexY = vertexBoundingBox.y + parentY + border;
                vertexBoundingBox.x = vertexX;
                vertexBoundingBox.y = vertexY;
                this.graphStorage.createOrUpdateVertexAttribute(graphModelId, vertexRecord.getId(), "system_vertex_graphics", JsonUtils.toJson(vertexGraphics), AttributeRecordType.JSON, false);
            });
            this.graphStorage.findEdgeRecordsByParentId(graphModelId, (int)parentId, false).forEach(edgeRecord -> {
                EdgeGraphics edgeGraphics = this.graphStorage.findAttributeRecordByOwnerAndName(graphModelId, edgeRecord.getId(), AttributeOwnerType.EDGE, "system_edge_graphics").map(it -> JsonUtils.fromJson(it.getStringValue(), EdgeGraphics.class)).orElseThrow(IllegalArgumentException::new);
                edgeGraphics.getPoints().forEach(point -> {
                    point.x = point.x + parentX + border;
                    point.y = point.y + parentY + border;
                });
                edgeGraphics.getBoundingBox().x = edgeGraphics.getBoundingBox().x + parentX + border;
                edgeGraphics.getBoundingBox().y = edgeGraphics.getBoundingBox().y + parentY + border;
                this.graphStorage.createOrUpdateEdgeAttribute(graphModelId, edgeRecord.getId(), "system_edge_graphics", JsonUtils.toJson(edgeGraphics), AttributeRecordType.JSON, false);
            });
        });
    }

    private void executePlainLayout(int graphModelId, int parentId, GraphStorage graphStorage, Map<UUID, Point> portIdToPos, Map<UUID, Point> portIdToSize) {
        ArrayList<UUID> vertexIds = new ArrayList<UUID>();
        ArrayList<UUID> inputPortIds = new ArrayList<UUID>();
        ArrayList<UUID> outputPortIds = new ArrayList<UUID>();
        LinkedHashMap<UUID, Point> vertexIdToSize = new LinkedHashMap<UUID, Point>();
        LinkedHashMap vertexIdToFragmentTextSize = new LinkedHashMap();
        LinkedHashMap<UUID, String> vertexIdToName = new LinkedHashMap<UUID, String>();
        HashMap<Integer, UUID> vertexIdToGlobalId = new HashMap<Integer, UUID>();
        HashMap<UUID, Integer> vertexGlobalIdToId = new HashMap<UUID, Integer>();
        HashSet portIds = new HashSet();
        graphStorage.findVertexRecordsByParentId(graphModelId, parentId).forEach(vertexRecord -> {
            boolean isOutputPort;
            vertexIdToGlobalId.put(vertexRecord.getId(), vertexRecord.getGlobalId());
            vertexGlobalIdToId.put(vertexRecord.getGlobalId(), vertexRecord.getId());
            vertexIds.add(vertexRecord.getGlobalId());
            List<AttributeRecord> vertexAttributeRecords = graphStorage.findAttributeRecordsByOwner(graphModelId, vertexRecord.getId(), AttributeOwnerType.VERTEX);
            Integer vertexType = GraphStorage.findVertexTypeAttributeRecord(vertexAttributeRecords).map(AttributeRecord::getIntegerValue).orElseThrow(IllegalArgumentException::new);
            boolean isPort = (vertexType & 0x80) > 0;
            boolean bl = isOutputPort = (vertexType & 0x10) > 0;
            if (isPort) {
                portIds.add(vertexRecord.getGlobalId());
                if (isOutputPort) {
                    outputPortIds.add(vertexRecord.getGlobalId());
                } else {
                    inputPortIds.add(vertexRecord.getGlobalId());
                }
            }
            VertexGraphics vertexGraphics = GraphStorage.findVertexGraphicsAttributeRecord(vertexAttributeRecords).map(it -> JsonUtils.fromJson(it.getStringValue(), VertexGraphics.class)).orElseThrow(IllegalArgumentException::new);
            Rectangle vertexBoundingBox = vertexGraphics.getBoundingBox();
            vertexIdToSize.put(vertexRecord.getGlobalId(), new Point(vertexBoundingBox.width, vertexBoundingBox.height));
            vertexIdToName.put(vertexRecord.getGlobalId(), "");
        });
        VertexRecord parentVertexRecord = graphStorage.findVertexRecord(graphModelId, parentId).orElse(null);
        boolean isVertexWithPorts = false;
        if (parentVertexRecord != null) {
            boolean containsNestedGraph;
            List<AttributeRecord> parentAttributeRecords = graphStorage.findAttributeRecordsByOwner(graphModelId, parentId, AttributeOwnerType.VERTEX);
            Integer parentType = GraphStorage.findVertexTypeAttributeRecord(parentAttributeRecords).map(AttributeRecord::getIntegerValue).orElseThrow(IllegalArgumentException::new);
            boolean containsPorts = (parentType & 2) > 0;
            boolean bl = containsNestedGraph = (parentType & 4) > 0;
            if (containsPorts && !containsNestedGraph) {
                VertexGraphics parentVertexGraphics = GraphStorage.findVertexGraphicsAttributeRecord(parentAttributeRecords).map(it -> JsonUtils.fromJson(it.getStringValue(), VertexGraphics.class)).orElseThrow(IllegalArgumentException::new);
                isVertexWithPorts = true;
                int width = parentVertexGraphics.getLabel().getWidth();
                int height = parentVertexGraphics.getLabel().getHeight();
                vertexIdToGlobalId.put(parentVertexRecord.getId(), parentVertexRecord.getGlobalId());
                vertexGlobalIdToId.put(parentVertexRecord.getGlobalId(), parentVertexRecord.getId());
                vertexIds.add(parentVertexRecord.getGlobalId());
                vertexIdToSize.put(parentVertexRecord.getGlobalId(), new Point(width, height));
                vertexIdToName.put(parentVertexRecord.getGlobalId(), "");
            }
        }
        LinkedHashMap<UUID, Map.Entry<UUID, UUID>> edgeToNodes = new LinkedHashMap<UUID, Map.Entry<UUID, UUID>>();
        LinkedHashMap<UUID, UUID> edgeToSrcPort = new LinkedHashMap<UUID, UUID>();
        LinkedHashMap<UUID, UUID> edgeToTrgPort = new LinkedHashMap<UUID, UUID>();
        HashMap edgeGlobalIdToId = new HashMap();
        graphStorage.findEdgeRecordsByParentId(graphModelId, parentId, false).forEach(edgeRecord -> {
            edgeGlobalIdToId.put(edgeRecord.getGlobalId(), edgeRecord.getId());
            List<AttributeRecord> edgeAttributeRecords = graphStorage.findAttributeRecordsByOwner(graphModelId, edgeRecord.getId(), AttributeOwnerType.EDGE);
            UUID sourcePortGlobalId = GraphStorage.findEdgeStorageSourcePortGlobalIdAttributeRecord(edgeAttributeRecords).map(AttributeRecord::getUUIDValue).orElse(null);
            UUID targetPortGlobalId = GraphStorage.findEdgeStorageTargetPortGlobalIdAttributeRecord(edgeAttributeRecords).map(AttributeRecord::getUUIDValue).orElse(null);
            if (sourcePortGlobalId != null) {
                edgeToSrcPort.put(edgeRecord.getGlobalId(), sourcePortGlobalId);
            }
            if (targetPortGlobalId != null) {
                edgeToTrgPort.put(edgeRecord.getGlobalId(), targetPortGlobalId);
            }
            UUID sourceId = (UUID)vertexIdToGlobalId.get(edgeRecord.getSourceId());
            UUID targetId = (UUID)vertexIdToGlobalId.get(edgeRecord.getTargetId());
            if (sourceId == null) {
                throw new IllegalArgumentException("Source id is null");
            }
            if (targetId == null) {
                throw new IllegalArgumentException("Target id is null");
            }
            edgeToNodes.put(edgeRecord.getGlobalId(), new AbstractMap.SimpleEntry<UUID, UUID>(sourceId, targetId));
        });
        log.debug("Prepare data and execute hierarchical layout, number of vertices {}, number of edges {}.", (Object)vertexIds.size(), (Object)edgeToNodes.size());
        LayoutResult result = this.doExecutePlainLayout(vertexIds, inputPortIds, outputPortIds, edgeToNodes, edgeToSrcPort, edgeToTrgPort, portIdToPos, portIdToSize, vertexIdToName, vertexIdToSize);
        int parentLabelWidth = 0;
        if (parentVertexRecord != null) {
            VertexGraphics parentVertexGraphics = graphStorage.findAttributeRecordByOwnerAndName(graphModelId, parentId, AttributeOwnerType.VERTEX, "system_vertex_graphics").map(it -> JsonUtils.fromJson(it.getStringValue(), VertexGraphics.class)).orElseThrow(IllegalArgumentException::new);
            parentVertexGraphics.setShapeType(VertexGraphics.ShapeType.RECTANGLE);
            if (!isVertexWithPorts) {
                parentVertexGraphics.getLabel().setAlignment(VertexGraphics.LabelAlignment.LEFT);
            }
            int parentWidth = result.getBoundingBoxSize().width + 2 * parentVertexGraphics.getBorder() + parentLabelWidth;
            int parentHeight = result.getBoundingBoxSize().height + 2 * parentVertexGraphics.getBorder();
            parentVertexGraphics.getBoundingBox().width = parentWidth;
            parentVertexGraphics.getBoundingBox().height = parentHeight;
            graphStorage.createOrUpdateVertexAttribute(graphModelId, parentId, "system_vertex_graphics", JsonUtils.toJson(parentVertexGraphics), AttributeRecordType.JSON, false);
        }
        for (LayoutResult.Vertex vertex : result.getVertices().values()) {
            int x = vertex.position().x;
            int y = vertex.position().y;
            Integer vertexId = (Integer)vertexGlobalIdToId.get(vertex.globalId());
            VertexGraphics vertexGraphics = graphStorage.findAttributeRecordByOwnerAndName(graphModelId, vertexId, AttributeOwnerType.VERTEX, "system_vertex_graphics").map(it -> JsonUtils.fromJson(it.getStringValue(), VertexGraphics.class)).orElseThrow(IllegalArgumentException::new);
            if (isVertexWithPorts && vertexId == parentId) {
                int vertexLabelWidth;
                int border = vertexGraphics.getBorder();
                int width = result.getBoundingBoxSize().width + border * 2;
                int offsetX = (width - (vertexLabelWidth = vertexGraphics.getLabel().getWidth())) / 2;
                if (offsetX < border) {
                    offsetX = border;
                }
                int offsetY = vertex.position().y;
                vertexGraphics.getLabelOffset().x = offsetX;
                vertexGraphics.getLabelOffset().y = offsetY;
            } else {
                vertexGraphics.getBoundingBox().x = x + parentLabelWidth;
                vertexGraphics.getBoundingBox().y = y;
            }
            graphStorage.createOrUpdateVertexAttribute(graphModelId, vertexId, "system_vertex_graphics", JsonUtils.toJson(vertexGraphics), AttributeRecordType.JSON, false);
            if (!portIds.contains(vertex.globalId())) continue;
            Rectangle vertexBoundingBox = vertexGraphics.getBoundingBox();
            Point pos = new Point(vertexBoundingBox.x, vertexBoundingBox.y);
            Point size = new Point(vertexBoundingBox.width, vertexBoundingBox.height);
            portIdToPos.put(vertex.globalId(), pos);
            portIdToSize.put(vertex.globalId(), size);
        }
        for (LayoutResult.Edge edge : result.getEdges().values()) {
            LayoutResult.Vertex sourceVertex = result.getVertices().get(edge.sourceGlobalId());
            LayoutResult.Vertex targetVertex = result.getVertices().get(edge.targetGlobalId());
            Integer edgeId = (Integer)edgeGlobalIdToId.get(edge.globalId());
            EdgeGraphics edgeGraphics = graphStorage.findAttributeRecordByOwnerAndName(graphModelId, edgeId, AttributeOwnerType.EDGE, "system_edge_graphics").map(it -> JsonUtils.fromJson(it.getStringValue(), EdgeGraphics.class)).orElseThrow(IllegalArgumentException::new);
            Integer srcVertexId = (Integer)vertexGlobalIdToId.get(edge.sourceGlobalId());
            VertexGraphics srcVertexGraphics = graphStorage.findAttributeRecordByOwnerAndName(graphModelId, srcVertexId, AttributeOwnerType.VERTEX, "system_vertex_graphics").map(it -> JsonUtils.fromJson(it.getStringValue(), VertexGraphics.class)).orElseThrow(IllegalArgumentException::new);
            Integer trgVertexId = (Integer)vertexGlobalIdToId.get(edge.targetGlobalId());
            VertexGraphics trgVertexGraphics = graphStorage.findAttributeRecordByOwnerAndName(graphModelId, trgVertexId, AttributeOwnerType.VERTEX, "system_vertex_graphics").map(it -> JsonUtils.fromJson(it.getStringValue(), VertexGraphics.class)).orElseThrow(IllegalArgumentException::new);
            edgeGraphics.setLineType(EdgeGraphics.LineType.SOLID);
            edgeGraphics.setPoints(this.handleEdge(edge, sourceVertex, targetVertex, srcVertexGraphics, trgVertexGraphics));
            GraphViewUtils.EdgeLabelPlacement edgeBoundingBoxAndLabelOffset = GraphViewUtils.calculateEdgeBoundingBoxAndLabelOffset(edgeGraphics.getPoints(), edgeGraphics.getLabel().getWidth(), edgeGraphics.getLabel().getHeight());
            edgeGraphics.setBoundingBox(edgeBoundingBoxAndLabelOffset.boundingBox());
            edgeGraphics.setLabelOffset(edgeBoundingBoxAndLabelOffset.labelOffset());
            graphStorage.createOrUpdateEdgeAttribute(graphModelId, edgeId, "system_edge_graphics", JsonUtils.toJson(edgeGraphics), AttributeRecordType.JSON, false);
        }
    }

    private LayoutResult doExecutePlainLayout(List<UUID> vertices, List<UUID> inputPortIds, List<UUID> outputPortIds, Map<UUID, Map.Entry<UUID, UUID>> edgeToNodes, Map<UUID, UUID> edgeToSrcPort, Map<UUID, UUID> edgeToTrgPort, Map<UUID, Point> portIdToPos, Map<UUID, Point> portIdToSize, Map<UUID, String> vertexIdToName, Map<UUID, Point> vertexIdToSize) {
        LinkedHashMap<UUID, LayoutResult.Vertex> vertexMap = new LinkedHashMap<UUID, LayoutResult.Vertex>();
        LinkedHashMap<UUID, LayoutResult.Edge> edgeMap = new LinkedHashMap<UUID, LayoutResult.Edge>();
        int maxWidth = 0;
        int maxHeight = 0;
        for (UUID v : vertices) {
            Point size = vertexIdToSize.get(v);
            if (size == null) continue;
            maxWidth = Math.max(maxWidth, size.x);
            maxHeight = Math.max(maxHeight, size.y);
        }
        if (maxWidth == 0) {
            maxWidth = 100;
        }
        if (maxHeight == 0) {
            maxHeight = 60;
        }
        int cellWidth = (int)Math.ceil((double)maxWidth * 1.25);
        int cellHeight = (int)Math.ceil((double)maxHeight * 1.25);
        int jitterX = (int)((double)cellWidth * 0.2);
        int jitterY = (int)((double)cellHeight * 0.2);
        Random rnd = new Random();
        int n = vertices.size();
        int sqrtN = (int)Math.ceil(Math.sqrt(n));
        int cols = (int)Math.ceil((double)sqrtN * 2.0);
        int rows = (int)Math.ceil((double)sqrtN * 2.0);
        ArrayList<Point> cells = new ArrayList<Point>(rows * cols);
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                int baseX = (c * 2 + 1) * cellWidth;
                int baseY = (r * 2 + 1) * cellHeight;
                cells.add(new Point(baseX, baseY));
            }
        }
        Collections.shuffle(cells, rnd);
        for (int i = 0; i < vertices.size(); ++i) {
            UUID v = vertices.get(i);
            Point base = (Point)cells.get(i);
            int x = base.x + rnd.nextInt(jitterX + 1);
            int y = base.y + rnd.nextInt(jitterY + 1);
            Point position = new Point(x, y);
            Point size = vertexIdToSize.getOrDefault(v, new Point(maxWidth, maxHeight));
            Dimension dimension = new Dimension(size.x, size.y);
            vertexMap.put(v, new LayoutResult.Vertex(v, position, dimension));
        }
        for (Map.Entry<UUID, Map.Entry<UUID, UUID>> entry : edgeToNodes.entrySet()) {
            int offsetY;
            int offsetX;
            int offsetRange;
            UUID edgeId = entry.getKey();
            UUID src = entry.getValue().getKey();
            UUID trg = entry.getValue().getValue();
            LayoutResult.Vertex srcV = vertexMap.get(src);
            LayoutResult.Vertex trgV = vertexMap.get(trg);
            if (srcV == null || trgV == null) continue;
            CellsCoords anchor = this.pickCellsCoords(srcV, trgV, cellWidth, cellHeight);
            if (anchor == null) {
                offsetRange = (int)((double)Math.min(cellWidth, cellHeight) * 0.2);
                offsetX = rnd.nextInt(offsetRange * 2 + 1) - offsetRange;
                offsetY = rnd.nextInt(offsetRange * 2 + 1) - offsetRange;
                Point srcCenter = new Point(srcV.position().x + srcV.size().width / 2, srcV.position().y + srcV.size().height / 2);
                Point trgCenter = new Point(trgV.position().x + trgV.size().width / 2, trgV.position().y + trgV.size().height / 2);
                Point mid = new Point((srcCenter.x + trgCenter.x) / 2 + offsetX, (srcCenter.y + trgCenter.y) / 2 + offsetY);
                edgeMap.put(edgeId, new LayoutResult.Edge(edgeId, src, trg, new Point[]{mid}));
                continue;
            }
            offsetRange = (int)((double)Math.min(cellWidth, cellHeight) * 0.2);
            offsetX = rnd.nextInt(offsetRange * 2 + 1) - offsetRange;
            offsetY = rnd.nextInt(offsetRange * 2 + 1) - offsetRange;
            Point srcAnchor = new Point(anchor.srcCol() * cellWidth + cellWidth / 2 + offsetX, anchor.srcRow() * cellHeight + cellHeight / 2 + offsetY);
            Point trgAnchor = new Point(anchor.trgCol() * cellWidth + cellWidth / 2 + offsetX, anchor.trgRow() * cellHeight + cellHeight / 2 + offsetY);
            if (anchor.srcRow() == anchor.trgRow() || anchor.srcCol() == anchor.trgCol()) {
                edgeMap.put(edgeId, new LayoutResult.Edge(edgeId, src, trg, new Point[]{srcAnchor, trgAnchor}));
                continue;
            }
            Point bend = new Point(trgAnchor.x, srcAnchor.y);
            edgeMap.put(edgeId, new LayoutResult.Edge(edgeId, src, trg, new Point[]{srcAnchor, bend, trgAnchor}));
        }
        int width = (cols * 2 + 1) * cellWidth;
        int height = (rows * 2 + 1) * cellHeight;
        return LayoutResult.builder().vertices(vertexMap).edges(edgeMap).boundingBoxSize(new Dimension(width, height)).build();
    }

    private CellsCoords pickCellsCoords(LayoutResult.Vertex src, LayoutResult.Vertex trg, int cellWidth, int cellHeight) {
        int dx = Math.abs(src.position().x / cellWidth - trg.position().x / cellWidth);
        int dy = Math.abs(src.position().y / cellHeight - trg.position().y / cellHeight);
        if (dx <= 2 && dy <= 2) {
            return null;
        }
        int srcCol = src.position().x / cellWidth;
        int srcRow = src.position().y / cellHeight;
        int trgCol = trg.position().x / cellWidth;
        int trgRow = trg.position().y / cellHeight;
        if (dx == 0) {
            if (src.position().y < trg.position().y) {
                return new CellsCoords(srcCol + 1, srcRow + 1, trgCol + 1, trgRow - 1);
            }
            return new CellsCoords(srcCol - 1, srcRow - 1, trgCol - 1, trgRow + 1);
        }
        if (dy == 0) {
            if (src.position().x < trg.position().x) {
                return new CellsCoords(srcCol + 1, srcRow - 1, trgCol - 1, trgRow - 1);
            }
            return new CellsCoords(srcCol - 1, srcRow + 1, trgCol + 1, trgRow + 1);
        }
        if (trgCol > srcCol && trgRow < srcRow) {
            return new CellsCoords(srcCol + 1, srcRow - 1, trgCol - 1, trgRow + 1);
        }
        if (trgCol < srcCol && trgRow < srcRow) {
            return new CellsCoords(srcCol - 1, srcRow - 1, trgCol + 1, trgRow + 1);
        }
        if (trgCol > srcCol && trgRow > srcRow) {
            return new CellsCoords(srcCol + 1, srcRow + 1, trgCol - 1, trgRow - 1);
        }
        return new CellsCoords(srcCol - 1, srcRow + 1, trgCol + 1, trgRow - 1);
    }

    private List<Point> handleEdge(LayoutResult.Edge edge, LayoutResult.Vertex sourceVertex, LayoutResult.Vertex targetVertex, VertexGraphics srcVertexGraphics, VertexGraphics trgVertexGraphics) {
        ArrayList<Point> points = new ArrayList<Point>();
        for (Point point : edge.points()) {
            points.add(point);
        }
        Point startPoint = GraphViewUtils.findPointOnVertexShape(GraphViewUtils.DirectionType.FROM_CENTER, srcVertexGraphics.getShapeType(), srcVertexGraphics.getBoundingBox(), (Point)points.get(0));
        Point endPoint = GraphViewUtils.findPointOnVertexShape(GraphViewUtils.DirectionType.FROM_CENTER, trgVertexGraphics.getShapeType(), trgVertexGraphics.getBoundingBox(), (Point)points.get(points.size() - 1));
        points.add(0, startPoint);
        points.add(endPoint);
        return points;
    }

    private record CellsCoords(int srcCol, int srcRow, int trgCol, int trgRow) {
    }
}

