/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.step3.legacy.operation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import vg.lib.layout.hierarchical.data.Direction;
import vg.lib.layout.hierarchical.data.HierarchicalBackwardEdge;
import vg.lib.layout.hierarchical.data.HierarchicalEdge;
import vg.lib.layout.hierarchical.data.HierarchicalGraph;
import vg.lib.layout.hierarchical.data.HierarchicalLongEdge;
import vg.lib.layout.hierarchical.data.HierarchicalVertex;
import vg.lib.layout.hierarchical.data.VertexType;
import vg.lib.operation.Procedure;

public class PrepareBackwardEdgesToAlignmentProcedure
implements Procedure {
    private final HierarchicalGraph graph;

    public PrepareBackwardEdgesToAlignmentProcedure(HierarchicalGraph graph) {
        this.graph = graph;
    }

    @Override
    public void execute() {
        for (Map.Entry<Integer, TreeMap<Integer, List<HierarchicalVertex>>> detailedGroup : this.graph.getDetailedGroups().entrySet()) {
            int index = 0;
            Shift[] shifts = new Shift[detailedGroup.getValue().size() + 5];
            ArrayList candidates = new ArrayList();
            for (Map.Entry<Integer, List<HierarchicalVertex>> detailedGroupEntry : detailedGroup.getValue().entrySet()) {
                List rowCandidates = detailedGroupEntry.getValue().stream().map(this::handleVertex).filter(Objects::nonNull).collect(Collectors.toList());
                for (PossibleCandidate rowCandidate : rowCandidates) {
                    int bottomMax;
                    int topMax = rowCandidate.topMax();
                    if (topMax > 0) {
                        HierarchicalVertex comp = rowCandidate.peekAnyInputCompanion();
                        Validate.notNull((Object)comp);
                        Shift shift = shifts[comp.getLevel()];
                        if (shift == null || shift.amount < topMax) {
                            shifts[comp.getLevel()] = new Shift(comp, topMax);
                        }
                    }
                    if ((bottomMax = rowCandidate.bottomMax()) <= 0) continue;
                    HierarchicalVertex comp = rowCandidate.peekAnyOutputCompanion();
                    Validate.notNull((Object)comp);
                    Shift shift = shifts[comp.getLevel()];
                    if (shift != null && shift.amount >= bottomMax) continue;
                    shifts[comp.getLevel()] = new Shift(comp, bottomMax);
                }
                candidates.addAll(rowCandidates);
                ++index;
            }
            for (PossibleCandidate c : candidates) {
                c.addFakes(this.graph);
            }
            for (Iterator<Map.Entry<Integer, List<HierarchicalVertex>>> iterator : shifts) {
                if (iterator == null) continue;
                HierarchicalVertex companion = ((Shift)((Object)iterator)).companion;
                this.graph.extendRows(companion.getLevel(), companion.getGroupId(), ((Shift)((Object)iterator)).amount, Direction.BOTTOM);
            }
            for (PossibleCandidate c : candidates) {
                c.setupCorrectRowIndexForCompanions(this.graph);
            }
            this.graph.reCalculateRoots();
            List longEdges = this.graph.getEdges().values().stream().filter(HierarchicalEdge::isLongEdge).collect(Collectors.toList());
            for (HierarchicalEdge longEdge : longEdges) {
                this.graph.convertToLongEdge(longEdge);
            }
            this.graph.reCalculateVertexIndices();
            this.graph.getBackwardEdges().values().stream().forEach(backwardEdge -> {
                this.graph.getVerticesByIds(backwardEdge.getTrgCompanionVertex().getOutputVertexIds()).forEach(v -> {
                    v.getSize().y = this.graph.companionVertexSize.y;
                });
                this.graph.getVerticesByIds(backwardEdge.getSrcCompanionVertex().getInputVertexIds()).forEach(v -> {
                    v.getSize().y = this.graph.companionVertexSize.y;
                });
            });
        }
        int prevGroupOrder = 0;
        for (Map.Entry<Integer, TreeMap<Integer, List<HierarchicalVertex>>> detailedGroupEntry : this.graph.getDetailedGroups().entrySet()) {
            for (Map.Entry<Integer, List<HierarchicalVertex>> levelEntry : detailedGroupEntry.getValue().entrySet()) {
                HierarchicalVertex.setupDefaultOrderForElements(levelEntry.getValue());
            }
            prevGroupOrder = HierarchicalGraph.shiftOrderForDetailedGroup(prevGroupOrder, (Map<Integer, List<HierarchicalVertex>>)detailedGroupEntry.getValue()) + 1;
        }
    }

    private PossibleCandidate handleVertex(HierarchicalVertex vertex) {
        if (vertex.isFakeVertex()) {
            return null;
        }
        ArrayList<HierarchicalBackwardEdge> outputLeftVertices = new ArrayList<HierarchicalBackwardEdge>();
        ArrayList<HierarchicalBackwardEdge> outputRightVertices = new ArrayList<HierarchicalBackwardEdge>();
        List<HierarchicalVertex> outputVertices = this.graph.getVerticesByIds(vertex.getOutputVertexIds());
        for (HierarchicalVertex outputVertex : outputVertices) {
            if (!outputVertex.isCompanionVertex()) continue;
            UUID backwardEdgeId = outputVertex.getBackEdgeId();
            HierarchicalBackwardEdge backwardEdge = this.graph.getBackwardEdges().get(backwardEdgeId);
            HierarchicalVertex backwardVertex = this.graph.getVertexById(backwardEdge.getSrcCompanionInputVertex());
            if (backwardVertex.getOrder() > vertex.getOrder()) {
                outputRightVertices.add(backwardEdge);
                continue;
            }
            outputLeftVertices.add(backwardEdge);
        }
        ArrayList<HierarchicalBackwardEdge> inputLeftVertices = new ArrayList<HierarchicalBackwardEdge>();
        ArrayList<HierarchicalBackwardEdge> inputRightVertices = new ArrayList<HierarchicalBackwardEdge>();
        List<HierarchicalVertex> inputVertices = this.graph.getVerticesByIds(vertex.getInputVertexIds());
        for (HierarchicalVertex inputVertex : inputVertices) {
            if (!inputVertex.isCompanionVertex()) continue;
            UUID backwardEdgeId = inputVertex.getBackEdgeId();
            HierarchicalBackwardEdge backwardEdge = this.graph.getBackwardEdges().get(backwardEdgeId);
            HierarchicalVertex backwardVertex = this.graph.getVertexById(backwardEdge.getTrgCompanionOutputVertex());
            if (backwardVertex.getOrder() > vertex.getOrder()) {
                inputRightVertices.add(backwardEdge);
                continue;
            }
            inputLeftVertices.add(backwardEdge);
        }
        if (inputLeftVertices.isEmpty() && inputRightVertices.isEmpty() && outputLeftVertices.isEmpty() && outputRightVertices.isEmpty()) {
            return null;
        }
        Collections.reverse(inputLeftVertices);
        Collections.reverse(outputLeftVertices);
        return new PossibleCandidate(vertex, inputLeftVertices, inputRightVertices, outputLeftVertices, outputRightVertices);
    }

    private static class Shift {
        HierarchicalVertex companion;
        int amount;

        public Shift(HierarchicalVertex companion, int amount) {
            this.companion = companion;
            this.amount = amount;
        }
    }

    private static class PossibleCandidate {
        HierarchicalVertex vertex;
        List<HierarchicalBackwardEdge> inputLeftVertices;
        List<HierarchicalBackwardEdge> inputRightVertices;
        List<HierarchicalBackwardEdge> outputLeftVertices;
        List<HierarchicalBackwardEdge> outputRightVertices;

        public PossibleCandidate(HierarchicalVertex vertex, List<HierarchicalBackwardEdge> inputLeftVertices, List<HierarchicalBackwardEdge> inputRightVertices, List<HierarchicalBackwardEdge> outputLeftVertices, List<HierarchicalBackwardEdge> outputRightVertices) {
            this.vertex = vertex;
            this.inputLeftVertices = inputLeftVertices;
            this.inputRightVertices = inputRightVertices;
            this.outputLeftVertices = outputLeftVertices;
            this.outputRightVertices = outputRightVertices;
        }

        public HierarchicalVertex peekAnyInputCompanion() {
            if (!this.inputLeftVertices.isEmpty()) {
                return this.inputLeftVertices.get(0).getTrgCompanionVertex();
            }
            if (!this.inputRightVertices.isEmpty()) {
                return this.inputRightVertices.get(0).getTrgCompanionVertex();
            }
            return null;
        }

        public HierarchicalVertex peekAnyOutputCompanion() {
            if (!this.outputLeftVertices.isEmpty()) {
                return this.outputLeftVertices.get(0).getSrcCompanionVertex();
            }
            if (!this.outputRightVertices.isEmpty()) {
                return this.outputRightVertices.get(0).getSrcCompanionVertex();
            }
            return null;
        }

        public int topMax() {
            return Math.max(this.inputLeftVertices.size(), this.inputRightVertices.size());
        }

        public int bottomMax() {
            return Math.max(this.outputLeftVertices.size(), this.outputRightVertices.size());
        }

        public List<HierarchicalVertex> get(List<UUID> vertexIds, HierarchicalGraph graph) {
            return graph.getVerticesByIds(vertexIds).stream().filter(v -> !v.isCompanionVertex()).collect(Collectors.toList());
        }

        public void addFakes(HierarchicalGraph graph) {
            List<HierarchicalVertex> outputVertices;
            HierarchicalBackwardEdge back;
            int backIndex;
            int order;
            List<HierarchicalVertex> inputVertices;
            if (this.inputLeftVertices.size() > 0) {
                inputVertices = this.get(this.vertex.getInputVertexIds(), graph);
                HierarchicalVertex inputLeftVertex = inputVertices.get(0);
                graph.shiftRightOrder(inputLeftVertex, this.inputLeftVertices.size());
                order = inputLeftVertex.getOrder();
                for (backIndex = this.inputLeftVertices.size() - 1; backIndex >= 0; --backIndex) {
                    back = this.inputLeftVertices.get(backIndex);
                    back.trgCompanionCoupleVertex = graph.addFakeVertex(back.getTrgCompanionVertex().getLevel(), back.getGroupId(), "L_COUPLE_TRG");
                    back.trgCompanionCoupleVertex.setOrder(order - 1);
                    --order;
                }
            }
            if (this.inputRightVertices.size() > 0) {
                inputVertices = this.get(this.vertex.getInputVertexIds(), graph);
                HierarchicalVertex inputRightVertex = inputVertices.get(inputVertices.size() - 1);
                graph.shiftLeftOrder(inputRightVertex, this.inputRightVertices.size());
                order = inputRightVertex.getOrder();
                for (backIndex = this.inputRightVertices.size() - 1; backIndex >= 0; --backIndex) {
                    back = this.inputRightVertices.get(backIndex);
                    back.trgCompanionCoupleVertex = graph.addFakeVertex(back.getTrgCompanionVertex().getLevel(), back.getGroupId(), "R_COUPLE_TRG");
                    back.trgCompanionCoupleVertex.setOrder(order + 1);
                    ++order;
                }
            }
            if (this.outputLeftVertices.size() > 0) {
                outputVertices = this.get(this.vertex.getOutputVertexIds(), graph);
                HierarchicalVertex outputLeftVertex = outputVertices.get(0);
                graph.shiftRightOrder(outputLeftVertex, this.outputLeftVertices.size());
                order = outputLeftVertex.getOrder();
                for (backIndex = this.outputLeftVertices.size() - 1; backIndex >= 0; --backIndex) {
                    back = this.outputLeftVertices.get(backIndex);
                    back.srcCompanionCoupleVertex = graph.addFakeVertex(back.getSrcCompanionVertex().getLevel(), back.getGroupId(), "L_COUPLE_SRC");
                    back.srcCompanionCoupleVertex.setOrder(order - 1);
                    --order;
                }
            }
            if (this.outputRightVertices.size() > 0) {
                outputVertices = this.get(this.vertex.getOutputVertexIds(), graph);
                HierarchicalVertex outputRightVertex = outputVertices.get(outputVertices.size() - 1);
                graph.shiftLeftOrder(outputRightVertex, this.outputRightVertices.size());
                order = outputRightVertex.getOrder();
                for (backIndex = this.outputRightVertices.size() - 1; backIndex >= 0; --backIndex) {
                    back = this.outputRightVertices.get(backIndex);
                    back.srcCompanionCoupleVertex = graph.addFakeVertex(back.getSrcCompanionVertex().getLevel(), back.getGroupId(), "R_COUPLE_SRC");
                    back.srcCompanionCoupleVertex.setOrder(order + 1);
                    ++order;
                }
            }
            graph.getVerticesByIds(this.vertex.getInputVertexIds()).forEach(v -> {
                if (v.isBeaconVertex()) {
                    Validate.isTrue((v.getInputEdges().size() == 0 ? 1 : 0) != 0);
                    Validate.isTrue((v.getOutputEdges().size() == 1 ? 1 : 0) != 0);
                    graph.removeEdge(v.getOutputEdges().get(0));
                    graph.removeVertex((HierarchicalVertex)v);
                }
            });
            graph.getVerticesByIds(this.vertex.getOutputVertexIds()).forEach(v -> {
                if (v.isBeaconVertex()) {
                    Validate.isTrue((v.getInputEdges().size() == 1 ? 1 : 0) != 0);
                    Validate.isTrue((v.getOutputEdges().size() == 0 ? 1 : 0) != 0);
                    graph.removeEdge(v.getInputEdges().get(0));
                    graph.removeVertex((HierarchicalVertex)v);
                }
            });
        }

        public void setupCorrectRowIndexForCompanions(HierarchicalGraph graph) {
            int order;
            HierarchicalLongEdge longEdge;
            HierarchicalEdge fakeEdge;
            int backIndex = 1;
            for (HierarchicalBackwardEdge back : this.inputLeftVertices) {
                back.getTrgCompanionVertex().setLevel(this.vertex.getLevel() - backIndex - 1);
                fakeEdge = graph.getEdgeById(back.getTopEdgeId());
                longEdge = graph.convertToLongEdge(fakeEdge);
                order = back.trgCompanionCoupleVertex.getOrder();
                longEdge.getFakeVertices().forEach(v -> v.setOrder(order));
                longEdge.getFakeVertices().forEach(v -> v.setType(VertexType.TOP_BACK_VERTEX_TYPE));
                longEdge.getFakeVertices().forEach(v -> {
                    v.getBorderSize().x = 0;
                });
                graph.removeVertex(back.trgCompanionCoupleVertex);
                ++backIndex;
            }
            backIndex = 1;
            for (HierarchicalBackwardEdge back : this.inputRightVertices) {
                back.getTrgCompanionVertex().setLevel(this.vertex.getLevel() - backIndex - 1);
                fakeEdge = graph.getEdgeById(back.getTopEdgeId());
                longEdge = graph.convertToLongEdge(fakeEdge);
                order = back.trgCompanionCoupleVertex.getOrder();
                longEdge.getFakeVertices().forEach(v -> v.setOrder(order));
                longEdge.getFakeVertices().forEach(v -> v.setType(VertexType.TOP_BACK_VERTEX_TYPE));
                longEdge.getFakeVertices().forEach(v -> {
                    v.getBorderSize().x = 0;
                });
                graph.removeVertex(back.trgCompanionCoupleVertex);
                ++backIndex;
            }
            backIndex = 1;
            for (HierarchicalBackwardEdge back : this.outputLeftVertices) {
                back.getSrcCompanionVertex().setLevel(this.vertex.getLevel() + backIndex + 1);
                fakeEdge = graph.getEdgeById(back.getBottomEdgeId());
                longEdge = graph.convertToLongEdge(fakeEdge);
                order = back.srcCompanionCoupleVertex.getOrder();
                longEdge.getFakeVertices().forEach(v -> v.setOrder(order));
                longEdge.getFakeVertices().forEach(v -> v.setType(VertexType.BOTTOM_BACK_VERTEX_TYPE));
                longEdge.getFakeVertices().forEach(v -> {
                    v.getBorderSize().x = 0;
                });
                graph.removeVertex(back.srcCompanionCoupleVertex);
                ++backIndex;
            }
            backIndex = 1;
            for (HierarchicalBackwardEdge back : this.outputRightVertices) {
                back.getSrcCompanionVertex().setLevel(this.vertex.getLevel() + backIndex + 1);
                fakeEdge = graph.getEdgeById(back.getBottomEdgeId());
                longEdge = graph.convertToLongEdge(fakeEdge);
                order = back.srcCompanionCoupleVertex.getOrder();
                longEdge.getFakeVertices().forEach(v -> v.setOrder(order));
                longEdge.getFakeVertices().forEach(v -> v.setType(VertexType.BOTTOM_BACK_VERTEX_TYPE));
                longEdge.getFakeVertices().forEach(v -> {
                    v.getBorderSize().x = 0;
                });
                graph.removeVertex(back.srcCompanionCoupleVertex);
                ++backIndex;
            }
        }
    }
}

