/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.step3.legacy.operation;

import vg.lib.layout.hierarchical.data.Direction;
import vg.lib.layout.hierarchical.step3.legacy.data.CoordinateAssignmentTable;
import vg.lib.layout.hierarchical.step3.legacy.operation.CalcLengthOperation;
import vg.lib.operation.Operation;

public class ExtCalcLengthOperation
implements Operation<Long> {
    private final Direction topOrBottomDirection;
    private final Direction direction;
    private final boolean ignoreBackwardEdges;
    private final int currRowIndex;
    private final CoordinateAssignmentTable table;

    public ExtCalcLengthOperation(int currRowIndex, CoordinateAssignmentTable table, Direction topOrBottomDirection, Direction direction, boolean ignoreBackwardEdges) {
        this.currRowIndex = currRowIndex;
        this.table = table;
        this.topOrBottomDirection = topOrBottomDirection;
        this.direction = direction;
        this.ignoreBackwardEdges = ignoreBackwardEdges;
    }

    @Override
    public Long execute() {
        long result = 0L;
        int importance = 5;
        if (this.topOrBottomDirection == Direction.BOTTOM) {
            for (int rowIndex = 0; rowIndex < this.currRowIndex - 1; ++rowIndex) {
                result += (long)importance * new CalcLengthOperation(this.table.edges[rowIndex], this.direction, this.ignoreBackwardEdges).execute();
                importance += 5;
            }
            if (this.currRowIndex - 1 >= 0) {
                result += (long)importance * new CalcLengthOperation(this.table.edges[this.currRowIndex - 1], this.direction, this.ignoreBackwardEdges).execute();
            }
        } else {
            if (this.currRowIndex < this.table.vertices.length - 1) {
                result += (long)importance * new CalcLengthOperation(this.table.edges[this.currRowIndex], this.direction, this.ignoreBackwardEdges).execute();
            }
            for (int rowIndex = this.table.vertices.length - 2; rowIndex >= this.currRowIndex + 1; --rowIndex) {
                result += (long)importance * new CalcLengthOperation(this.table.edges[rowIndex], this.direction, this.ignoreBackwardEdges).execute();
                importance += 5;
            }
        }
        return result;
    }
}

