/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.step3.legacy.operation;

import vg.lib.layout.hierarchical.data.Direction;
import vg.lib.layout.hierarchical.step3.legacy.data.Edge;
import vg.lib.layout.hierarchical.step3.legacy.data.Vertex;
import vg.lib.operation.Operation;

public class CalcLengthOperation
implements Operation<Long> {
    private final Edge[] edges;
    private final Direction direction;
    private final boolean ignoreBackwardEdges;

    public CalcLengthOperation(Edge[] edges, Direction direction, boolean ignoreBackwardEdges) {
        this.edges = edges;
        this.direction = direction;
        this.ignoreBackwardEdges = ignoreBackwardEdges;
    }

    @Override
    public Long execute() {
        long[] maxSourceLengths = new long[]{};
        long[] maxTargetLengths = new long[]{};
        if (this.edges.length > 0) {
            maxSourceLengths = new long[this.edges[0].getSourceRowSize()];
            maxTargetLengths = new long[this.edges[0].getTargetRowSize()];
        }
        for (Edge edge : this.edges) {
            long realPartLong = Math.abs(edge.getSourceX() - edge.getTargetX());
            realPartLong = Math.multiplyExact(realPartLong, this.calcW(edge));
            maxSourceLengths[edge.sourceIndex] = Math.max(maxSourceLengths[edge.sourceIndex], realPartLong);
            maxTargetLengths[edge.targetIndex] = Math.max(maxTargetLengths[edge.targetIndex], realPartLong);
        }
        long sumOfLengthsOfAllEdges = 0L;
        for (long l : maxSourceLengths) {
            sumOfLengthsOfAllEdges = Math.addExact(sumOfLengthsOfAllEdges, l);
        }
        for (long l : maxTargetLengths) {
            sumOfLengthsOfAllEdges = Math.addExact(sumOfLengthsOfAllEdges, l);
        }
        return sumOfLengthsOfAllEdges;
    }

    private long calcW(Edge edge) {
        if (!edge.isSuitable(this.direction)) {
            return 0L;
        }
        Vertex src = edge.getSourceBlock();
        Vertex trg = edge.getTargetBlock();
        int X3 = 100000;
        int X2 = 1000;
        int DEFAULT = 1;
        if (this.ignoreBackwardEdges && (src.isBackVertex() || trg.isBackVertex())) {
            return 0L;
        }
        if (trg.isRealVertex() && edge.srcBetweenRealVertices && src.isFakeVertex()) {
            return X3;
        }
        if (src.isRealVertex() && edge.trgBetweenRealVertices && trg.isFakeVertex()) {
            return X3;
        }
        if (src.isRealVertex() && trg.isRealVertex()) {
            return X2;
        }
        if (src.original.isPartOfCoreTree() && trg.original.isPartOfCoreTree()) {
            return X2;
        }
        return DEFAULT;
    }
}

