/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.step3.legacy.operation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vg.lib.config.VGConfigSettings;
import vg.lib.layout.hierarchical.data.Direction;
import vg.lib.layout.hierarchical.step3.legacy.data.CoordinateAssignmentTable;
import vg.lib.layout.hierarchical.step3.legacy.data.Edge;
import vg.lib.layout.hierarchical.step3.legacy.data.Row;
import vg.lib.layout.hierarchical.step3.legacy.data.StraightLineCandidate;
import vg.lib.layout.hierarchical.step3.legacy.data.Vertex;
import vg.lib.layout.hierarchical.step3.legacy.operation.AlignRowProcedure;
import vg.lib.layout.hierarchical.step3.legacy.operation.CalcLengthOperation;
import vg.lib.operation.Procedure;

public class ApplyStraightLinesProcedure
implements Procedure {
    private static final Logger log = LoggerFactory.getLogger(ApplyStraightLinesProcedure.class);
    private final CoordinateAssignmentTable table;

    public ApplyStraightLinesProcedure(CoordinateAssignmentTable table) {
        this.table = table;
    }

    @Override
    public void execute() {
        Map<Vertex, List<Edge>> downResult = this.down();
        ArrayList<StraightLineCandidate> candidates = new ArrayList<StraightLineCandidate>();
        for (Map.Entry<Vertex, List<Edge>> entry : downResult.entrySet()) {
            List<Edge> edges = entry.getValue();
            ArrayList<Edge> candidateEdges = new ArrayList<Edge>();
            for (Edge edge : edges) {
                if (edge.getTargetBlock().original.isOutputBreakPoint()) {
                    edge.direction = Direction.UNKNOWN;
                    if (!candidateEdges.isEmpty()) {
                        candidates.add(new StraightLineCandidate(candidateEdges));
                    }
                    candidateEdges = new ArrayList();
                    continue;
                }
                if (edge.getSourceBlock().original.isInputBreakPoint()) {
                    edge.direction = Direction.UNKNOWN;
                    if (!candidateEdges.isEmpty()) {
                        candidates.add(new StraightLineCandidate(candidateEdges));
                    }
                    candidateEdges = new ArrayList();
                    continue;
                }
                candidateEdges.add(edge);
            }
            if (candidateEdges.isEmpty()) continue;
            candidates.add(new StraightLineCandidate(candidateEdges));
        }
        this.table.applyCandidates(candidates);
    }

    private Map<Vertex, List<Edge>> down() {
        HashMap<Vertex, List<Edge>> downResult = new HashMap<Vertex, List<Edge>>();
        for (int rowIndex = 0; rowIndex < this.table.rows.length - 1; ++rowIndex) {
            Row prevRow = this.table.rows[rowIndex];
            Row row = this.table.rows[rowIndex + 1];
            Edge[] edgePairs = this.table.edges[rowIndex];
            List<Edge> straightEdgePairs = this.calcStraightLinePairs(prevRow, row, row, edgePairs, Direction.BOTH_AND_BOTTOM);
            List<Edge> straightEdgePairsAdditional = this.calcStraightLinePairs(prevRow, row, prevRow, edgePairs, Direction.BOTH_AND_TOP);
            HashSet used = new HashSet();
            Stream.concat(straightEdgePairs.stream(), straightEdgePairsAdditional.stream()).forEach(straightEdge -> {
                if (used.contains(straightEdge.getSourceBlock()) || used.contains(straightEdge.getTargetBlock())) {
                    return;
                }
                used.add(straightEdge.getSourceBlock());
                used.add(straightEdge.getTargetBlock());
                ArrayList<Edge> value = (ArrayList<Edge>)downResult.get(straightEdge.getSourceBlock());
                if (value == null) {
                    value = new ArrayList<Edge>();
                }
                downResult.remove(straightEdge.getSourceBlock());
                downResult.put(straightEdge.getTargetBlock(), value);
                value.add((Edge)straightEdge);
            });
        }
        return downResult;
    }

    private List<Edge> collectStraightLinePairs(Edge[] edges) {
        ArrayList<Edge> pairs = new ArrayList<Edge>();
        for (Edge edgePair : edges) {
            int realPart = Math.abs(edgePair.getSourceX() - edgePair.getTargetX());
            if (realPart > 0) continue;
            Vertex src = edgePair.getSourceBlock();
            Vertex trg = edgePair.getTargetBlock();
            if (src.isCompanionVertex() || trg.isCompanionVertex() || src.isRealVertex() && trg.isBackVertex() || src.isBackVertex() && trg.isRealVertex() || src.inputEdgeAmount > 1 || src.outputEdgeAmount > 1 || trg.inputEdgeAmount > 1 || trg.outputEdgeAmount > 1) continue;
            if (!trg.isFakeVertex() || !trg.isFakeVertex()) {
                // empty if block
            }
            pairs.add(edgePair);
        }
        return pairs;
    }

    private List<Edge> calcStraightLinePairs(Row row1, Row row2, Row currRow, Edge[] edges, Direction direction) {
        row1.resetCoordinates(0, 500);
        row2.resetCoordinates(0, 500);
        new AlignRowProcedure(currRow, new CalcLengthOperation(edges, direction, false)).execute();
        List<Edge> straightEdgePairs = this.collectStraightLinePairs(edges);
        if (VGConfigSettings.DIAGNOSTIC_MODE) {
            log.debug("Straight edge pairs for between levels: {} and {}.", (Object)row1.rowIndex, (Object)row2.rowIndex);
            for (Edge straightEdgePair : straightEdgePairs) {
                log.debug(straightEdgePair.toString());
            }
        }
        return straightEdgePairs;
    }
}

