/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.step3.legacy.operation;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vg.lib.config.VGConfigSettings;
import vg.lib.layout.hierarchical.step3.legacy.data.Row;
import vg.lib.layout.hierarchical.step3.legacy.data.Vertex;
import vg.lib.operation.Operation;
import vg.lib.operation.Procedure;

public class AlignRowProcedure
implements Procedure {
    private static final Logger log = LoggerFactory.getLogger(AlignRowProcedure.class);
    private final Row row;
    private final Operation<Long> calcLengthOperation;

    public AlignRowProcedure(Row row, Operation<Long> calcLengthOperation) {
        this.row = row;
        this.calcLengthOperation = calcLengthOperation;
    }

    @Override
    public void execute() {
        for (int it = 0; it < 3; ++it) {
            this.align();
        }
    }

    private void align() {
        Vertex suitableBlock;
        this.row.resetVisited();
        long currentResult = 0L;
        block4: while ((suitableBlock = this.row.takeSuitableBlock()) != null) {
            currentResult = this.calcLengthOperation.execute();
            Direction direction = Direction.BREAK;
            this.row.backup();
            boolean toRightRe = this.row.moveRight(suitableBlock);
            long toRightResult = toRightRe ? this.calcLengthOperation.execute() : Long.MAX_VALUE;
            this.row.rollback();
            this.row.backup();
            boolean toLeftRe = this.row.moveLeft(suitableBlock);
            long toLeftResult = toLeftRe ? this.calcLengthOperation.execute() : Long.MAX_VALUE;
            this.row.rollback();
            if (toLeftResult < currentResult) {
                direction = Direction.LEFT;
            }
            if (toRightResult < currentResult) {
                direction = Direction.RIGHT;
            }
            if (VGConfigSettings.DIAGNOSTIC_MODE) {
                log.debug("Choose direction for pushing. Pusher index = {}, direction = {}.", (Object)suitableBlock, (Object)direction);
            }
            while (true) {
                boolean pushResult = false;
                this.row.backup();
                switch (direction) {
                    case RIGHT: {
                        pushResult = this.row.moveRight(suitableBlock);
                        break;
                    }
                    case LEFT: {
                        pushResult = this.row.moveLeft(suitableBlock);
                    }
                }
                if (!pushResult) {
                    this.row.rollback();
                    continue block4;
                }
                Long tempResult = this.calcLengthOperation.execute();
                if (tempResult >= currentResult) {
                    this.row.rollback();
                    continue block4;
                }
                currentResult = tempResult;
            }
        }
    }

    private static enum Direction {
        BREAK,
        LEFT,
        RIGHT;

    }
}

