/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.step3.legacy.data;

import vg.lib.layout.hierarchical.data.HierarchicalVertex;
import vg.lib.layout.hierarchical.data.VertexType;

public class Vertex {
    public HierarchicalVertex original;
    public final int originalId;
    public VertexType type;
    public final int[] xRef;
    public boolean[] visitedRef;
    public boolean[] fixedRef;
    public String name;
    public int rowIndex;
    public int columnIndex;
    public int size;
    public int inputEdgeAmount;
    public int outputEdgeAmount;
    public int straightLineId = -1;
    public boolean isStraightLineStartBlock;
    public boolean isStraightLineFinishBlock;
    public int leftSpace;
    public int rightSpace;
    public int moveNumber;

    public Vertex(HierarchicalVertex original, int originalId, String name, VertexType type, int rowIndex, int columnIndex, int size, int[] xRef, boolean[] visitedRef, boolean[] fixedRef) {
        this.original = original;
        this.originalId = originalId;
        this.name = name;
        this.type = type;
        this.rowIndex = rowIndex;
        this.columnIndex = columnIndex;
        this.size = size;
        this.xRef = xRef;
        this.visitedRef = visitedRef;
        this.fixedRef = fixedRef;
    }

    public boolean isVertex() {
        return this.isRealVertex() || this.isFakeVertex();
    }

    public boolean isRealVertex() {
        return this.type == VertexType.VERTEX_TYPE;
    }

    public boolean isFakeVertex() {
        return this.type == VertexType.FAKE_VERTEX_TYPE || this.type == VertexType.TOP_BACK_VERTEX_TYPE || this.type == VertexType.MAIN_BACK_VERTEX_TYPE || this.type == VertexType.BOTTOM_BACK_VERTEX_TYPE || this.type == VertexType.TOP_COMPANION_VERTEX_TYPE || this.type == VertexType.BOTTOM_COMPANION_VERTEX_TYPE || this.type == VertexType.TOP_BEACON_VERTEX_TYPE || this.type == VertexType.BOTTOM_BEACON_VERTEX_TYPE;
    }

    public boolean isCompanionVertex() {
        return this.type == VertexType.TOP_COMPANION_VERTEX_TYPE || this.type == VertexType.BOTTOM_COMPANION_VERTEX_TYPE;
    }

    public boolean isTopCompanionVertex() {
        return this.type == VertexType.TOP_COMPANION_VERTEX_TYPE;
    }

    public boolean isBottomCompanionVertex() {
        return this.type == VertexType.BOTTOM_COMPANION_VERTEX_TYPE;
    }

    public boolean isTopBackVertex() {
        return this.type == VertexType.TOP_BACK_VERTEX_TYPE;
    }

    public boolean isBottomBackVertex() {
        return this.type == VertexType.BOTTOM_BACK_VERTEX_TYPE;
    }

    public boolean isMainBackVertex() {
        return this.type == VertexType.MAIN_BACK_VERTEX_TYPE;
    }

    public boolean isBackVertex() {
        return this.isBottomBackVertex() || this.isTopBackVertex() || this.isMainBackVertex() || this.isCompanionVertex();
    }

    public boolean isInputPort() {
        return this.type == VertexType.REAL_INPUT_PORT_TYPE || this.type == VertexType.FAKE_INPUT_PORT_TYPE;
    }

    public boolean isOutputPort() {
        return this.type == VertexType.REAL_OUTPUT_PORT_TYPE || this.type == VertexType.FAKE_OUTPUT_PORT_TYPE;
    }

    public boolean isPort() {
        return this.isInputPort() | this.isOutputPort();
    }

    public boolean isFixed() {
        return this.fixedRef[this.columnIndex];
    }

    public void setFixed(boolean value) {
        this.fixedRef[this.columnIndex] = value;
    }

    public boolean isVisited() {
        return this.visitedRef[this.columnIndex];
    }

    public void setVisited(boolean value) {
        this.visitedRef[this.columnIndex] = value;
    }

    public void setX(int x) {
        this.xRef[this.columnIndex] = x;
    }

    public int getX() {
        return this.xRef[this.columnIndex];
    }

    public int getSize() {
        return this.size;
    }

    public String toString() {
        return this.name;
    }
}

