/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.step3.legacy.data;

import vg.lib.layout.hierarchical.step3.legacy.data.CoordinateAssignmentTable;
import vg.lib.layout.hierarchical.step3.legacy.data.Vertex;

public class Row {
    private final CoordinateAssignmentTable table;
    private final Vertex[] blocksRef;
    public final int rowIndex;

    public Row(Vertex[] vertices, int rowIndex, CoordinateAssignmentTable table) {
        this.blocksRef = vertices;
        this.rowIndex = rowIndex;
        this.table = table;
    }

    public void resetCoordinates(int startX) {
        this.resetCoordinates(startX, 0);
    }

    public void resetCoordinates(int startX, int space) {
        int lastX = startX;
        for (int columnIndex = 0; columnIndex < this.blocksRef.length; ++columnIndex) {
            this.blocksRef[columnIndex].xRef[columnIndex] = lastX;
            lastX += this.blocksRef[columnIndex].size + space;
        }
    }

    public void resetVisited() {
        this.table.resetVisited();
    }

    public Vertex takeSuitableBlock() {
        Vertex suitableVertex = null;
        for (Vertex vertex : this.blocksRef) {
            if (vertex.isFixed() || vertex.isVisited() || vertex.straightLineId < 0) continue;
            suitableVertex = vertex;
            break;
        }
        if (suitableVertex != null) {
            suitableVertex.setVisited(true);
            return suitableVertex;
        }
        long maxImportance = Long.MAX_VALUE;
        for (Vertex vertex : this.blocksRef) {
            if (vertex.isFixed() || vertex.isVisited() || vertex.straightLineId >= 0 || vertex.original.getImportance() >= maxImportance) continue;
            maxImportance = vertex.original.getImportance();
            suitableVertex = vertex;
        }
        if (suitableVertex != null) {
            suitableVertex.setVisited(true);
            return suitableVertex;
        }
        return null;
    }

    public void backup() {
        this.table.backup();
    }

    public void rollback() {
        this.table.rollback();
    }

    public boolean moveRight(Vertex vertex) {
        return this.table.moveRight(vertex);
    }

    public boolean moveLeft(Vertex vertex) {
        return this.table.moveLeft(vertex);
    }

    public int size() {
        return this.blocksRef.length;
    }

    public int calcWidth() {
        return this.blocksRef[this.blocksRef.length - 1].getX() + this.blocksRef[this.blocksRef.length - 1].getSize() - this.blocksRef[0].getX();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Row #").append(this.rowIndex).append(":\n");
        for (Vertex v : this.blocksRef) {
            sb.append(String.format("    %s\n", v));
        }
        return sb.toString();
    }
}

