/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.step3.legacy.data;

import org.apache.commons.lang3.Validate;
import vg.lib.layout.hierarchical.data.Direction;
import vg.lib.layout.hierarchical.data.HierarchicalEdge;
import vg.lib.layout.hierarchical.step3.legacy.data.Vertex;

public class Edge {
    public final HierarchicalEdge original;
    private final int[] sourceRowXRef;
    private final int[] targetRowXRef;
    private final Vertex[] sourceRowVertexRef;
    private final Vertex[] targetRowVertexRef;
    public final int sourceIndex;
    public final int targetIndex;
    public final int sourceAmount;
    public final int targetAmount;
    public int sourceShift;
    public int targetShift;
    public boolean srcBetweenRealVertices;
    public boolean trgBetweenRealVertices;
    public Direction direction;

    public Edge(HierarchicalEdge edge, int sourceIndex, int targetIndex, int sourceAmount, int targetAmount, int sourceShift, int targetShift, int[] sourceRowXRef, int[] targetRowXRef, Vertex[] sourceRowVertexRef, Vertex[] targetRowVertexRef) {
        this.original = edge;
        this.sourceIndex = sourceIndex;
        this.targetIndex = targetIndex;
        this.sourceAmount = sourceAmount;
        this.targetAmount = targetAmount;
        this.sourceShift = sourceShift;
        this.targetShift = targetShift;
        this.sourceRowXRef = sourceRowXRef;
        this.targetRowXRef = targetRowXRef;
        this.sourceRowVertexRef = sourceRowVertexRef;
        this.targetRowVertexRef = targetRowVertexRef;
        this.direction = Direction.BOTH;
    }

    public boolean isSuitable(Direction value) {
        Validate.isTrue((this.direction != Direction.BOTH_AND_TOP ? 1 : 0) != 0);
        Validate.isTrue((this.direction != Direction.BOTH_AND_BOTTOM ? 1 : 0) != 0);
        if (this.direction == Direction.UNKNOWN) {
            return false;
        }
        if (value == Direction.BOTH_AND_BOTTOM && (this.direction == Direction.BOTH || this.direction == Direction.BOTTOM)) {
            return true;
        }
        if (value == Direction.BOTH_AND_TOP && (this.direction == Direction.BOTH || this.direction == Direction.TOP)) {
            return true;
        }
        return value == this.direction;
    }

    public int getSourceRowSize() {
        return this.sourceRowXRef.length;
    }

    public int getTargetRowSize() {
        return this.targetRowXRef.length;
    }

    public int getSourceX() {
        return this.sourceRowXRef[this.sourceIndex] + this.sourceShift;
    }

    public int getTargetX() {
        return this.targetRowXRef[this.targetIndex] + this.targetShift;
    }

    public Vertex getSourceBlock() {
        return this.sourceRowVertexRef[this.sourceIndex];
    }

    public Vertex getTargetBlock() {
        return this.targetRowVertexRef[this.targetIndex];
    }

    public String toString() {
        return this.sourceRowVertexRef[this.sourceIndex] + " -> " + this.targetRowVertexRef[this.targetIndex] + " | " + this.direction;
    }
}

