/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.step3.legacy.data;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vg.lib.config.VGConfigSettings;
import vg.lib.layout.hierarchical.data.Direction;
import vg.lib.layout.hierarchical.data.HierarchicalEdge;
import vg.lib.layout.hierarchical.data.HierarchicalGraph;
import vg.lib.layout.hierarchical.data.HierarchicalVertex;
import vg.lib.layout.hierarchical.step3.legacy.data.Edge;
import vg.lib.layout.hierarchical.step3.legacy.data.Row;
import vg.lib.layout.hierarchical.step3.legacy.data.StraightLine;
import vg.lib.layout.hierarchical.step3.legacy.data.StraightLineCandidate;
import vg.lib.layout.hierarchical.step3.legacy.data.Vertex;
import vg.lib.layout.hierarchical.step3.legacy.operation.AlignRowProcedure;
import vg.lib.layout.hierarchical.step3.legacy.operation.ExtCalcLengthOperation;

public class CoordinateAssignmentTable {
    private static final Logger log = LoggerFactory.getLogger(CoordinateAssignmentTable.class);
    private static final int RIGHT_VALUE = 50000;
    private static final int CENTER_VALUE = 25000;
    public int[][] x;
    public int[][] backupX;
    public boolean[][] visited;
    public boolean[][] fixed;
    public Edge[][] edges;
    public Vertex[][] vertices;
    public List<StraightLine> lines;
    public Row[] rows;
    public Vertex[] toMapping;
    public HierarchicalVertex[] fromMapping;
    private final Queue<Vertex> _moveQueue = new ArrayDeque<Vertex>(300);
    private int _moveNumber = 0;
    int[] leftWallX;
    int[] rightWallIndex;
    int rightWallAmount;

    public CoordinateAssignmentTable(TreeMap<Integer, List<HierarchicalVertex>> group, HierarchicalGraph graph) {
        this(group, graph, true);
    }

    public CoordinateAssignmentTable(TreeMap<Integer, List<HierarchicalVertex>> group, HierarchicalGraph graph, boolean ignorePorts) {
        this.vertices = new Vertex[group.size()][];
        this.visited = new boolean[this.vertices.length][];
        this.fixed = new boolean[this.vertices.length][];
        this.x = new int[this.vertices.length][];
        this.backupX = new int[this.vertices.length][];
        this.rows = new Row[this.vertices.length];
        int amountOfVertices = graph.getVertices().size();
        this.toMapping = new Vertex[amountOfVertices];
        this.fromMapping = new HierarchicalVertex[amountOfVertices];
        int rowIndex = 0;
        for (Map.Entry<Integer, List<HierarchicalVertex>> groupEntry : group.entrySet()) {
            List<HierarchicalVertex> row = groupEntry.getValue();
            this.vertices[rowIndex] = new Vertex[row.size()];
            this.visited[rowIndex] = new boolean[row.size()];
            this.fixed[rowIndex] = new boolean[row.size()];
            this.x[rowIndex] = new int[row.size()];
            this.backupX[rowIndex] = new int[row.size()];
            this.rows[rowIndex] = new Row(this.vertices[rowIndex], rowIndex, this);
            for (int columnIndex = 0; columnIndex < row.size(); ++columnIndex) {
                Vertex block;
                HierarchicalVertex vertex = row.get(columnIndex);
                this.toMapping[vertex.getIndex()] = block = new Vertex(vertex, vertex.getIndex(), vertex.getName(), vertex.getType(), rowIndex, columnIndex, vertex.getWidth(), this.x[rowIndex], this.visited[rowIndex], this.fixed[rowIndex]);
                this.fromMapping[vertex.getIndex()] = vertex;
                this.vertices[rowIndex][columnIndex] = block;
            }
            this.rows[rowIndex].resetCoordinates(0);
            ++rowIndex;
        }
        this.edges = new Edge[group.size()][];
        rowIndex = 0;
        for (Map.Entry<Integer, List<HierarchicalVertex>> groupEntry : group.entrySet()) {
            List<HierarchicalEdge> outputEdges = graph.getOutputEdgesDefault(groupEntry.getValue());
            ArrayList<Edge> rowEdges = new ArrayList<Edge>(outputEdges.size());
            for (int edgeIndex = 0; edgeIndex < outputEdges.size(); ++edgeIndex) {
                HierarchicalEdge outputEdge = outputEdges.get(edgeIndex);
                if (ignorePorts && (outputEdge.getSrcVertex().isPort() || outputEdge.getTrgVertex().isPort())) continue;
                HierarchicalVertex srcVertex = outputEdge.getSrcVertex();
                HierarchicalVertex trgVertex = outputEdge.getTrgVertex();
                Vertex sourceBlock = this.toMapping[srcVertex.getIndex()];
                Vertex targetBlock = this.toMapping[trgVertex.getIndex()];
                Validate.notNull((Object)sourceBlock, (String)("Can't find block for vertex: " + srcVertex.getName()), (Object[])new Object[0]);
                Validate.notNull((Object)targetBlock, (String)("Can't find block for vertex: " + trgVertex.getName()), (Object[])new Object[0]);
                Edge edge = new Edge(outputEdge, sourceBlock.columnIndex, targetBlock.columnIndex, srcVertex.getOutputEdges().size(), trgVertex.getInputEdges().size(), outputEdge.getSrcPosX() + outputEdge.getSrcVertex().getBorderSize().x, outputEdge.getTrgPosX() + outputEdge.getTrgVertex().getBorderSize().x, this.x[rowIndex], this.x[rowIndex + 1], this.vertices[rowIndex], this.vertices[rowIndex + 1]);
                edge.srcBetweenRealVertices = outputEdge.isSrcBetweenRealVertices();
                edge.trgBetweenRealVertices = outputEdge.isTrgBetweenRealVertices();
                rowEdges.add(edge);
            }
            this.edges[rowIndex] = new Edge[rowEdges.size()];
            rowEdges.toArray(this.edges[rowIndex]);
            ++rowIndex;
        }
        for (int i = 0; i < this.vertices.length; ++i) {
            for (int j = 0; j < this.vertices[i].length; ++j) {
                Edge edge;
                Vertex trg;
                Vertex src;
                Vertex vertex = this.vertices[i][j];
                if (vertex.original.isInputBreakPoint()) {
                    src = vertex;
                    while (src.isFakeVertex()) {
                        Edge edge2 = this.getEdgeBySrc(src);
                        edge2.direction = Direction.TOP;
                        src = edge2.getTargetBlock();
                    }
                }
                if (vertex.original.isOutputBreakPoint()) {
                    trg = vertex;
                    while (trg.isFakeVertex()) {
                        Edge edge3 = this.getEdgeByTrg(trg);
                        edge3.direction = Direction.BOTTOM;
                        trg = edge3.getSourceBlock();
                    }
                }
                if (vertex.original.isTopCompanionVertex()) {
                    Edge edge4;
                    src = vertex;
                    while (src.isFakeVertex()) {
                        edge4 = this.getTopBackEdgeBySrc(src);
                        edge4.direction = Direction.TOP;
                        src = edge4.getTargetBlock();
                    }
                    edge4 = this.getTopMainBackEdgeBySrc(vertex);
                    edge4.direction = Direction.BOTH;
                }
                if (!vertex.original.isBottomCompanionVertex()) continue;
                trg = vertex;
                while (trg.isFakeVertex()) {
                    edge = this.getBottomBackEdgeByTrg(trg);
                    edge.direction = Direction.BOTTOM;
                    trg = edge.getSourceBlock();
                }
                edge = this.getBottomMainBackEdgeByTrg(vertex);
                edge.direction = Direction.BOTH;
            }
        }
    }

    private Edge getTopBackEdgeBySrc(Vertex src) {
        for (int i = 0; i < this.edges.length; ++i) {
            for (int j = 0; j < this.edges[i].length; ++j) {
                Edge edge = this.edges[i][j];
                if (edge.getSourceBlock() != src || !edge.original.isTopBackEdge()) continue;
                return edge;
            }
        }
        return null;
    }

    private Edge getTopMainBackEdgeBySrc(Vertex src) {
        for (int i = 0; i < this.edges.length; ++i) {
            for (int j = 0; j < this.edges[i].length; ++j) {
                Edge edge = this.edges[i][j];
                if (edge.getSourceBlock() != src || edge.original.isTopBackEdge()) continue;
                return edge;
            }
        }
        return null;
    }

    private Edge getEdgeBySrc(Vertex src) {
        for (int i = 0; i < this.edges.length; ++i) {
            for (int j = 0; j < this.edges[i].length; ++j) {
                Edge edge = this.edges[i][j];
                if (edge.getSourceBlock() != src) continue;
                return edge;
            }
        }
        return null;
    }

    private Edge getBottomBackEdgeByTrg(Vertex trg) {
        for (int i = 0; i < this.edges.length; ++i) {
            for (int j = 0; j < this.edges[i].length; ++j) {
                Edge edge = this.edges[i][j];
                if (edge.getTargetBlock() != trg || !edge.original.isBottomBackEdge()) continue;
                return edge;
            }
        }
        return null;
    }

    private Edge getBottomMainBackEdgeByTrg(Vertex trg) {
        for (int i = 0; i < this.edges.length; ++i) {
            for (int j = 0; j < this.edges[i].length; ++j) {
                Edge edge = this.edges[i][j];
                if (edge.getTargetBlock() != trg || edge.original.isBottomBackEdge()) continue;
                return edge;
            }
        }
        return null;
    }

    private Edge getEdgeByTrg(Vertex trg) {
        for (int i = 0; i < this.edges.length; ++i) {
            for (int j = 0; j < this.edges[i].length; ++j) {
                Edge edge = this.edges[i][j];
                if (edge.getTargetBlock() != trg) continue;
                return edge;
            }
        }
        return null;
    }

    public void fixRealVertices() {
        for (int i = 0; i < this.vertices.length; ++i) {
            for (int j = 0; j < this.vertices[i].length; ++j) {
                Vertex vertex = this.vertices[i][j];
                if (vertex.isRealVertex()) {
                    vertex.setFixed(true);
                }
                vertex.leftSpace = 0;
                vertex.rightSpace = 0;
            }
        }
    }

    public void fixMainBackVertices() {
        for (int i = 0; i < this.vertices.length; ++i) {
            for (int j = 0; j < this.vertices[i].length; ++j) {
                Vertex vertex = this.vertices[i][j];
                if (vertex.isMainBackVertex()) {
                    vertex.setFixed(true);
                }
                vertex.leftSpace = 0;
                vertex.rightSpace = 0;
            }
        }
    }

    public void unfixCompanionVertices() {
        for (int i = 0; i < this.vertices.length; ++i) {
            for (int j = 0; j < this.vertices[i].length; ++j) {
                Vertex vertex = this.vertices[i][j];
                if (vertex.isCompanionVertex()) {
                    vertex.setFixed(false);
                }
                vertex.leftSpace = 0;
                vertex.rightSpace = 0;
            }
        }
    }

    public void fixTopCompanionVertices() {
        for (int i = 0; i < this.vertices.length; ++i) {
            for (int j = 0; j < this.vertices[i].length; ++j) {
                Vertex vertex = this.vertices[i][j];
                if (vertex.isTopCompanionVertex()) {
                    vertex.setFixed(true);
                }
                vertex.leftSpace = 0;
                vertex.rightSpace = 0;
            }
        }
    }

    public void fixBottomCompanionVertices() {
        for (int i = 0; i < this.vertices.length; ++i) {
            for (int j = 0; j < this.vertices[i].length; ++j) {
                Vertex vertex = this.vertices[i][j];
                if (vertex.isBottomCompanionVertex()) {
                    vertex.setFixed(true);
                }
                vertex.leftSpace = 0;
                vertex.rightSpace = 0;
            }
        }
    }

    public void fixEdges(Direction direction) {
        for (int i = 0; i < this.edges.length; ++i) {
            for (int j = 0; j < this.edges[i].length; ++j) {
                Edge edge = this.edges[i][j];
                if (!edge.isSuitable(direction)) continue;
                edge.getSourceBlock().setFixed(true);
                edge.getTargetBlock().setFixed(true);
            }
        }
    }

    public void bottomPass(Direction direction, boolean insertFillers, boolean ignoreBackwardEdges) {
        for (int currLevelIndex = 1; currLevelIndex < this.vertices.length; ++currLevelIndex) {
            new AlignRowProcedure(this.rows[currLevelIndex], new ExtCalcLengthOperation(currLevelIndex, this, Direction.BOTTOM, direction, ignoreBackwardEdges)).execute();
        }
        if (insertFillers) {
            this.updateFillers();
        }
    }

    public void topPass(Direction direction, boolean insertFillers, boolean ignoreBackwardEdges) {
        for (int currLevelIndex = this.vertices.length - 2; currLevelIndex >= 0; --currLevelIndex) {
            new AlignRowProcedure(this.rows[currLevelIndex], new ExtCalcLengthOperation(currLevelIndex, this, Direction.TOP, direction, ignoreBackwardEdges)).execute();
        }
        if (insertFillers) {
            this.updateFillers();
        }
    }

    private void printRows(int currRowIndex) {
        if (!VGConfigSettings.DIAGNOSTIC_MODE) {
            return;
        }
        log.debug("\n\n\n==========\nAfter row index: " + currRowIndex);
        for (Row row : this.rows) {
            log.debug(row.toString());
        }
    }

    public boolean moveLeft(Vertex vertex) {
        int j;
        int i;
        this._moveInit(vertex);
        while (!this._moveQueue.isEmpty()) {
            int blockX;
            int leftX;
            vertex = this._moveQueue.poll();
            vertex.moveNumber = this._moveNumber;
            if (vertex.columnIndex <= 0) continue;
            Vertex leftBlock = this.vertices[vertex.rowIndex][vertex.columnIndex - 1];
            if (leftBlock.moveNumber == this._moveNumber || (leftX = this.x[vertex.rowIndex][vertex.columnIndex - 1]) + leftBlock.size + leftBlock.rightSpace < (blockX = this.x[vertex.rowIndex][vertex.columnIndex])) continue;
            this._addToQueue(leftBlock);
        }
        for (i = 0; i < this.vertices.length; ++i) {
            for (j = 0; j < this.vertices[i].length; ++j) {
                if (this.vertices[i][j].moveNumber != this._moveNumber || !this.fixed[i][j]) continue;
                return false;
            }
        }
        for (i = 0; i < this.vertices.length; ++i) {
            for (j = 0; j < this.vertices[i].length; ++j) {
                if (this.vertices[i][j].moveNumber != this._moveNumber) continue;
                int[] nArray = this.x[i];
                int n = j;
                nArray[n] = nArray[n] - 1;
            }
        }
        return true;
    }

    public boolean moveRight(Vertex vertex) {
        int j;
        int i;
        this._moveInit(vertex);
        while (!this._moveQueue.isEmpty()) {
            int rightX;
            int blockX;
            vertex = this._moveQueue.poll();
            vertex.moveNumber = this._moveNumber;
            if (vertex.columnIndex >= this.vertices[vertex.rowIndex].length - 1) continue;
            Vertex rightBlock = this.vertices[vertex.rowIndex][vertex.columnIndex + 1];
            if (rightBlock.moveNumber == this._moveNumber || (blockX = this.x[vertex.rowIndex][vertex.columnIndex]) + vertex.size + vertex.rightSpace < (rightX = this.x[vertex.rowIndex][vertex.columnIndex + 1])) continue;
            this._addToQueue(rightBlock);
        }
        for (i = 0; i < this.vertices.length; ++i) {
            for (j = 0; j < this.vertices[i].length; ++j) {
                if (this.vertices[i][j].moveNumber != this._moveNumber || !this.fixed[i][j]) continue;
                return false;
            }
        }
        for (i = 0; i < this.vertices.length; ++i) {
            for (j = 0; j < this.vertices[i].length; ++j) {
                if (this.vertices[i][j].moveNumber != this._moveNumber) continue;
                int[] nArray = this.x[i];
                int n = j;
                nArray[n] = nArray[n] + 1;
            }
        }
        return true;
    }

    private void _moveInit(Vertex vertex) {
        this._moveQueue.clear();
        ++this._moveNumber;
        this._addToQueue(vertex);
    }

    private void _addToQueue(Vertex vertex) {
        if (vertex.straightLineId >= 0) {
            StraightLine line = this.lines.get(vertex.straightLineId);
            line.setMoveNumber(this._moveNumber);
            this._moveQueue.addAll(line.vertices);
        } else {
            vertex.moveNumber = this._moveNumber;
            this._moveQueue.add(vertex);
        }
    }

    private void updateFillers() {
        for (int rowIndex = 0; rowIndex < this.vertices.length; ++rowIndex) {
            for (int columnIndex = 0; columnIndex < this.vertices[rowIndex].length - 1; ++columnIndex) {
                int len;
                Vertex currBlock = this.vertices[rowIndex][columnIndex];
                Vertex nextBlock = this.vertices[rowIndex][columnIndex + 1];
                if (currBlock.isFakeVertex() && nextBlock.isFakeVertex() || currBlock.isBackVertex() || nextBlock.isBackVertex()) continue;
                currBlock.rightSpace = len = this.x[nextBlock.rowIndex][nextBlock.columnIndex] - this.x[currBlock.rowIndex][currBlock.columnIndex] - currBlock.size;
                nextBlock.leftSpace = len;
            }
        }
    }

    public void resetVisited() {
        for (boolean[] booleans : this.visited) {
            Arrays.fill(booleans, false);
        }
    }

    public void backup() {
        for (int i = 0; i < this.x.length; ++i) {
            System.arraycopy(this.x[i], 0, this.backupX[i], 0, this.x[i].length);
        }
    }

    public void rollback() {
        for (int i = 0; i < this.backupX.length; ++i) {
            System.arraycopy(this.backupX[i], 0, this.x[i], 0, this.backupX[i].length);
        }
    }

    public void setupCoordinates() {
        int i;
        int min = Integer.MAX_VALUE;
        for (int[] row : this.x) {
            if (row.length <= 0) continue;
            min = Math.min(min, row[0]);
        }
        for (i = 0; i < this.x.length; ++i) {
            int j = 0;
            while (j < this.x[i].length) {
                int[] nArray = this.x[i];
                int n = j++;
                nArray[n] = nArray[n] + -min;
            }
        }
        for (i = 0; i < this.vertices.length; ++i) {
            int lastX = 0;
            for (int j = 0; j < this.vertices[i].length; ++j) {
                Vertex vertex = this.vertices[i][j];
                HierarchicalVertex hVertex = this.fromMapping[vertex.originalId];
                Validate.isTrue((lastX <= this.x[i][j] ? 1 : 0) != 0, (String)String.format("Problem with block %s %s, name = %s", vertex.rowIndex, vertex.columnIndex, vertex.toString()), (Object[])new Object[0]);
                hVertex.setPosX(this.x[i][j]);
                lastX = this.x[i][j] + vertex.size;
            }
        }
    }

    public void applyCoordinates() {
        for (int i = 0; i < this.vertices.length; ++i) {
            for (int j = 0; j < this.vertices[i].length; ++j) {
                Vertex vertex = this.vertices[i][j];
                HierarchicalVertex hVertex = this.fromMapping[vertex.originalId];
                this.x[i][j] = hVertex.getPosX();
            }
        }
    }

    public void applyCandidates(List<StraightLineCandidate> candidates) {
        this.leftWallX = new int[this.vertices.length];
        Arrays.fill(this.leftWallX, 0);
        this.rightWallIndex = new int[this.vertices.length];
        Arrays.fill(this.rightWallIndex, 0);
        this.rightWallAmount = 0;
        for (Row row : this.rows) {
            row.resetCoordinates(50000);
            this.rightWallAmount += row.size();
        }
        ArrayList<StraightLineCandidate> existedCandidates = new ArrayList<StraightLineCandidate>();
        this.lines = new ArrayList<StraightLine>();
        int straightLineId = 0;
        for (StraightLineCandidate candidate : candidates) {
            if (candidate.vertices.size() <= 1 || this.checkIntersections(candidate, existedCandidates)) continue;
            existedCandidates.add(candidate);
            StraightLine line = new StraightLine(straightLineId);
            this.lines.add(line);
            int negativeShift = 0;
            line.shifts = new int[candidate.vertices.size()];
            for (int blockIndex = 0; blockIndex < candidate.vertices.size(); ++blockIndex) {
                Vertex block = candidate.vertices.get(blockIndex);
                line.vertices.add(block);
                block.straightLineId = straightLineId;
                if (blockIndex > 0) {
                    Edge pair = candidate.edges.get(blockIndex - 1);
                    int prevShift = line.shifts[blockIndex - 1] + pair.sourceShift;
                    line.shifts[blockIndex] = prevShift - pair.targetShift;
                    if (negativeShift > line.shifts[blockIndex]) {
                        negativeShift = line.shifts[blockIndex];
                    }
                }
                if (blockIndex == 0) {
                    block.isStraightLineStartBlock = true;
                }
                if (blockIndex != candidate.vertices.size() - 1) continue;
                block.isStraightLineFinishBlock = true;
            }
            int shiftIndex = 0;
            while (shiftIndex < line.shifts.length) {
                int n = shiftIndex++;
                line.shifts[n] = line.shifts[n] + -negativeShift;
            }
            ++straightLineId;
        }
        while (this.rightWallAmount > 0) {
            for (int rowIndex = 0; rowIndex < this.vertices.length; ++rowIndex) {
                int columnIndex = this.rightWallIndex[rowIndex];
                if (columnIndex < 0) continue;
                Vertex block = this.vertices[rowIndex][columnIndex];
                if (block.straightLineId >= 0) {
                    StraightLine line = this.lines.get(block.straightLineId);
                    if (this.leftShiftLine(line)) continue;
                    if (VGConfigSettings.DIAGNOSTIC_MODE) {
                        log.debug("Can't move to left following line:");
                        for (Vertex lineBlock : line.vertices) {
                            log.debug(lineBlock.toString());
                        }
                    }
                    ++line.shiftAttempt;
                    if (line.shiftAttempt <= 500) continue;
                    line.vertices.forEach(v -> {
                        v.straightLineId = -1;
                    });
                    continue;
                }
                this.leftShift(block, false);
            }
        }
        if (VGConfigSettings.DIAGNOSTIC_MODE) {
            log.debug("\n\nStraight lines: " + this.lines.size());
            for (StraightLine line : this.lines) {
                log.debug("\n========================================\n");
                log.debug(String.format("Line #%s: ", line.id));
                for (Vertex block : line.vertices) {
                    log.debug(block + " : " + this.x[block.rowIndex][block.columnIndex] + " : " + block.size);
                }
                log.debug("========================================\n");
            }
        }
        this.setupCoordinates();
        log.debug("CalculateStraightLinesProcedure was finished.");
    }

    private boolean leftShiftLine(StraightLine line) {
        boolean check = true;
        for (Vertex lineBlock : line.vertices) {
            check &= this.leftShift(lineBlock.rowIndex, lineBlock.columnIndex, true);
        }
        if (!check) {
            return false;
        }
        int leftMax = this.findLeftMaxForLine(line);
        for (int blockIndex = 0; blockIndex < line.vertices.size(); ++blockIndex) {
            int lineBlockX;
            Vertex lineBlock = line.vertices.get(blockIndex);
            this.x[lineBlock.rowIndex][lineBlock.columnIndex] = lineBlockX = leftMax + line.shifts[blockIndex];
            this.leftWallX[lineBlock.rowIndex] = lineBlockX + lineBlock.size;
            --this.rightWallAmount;
            int n = lineBlock.rowIndex;
            this.rightWallIndex[n] = this.rightWallIndex[n] + 1;
            if (this.rightWallIndex[lineBlock.rowIndex] < this.vertices[lineBlock.rowIndex].length) continue;
            this.rightWallIndex[lineBlock.rowIndex] = -1;
        }
        return true;
    }

    private int findLeftMaxForLine(StraightLine line) {
        int max = 0;
        for (Vertex lineBlock : line.vertices) {
            int rowIndex = lineBlock.rowIndex;
            if (max >= this.leftWallX[rowIndex]) continue;
            max = this.leftWallX[rowIndex];
        }
        return max;
    }

    private boolean checkIntersections(StraightLineCandidate candidate, List<StraightLineCandidate> existedCandidates) {
        for (int i = 0; i < candidate.vertices.size() - 1; ++i) {
            Vertex currVertex = candidate.vertices.get(i);
            Vertex nextVertex = candidate.vertices.get(i + 1);
            for (StraightLineCandidate existLongEdge : existedCandidates) {
                for (int j = 0; j < existLongEdge.vertices.size() - 1; ++j) {
                    Vertex existCurrVertex = existLongEdge.vertices.get(j);
                    Vertex existNextVertex = existLongEdge.vertices.get(j + 1);
                    if (existCurrVertex.rowIndex != currVertex.rowIndex || existNextVertex.rowIndex != nextVertex.rowIndex) continue;
                    if (currVertex.columnIndex < existCurrVertex.columnIndex && existNextVertex.columnIndex < nextVertex.columnIndex) {
                        return true;
                    }
                    if (currVertex.columnIndex <= existCurrVertex.columnIndex || existNextVertex.columnIndex <= nextVertex.columnIndex) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean leftShift(int rowIndex, int columnIndex, boolean dryRun) {
        if (columnIndex < 0) {
            return false;
        }
        return this.leftShift(this.vertices[rowIndex][columnIndex], dryRun);
    }

    private boolean leftShift(Vertex vertex, boolean dryRun) {
        int nextColumnIndex;
        int rowIndex = vertex.rowIndex;
        int columnIndex = vertex.columnIndex;
        if (this.x[rowIndex][columnIndex] < 25000) {
            return true;
        }
        if (columnIndex > 0 && this.x[rowIndex][nextColumnIndex = columnIndex - 1] > 25000) {
            return false;
        }
        if (dryRun) {
            return true;
        }
        this.x[rowIndex][columnIndex] = this.leftWallX[rowIndex];
        int n = rowIndex;
        this.leftWallX[n] = this.leftWallX[n] + vertex.size;
        --this.rightWallAmount;
        int n2 = rowIndex;
        this.rightWallIndex[n2] = this.rightWallIndex[n2] + 1;
        if (this.rightWallIndex[rowIndex] >= this.vertices[rowIndex].length) {
            this.rightWallIndex[rowIndex] = -1;
        }
        return true;
    }
}

