/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.step3.legacy;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vg.lib.layout.hierarchical.data.HierarchicalGraph;
import vg.lib.layout.hierarchical.data.HierarchicalVertex;
import vg.lib.layout.hierarchical.step3.legacy.LeftAlignmentForPortsProcedure;
import vg.lib.operation.Procedure;

public class LeftAlignmentProcedure
implements Procedure {
    private static final Logger log = LoggerFactory.getLogger(LeftAlignmentProcedure.class);
    private final HierarchicalGraph graph;

    public LeftAlignmentProcedure(HierarchicalGraph graph) {
        this.graph = graph;
    }

    @Override
    public void execute() {
        log.debug("Use left alignment...");
        int prevGroupPosX = 0;
        for (Map.Entry<Integer, TreeMap<Integer, List<HierarchicalVertex>>> detailedGroupEntry : this.graph.getDetailedGroups().entrySet()) {
            for (Map.Entry<Integer, List<HierarchicalVertex>> levelEntry : detailedGroupEntry.getValue().entrySet()) {
                int prevPosX = 0;
                for (int i = 0; i < levelEntry.getValue().size(); ++i) {
                    levelEntry.getValue().get(i).setPosX(prevPosX);
                    prevPosX += levelEntry.getValue().get(i).getWidth();
                }
            }
            prevGroupPosX = HierarchicalGraph.shiftPosXForDetailedGroup(prevGroupPosX, (Map<Integer, List<HierarchicalVertex>>)detailedGroupEntry.getValue());
        }
        new LeftAlignmentForPortsProcedure(this.graph).execute();
    }
}

