/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.step3.legacy;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vg.lib.layout.hierarchical.data.HierarchicalGraph;
import vg.lib.layout.hierarchical.data.HierarchicalVertex;
import vg.lib.operation.Procedure;

public class LeftAlignmentForPortsProcedure
implements Procedure {
    private static final Logger log = LoggerFactory.getLogger(LeftAlignmentForPortsProcedure.class);
    private final HierarchicalGraph graph;

    public LeftAlignmentForPortsProcedure(HierarchicalGraph graph) {
        this.graph = graph;
    }

    @Override
    public void execute() {
        log.debug("Use left alignment for the input and output ports...");
        int startPosX = 0;
        for (HierarchicalVertex inputPort : this.graph.getInputPorts()) {
            inputPort.setPosX(startPosX);
            startPosX += inputPort.getWidth();
        }
        startPosX = 0;
        for (HierarchicalVertex outputPort : this.graph.getOutputPorts()) {
            outputPort.setPosX(startPosX);
            startPosX += outputPort.getWidth();
        }
    }
}

