/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.step3.legacy;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vg.lib.layout.hierarchical.data.HierarchicalEdge;
import vg.lib.layout.hierarchical.data.HierarchicalGraph;
import vg.lib.layout.hierarchical.data.HierarchicalVertex;
import vg.lib.layout.hierarchical.step3.legacy.ForceDirectedAlignmentForPortsProcedure;
import vg.lib.layout.hierarchical.step3.legacy.ForceDirectedGroupAlignmentProcedure;
import vg.lib.operation.Procedure;

public class ForceDirectedAlignmentProcedure
implements Procedure {
    private static final Logger log = LoggerFactory.getLogger(ForceDirectedAlignmentProcedure.class);
    private final HierarchicalGraph graph;
    private final boolean collapseEdgeSrc;
    private final boolean collapseEdgeTrg;

    public ForceDirectedAlignmentProcedure(boolean collapseEdgeSrc, boolean collapseEdgeTrg, HierarchicalGraph graph) {
        this.graph = graph;
        this.collapseEdgeSrc = collapseEdgeSrc;
        this.collapseEdgeTrg = collapseEdgeTrg;
    }

    @Override
    public void execute() {
        log.debug("Use force directed alignment...");
        for (HierarchicalVertex vertex : this.graph.getVertices()) {
            List<HierarchicalEdge> outputEdges = this.graph.getOutputEdgesSortedByOutputVertices(vertex);
            this.calcEdgeSrcPosX(outputEdges, vertex.getWidthWithoutBorder(), vertex.getFragmentTextSize().x);
            this.calcEdgeTrgPosX(this.graph.getInputEdges(vertex), vertex.getWidthWithoutBorder(), vertex.getFragmentTextSize().x);
        }
        int prevGroupPosX = 0;
        for (Map.Entry<Integer, TreeMap<Integer, List<HierarchicalVertex>>> detailedGroupsEntry : this.graph.getDetailedGroups().entrySet()) {
            new ForceDirectedGroupAlignmentProcedure(detailedGroupsEntry.getValue(), this.graph).execute();
            prevGroupPosX = HierarchicalGraph.shiftPosXForDetailedGroup(prevGroupPosX, (Map<Integer, List<HierarchicalVertex>>)detailedGroupsEntry.getValue());
        }
        new ForceDirectedAlignmentForPortsProcedure(this.graph).execute();
    }

    private void calcEdgeSrcPosX(List<HierarchicalEdge> outputEdges, int width, int fragmentTextSize) {
        Pair<Integer, Integer> borders = this.findRealBorders(outputEdges, edge -> edge.getTrgVertex().isRealVertex());
        int i = 0;
        float posI = 0.0f;
        float posJ = 0.0f;
        float sizeI = 0.0f;
        float sizeJ = 0.0f;
        while (i < outputEdges.size()) {
            HierarchicalEdge outputEdge;
            int j;
            for (j = i; j < outputEdges.size(); ++j) {
                outputEdge = outputEdges.get(j);
                if (!outputEdge.hasSrcPort()) continue;
                posJ = outputEdge.getSrcPortPosX();
                sizeJ = outputEdge.getSrcPortSizeX();
                break;
            }
            if (i == j) {
                outputEdge = outputEdges.get(i);
                outputEdge.setSrcPosX(outputEdge.getRoundSrcPortCenterX());
                posI = outputEdge.getSrcPortPosX();
                sizeI = outputEdge.getSrcPortSizeX();
                if ((Integer)borders.getLeft() >= ++i || i >= (Integer)borders.getRight()) continue;
                outputEdge.setTrgBetweenRealVertices(true);
                continue;
            }
            if (j == outputEdges.size()) {
                posJ = width - fragmentTextSize;
                sizeJ = 0.0f;
            }
            float w = (posJ - posI - sizeI) / (float)(j - i);
            int initI = i;
            while (i < j) {
                HierarchicalEdge outputEdge2 = outputEdges.get(i);
                if (this.collapseEdgeSrc || outputEdge2.getSrcVertex().isCompanionVertex()) {
                    outputEdge2.setSrcPosX(fragmentTextSize + Math.round(posI + sizeI + (float)(j - initI) / 2.0f * w));
                } else {
                    outputEdge2.setSrcPosX(fragmentTextSize + Math.round(posI + sizeI + (float)(i - initI) * w + w / 2.0f));
                }
                if ((Integer)borders.getLeft() < i && i < (Integer)borders.getRight()) {
                    outputEdge2.setTrgBetweenRealVertices(true);
                }
                ++i;
            }
            posI = posJ;
            sizeI = sizeJ;
        }
    }

    private void calcEdgeTrgPosX(List<HierarchicalEdge> inputEdges, int width, int fragmentTextSize) {
        Pair<Integer, Integer> borders = this.findRealBorders(inputEdges, edge -> edge.getSrcVertex().isRealVertex());
        int i = 0;
        float posI = 0.0f;
        float posJ = 0.0f;
        float sizeI = 0.0f;
        float sizeJ = 0.0f;
        while (i < inputEdges.size()) {
            HierarchicalEdge inputEdge;
            int j;
            for (j = i; j < inputEdges.size(); ++j) {
                inputEdge = inputEdges.get(j);
                if (!inputEdge.hasTrgPort()) continue;
                posJ = inputEdge.getTrgPortPosX();
                sizeJ = inputEdge.getTrgPortSizeX();
                break;
            }
            if (i == j) {
                inputEdge = inputEdges.get(i);
                inputEdge.setTrgPosX(inputEdge.getRoundTrgPortCenterX());
                posI = inputEdge.getTrgPortPosX();
                sizeI = inputEdge.getTrgPortSizeX();
                if ((Integer)borders.getLeft() >= ++i || i >= (Integer)borders.getRight()) continue;
                inputEdge.setSrcBetweenRealVertices(true);
                continue;
            }
            if (j == inputEdges.size()) {
                posJ = width - fragmentTextSize;
                sizeJ = 0.0f;
            }
            float w = (posJ - posI - sizeI) / (float)(j - i);
            int initI = i;
            while (i < j) {
                HierarchicalEdge inputEdge2 = inputEdges.get(i);
                if (this.collapseEdgeTrg || inputEdge2.getTrgVertex().isCompanionVertex()) {
                    inputEdge2.setTrgPosX(fragmentTextSize + Math.round(posI + sizeI + (float)(j - initI) / 2.0f * w));
                } else {
                    inputEdge2.setTrgPosX(fragmentTextSize + Math.round(posI + sizeI + (float)(i - initI) * w + w / 2.0f));
                }
                if ((Integer)borders.getLeft() < i && i < (Integer)borders.getRight()) {
                    inputEdge2.setSrcBetweenRealVertices(true);
                }
                ++i;
            }
            posI = posJ;
            sizeI = sizeJ;
        }
    }

    private Pair<Integer, Integer> findRealBorders(List<HierarchicalEdge> edges, Predicate<HierarchicalEdge> func) {
        MutablePair pair = new MutablePair((Object)Integer.MAX_VALUE, (Object)Integer.MIN_VALUE);
        int index = 0;
        for (HierarchicalEdge edge : edges) {
            if (func.test(edge)) {
                if (index < (Integer)pair.getLeft()) {
                    pair.setLeft((Object)index);
                }
                if (index > (Integer)pair.getRight()) {
                    pair.setRight((Object)index);
                }
            }
            ++index;
        }
        return pair;
    }
}

