/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.step3.legacy;

import java.util.List;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vg.lib.layout.hierarchical.data.Direction;
import vg.lib.layout.hierarchical.data.HierarchicalEdge;
import vg.lib.layout.hierarchical.data.HierarchicalGraph;
import vg.lib.layout.hierarchical.data.HierarchicalVertex;
import vg.lib.layout.hierarchical.step3.legacy.LeftAlignmentForPortsProcedure;
import vg.lib.layout.hierarchical.step3.legacy.data.CoordinateAssignmentTable;
import vg.lib.layout.hierarchical.step3.legacy.operation.AlignRowProcedure;
import vg.lib.layout.hierarchical.step3.legacy.operation.CalcLengthOperation;
import vg.lib.operation.Procedure;

public class ForceDirectedAlignmentForPortsProcedure
implements Procedure {
    private static final Logger log = LoggerFactory.getLogger(ForceDirectedAlignmentForPortsProcedure.class);
    private final HierarchicalGraph graph;

    public ForceDirectedAlignmentForPortsProcedure(HierarchicalGraph graph) {
        this.graph = graph;
    }

    @Override
    public void execute() {
        log.debug("Use force directed alignment for the input and output ports...");
        new LeftAlignmentForPortsProcedure(this.graph).execute();
        TreeMap<Integer, List<HierarchicalVertex>> group = new TreeMap<Integer, List<HierarchicalVertex>>();
        for (int levelIndex = this.graph.getStartLevelOfGraphWithInputPorts(); levelIndex <= this.graph.getFinishLevelOfGraphWithOutputPorts(); ++levelIndex) {
            group.put(levelIndex, this.graph.getRowByLevel(levelIndex));
        }
        CoordinateAssignmentTable table = new CoordinateAssignmentTable(group, this.graph, false);
        table.applyCoordinates();
        int inputPortsWidth = 0;
        if (this.graph.hasInputPorts) {
            inputPortsWidth = table.rows[0].calcWidth();
        }
        int outputPortsWidth = 0;
        if (this.graph.hasOutputPorts) {
            outputPortsWidth = table.rows[table.rows.length - 1].calcWidth();
        }
        List<HierarchicalVertex> firstRow = this.graph.getFirstRow();
        List<HierarchicalVertex> lastRow = this.graph.getLastRow();
        List<HierarchicalEdge> inputEdges = this.graph.getInputEdges(this.graph.getFirstRow());
        List<HierarchicalEdge> outputEdges = this.graph.getOutputEdges(this.graph.getLastRow());
        int maxWidth = Math.max(inputPortsWidth, outputPortsWidth);
        if (this.graph.hasInputPorts && !firstRow.isEmpty()) {
            if (inputEdges.isEmpty()) {
                table.rows[0].resetCoordinates((maxWidth - inputPortsWidth) / 2);
            } else {
                new AlignRowProcedure(table.rows[0], new CalcLengthOperation(table.edges[0], Direction.BOTH_AND_TOP, false)).execute();
            }
        }
        if (this.graph.hasOutputPorts && !lastRow.isEmpty()) {
            if (outputEdges.isEmpty()) {
                table.rows[table.rows.length - 1].resetCoordinates((maxWidth - outputPortsWidth) / 2);
            } else {
                new AlignRowProcedure(table.rows[table.rows.length - 1], new CalcLengthOperation(table.edges[table.rows.length - 2], Direction.BOTH_AND_BOTTOM, false)).execute();
            }
        }
        table.setupCoordinates();
    }
}

