/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.step3.custom;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vg.lib.layout.hierarchical.data.HierarchicalGraph;
import vg.lib.layout.hierarchical.data.HierarchicalVertex;

public class CustomCoordinateAlignmentProcedure {
    private static final Logger log = LoggerFactory.getLogger(CustomCoordinateAlignmentProcedure.class);
    private final HierarchicalGraph graph;

    public CustomCoordinateAlignmentProcedure(HierarchicalGraph graph) {
        this.graph = graph;
    }

    public void execute() {
        int[] groupIds = this.graph.getGroupIds();
        log.debug("Number of groups is '{}'.", (Object)groupIds.length);
        boolean prevMaxGroupOrder = false;
        for (int groupId : groupIds) {
            log.debug("Handle group {}.", (Object)groupId);
            TreeMap<Integer, List<HierarchicalVertex>> detailedGroup = this.graph.getDetailedGroups().get(groupId);
            ArrayList levels = new ArrayList();
            LinkedHashMap childMap = new LinkedHashMap();
            for (List<HierarchicalVertex> detailedGroupVertices : detailedGroup.values()) {
                ArrayList level = new ArrayList();
                detailedGroupVertices.forEach(vertex -> {
                    level.add(vertex.getVertexId());
                    childMap.put(vertex.getVertexId(), vertex.getOutputVertexIds());
                });
                levels.add(level);
            }
        }
    }
}

