/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.step2.legacy.data;

import java.util.ArrayList;
import java.util.List;
import vg.lib.layout.hierarchical.data.Direction;
import vg.lib.layout.hierarchical.data.HierarchicalVertex;
import vg.lib.layout.hierarchical.step2.legacy.data.Edge;

public class Vertex {
    public final int[] ordersRef;
    public final int[] orderToIndexRef;
    public boolean[] visitedRef;
    public List<Edge> inputs = new ArrayList<Edge>();
    public List<Edge> outputs = new ArrayList<Edge>();
    public HierarchicalVertex vertex;
    public int rowIndex;
    public int columnIndex;
    public boolean isPartOfLongChain;
    public boolean isFixed;
    public Direction direction;

    public Vertex(HierarchicalVertex vertex, int[] orders, int[] orderToIndex, boolean[] visitedRef, int rowIndex, int columnIndex) {
        this.vertex = vertex;
        this.ordersRef = orders;
        this.orderToIndexRef = orderToIndex;
        this.visitedRef = visitedRef;
        this.rowIndex = rowIndex;
        this.columnIndex = columnIndex;
        this.direction = Direction.BOTH;
    }

    public boolean isSuitable(Direction value) {
        return value == Direction.ALL || this.direction == Direction.BOTH || this.direction == value;
    }

    public boolean isVisited() {
        return this.visitedRef[this.columnIndex];
    }

    public void setVisited(boolean value) {
        this.visitedRef[this.columnIndex] = value;
    }

    public int getLevel() {
        return this.vertex.getLevel();
    }

    public int getOrder() {
        return this.ordersRef[this.columnIndex];
    }

    public void setOrder(int value) {
        this.ordersRef[this.columnIndex] = value;
    }

    public boolean containInput(Vertex value) {
        for (Edge input : this.inputs) {
            if (input.getSource() != value) continue;
            return true;
        }
        return false;
    }

    public boolean containOutput(Vertex value) {
        for (Edge output : this.outputs) {
            if (output.getTarget() != value) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.vertex.getName() + " - " + this.direction + " - " + this.ordersRef[this.columnIndex];
    }
}

