/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.step2.legacy.data;

import java.util.Arrays;
import java.util.List;
import vg.lib.layout.hierarchical.data.Direction;
import vg.lib.layout.hierarchical.step2.legacy.data.Chain;
import vg.lib.layout.hierarchical.step2.legacy.data.CrossingReductionTable;
import vg.lib.layout.hierarchical.step2.legacy.data.Group;
import vg.lib.layout.hierarchical.step2.legacy.data.Vertex;

public class Row {
    private final CrossingReductionTable table;
    public final Vertex[] verticesRef;
    public final int[] ordersRef;
    public final int[] orderToIndexRef;
    private final boolean[] visitedRef;
    public final int rowIndex;
    public Group[] topGroups = new Group[0];
    public Group[] bottomGroups = new Group[0];
    public Chain[] chains = new Chain[0];

    public Row(Vertex[] vertices, int[] ordersRef, int[] orderToIndexRef, boolean[] visitedRef, int rowIndex, CrossingReductionTable table) {
        this.verticesRef = vertices;
        this.ordersRef = ordersRef;
        this.orderToIndexRef = orderToIndexRef;
        this.visitedRef = visitedRef;
        this.rowIndex = rowIndex;
        this.table = table;
    }

    public void setGroups(List<Group> topGroups, List<Group> bottomGroups) {
        this.topGroups = new Group[topGroups.size()];
        topGroups.toArray(this.topGroups);
        this.bottomGroups = new Group[bottomGroups.size()];
        bottomGroups.toArray(this.bottomGroups);
    }

    public void setChains(List<Chain> chains) {
        this.chains = new Chain[chains.size()];
        chains.toArray(this.chains);
    }

    public int getOrder(int columnIndex) {
        return this.ordersRef[columnIndex];
    }

    public Vertex getVertexByOrder(int order) {
        return this.verticesRef[this.orderToIndexRef[order]];
    }

    public Vertex takeSuitableVertex(Direction direction) {
        Vertex suitableVertex = null;
        for (Vertex vertex : this.verticesRef) {
            if (vertex.isVisited() || vertex.isFixed || !vertex.isSuitable(direction)) continue;
            suitableVertex = vertex;
            break;
        }
        if (suitableVertex != null) {
            suitableVertex.setVisited(true);
            return suitableVertex;
        }
        return null;
    }

    public void resetOrders() {
        for (int columnIndex = 0; columnIndex < this.verticesRef.length; ++columnIndex) {
            Vertex vertex = this.verticesRef[columnIndex];
            this.ordersRef[columnIndex] = columnIndex;
            this.orderToIndexRef[columnIndex] = columnIndex;
            if (vertex.vertex.getInitialPortIndex() < 0) continue;
            vertex.isFixed = true;
        }
    }

    public void resetVisited() {
        Arrays.fill(this.visitedRef, false);
        for (Group group : this.topGroups) {
            group.visited = false;
        }
        for (Group group : this.bottomGroups) {
            group.visited = false;
        }
    }

    public void backup() {
        this.table.backup(this.rowIndex);
    }

    public void rollback() {
        this.table.rollback(this.rowIndex);
    }

    public void longBackup() {
        this.table.longBackup(this.rowIndex);
    }

    public void longRollback() {
        this.table.longRollback(this.rowIndex);
    }

    public int size() {
        return this.verticesRef.length;
    }

    public boolean leftSwap(Vertex vertex) {
        int leftColumnIndex;
        int order = vertex.getOrder();
        if (order <= 0) {
            return false;
        }
        int columnIndex = this.orderToIndexRef[order];
        int n = leftColumnIndex = this.orderToIndexRef[order - 1];
        this.ordersRef[n] = this.ordersRef[n] + 1;
        int n2 = columnIndex;
        this.ordersRef[n2] = this.ordersRef[n2] - 1;
        this.orderToIndexRef[order] = leftColumnIndex;
        this.orderToIndexRef[order - 1] = columnIndex;
        return true;
    }

    public boolean rightSwap(Vertex vertex) {
        int rightColumnIndex;
        int order = vertex.getOrder();
        if (order >= this.size() - 1) {
            return false;
        }
        int columnIndex = this.orderToIndexRef[order];
        int n = rightColumnIndex = this.orderToIndexRef[order + 1];
        this.ordersRef[n] = this.ordersRef[n] - 1;
        int n2 = columnIndex;
        this.ordersRef[n2] = this.ordersRef[n2] + 1;
        this.orderToIndexRef[order] = rightColumnIndex;
        this.orderToIndexRef[order + 1] = columnIndex;
        return true;
    }
}

