/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.step2.legacy.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import vg.lib.layout.hierarchical.data.Direction;
import vg.lib.layout.hierarchical.data.HierarchicalEdge;
import vg.lib.layout.hierarchical.data.HierarchicalGraph;
import vg.lib.layout.hierarchical.data.HierarchicalVertex;
import vg.lib.layout.hierarchical.step2.legacy.ApplyChainsProcedure;
import vg.lib.layout.hierarchical.step2.legacy.CalcCrossesOperation;
import vg.lib.layout.hierarchical.step2.legacy.CrossingReductionRowProcedure;
import vg.lib.layout.hierarchical.step2.legacy.EstCrossesOperation;
import vg.lib.layout.hierarchical.step2.legacy.ProximityOfVerticesOperation;
import vg.lib.layout.hierarchical.step2.legacy.SameTypeOperation;
import vg.lib.layout.hierarchical.step2.legacy.data.Chain;
import vg.lib.layout.hierarchical.step2.legacy.data.Edge;
import vg.lib.layout.hierarchical.step2.legacy.data.Group;
import vg.lib.layout.hierarchical.step2.legacy.data.Row;
import vg.lib.layout.hierarchical.step2.legacy.data.Vertex;

public class CrossingReductionTable {
    public final int amountOfRows;
    public long bestW = Integer.MAX_VALUE;
    public int bestCrosses = Integer.MAX_VALUE;
    public int[][] bestOrders;
    public int[][] bestOrderToIndex;
    public int[][] orders;
    public int[][] backupOrders;
    public int[][] longBackupOrders;
    public int[][] orderToIndex;
    public int[][] backupOrderToIndex;
    public int[][] longBackupOrderToIndex;
    public boolean[][] visited;
    public Edge[][] edges;
    public Vertex[][] vertices;
    public List<Chain> chains;
    public Row[] rows;
    private final Vertex[] allVertices;
    public final List<Integer> rowIndicesOrder;

    public CrossingReductionTable(TreeMap<Integer, List<HierarchicalVertex>> group, HierarchicalGraph graph) {
        this.amountOfRows = group.size() + 2;
        this.allVertices = new Vertex[graph.getVertices().size()];
        this.vertices = new Vertex[this.amountOfRows][];
        this.visited = new boolean[this.amountOfRows][];
        this.orders = new int[this.amountOfRows][];
        this.bestOrders = new int[this.amountOfRows][];
        this.bestOrderToIndex = new int[this.amountOfRows][];
        this.backupOrders = new int[this.amountOfRows][];
        this.orderToIndex = new int[this.amountOfRows][];
        this.backupOrderToIndex = new int[this.amountOfRows][];
        this.longBackupOrders = new int[this.amountOfRows][];
        this.longBackupOrderToIndex = new int[this.amountOfRows][];
        this.rows = new Row[this.amountOfRows];
        int rowIndex = 0;
        this.fillRow(graph.getInputPorts(), rowIndex++);
        for (Map.Entry<Integer, List<HierarchicalVertex>> groupEntry : group.entrySet()) {
            this.fillRow(groupEntry.getValue(), rowIndex++);
        }
        this.fillRow(graph.getOutputPorts(), rowIndex);
        this.edges = new Edge[this.amountOfRows][];
        rowIndex = 0;
        this.fillEdges(graph.getOutputEdgesDefault(graph.getInputPorts()), rowIndex++);
        for (Map.Entry<Integer, List<HierarchicalVertex>> groupEntry : group.entrySet()) {
            this.fillEdges(graph.getOutputEdgesDefault(groupEntry.getValue()), rowIndex++);
        }
        this.fillEdges(Collections.emptyList(), rowIndex);
        new ApplyChainsProcedure(this, graph).execute();
        for (rowIndex = 0; rowIndex < this.vertices.length; ++rowIndex) {
            int index;
            ArrayList<Chain> rowChains = new ArrayList<Chain>();
            for (Chain chain : this.chains) {
                if (!chain.isOnRow(rowIndex)) continue;
                rowChains.add(chain);
            }
            this.rows[rowIndex].setChains(rowChains);
            int minRowIndex = Integer.MAX_VALUE;
            int maxRowIndex = Integer.MIN_VALUE;
            for (Chain chain : this.chains) {
                if (chain.startRowIndex < minRowIndex) {
                    minRowIndex = chain.startRowIndex;
                }
                if (chain.finishRowIndex <= maxRowIndex) continue;
                maxRowIndex = chain.finishRowIndex;
            }
            ArrayList<Group> topGroups = new ArrayList<Group>();
            ArrayList<Group> bottomGroups = new ArrayList<Group>();
            for (index = rowIndex + 1; index <= maxRowIndex; ++index) {
                block6: for (Vertex vertex : this.vertices[index]) {
                    List parents;
                    if (vertex.inputs.size() <= 1 || !vertex.vertex.isRealVertex() && !vertex.vertex.isCompanionVertex()) continue;
                    Collection<HierarchicalVertex> hParents = Collections.singletonList(vertex.vertex);
                    while (!(parents = (hParents = (Collection)hParents.stream().filter(x -> {
                        Vertex v = this.allVertices[x.getIndex()];
                        return v != null;
                    }).collect(Collectors.toList())).stream().map(x -> this.allVertices[x.getIndex()]).collect(Collectors.toList())).isEmpty()) {
                        if (((Vertex)parents.get((int)0)).rowIndex == rowIndex) {
                            if (parents.size() < 2) continue block6;
                            bottomGroups.add(new Group(vertex, parents.stream().mapToInt(p -> p.columnIndex).toArray()));
                            continue block6;
                        }
                        hParents = graph.getInputVertices(hParents).values();
                    }
                }
            }
            for (index = rowIndex - 1; index >= minRowIndex; --index) {
                block9: for (Vertex vertex : this.vertices[index]) {
                    List children;
                    if (vertex.outputs.size() <= 1 || !vertex.vertex.isRealVertex() && !vertex.vertex.isCompanionVertex()) continue;
                    Collection<HierarchicalVertex> hChildren = Collections.singletonList(vertex.vertex);
                    while (!(children = (hChildren = (Collection)hChildren.stream().filter(x -> {
                        Vertex v = this.allVertices[x.getIndex()];
                        return v != null;
                    }).collect(Collectors.toList())).stream().map(x -> this.allVertices[x.getIndex()]).collect(Collectors.toList())).isEmpty()) {
                        if (((Vertex)children.get((int)0)).rowIndex == rowIndex) {
                            if (children.size() < 2) continue block9;
                            topGroups.add(new Group(vertex, children.stream().mapToInt(p -> p.columnIndex).toArray()));
                            continue block9;
                        }
                        hChildren = graph.getOutputVertices(hChildren).values();
                    }
                }
            }
            Collections.reverse(topGroups);
            Collections.reverse(bottomGroups);
            this.rows[rowIndex].setGroups(topGroups, bottomGroups);
        }
        this.rowIndicesOrder = new ArrayList<Integer>();
        this.rowIndicesOrder.add(0);
        this.rowIndicesOrder.add(this.vertices.length - 1);
    }

    public void fixDirection(Direction direction) {
        Vertex[][] vertexArray = this.vertices;
        int n = vertexArray.length;
        for (int i = 0; i < n; ++i) {
            Vertex[] row;
            for (Vertex v : row = vertexArray[i]) {
                if (!v.isFixed && !v.isSuitable(direction)) continue;
                v.isFixed = true;
            }
        }
    }

    public long doExecuteBottom(int startRowIndex, Direction direction, int[] vector) {
        long w = 0L;
        for (int currLevelIndex = startRowIndex; currLevelIndex < this.vertices.length; ++currLevelIndex) {
            CrossingReductionRowProcedure p = new CrossingReductionRowProcedure(this.rows[currLevelIndex], direction, new CalcCrossesOperation(currLevelIndex == 0 ? new Edge[]{} : this.edges[currLevelIndex - 1], direction), new EstCrossesOperation(this.rows[currLevelIndex], direction), new ProximityOfVerticesOperation(this.rows[currLevelIndex]), new SameTypeOperation(this.rows[currLevelIndex]), vector);
            p.execute();
            w += p.w;
        }
        this.backupBestSolution();
        return w;
    }

    public long doExecuteTop(int startRowIndex, Direction direction, int[] vector) {
        long w = 0L;
        for (int currLevelIndex = startRowIndex; currLevelIndex >= 0; --currLevelIndex) {
            CrossingReductionRowProcedure p = new CrossingReductionRowProcedure(this.rows[currLevelIndex], direction, new CalcCrossesOperation(currLevelIndex == this.vertices.length - 1 ? new Edge[]{} : this.edges[currLevelIndex], direction), new EstCrossesOperation(this.rows[currLevelIndex], direction), new ProximityOfVerticesOperation(this.rows[currLevelIndex]), new SameTypeOperation(this.rows[currLevelIndex]), vector);
            p.execute();
            w += p.w;
        }
        this.backupBestSolution();
        return w;
    }

    public void backupBestSolution() {
        int crosses = this.calculateCrosses();
        if (this.bestCrosses > crosses) {
            this.bestCrosses = crosses;
            for (int rowIndex = 0; rowIndex < this.orders.length; ++rowIndex) {
                System.arraycopy(this.orders[rowIndex], 0, this.bestOrders[rowIndex], 0, this.orders[rowIndex].length);
                System.arraycopy(this.orderToIndex[rowIndex], 0, this.bestOrderToIndex[rowIndex], 0, this.orders[rowIndex].length);
            }
        }
    }

    public void rollbackBestSolution() {
        for (int rowIndex = 0; rowIndex < this.bestOrders.length; ++rowIndex) {
            System.arraycopy(this.bestOrders[rowIndex], 0, this.orders[rowIndex], 0, this.bestOrders[rowIndex].length);
            System.arraycopy(this.bestOrderToIndex[rowIndex], 0, this.orderToIndex[rowIndex], 0, this.bestOrderToIndex[rowIndex].length);
        }
    }

    private void fillRow(List<HierarchicalVertex> rowVertices, int rowIndex) {
        this.vertices[rowIndex] = new Vertex[rowVertices.size()];
        this.visited[rowIndex] = new boolean[rowVertices.size()];
        this.orders[rowIndex] = new int[rowVertices.size()];
        this.bestOrders[rowIndex] = new int[rowVertices.size()];
        this.bestOrderToIndex[rowIndex] = new int[rowVertices.size()];
        this.backupOrders[rowIndex] = new int[rowVertices.size()];
        this.orderToIndex[rowIndex] = new int[rowVertices.size()];
        this.backupOrderToIndex[rowIndex] = new int[rowVertices.size()];
        this.longBackupOrders[rowIndex] = new int[rowVertices.size()];
        this.longBackupOrderToIndex[rowIndex] = new int[rowVertices.size()];
        this.rows[rowIndex] = new Row(this.vertices[rowIndex], this.orders[rowIndex], this.orderToIndex[rowIndex], this.visited[rowIndex], rowIndex, this);
        for (int columnIndex = 0; columnIndex < rowVertices.size(); ++columnIndex) {
            Vertex vertex;
            HierarchicalVertex hVertex = rowVertices.get(columnIndex);
            this.vertices[rowIndex][columnIndex] = vertex = new Vertex(hVertex, this.orders[rowIndex], this.orderToIndex[rowIndex], this.visited[rowIndex], rowIndex, columnIndex);
            this.allVertices[hVertex.getIndex()] = vertex;
        }
        this.rows[rowIndex].resetOrders();
    }

    private void fillEdges(List<HierarchicalEdge> outputEdges, int rowIndex) {
        ArrayList<Edge> edgeList = new ArrayList<Edge>();
        for (HierarchicalEdge outputEdge : outputEdges) {
            Vertex source = this.allVertices[outputEdge.getSrcVertex().getIndex()];
            Vertex target = this.allVertices[outputEdge.getTrgVertex().getIndex()];
            if (source == null || target == null) continue;
            Edge edge = new Edge(outputEdge, source.columnIndex, target.columnIndex, outputEdge.getSrcPortIndex(), outputEdge.getTrgPortIndex(), this.orders[rowIndex], this.orders[rowIndex + 1], this.vertices[rowIndex], this.vertices[rowIndex + 1]);
            edgeList.add(edge);
            source.outputs.add(edge);
            target.inputs.add(edge);
        }
        this.edges[rowIndex] = new Edge[edgeList.size()];
        edgeList.toArray(this.edges[rowIndex]);
    }

    public void backup(int rowIndex) {
        System.arraycopy(this.orders[rowIndex], 0, this.backupOrders[rowIndex], 0, this.orders[rowIndex].length);
        System.arraycopy(this.orderToIndex[rowIndex], 0, this.backupOrderToIndex[rowIndex], 0, this.orderToIndex[rowIndex].length);
    }

    public void rollback(int rowIndex) {
        System.arraycopy(this.backupOrders[rowIndex], 0, this.orders[rowIndex], 0, this.backupOrders[rowIndex].length);
        System.arraycopy(this.backupOrderToIndex[rowIndex], 0, this.orderToIndex[rowIndex], 0, this.backupOrderToIndex[rowIndex].length);
    }

    public void longBackup(int rowIndex) {
        System.arraycopy(this.orders[rowIndex], 0, this.longBackupOrders[rowIndex], 0, this.orders[rowIndex].length);
        System.arraycopy(this.orderToIndex[rowIndex], 0, this.longBackupOrderToIndex[rowIndex], 0, this.orderToIndex[rowIndex].length);
    }

    public void longRollback(int rowIndex) {
        System.arraycopy(this.longBackupOrders[rowIndex], 0, this.orders[rowIndex], 0, this.longBackupOrders[rowIndex].length);
        System.arraycopy(this.longBackupOrderToIndex[rowIndex], 0, this.orderToIndex[rowIndex], 0, this.longBackupOrderToIndex[rowIndex].length);
    }

    public int calculateCrosses() {
        int crosses = 0;
        for (Edge[] edgeRow : this.edges) {
            crosses += new CalcCrossesOperation((Edge[])edgeRow, (Direction)Direction.ALL).execute().amount;
        }
        return crosses;
    }

    public void setupOrders() {
        for (int i = 0; i < this.vertices.length; ++i) {
            for (int j = 0; j < this.vertices[i].length; ++j) {
                Vertex vertex = this.vertices[i][j];
                vertex.vertex.setOrder(this.orders[i][j]);
                Validate.isTrue((this.orders[i][j] >= 0 ? 1 : 0) != 0, (String)String.format("Vertex '%s' hasn't order.", vertex.vertex), (Object[])new Object[0]);
            }
        }
    }
}

