/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.step2.legacy.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import vg.lib.layout.hierarchical.data.Direction;
import vg.lib.layout.hierarchical.step2.legacy.data.Edge;
import vg.lib.layout.hierarchical.step2.legacy.data.Vertex;

public class Chain {
    public final int id;
    public int startRowIndex;
    public int finishRowIndex;
    public Vertex startVertex;
    public int startColumnIndex;
    public Vertex finishVertex;
    public int finishColumnIndex;
    public List<Vertex> vertices = new ArrayList<Vertex>();
    public List<Edge> edges;
    public boolean visited;

    public Chain(int id, Edge edge) {
        this(id, Collections.singletonList(edge));
    }

    public Chain(int id, List<Edge> edges) {
        this.id = id;
        this.edges = edges;
        this.startVertex = edges.get(0).getSource();
        this.startRowIndex = this.startVertex.rowIndex;
        this.vertices.add(this.startVertex);
        for (Edge edge : edges) {
            this.finishVertex = edge.getTarget();
            this.finishRowIndex = this.finishVertex.rowIndex;
            this.vertices.add(this.finishVertex);
            edge.chainId = id;
        }
        if (this.startVertex.vertex.isCompanionVertex()) {
            this.startVertex.direction = Direction.TOP;
            for (Edge e : this.startVertex.outputs) {
                if (e.originalEdge.isTopMainBackEdge()) {
                    e.direction = Direction.BOTH;
                    continue;
                }
                e.direction = Direction.TOP;
            }
        }
        if (this.finishVertex.vertex.isCompanionVertex()) {
            this.finishVertex.direction = Direction.BOTTOM;
            for (Edge e : this.finishVertex.inputs) {
                if (e.originalEdge.isBottomMainBackEdge()) {
                    e.direction = Direction.BOTH;
                    continue;
                }
                e.direction = Direction.BOTTOM;
            }
        }
        if (!this.startVertex.vertex.isCompanionVertex() && !this.finishVertex.vertex.isCompanionVertex()) {
            Direction direction = Direction.BOTH;
            if (this.startVertex.inputs.isEmpty() && this.startVertex.outputs.size() == 1) {
                direction = Direction.TOP;
                for (int vertexIndex = 0; vertexIndex < this.vertices.size() - 1; ++vertexIndex) {
                    vertex = this.vertices.get(vertexIndex);
                    vertex.direction = direction;
                }
            } else if (this.finishVertex.outputs.isEmpty() && this.finishVertex.inputs.size() == 1) {
                direction = Direction.BOTTOM;
                for (int vertexIndex = 1; vertexIndex < this.vertices.size(); ++vertexIndex) {
                    vertex = this.vertices.get(vertexIndex);
                    vertex.direction = direction;
                }
            }
            for (Edge edge : edges) {
                edge.direction = direction;
            }
        }
        for (int i = 1; i < this.vertices.size() - 1; ++i) {
            this.vertices.get((int)i).isPartOfLongChain = true;
        }
        this.startColumnIndex = this.startVertex.columnIndex;
        this.finishColumnIndex = this.finishVertex.columnIndex;
    }

    public boolean isOnRow(int rowIndex) {
        return this.startRowIndex <= rowIndex && rowIndex <= this.finishRowIndex;
    }

    public Vertex getVertex(int rowIndex) {
        return this.vertices.get(rowIndex - this.startRowIndex);
    }

    public boolean isBackChain() {
        return this.startVertex.vertex.isCompanionVertex() || this.finishVertex.vertex.isCompanionVertex();
    }

    public boolean isFakeChain() {
        return this.edges.get((int)0).originalEdge.isFakeEdge();
    }

    public boolean isShort() {
        return this.finishRowIndex - this.startRowIndex <= 1;
    }

    public int calcLength() {
        return this.edges.size();
    }

    public String toString() {
        return "{startRowIndex=" + this.startRowIndex + ", finishRowIndex=" + this.finishRowIndex + ", startVertex=" + this.startVertex + ", finishVertex=" + this.finishVertex + "}";
    }
}

