/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.step2.legacy;

import vg.lib.layout.hierarchical.data.Direction;
import vg.lib.layout.hierarchical.step2.legacy.data.Group;
import vg.lib.layout.hierarchical.step2.legacy.data.Row;
import vg.lib.layout.hierarchical.step2.legacy.data.Vertex;
import vg.lib.operation.Operation;

public class ProximityOfVerticesOperation
implements Operation<Long> {
    private final Row row;

    public ProximityOfVerticesOperation(Row row) {
        this.row = row;
    }

    @Override
    public Long execute() {
        long w = 0L;
        w += this.doExecuteForGroups(this.row.bottomGroups);
        return w += this.doExecuteForGroups(this.row.topGroups);
    }

    private long doExecuteForLevelGroups(Direction direction) {
        if (direction != Direction.BOTTOM && direction != Direction.TOP) {
            return 0L;
        }
        long w = 0L;
        long maxImp = -1L;
        int maxCount = 0;
        boolean check = false;
        for (int order = 0; order < this.row.orderToIndexRef.length - 1; ++order) {
            Vertex curr = this.row.getVertexByOrder(order);
            Vertex next = this.row.getVertexByOrder(order + 1);
            if (direction == Direction.BOTTOM) {
                if (curr.vertex.bottomLevelGroupId == next.vertex.bottomLevelGroupId && maxImp < (long)next.vertex.bottomLevelGroupP) {
                    maxImp = next.vertex.bottomLevelGroupP;
                }
                if (maxImp < (long)curr.vertex.bottomLevelGroupP) {
                    maxImp = curr.vertex.bottomLevelGroupP;
                }
                if (curr.vertex.bottomLevelGroupId != next.vertex.bottomLevelGroupId || order == this.row.orderToIndexRef.length - 2) {
                    check = true;
                }
            } else {
                if (curr.vertex.topLevelGroupId == next.vertex.topLevelGroupId && maxImp < (long)next.vertex.topLevelGroupP) {
                    maxImp = next.vertex.topLevelGroupP;
                }
                if (maxImp < (long)curr.vertex.topLevelGroupP) {
                    maxImp = curr.vertex.topLevelGroupP;
                }
                if (curr.vertex.topLevelGroupId != next.vertex.topLevelGroupId || order == this.row.orderToIndexRef.length - 2) {
                    check = true;
                }
            }
            ++maxCount;
            if (!check) continue;
            check = false;
            if (maxCount > 1) {
                w += maxImp + 1L;
            }
            maxCount = 0;
            maxImp = -1L;
        }
        return Math.max(1000L - w, 0L);
    }

    private long doExecuteForGroups(Group[] groups) {
        long dw = 0L;
        for (Group group : groups) {
            int s;
            int minGroupOrder = Integer.MAX_VALUE;
            int maxGroupOrder = Integer.MIN_VALUE;
            for (int columnIndex : group.columnIndices) {
                int order = this.row.getOrder(columnIndex);
                if (order < minGroupOrder) {
                    minGroupOrder = order;
                }
                if (order <= maxGroupOrder) continue;
                maxGroupOrder = order;
            }
            if (group.columnIndices.length <= 0 || (s = maxGroupOrder - minGroupOrder - group.columnIndices.length) <= 0) continue;
            dw += (long)s * 10L;
        }
        return dw > 1000L ? 1000L : dw;
    }
}

