/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.step2.legacy;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vg.lib.layout.hierarchical.data.Direction;
import vg.lib.layout.hierarchical.data.HierarchicalGraph;
import vg.lib.layout.hierarchical.data.HierarchicalVertex;
import vg.lib.layout.hierarchical.step2.legacy.data.CrossingReductionTable;
import vg.lib.operation.Procedure;

public class LegacyCrossingReductionProcedure
implements Procedure {
    private static final Logger log = LoggerFactory.getLogger(LegacyCrossingReductionProcedure.class);
    private final HierarchicalGraph graph;

    public LegacyCrossingReductionProcedure(HierarchicalGraph graph) {
        this.graph = graph;
    }

    @Override
    public void execute() {
        log.debug("Use crossing reduction procedure...");
        this.graph.resetOrders();
        int amountOfIntersections = 0;
        int prevGroupOrder = 0;
        Map<Integer, TreeMap<Integer, List<HierarchicalVertex>>> detailedGroups = this.graph.getDetailedGroups();
        log.debug("Amount of detailed groups '{}'.", (Object)detailedGroups.size());
        for (Map.Entry<Integer, TreeMap<Integer, List<HierarchicalVertex>>> detailedGroupEntry : detailedGroups.entrySet()) {
            log.debug("Handle detailed group '{}'.", (Object)detailedGroupEntry.getKey());
            CrossingReductionTable table = new CrossingReductionTable(detailedGroupEntry.getValue(), this.graph);
            if (!this.graph.getEdges().isEmpty()) {
                int[] defaultVector = new int[]{1, 1, 1, 1};
                for (int it = 0; it < 3; ++it) {
                    table.doExecuteBottom(0, Direction.ALL, defaultVector);
                    table.doExecuteTop(table.vertices.length - 1, Direction.ALL, defaultVector);
                }
                table.rollbackBestSolution();
                table.fixDirection(Direction.BOTH);
                table.doExecuteBottom(0, Direction.BOTTOM, defaultVector);
                table.fixDirection(Direction.BOTTOM);
                table.doExecuteTop(table.vertices.length - 1, Direction.ALL, defaultVector);
            }
            table.setupOrders();
            long crosses = table.calculateCrosses();
            log.debug("Crossing reduction procedure was finished. Amount of crosses: {}", (Object)crosses);
            prevGroupOrder = HierarchicalGraph.shiftOrderForDetailedGroup(prevGroupOrder, (Map<Integer, List<HierarchicalVertex>>)detailedGroupEntry.getValue()) + 1;
            this.graph.crosses = (int)((long)this.graph.crosses + crosses);
        }
        log.debug("Crossing reduction operation was finished. Amount of intersections: {}", (Object)amountOfIntersections);
    }
}

