/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.step2.legacy;

import vg.lib.layout.hierarchical.data.Direction;
import vg.lib.layout.hierarchical.step2.legacy.data.Chain;
import vg.lib.layout.hierarchical.step2.legacy.data.Group;
import vg.lib.layout.hierarchical.step2.legacy.data.Row;
import vg.lib.layout.hierarchical.step2.legacy.data.Vertex;
import vg.lib.operation.Operation;

public class EstCrossesOperation
implements Operation<Long> {
    private final Row row;
    private final Direction direction;
    private long w;

    public EstCrossesOperation(Row row, Direction direction) {
        this.row = row;
        this.direction = direction;
    }

    @Override
    public Long execute() {
        this.w = 0L;
        this.doExecute(this.row.bottomGroups, this.direction);
        this.doExecute(this.row.topGroups, this.direction);
        return this.w;
    }

    private void doExecute(Group[] groups, Direction direction) {
        for (Group group : groups) {
            int minChainOrder = Integer.MAX_VALUE;
            int maxChainOrder = Integer.MIN_VALUE;
            for (int columnIndex : group.columnIndices) {
                int order = this.row.getOrder(columnIndex);
                if (order < minChainOrder) {
                    minChainOrder = order;
                }
                if (order <= maxChainOrder) continue;
                maxChainOrder = order;
            }
            if (minChainOrder == maxChainOrder) continue;
            for (Chain chain : this.row.chains) {
                if (chain.startRowIndex == group.parentRowIndex && chain.startColumnIndex == group.parentColumnIndex || chain.finishRowIndex == group.parentRowIndex && chain.finishColumnIndex == group.parentColumnIndex || direction == Direction.BOTTOM && this.row.rowIndex == group.parentRowIndex + 1 || direction == Direction.TOP && this.row.rowIndex == group.parentRowIndex - 1 || (this.row.rowIndex >= group.parentRowIndex ? chain.startRowIndex > group.parentRowIndex || chain.isBackChain() && group.isBack && chain.startRowIndex == group.parentRowIndex || chain.isBackChain() && chain.finishVertex.containInput(group.parentVertex) : chain.finishRowIndex < group.parentRowIndex || chain.isBackChain() && group.isBack && chain.finishRowIndex == group.parentRowIndex || chain.isBackChain() && chain.startVertex.containOutput(group.parentVertex))) continue;
                Vertex chainVertex = chain.getVertex(this.row.rowIndex);
                if (minChainOrder >= chainVertex.getOrder() || chainVertex.getOrder() >= maxChainOrder) continue;
                this.w += this.calcCost(group, chain, chainVertex);
                chain.visited = true;
            }
        }
    }

    private long calcCost(Group group, Chain chain, Vertex chainVertex) {
        long left = 0L;
        long right = 0L;
        for (int columnIndex : group.columnIndices) {
            int order;
            Vertex vertex = this.row.verticesRef[columnIndex];
            int w = 10000;
            if (vertex.vertex.isBackVertex() || chain.isBackChain()) {
                w = 9000;
            } else if (vertex.vertex.isFakeVertex() && chain.isFakeChain()) {
                w = 10000;
            } else if (vertex.vertex.isFakeVertex() || chain.isFakeChain()) {
                w = 10000;
            }
            if (this.row.rowIndex < group.parentRowIndex ? vertex.vertex.bottomLevelGroupId != chainVertex.vertex.bottomLevelGroupId : vertex.vertex.topLevelGroupId != chainVertex.vertex.topLevelGroupId) {
                // empty if block
            }
            if ((order = this.row.getOrder(columnIndex)) < chainVertex.getOrder()) {
                left += (long)w;
            }
            if (order <= chainVertex.getOrder()) continue;
            right += (long)w;
        }
        return Math.min(left, right);
    }
}

