/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.step2.legacy;

import vg.lib.layout.hierarchical.data.Direction;
import vg.lib.layout.hierarchical.step2.legacy.CalcCrossesOperation;
import vg.lib.layout.hierarchical.step2.legacy.data.Row;
import vg.lib.layout.hierarchical.step2.legacy.data.Vertex;
import vg.lib.operation.Operation;
import vg.lib.operation.Procedure;

public class CrossingReductionRowProcedure
implements Procedure {
    private final Row row;
    private final Direction direction;
    private final Operation<CalcCrossesOperation.Crosses> calcCrossesOperation;
    private final Operation<Long> sameTypeOperation;
    private final Operation<Long> proximityOfVerticesOperation;
    private final Operation<Long> estCrossesOperation;
    private final int[] vector;
    public long w;

    public CrossingReductionRowProcedure(Row row, Direction direction, Operation<CalcCrossesOperation.Crosses> calcCrossesOperation, Operation<Long> estCrossesOperation, Operation<Long> proximityOfVerticesOperation, Operation<Long> sameTypeOperation, int[] vector) {
        this.row = row;
        this.direction = direction;
        this.calcCrossesOperation = calcCrossesOperation;
        this.estCrossesOperation = estCrossesOperation;
        this.proximityOfVerticesOperation = proximityOfVerticesOperation;
        this.sameTypeOperation = sameTypeOperation;
        this.vector = vector;
    }

    @Override
    public void execute() {
        long bestCrosses = this.calcCrosses();
        while (true) {
            this.row.longBackup();
            long re = this.doExecute();
            if (re >= bestCrosses) break;
            bestCrosses = re;
            this.row.longBackup();
        }
        this.row.longRollback();
        this.w = this.calcCrosses();
    }

    public long doExecute() {
        this.row.resetVisited();
        long bestCrossesResult = this.calcCrosses();
        while (true) {
            long re;
            long currentCrossesResult = this.calcCrosses();
            Vertex suitableVertex = this.row.takeSuitableVertex(this.direction);
            if (suitableVertex == null) {
                if (currentCrossesResult >= bestCrossesResult) break;
                bestCrossesResult = currentCrossesResult;
                this.row.resetVisited();
                continue;
            }
            this.row.backup();
            while (this.row.leftSwap(suitableVertex)) {
                re = this.calcCrosses();
                if (re < currentCrossesResult) {
                    currentCrossesResult = re;
                    this.row.backup();
                }
                if (currentCrossesResult != 0L) continue;
                break;
            }
            this.row.rollback();
            this.row.backup();
            while (this.row.rightSwap(suitableVertex)) {
                re = this.calcCrosses();
                if (re < currentCrossesResult) {
                    currentCrossesResult = re;
                    this.row.backup();
                }
                if (currentCrossesResult != 0L) continue;
                break;
            }
            this.row.rollback();
        }
        return this.calcCrosses();
    }

    private long calcCrosses() {
        return (long)this.vector[0] * this.calcCrossesOperation.execute().w + (long)this.vector[1] * this.estCrossesOperation.execute() + (long)this.vector[2] * this.proximityOfVerticesOperation.execute() + (long)this.vector[3] * this.sameTypeOperation.execute();
    }
}

