/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.step2.legacy;

import vg.lib.layout.hierarchical.data.Direction;
import vg.lib.layout.hierarchical.step2.legacy.data.Edge;
import vg.lib.operation.Operation;

public class CalcCrossesOperation
implements Operation<Crosses> {
    private final Edge[] edges;
    private final Direction direction;

    public CalcCrossesOperation(Edge[] edges, Direction direction) {
        this.edges = edges;
        this.direction = direction;
    }

    @Override
    public Crosses execute() {
        int amount = 0;
        long w = 0L;
        if (this.edges == null) {
            return new Crosses(amount, w);
        }
        for (Edge edge : this.edges) {
            edge.c = 0L;
            edge.cw = 0L;
        }
        for (int i = 0; i < this.edges.length; ++i) {
            for (int j = i + 1; j < this.edges.length; ++j) {
                Edge edge1 = this.edges[i];
                Edge edge2 = this.edges[j];
                if (!Edge.isIntersected(edge1, edge2)) continue;
                ++amount;
                ++edge1.c;
                ++edge2.c;
                if (!edge1.isSuitable(this.direction) || !edge2.isSuitable(this.direction)) continue;
                int edgeW = 10000;
                if (edge1.originalEdge.isTopBackEdge() || edge2.originalEdge.isTopBackEdge()) {
                    edgeW = 6000;
                } else if (edge1.originalEdge.isBottomBackEdge() || edge2.originalEdge.isBottomBackEdge()) {
                    edgeW = 6000;
                } else if (edge1.originalEdge.isFakeEdge() && edge2.originalEdge.isFakeEdge()) {
                    edgeW = 10000;
                } else if (edge1.originalEdge.isTopMainBackEdge() || edge2.originalEdge.isTopMainBackEdge()) {
                    edgeW = 9000;
                } else if (edge1.originalEdge.isBottomMainBackEdge() || edge2.originalEdge.isBottomMainBackEdge()) {
                    edgeW = 9000;
                } else if (edge1.originalEdge.isMainBackEdge() || edge2.originalEdge.isMainBackEdge()) {
                    edgeW = 9000;
                } else if (edge1.originalEdge.isFakeEdge() || edge2.originalEdge.isFakeEdge()) {
                    edgeW = 10000;
                }
                if (edge1.originalEdge.levelGroupId != edge2.originalEdge.levelGroupId) {
                    edgeW += 10000;
                }
                w += (long)edgeW;
                edge1.cw += (long)edgeW;
                edge2.cw += (long)edgeW;
            }
        }
        return new Crosses(amount, w);
    }

    public static class Crosses {
        public final int amount;
        public final long w;

        public Crosses(int amount, long w) {
            this.amount = amount;
            this.w = w;
        }
    }
}

