/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.step2.legacy;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vg.lib.config.VGConfigSettings;
import vg.lib.layout.hierarchical.data.HierarchicalGraph;
import vg.lib.layout.hierarchical.data.HierarchicalVertex;
import vg.lib.layout.hierarchical.step2.legacy.data.Chain;
import vg.lib.layout.hierarchical.step2.legacy.data.CrossingReductionTable;
import vg.lib.layout.hierarchical.step2.legacy.data.Edge;
import vg.lib.layout.hierarchical.step2.legacy.data.Vertex;
import vg.lib.operation.Procedure;

public class ApplyChainsProcedure
implements Procedure {
    private static final Logger log = LoggerFactory.getLogger(ApplyChainsProcedure.class);
    private final CrossingReductionTable table;
    private final HierarchicalGraph graph;
    private int chainId = 0;
    private ArrayList<Chain> chains;

    public ApplyChainsProcedure(CrossingReductionTable table, HierarchicalGraph graph) {
        this.table = table;
        this.graph = graph;
    }

    @Override
    public void execute() {
        this.chainId = 0;
        this.chains = new ArrayList();
        int edgeAmount = 0;
        LinkedHashMap<Vertex, List<Edge>> currentChains = new LinkedHashMap<Vertex, List<Edge>>();
        for (int rowIndex = 0; rowIndex < this.table.rows.length - 1; ++rowIndex) {
            for (Edge edge : this.table.edges[rowIndex]) {
                ++edgeAmount;
                HierarchicalVertex trg = edge.getTarget().vertex;
                if (edge.originalEdge.isTopBackEdge() || edge.originalEdge.isBottomBackEdge() || edge.originalEdge.isTopBeaconEdge() || edge.originalEdge.isBottomBeaconEdge()) {
                    this.chains.add(new Chain(this.chainId++, edge));
                    continue;
                }
                if (edge.originalEdge.isTopMainBackEdge()) {
                    this.putOrUpdateCurrentChains(currentChains, edge);
                    continue;
                }
                if (edge.originalEdge.isMainBackEdge()) {
                    this.putOrUpdateCurrentChains(currentChains, edge);
                    continue;
                }
                if (edge.originalEdge.isBottomMainBackEdge()) {
                    this.putOrUpdateCurrentChains(currentChains, edge);
                    List chainEdges = (List)currentChains.remove(edge.getTarget());
                    this.chains.add(new Chain(this.chainId++, chainEdges));
                    continue;
                }
                if (!currentChains.containsKey(edge.getSource())) {
                    if (this.isSuitable(trg)) {
                        this.putOrUpdateCurrentChains(currentChains, edge);
                        continue;
                    }
                    this.chains.add(new Chain(this.chainId++, edge));
                    continue;
                }
                if (this.isSuitable(trg)) {
                    this.putOrUpdateCurrentChains(currentChains, edge);
                    continue;
                }
                this.putOrUpdateCurrentChains(currentChains, edge);
                this.chains.add(new Chain(this.chainId++, (List)currentChains.remove(edge.getTarget())));
            }
        }
        for (Object chainEdges : currentChains.values()) {
            this.chains.add(new Chain(this.chainId++, (List<Edge>)chainEdges));
        }
        int chainEdgeAmount = 0;
        for (Chain chain : this.chains) {
            chainEdgeAmount += chain.calcLength();
        }
        this.table.chains = this.chains;
        log.debug("Calculate (and apply) chains procedure was finished. Chains: {}.", (Object)this.chains.size());
        if (VGConfigSettings.DIAGNOSTIC_MODE) {
            int longChainsAmount = 0;
            for (Chain chain : this.chains) {
                if (chain.isShort()) continue;
                ++longChainsAmount;
                log.debug("Long chain: {}.", (Object)chain);
            }
            log.debug("Long chains amount: {}.", (Object)longChainsAmount);
        }
        Validate.isTrue((chainEdgeAmount == edgeAmount ? 1 : 0) != 0, (String)String.format("Expected %s but found %s.", edgeAmount, chainEdgeAmount), (Object[])new Object[0]);
    }

    private void putOrUpdateCurrentChains(LinkedHashMap<Vertex, List<Edge>> currentChains, Edge edge) {
        if (currentChains.containsKey(edge.getTarget())) {
            log.error(String.format("Map currentChains contains target %s.", edge.getTarget()));
            this.chains.add(new Chain(this.chainId++, edge));
            return;
        }
        List currentChainEdges = (List)currentChains.remove(edge.getSource());
        if (currentChainEdges == null) {
            currentChains.put(edge.getTarget(), Stream.of(edge).collect(Collectors.toList()));
            return;
        }
        currentChainEdges.add(edge);
        currentChains.put(edge.getTarget(), currentChainEdges);
    }

    private boolean isSuitable(HierarchicalVertex vertex) {
        int inputRealVertices = 0;
        int outputRealVertices = 0;
        for (HierarchicalVertex inputVertex : this.graph.getVerticesByIds(vertex.getInputVertexIds())) {
            if (inputVertex.isRealVertex()) {
                ++inputRealVertices;
                continue;
            }
            if (inputVertex.isFakeVertex() && !inputVertex.isBackVertex()) {
                ++inputRealVertices;
            }
            if (!inputVertex.isPort()) continue;
            ++inputRealVertices;
        }
        for (HierarchicalVertex outputVertex : this.graph.getVerticesByIds(vertex.getOutputVertexIds())) {
            if (outputVertex.isRealVertex()) {
                ++outputRealVertices;
                continue;
            }
            if (outputVertex.isFakeVertex() && !outputVertex.isBackVertex()) {
                ++outputRealVertices;
            }
            if (!outputVertex.isPort()) continue;
            ++outputRealVertices;
        }
        return inputRealVertices <= 1 && outputRealVertices <= 1;
    }
}

