/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.step2.custom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import vg.lib.operation.Operation;

public class CustomSplitVerticesIntoGroups
implements Operation<Result> {
    private final int numberOfVertices;
    private final int[] vertexIndexToType;
    private final int[][] vertexIndexToInputVertexIndices;
    private final int[][] vertexIndexToOutputVertexIndices;
    private final int[][] vertexIndexToInputEdgeIndices;
    private final int[][] vertexIndexToOutputEdgeIndices;
    private final int[] vertexIndexToLayer;
    private final int numberOfEdges;
    private final int[] edgeIndexToSrcVertexIndex;
    private final int[] edgeIndexToTrgVertexIndex;
    private final int[] edgeIndexToChainIndex;
    private final int numberOfLayers;
    private final int[][] layerToVertexIndices;
    private final int numberOfChains;
    private final int[] chainIndexToStartVertexIndex;
    private final int[] chainIndexToFinishVertexIndex;
    private final int[] cycleVertexIndexToParentVertexIndex;

    public CustomSplitVerticesIntoGroups(int numberOfVertices, int[] vertexIndexToType, int[][] vertexIndexToInputVertexIndices, int[][] vertexIndexToOutputVertexIndices, int[][] vertexIndexToInputEdgeIndices, int[][] vertexIndexToOutputEdgeIndices, int[] vertexIndexToLayer, int numberOfEdges, int[] edgeIndexToSrcVertexIndex, int[] edgeIndexToTrgVertexIndex, int[] edgeIndexToChainIndex, int numberOfLayers, int[][] layerToVertexIndices, int numberOfChains, int[] chainIndexToStartVertexIndex, int[] chainIndexToFinishVertexIndex, int[] cycleVertexIndexToParentVertexIndex) {
        this.numberOfVertices = numberOfVertices;
        this.vertexIndexToType = vertexIndexToType;
        this.vertexIndexToInputVertexIndices = vertexIndexToInputVertexIndices;
        this.vertexIndexToOutputVertexIndices = vertexIndexToOutputVertexIndices;
        this.vertexIndexToInputEdgeIndices = vertexIndexToInputEdgeIndices;
        this.vertexIndexToOutputEdgeIndices = vertexIndexToOutputEdgeIndices;
        this.vertexIndexToLayer = vertexIndexToLayer;
        this.numberOfEdges = numberOfEdges;
        this.edgeIndexToSrcVertexIndex = edgeIndexToSrcVertexIndex;
        this.edgeIndexToTrgVertexIndex = edgeIndexToTrgVertexIndex;
        this.edgeIndexToChainIndex = edgeIndexToChainIndex;
        this.numberOfLayers = numberOfLayers;
        this.layerToVertexIndices = layerToVertexIndices;
        this.numberOfChains = numberOfChains;
        this.chainIndexToStartVertexIndex = chainIndexToStartVertexIndex;
        this.chainIndexToFinishVertexIndex = chainIndexToFinishVertexIndex;
        this.cycleVertexIndexToParentVertexIndex = cycleVertexIndexToParentVertexIndex;
    }

    @Override
    public Result execute() {
        int[] vertexIndexToMinLayer = this.findVertexIndexToMinMaxLayer(2);
        int[] vertexIndexToMaxLayer = this.findVertexIndexToMinMaxLayer(1);
        return this.findWeightToVertexIndices(vertexIndexToMinLayer, vertexIndexToMaxLayer);
    }

    private Result findWeightToVertexIndices(int[] vertexIndexToMinLayer, int[] vertexIndexToMaxLayer) {
        ArrayList<LinkedHashSet<Object>> weightToVertexIndicesList = new ArrayList<LinkedHashSet<Object>>();
        ArrayList<Integer> weightToDirectionList = new ArrayList<Integer>();
        boolean[] vertexIndexToIsVisited = new boolean[this.numberOfVertices];
        int count = 0;
        while (count < this.numberOfVertices) {
            boolean[] vertexIndexToIsSuitableFromTop = new boolean[this.numberOfVertices];
            System.arraycopy(vertexIndexToIsVisited, 0, vertexIndexToIsSuitableFromTop, 0, this.numberOfVertices);
            boolean[] vertexIndexToIsSuitableFromBottom = new boolean[this.numberOfVertices];
            System.arraycopy(vertexIndexToIsVisited, 0, vertexIndexToIsSuitableFromBottom, 0, this.numberOfVertices);
            LinkedHashSet<Object> vertexIndicesFromTop = new LinkedHashSet<Integer>();
            for (int layer = 0; layer < this.numberOfLayers; ++layer) {
                for (int vertexIndex : this.layerToVertexIndices[layer]) {
                    if (!vertexIndexToIsSuitableFromTop[vertexIndex]) continue;
                    for (int outputVertexIndex2 : this.vertexIndexToOutputVertexIndices[vertexIndex]) {
                        if (vertexIndexToIsSuitableFromTop[outputVertexIndex2] || this.doesVertexIsPartOfCycle(outputVertexIndex2)) continue;
                        vertexIndexToIsSuitableFromTop[outputVertexIndex2] = true;
                        if (vertexIndexToIsVisited[outputVertexIndex2]) continue;
                        vertexIndicesFromTop.add(outputVertexIndex2);
                    }
                }
            }
            for (int vertexIndex = 0; vertexIndex < this.numberOfVertices; ++vertexIndex) {
                if (!vertexIndexToIsSuitableFromTop[vertexIndex]) continue;
                vertexIndexToIsVisited[vertexIndex] = true;
            }
            LinkedHashSet<Object> vertexIndicesFromBottom = new LinkedHashSet();
            for (int layer = this.numberOfLayers - 1; layer >= 0; --layer) {
                for (int vertexIndex : this.layerToVertexIndices[layer]) {
                    if (!vertexIndexToIsSuitableFromBottom[vertexIndex]) continue;
                    int[] nArray = this.vertexIndexToInputVertexIndices[vertexIndex];
                    int n = nArray.length;
                    for (int outputVertexIndex2 = 0; outputVertexIndex2 < n; ++outputVertexIndex2) {
                        int inputVertexIndex2 = nArray[outputVertexIndex2];
                        if (vertexIndexToIsSuitableFromBottom[inputVertexIndex2] || this.doesVertexIsPartOfCycle(inputVertexIndex2)) continue;
                        vertexIndexToIsSuitableFromBottom[inputVertexIndex2] = true;
                        if (vertexIndexToIsVisited[inputVertexIndex2]) continue;
                        vertexIndicesFromBottom.add(inputVertexIndex2);
                    }
                }
            }
            for (int vertexIndex = 0; vertexIndex < this.numberOfVertices; ++vertexIndex) {
                if (!vertexIndexToIsSuitableFromBottom[vertexIndex]) continue;
                vertexIndexToIsVisited[vertexIndex] = true;
            }
            if (vertexIndicesFromTop.isEmpty() && vertexIndicesFromBottom.isEmpty()) {
                LinkedHashSet<Integer> coreGroupOfVertexIndices = this.findNextCoreGroup(vertexIndexToMinLayer, vertexIndexToMaxLayer, vertexIndexToIsVisited);
                Validate.isTrue((!coreGroupOfVertexIndices.isEmpty() ? 1 : 0) != 0);
                int numberOfTopTraps = 0;
                int numberOfBottomTraps = 0;
                for (Integer vertexIndex : coreGroupOfVertexIndices) {
                    long numberOfInputVertexIndices = IntStream.of(this.vertexIndexToInputVertexIndices[vertexIndex]).filter(inputVertexIndex -> vertexIndexToIsVisited[inputVertexIndex]).count();
                    long numberOfOutputVertexIndices = IntStream.of(this.vertexIndexToOutputVertexIndices[vertexIndex]).filter(outputVertexIndex -> vertexIndexToIsVisited[outputVertexIndex]).count();
                    if (numberOfOutputVertexIndices > 1L) {
                        ++numberOfTopTraps;
                    }
                    if (numberOfInputVertexIndices <= 1L) continue;
                    ++numberOfBottomTraps;
                }
                if (numberOfTopTraps >= numberOfBottomTraps) {
                    vertexIndicesFromTop = coreGroupOfVertexIndices;
                } else {
                    vertexIndicesFromBottom = coreGroupOfVertexIndices;
                }
            }
            LinkedHashSet<Integer> cycleVertexIndices = this.includeCyclesToGroup(vertexIndexToIsVisited);
            count += vertexIndicesFromTop.size() + vertexIndicesFromBottom.size() + cycleVertexIndices.size();
            Set<Integer> allVertexIndices = Stream.of(vertexIndicesFromTop, vertexIndicesFromBottom, cycleVertexIndices).flatMap(Collection::stream).collect(Collectors.toSet());
            Pair<LinkedHashSet<Integer>, List<LinkedHashSet<Integer>>> extractedChains = this.extractChains(allVertexIndices);
            vertexIndicesFromTop.removeAll((Collection)extractedChains.getKey());
            vertexIndicesFromBottom.removeAll((Collection)extractedChains.getKey());
            cycleVertexIndices.removeAll((Collection)extractedChains.getKey());
            if (vertexIndicesFromTop.size() >= vertexIndicesFromBottom.size()) {
                if (!vertexIndicesFromTop.isEmpty()) {
                    weightToDirectionList.add(1);
                    weightToVertexIndicesList.add(vertexIndicesFromTop);
                }
                if (!vertexIndicesFromBottom.isEmpty()) {
                    weightToDirectionList.add(2);
                    weightToVertexIndicesList.add(vertexIndicesFromBottom);
                }
            } else {
                weightToDirectionList.add(2);
                weightToVertexIndicesList.add(vertexIndicesFromBottom);
                if (!vertexIndicesFromTop.isEmpty()) {
                    weightToDirectionList.add(1);
                    weightToVertexIndicesList.add(vertexIndicesFromTop);
                }
            }
            if (((LinkedHashSet)extractedChains.getKey()).isEmpty()) continue;
            ((List)extractedChains.getValue()).forEach(it -> {
                weightToDirectionList.add(3);
                weightToVertexIndicesList.add((LinkedHashSet<Object>)it);
            });
        }
        Collections.reverse(weightToDirectionList);
        Collections.reverse(weightToVertexIndicesList);
        int[][] weightToVertexIndices = new int[weightToVertexIndicesList.size()][];
        int[] weightToDirection = new int[weightToDirectionList.size()];
        for (int weight = 0; weight < weightToVertexIndicesList.size(); ++weight) {
            weightToVertexIndices[weight] = ((LinkedHashSet)weightToVertexIndicesList.get(weight)).stream().mapToInt(Integer::intValue).toArray();
            weightToDirection[weight] = (Integer)weightToDirectionList.get(weight);
        }
        return new Result(weightToVertexIndices, weightToDirection, this.findVertexIndexToWeight(weightToVertexIndices));
    }

    private Pair<LinkedHashSet<Integer>, List<LinkedHashSet<Integer>>> extractChains(Set<Integer> allVertexIndices) {
        LinkedHashMap<Integer, Integer> chainIndexToWeight = new LinkedHashMap<Integer, Integer>();
        LinkedHashMap chainIndexToVertexIndices = new LinkedHashMap();
        for (int edgeIndex = 0; edgeIndex < this.numberOfEdges; ++edgeIndex) {
            int chainIndex = this.edgeIndexToChainIndex[edgeIndex];
            int srcVertexIndex = this.edgeIndexToSrcVertexIndex[edgeIndex];
            int trgVertexIndex = this.edgeIndexToTrgVertexIndex[edgeIndex];
            if (chainIndex < 0 || !allVertexIndices.contains(srcVertexIndex) || !allVertexIndices.contains(trgVertexIndex)) continue;
            LinkedHashSet<Integer> vertexIndices = (LinkedHashSet<Integer>)chainIndexToVertexIndices.get(chainIndex);
            if (vertexIndices == null) {
                vertexIndices = new LinkedHashSet<Integer>();
            }
            if ((this.vertexIndexToType[srcVertexIndex] & 3) > 0) {
                vertexIndices.add(srcVertexIndex);
                chainIndexToVertexIndices.put(chainIndex, vertexIndices);
                chainIndexToWeight.put(chainIndex, vertexIndices.size());
            }
            if ((this.vertexIndexToType[trgVertexIndex] & 3) <= 0) continue;
            vertexIndices.add(trgVertexIndex);
            chainIndexToVertexIndices.put(chainIndex, vertexIndices);
            chainIndexToWeight.put(chainIndex, vertexIndices.size());
        }
        ArrayList<LinkedHashSet> resultValue = new ArrayList<LinkedHashSet>();
        chainIndexToWeight.entrySet().stream().filter(it -> (Integer)it.getValue() > 1).sorted(Map.Entry.comparingByValue()).forEachOrdered(it -> resultValue.add((LinkedHashSet)chainIndexToVertexIndices.get(it.getKey())));
        LinkedHashSet resultKey = new LinkedHashSet();
        resultValue.forEach(resultKey::addAll);
        return Pair.of(resultKey, resultValue);
    }

    private LinkedHashSet<Integer> findNextCoreGroup(int[] vertexIndexToMinLayer, int[] vertexIndexToMaxLayer, boolean[] vertexIndexToIsVisited) {
        int maxWeight = Integer.MIN_VALUE;
        for (int vertexIndex = 0; vertexIndex < this.numberOfVertices; ++vertexIndex) {
            int weight;
            if (vertexIndexToIsVisited[vertexIndex] || (weight = vertexIndexToMaxLayer[vertexIndex] - vertexIndexToMinLayer[vertexIndex]) <= maxWeight) continue;
            maxWeight = weight;
        }
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        for (int vertexIndex = 0; vertexIndex < this.numberOfVertices; ++vertexIndex) {
            int weight;
            if (vertexIndexToIsVisited[vertexIndex] || (weight = vertexIndexToMaxLayer[vertexIndex] - vertexIndexToMinLayer[vertexIndex]) != maxWeight || this.doesVertexIsPartOfCycle(vertexIndex)) continue;
            result.add(vertexIndex);
            vertexIndexToIsVisited[vertexIndex] = true;
        }
        return result;
    }

    private LinkedHashSet<Integer> includeCyclesToGroup(boolean[] vertexIndexToIsVisited) {
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        for (int chainIndex = 0; chainIndex < this.numberOfChains; ++chainIndex) {
            int startVertexIndex = this.chainIndexToStartVertexIndex[chainIndex];
            int finishVertexIndex = this.chainIndexToFinishVertexIndex[chainIndex];
            int parentStartVertexIndex = this.cycleVertexIndexToParentVertexIndex[startVertexIndex];
            int parentFinishVertexIndex = this.cycleVertexIndexToParentVertexIndex[finishVertexIndex];
            if (parentStartVertexIndex < 0 || parentFinishVertexIndex < 0 || !vertexIndexToIsVisited[parentStartVertexIndex] || !vertexIndexToIsVisited[parentFinishVertexIndex] || vertexIndexToIsVisited[startVertexIndex] && vertexIndexToIsVisited[finishVertexIndex]) continue;
            for (int edgeIndex = 0; edgeIndex < this.numberOfEdges; ++edgeIndex) {
                int edgeChainIndex = this.edgeIndexToChainIndex[edgeIndex];
                if (edgeChainIndex != chainIndex) continue;
                int srcVertexIndex = this.edgeIndexToSrcVertexIndex[edgeIndex];
                int trgVertexIndex = this.edgeIndexToTrgVertexIndex[edgeIndex];
                if ((this.vertexIndexToType[srcVertexIndex] & 3) > 0) {
                    result.add(srcVertexIndex);
                    vertexIndexToIsVisited[srcVertexIndex] = true;
                }
                if ((this.vertexIndexToType[trgVertexIndex] & 3) <= 0) continue;
                result.add(trgVertexIndex);
                vertexIndexToIsVisited[trgVertexIndex] = true;
            }
        }
        return result;
    }

    private int[] findVertexIndexToMinMaxLayer(int direction) {
        int[] vertexIndexToMinMaxLayer = new int[this.numberOfVertices];
        boolean[] _vertexIndexToIsVisited = new boolean[this.numberOfVertices];
        int[] _stack = new int[this.numberOfVertices];
        for (int vertexIndex = 0; vertexIndex < this.numberOfVertices; ++vertexIndex) {
            int minLayer;
            Arrays.fill(_vertexIndexToIsVisited, false);
            vertexIndexToMinMaxLayer[vertexIndex] = minLayer = this.findMinMaxLayerFromStartVertex(vertexIndex, direction, _vertexIndexToIsVisited, _stack);
        }
        return vertexIndexToMinMaxLayer;
    }

    private int findMinMaxLayerFromStartVertex(int startVertexIndex, int direction, boolean[] _vertexIndexToIsVisited, int[] _stack) {
        int minMaxLayer = this.vertexIndexToLayer[startVertexIndex];
        int stackCounter = 0;
        _stack[stackCounter++] = startVertexIndex;
        while (stackCounter > 0) {
            int vertexIndex = _stack[--stackCounter];
            int vertexLayer = this.vertexIndexToLayer[vertexIndex];
            if (direction == 2 && minMaxLayer > vertexLayer) {
                minMaxLayer = vertexLayer;
            }
            if (direction == 1 && minMaxLayer < vertexLayer) {
                minMaxLayer = vertexLayer;
            }
            _vertexIndexToIsVisited[vertexIndex] = true;
            int[] nextVertexIndices = this.vertexIndexToOutputVertexIndices[vertexIndex];
            if (direction == 2) {
                nextVertexIndices = this.vertexIndexToInputVertexIndices[vertexIndex];
            }
            for (int nextVertexIndex : nextVertexIndices) {
                if (_vertexIndexToIsVisited[nextVertexIndex]) continue;
                _stack[stackCounter++] = nextVertexIndex;
            }
        }
        return minMaxLayer;
    }

    private boolean doesVertexIsPartOfCycle(int vertexIndex) {
        if (this.vertexIndexToType[vertexIndex] == 2 || this.vertexIndexToType[vertexIndex] == 1) {
            return true;
        }
        if (this.vertexIndexToType[vertexIndex] == 3 && this.vertexIndexToInputEdgeIndices[vertexIndex].length == 1 && this.vertexIndexToOutputEdgeIndices[vertexIndex].length == 1) {
            int chainIndex = this.edgeIndexToChainIndex[this.vertexIndexToInputEdgeIndices[vertexIndex][0]];
            if (chainIndex < 0) {
                return false;
            }
            int startChainVertexIndex = this.chainIndexToStartVertexIndex[chainIndex];
            if (this.vertexIndexToType[startChainVertexIndex] == 2 || this.vertexIndexToType[startChainVertexIndex] == 1) {
                return true;
            }
        }
        return false;
    }

    private int[] findVertexIndexToWeight(int[][] weightToVertexIndices) {
        int[] vertexIndexToWeight = new int[this.numberOfVertices];
        for (int weight = 0; weight < weightToVertexIndices.length; ++weight) {
            for (int vertexIndex : weightToVertexIndices[weight]) {
                vertexIndexToWeight[vertexIndex] = weight;
            }
        }
        return vertexIndexToWeight;
    }

    public record Result(int[][] weightToVertexIndices, int[] weightToDirection, int[] vertexIndexToWeight) {
    }
}

