/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.step2.custom;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import vg.lib.operation.Operation;

public class CustomExtractTraps
implements Operation<Result> {
    private final int numberOfVertices;
    private final int[][] vertexIndexToInputVertexIndices;
    private final int[][] vertexIndexToOutputVertexIndices;
    private final int[] vertexIndexToLayer;
    private final int numberOfLayers;
    private final int[][] layerToVertexIndices;

    public CustomExtractTraps(int numberOfVertices, int[][] vertexIndexToInputVertexIndices, int[][] vertexIndexToOutputVertexIndices, int[] vertexIndexToLayer, int numberOfLayers, int[][] layerToVertexIndices) {
        this.numberOfVertices = numberOfVertices;
        this.vertexIndexToInputVertexIndices = vertexIndexToInputVertexIndices;
        this.vertexIndexToOutputVertexIndices = vertexIndexToOutputVertexIndices;
        this.vertexIndexToLayer = vertexIndexToLayer;
        this.numberOfLayers = numberOfLayers;
        this.layerToVertexIndices = layerToVertexIndices;
    }

    @Override
    public Result execute() {
        int layer;
        boolean[][] topTrapVertexIndexToVertexIndex = new boolean[this.numberOfVertices][this.numberOfVertices];
        boolean[][] bottomTrapVertexIndexToVertexIndex = new boolean[this.numberOfVertices][this.numberOfVertices];
        TreeMap<Integer, TreeMap<Long, Set<Integer>>> layerToTopTrapIndexToVertexIndices = new TreeMap<Integer, TreeMap<Long, Set<Integer>>>();
        TreeMap<Integer, TreeMap<Long, Set<Integer>>> layerToBottomTrapIndexToVertexIndices = new TreeMap<Integer, TreeMap<Long, Set<Integer>>>();
        int[] _stack = new int[this.numberOfVertices];
        for (layer = 0; layer < this.numberOfLayers; ++layer) {
            for (int vertexIndex : this.layerToVertexIndices[layer]) {
                int[] inputVertices = this.vertexIndexToInputVertexIndices[vertexIndex];
                if (inputVertices.length <= 1) continue;
                this.doPassageFromStartVertex(vertexIndex, bottomTrapVertexIndexToVertexIndex[vertexIndex], 2, _stack);
                this.addToLayerToTrapGroupsWithVertexIndices(vertexIndex, bottomTrapVertexIndexToVertexIndex[vertexIndex], layerToBottomTrapIndexToVertexIndices);
            }
        }
        for (layer = this.numberOfLayers - 1; layer >= 0; --layer) {
            for (int vertexIndex : this.layerToVertexIndices[layer]) {
                int[] outputVertices = this.vertexIndexToOutputVertexIndices[vertexIndex];
                if (outputVertices.length <= 1) continue;
                this.doPassageFromStartVertex(vertexIndex, topTrapVertexIndexToVertexIndex[vertexIndex], 1, _stack);
                this.addToLayerToTrapGroupsWithVertexIndices(vertexIndex, topTrapVertexIndexToVertexIndex[vertexIndex], layerToTopTrapIndexToVertexIndices);
            }
        }
        return new Result(this.mapToLayerToTrapGroupsWithVertexIndices(layerToTopTrapIndexToVertexIndices), this.mapToLayerToTrapGroupsWithVertexIndices(layerToBottomTrapIndexToVertexIndices), this.mapToLayerToTrapVertexIndices(layerToTopTrapIndexToVertexIndices), this.mapToLayerToTrapVertexIndices(layerToBottomTrapIndexToVertexIndices));
    }

    private void doPassageFromStartVertex(int startVertexIndex, boolean[] vertexIndexToIsVisited, int direction, int[] _stack) {
        int stackCounter = 0;
        _stack[stackCounter++] = startVertexIndex;
        while (stackCounter > 0) {
            int vertexIndex = _stack[--stackCounter];
            vertexIndexToIsVisited[vertexIndex] = true;
            int[] nextVertexIndices = this.vertexIndexToOutputVertexIndices[vertexIndex];
            if (direction == 2) {
                nextVertexIndices = this.vertexIndexToInputVertexIndices[vertexIndex];
            }
            for (int nextVertexIndex : nextVertexIndices) {
                if (vertexIndexToIsVisited[nextVertexIndex]) continue;
                _stack[stackCounter++] = nextVertexIndex;
            }
        }
    }

    private int[][][] mapToLayerToTrapGroupsWithVertexIndices(TreeMap<Integer, TreeMap<Long, Set<Integer>>> layerToTrapGroupsWithVertexIndices) {
        int[][][] result = new int[this.numberOfLayers][][];
        for (int layer = 0; layer < this.numberOfLayers; ++layer) {
            TreeMap trapGroupsWithVertexIndices = layerToTrapGroupsWithVertexIndices.getOrDefault(layer, new TreeMap());
            int trapGroupsWithVertexIndicesArrayIndex = 0;
            int[][] trapGroupsWithVertexIndicesArray = new int[trapGroupsWithVertexIndices.size()][];
            for (Map.Entry topTrapGroupsWithVertexIndicesEntry : trapGroupsWithVertexIndices.entrySet()) {
                trapGroupsWithVertexIndicesArray[trapGroupsWithVertexIndicesArrayIndex] = ((Set)topTrapGroupsWithVertexIndicesEntry.getValue()).stream().mapToInt(Integer::intValue).toArray();
                ++trapGroupsWithVertexIndicesArrayIndex;
            }
            result[layer] = trapGroupsWithVertexIndicesArray;
        }
        return result;
    }

    private int[][] mapToLayerToTrapVertexIndices(TreeMap<Integer, TreeMap<Long, Set<Integer>>> layerToTrapGroupsWithVertexIndices) {
        int[][] result = new int[this.numberOfLayers][];
        for (int layer = 0; layer < this.numberOfLayers; ++layer) {
            result[layer] = layerToTrapGroupsWithVertexIndices.getOrDefault(layer, new TreeMap()).keySet().stream().mapToInt(CustomExtractTraps::fromKeyToTrapVertexIndex).toArray();
        }
        return result;
    }

    private void addToLayerToTrapGroupsWithVertexIndices(int trapVertexIndex, boolean[] vertexIndexToIsVisited, TreeMap<Integer, TreeMap<Long, Set<Integer>>> layerToTrapGroupsWithVertexIndices) {
        int vertexIndex;
        int numberOfRelatedVertices = 0;
        for (vertexIndex = 0; vertexIndex < this.numberOfVertices; ++vertexIndex) {
            if (!vertexIndexToIsVisited[vertexIndex]) continue;
            ++numberOfRelatedVertices;
        }
        for (vertexIndex = 0; vertexIndex < this.numberOfVertices; ++vertexIndex) {
            if (!vertexIndexToIsVisited[vertexIndex]) continue;
            int layer = this.vertexIndexToLayer[vertexIndex];
            layerToTrapGroupsWithVertexIndices.putIfAbsent(layer, new TreeMap());
            TreeMap<Long, Set<Integer>> trapGroupsWithVertexIndices = layerToTrapGroupsWithVertexIndices.get(layer);
            int trapVertexLayer = this.vertexIndexToLayer[trapVertexIndex];
            long key = CustomExtractTraps.toKey(layer, trapVertexLayer, trapVertexIndex, numberOfRelatedVertices);
            trapGroupsWithVertexIndices.putIfAbsent(key, new LinkedHashSet());
            Set<Integer> trapGroupWithVertexIndices = trapGroupsWithVertexIndices.get(key);
            trapGroupWithVertexIndices.add(vertexIndex);
        }
    }

    private static long toKey(int currentLayer, int trapVertexLayer, int trapVertexIndex, int numberOfRelatedVertices) {
        return (long)Math.abs(trapVertexLayer - currentLayer) * 10000000000L + (long)numberOfRelatedVertices * 50000L + (long)trapVertexIndex;
    }

    private static int fromKeyToTrapVertexIndex(long key) {
        return (int)(key % 10000000000L % 50000L);
    }

    public record Result(int[][][] layerToTopTrapGroupsWithVertexIndices, int[][][] layerToBottomTrapGroupsWithVertexIndices, int[][] layerToTopTrapVertexIndices, int[][] layerToBottomTrapVertexIndices) {
    }
}

