/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.step2.custom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import vg.lib.layout.hierarchical.step2.custom.CustomConfig;
import vg.lib.operation.Operation;

public class CustomExtractChains
implements Operation<Result> {
    private final int[] vertexIndexToType;
    private final int[][] vertexIndexToInputEdgeIndices;
    private final int[][] vertexIndexToOutputEdgeIndices;
    private final int[] vertexIndexToLayer;
    private final int numberOfEdges;
    private final int[] edgeIndexToType;
    private final int[] edgeIndexToSrcVertexIndex;
    private final int[] edgeIndexToTrgVertexIndex;
    private final int numberOfLayers;
    private final int[][] layerToVertexIndices;

    public CustomExtractChains(int[] vertexIndexToType, int[][] vertexIndexToInputEdgeIndices, int[][] vertexIndexToOutputEdgeIndices, int[] vertexIndexToLayer, int numberOfEdges, int[] edgeIndexToType, int[] edgeIndexToSrcVertexIndex, int[] edgeIndexToTrgVertexIndex, int numberOfLayers, int[][] layerToVertexIndices) {
        this.vertexIndexToType = vertexIndexToType;
        this.vertexIndexToInputEdgeIndices = vertexIndexToInputEdgeIndices;
        this.vertexIndexToOutputEdgeIndices = vertexIndexToOutputEdgeIndices;
        this.vertexIndexToLayer = vertexIndexToLayer;
        this.numberOfEdges = numberOfEdges;
        this.edgeIndexToType = edgeIndexToType;
        this.edgeIndexToSrcVertexIndex = edgeIndexToSrcVertexIndex;
        this.edgeIndexToTrgVertexIndex = edgeIndexToTrgVertexIndex;
        this.numberOfLayers = numberOfLayers;
        this.layerToVertexIndices = layerToVertexIndices;
    }

    @Override
    public Result execute() {
        boolean[] layerToIsDummy = this.findLayerToIsDummy(this.numberOfLayers, this.layerToVertexIndices, this.vertexIndexToType);
        HashMap<Integer, Integer> chainIndexToStartVertexIndex = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> chainIndexToFinishVertexIndex = new HashMap<Integer, Integer>();
        int[] edgeIndexToChainIndex = new int[this.numberOfEdges];
        Arrays.fill(edgeIndexToChainIndex, -1);
        int chainIndexCounter = 0;
        HashMap<Integer, Integer> lastVertexIndexToChainIndex = new HashMap<Integer, Integer>();
        for (int layer = 0; layer < this.numberOfLayers; ++layer) {
            int[] vertexIndices;
            for (int vertexIndex : vertexIndices = this.layerToVertexIndices[layer]) {
                int[] outputEdgeIndices;
                for (int outputEdgeIndex : outputEdgeIndices = this.vertexIndexToOutputEdgeIndices[vertexIndex]) {
                    int edgeType;
                    if (edgeIndexToChainIndex[outputEdgeIndex] >= 0 || (edgeType = this.edgeIndexToType[outputEdgeIndex]) != 15 && edgeType != 16) continue;
                    Integer chainIndex = (Integer)lastVertexIndexToChainIndex.remove(vertexIndex);
                    if (chainIndex == null) {
                        chainIndex = chainIndexCounter;
                        chainIndexToStartVertexIndex.put(chainIndex, vertexIndex);
                        ++chainIndexCounter;
                    }
                    int trgVertexIndex = this.edgeIndexToTrgVertexIndex[outputEdgeIndex];
                    int[] trgInputEdgeIndices = this.vertexIndexToInputEdgeIndices[trgVertexIndex];
                    int[] trgOutputEdgeIndices = this.vertexIndexToOutputEdgeIndices[trgVertexIndex];
                    if (trgInputEdgeIndices.length == 1 && trgOutputEdgeIndices.length == 1 && (this.edgeIndexToType[trgOutputEdgeIndices[0]] == 15 || this.edgeIndexToType[trgOutputEdgeIndices[0]] == 16)) {
                        lastVertexIndexToChainIndex.put(trgVertexIndex, chainIndex);
                    } else {
                        chainIndexToFinishVertexIndex.put(chainIndex, trgVertexIndex);
                    }
                    edgeIndexToChainIndex[outputEdgeIndex] = chainIndex;
                }
            }
        }
        Validate.isTrue((boolean)lastVertexIndexToChainIndex.isEmpty());
        Validate.isTrue((chainIndexToStartVertexIndex.size() == chainIndexToFinishVertexIndex.size() ? 1 : 0) != 0);
        ArrayList<Integer> chainIndexToStartVertexIndexResult = new ArrayList<Integer>();
        ArrayList<Integer> chainIndexToFinishVertexIndexResult = new ArrayList<Integer>();
        HashMap<Integer, Integer> chainIndexBeforeExcludeToChainIndex = new HashMap<Integer, Integer>();
        for (int chainIndex = 0; chainIndex < chainIndexCounter; ++chainIndex) {
            Integer startVertexIndex = (Integer)chainIndexToStartVertexIndex.get(chainIndex);
            Integer finishVertexIndex = (Integer)chainIndexToFinishVertexIndex.get(chainIndex);
            if (this.vertexIndexToType[startVertexIndex] == 4 && this.vertexIndexToType[finishVertexIndex] == 4 && this.vertexIndexToLayer[finishVertexIndex] - this.vertexIndexToLayer[startVertexIndex] == 2 && layerToIsDummy[this.vertexIndexToLayer[startVertexIndex] + 1]) continue;
            chainIndexBeforeExcludeToChainIndex.put(chainIndex, chainIndexToStartVertexIndexResult.size());
            chainIndexToStartVertexIndexResult.add(startVertexIndex);
            chainIndexToFinishVertexIndexResult.add(finishVertexIndex);
        }
        int[] edgeIndexToChainIndexAfterExclude = new int[this.numberOfEdges];
        for (int edgeIndex = 0; edgeIndex < this.numberOfEdges; ++edgeIndex) {
            int chainIndexBeforeExclude;
            int chainIndexAfterExclude = chainIndexBeforeExclude = edgeIndexToChainIndex[edgeIndex];
            if (chainIndexBeforeExclude >= 0) {
                chainIndexAfterExclude = chainIndexBeforeExcludeToChainIndex.getOrDefault(chainIndexBeforeExclude, -1);
            }
            edgeIndexToChainIndexAfterExclude[edgeIndex] = chainIndexAfterExclude;
        }
        int numberOfChains = chainIndexToStartVertexIndexResult.size();
        return new Result(numberOfChains, chainIndexToStartVertexIndexResult.stream().mapToInt(Integer::intValue).toArray(), chainIndexToFinishVertexIndexResult.stream().mapToInt(Integer::intValue).toArray(), edgeIndexToChainIndexAfterExclude, this.findLayerToChainIndicesWithVertexIndices(edgeIndexToChainIndexAfterExclude));
    }

    private long[][] findLayerToChainIndicesWithVertexIndices(int[] edgeIndexToChainIndex) {
        LinkedHashMap<Integer, Set<Object>> layerToChainIndicesWithVertexIndices = new LinkedHashMap<Integer, Set<Object>>();
        for (int edgeIndex = 0; edgeIndex < this.numberOfEdges; ++edgeIndex) {
            int chainIndex = edgeIndexToChainIndex[edgeIndex];
            if (chainIndex < 0) continue;
            int srcVertexIndex = this.edgeIndexToSrcVertexIndex[edgeIndex];
            int trgVertexIndex = this.edgeIndexToTrgVertexIndex[edgeIndex];
            int srcLayer = this.vertexIndexToLayer[srcVertexIndex];
            int trgLayer = this.vertexIndexToLayer[trgVertexIndex];
            layerToChainIndicesWithVertexIndices.putIfAbsent(srcLayer, new LinkedHashSet());
            layerToChainIndicesWithVertexIndices.putIfAbsent(trgLayer, new LinkedHashSet());
            long chainIndexWithSrcVertexIndex = CustomConfig.toChainIndexWithVertexIndex(chainIndex, srcVertexIndex);
            long chainIndexWithTrgVertexIndex = CustomConfig.toChainIndexWithVertexIndex(chainIndex, trgVertexIndex);
            ((Set)layerToChainIndicesWithVertexIndices.get(srcLayer)).add(chainIndexWithSrcVertexIndex);
            ((Set)layerToChainIndicesWithVertexIndices.get(trgLayer)).add(chainIndexWithTrgVertexIndex);
        }
        long[][] result = new long[this.numberOfLayers][];
        for (int layer = 0; layer < this.numberOfLayers; ++layer) {
            result[layer] = layerToChainIndicesWithVertexIndices.getOrDefault(layer, Collections.emptySet()).stream().mapToLong(Long::longValue).toArray();
        }
        return result;
    }

    private boolean[] findLayerToIsDummy(int numberOfLayers, int[][] layerToVertexIndices, int[] vertexIndexToType) {
        boolean[] layerToIsDummy = new boolean[numberOfLayers];
        for (int layer = 0; layer < numberOfLayers; ++layer) {
            boolean isDummy = true;
            for (int vertexIndex : layerToVertexIndices[layer]) {
                if (vertexIndexToType[vertexIndex] != 4) continue;
                isDummy = false;
                break;
            }
            layerToIsDummy[layer] = isDummy;
        }
        return layerToIsDummy;
    }

    public record Result(int numberOfChains, int[] chainIndexToStartVertexIndex, int[] chainIndexToFinishVertexIndex, int[] edgeIndexToChainIndex, long[][] layerToChainIndicesWithVertexIndices) {
    }
}

