/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.step2.custom;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vg.lib.layout.hierarchical.data.HierarchicalEdge;
import vg.lib.layout.hierarchical.data.HierarchicalGraph;
import vg.lib.layout.hierarchical.data.HierarchicalVertex;
import vg.lib.layout.hierarchical.step2.custom.CustomCrossingReductionForOneGroupOperation;
import vg.lib.layout.hierarchical.step2.data.CrossingReductionOperationResult;
import vg.lib.operation.Procedure;

public class CustomCrossingReductionProcedure
implements Procedure {
    private static final Logger log = LoggerFactory.getLogger(CustomCrossingReductionProcedure.class);
    private final HierarchicalGraph graph;

    public CustomCrossingReductionProcedure(HierarchicalGraph graph) {
        this.graph = graph;
    }

    @Override
    public void execute() {
        log.debug("Use custom crossing reduction procedure...");
        this.graph.resetOrders();
        int[] groupIds = this.graph.getGroupIds();
        log.debug("Number of groups is '{}'.", (Object)groupIds.length);
        int prevMaxGroupOrder = 0;
        for (int groupId : groupIds) {
            log.debug("Handle group {}.", (Object)groupId);
            ArrayList<UUID> vertices = new ArrayList<UUID>();
            ArrayList<UUID> dummyVertices = new ArrayList<UUID>();
            LinkedHashMap<UUID, Integer> vertexIdToLayer = new LinkedHashMap<UUID, Integer>();
            LinkedHashMap<UUID, Integer> vertexIdToInitialOrder = new LinkedHashMap<UUID, Integer>();
            LinkedHashMap<UUID, String> vertexIdToName = new LinkedHashMap<UUID, String>();
            LinkedHashMap<UUID, HierarchicalVertex> vertexIdToVertex = new LinkedHashMap<UUID, HierarchicalVertex>();
            for (HierarchicalVertex vertex : this.graph.getVerticesByGroupId(groupId)) {
                vertices.add(vertex.getVertexId());
                vertexIdToLayer.put(vertex.getVertexId(), vertex.getLevel());
                vertexIdToInitialOrder.put(vertex.getVertexId(), vertex.getInitialPortIndex());
                vertexIdToName.put(vertex.getVertexId(), vertex.getName());
                vertexIdToVertex.put(vertex.getVertexId(), vertex);
                if (!vertex.isFakeVertex()) continue;
                dummyVertices.add(vertex.getVertexId());
            }
            LinkedHashMap<UUID, Map.Entry<UUID, UUID>> edgeIdToNodeIds = new LinkedHashMap<UUID, Map.Entry<UUID, UUID>>();
            LinkedHashMap<UUID, Map.Entry<Integer, Integer>> edgeIdToPortIndices = new LinkedHashMap<UUID, Map.Entry<Integer, Integer>>();
            for (HierarchicalEdge edge : this.graph.getEdgesByGroupId(groupId)) {
                edgeIdToNodeIds.put(edge.getId(), Map.entry(edge.getSrcVertex().getVertexId(), edge.getTrgVertex().getVertexId()));
                edgeIdToPortIndices.put(edge.getId(), Map.entry(edge.getSrcPortIndex(), edge.getTrgPortIndex()));
            }
            CrossingReductionOperationResult result = new CustomCrossingReductionForOneGroupOperation(vertices, edgeIdToNodeIds, edgeIdToPortIndices, vertexIdToLayer, dummyVertices, vertexIdToInitialOrder, vertexIdToName).execute();
            int currMaxGroupOrder = 0;
            for (int vertexIndex = 0; vertexIndex < result.numberOfVertices; ++vertexIndex) {
                UUID vertexId = result.vertexIndexToId[vertexIndex];
                int order = result.vertexIndexToOrder[vertexIndex];
                HierarchicalVertex vertex = (HierarchicalVertex)vertexIdToVertex.get(vertexId);
                vertex.setOrder(prevMaxGroupOrder + order);
                if (prevMaxGroupOrder + order <= currMaxGroupOrder) continue;
                currMaxGroupOrder = prevMaxGroupOrder + order;
            }
            prevMaxGroupOrder = currMaxGroupOrder + 1;
            this.graph.crosses += result.numberOfCrosses;
            log.debug("Group {} was handled. Number of crosses: {}.", (Object)groupId, (Object)result.numberOfCrosses);
            log.debug("Chains: {}.", (Object)result.chainIndexToStartVertexIndex.length);
            for (int chainIndex = 0; chainIndex < result.chainIndexToStartVertexIndex.length; ++chainIndex) {
                UUID startVertexId = result.vertexIndexToId[result.chainIndexToStartVertexIndex[chainIndex]];
                UUID finishVertexId = result.vertexIndexToId[result.chainIndexToFinishVertexIndex[chainIndex]];
                String startVertexName = vertexIdToName.get(startVertexId);
                String finishVertexName = vertexIdToName.get(finishVertexId);
                log.debug("{}: '{}'  ->  '{}'", new Object[]{chainIndex, startVertexName, finishVertexName});
            }
            log.debug("Weight to number of vertices: ");
            for (int weight = 0; weight < result.weightToVertexIndices.length; ++weight) {
                if (result.weightToVertexIndices[weight].length == 0) continue;
                log.debug("'{}'  ->  '{}'", (Object)weight, (Object)result.weightToVertexIndices[weight].length);
            }
        }
        log.debug("Crossing reduction operation was finished. Amount of crosses: {}", (Object)this.graph.crosses);
    }
}

