/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.step2.custom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vg.lib.config.VGConfigSettings;
import vg.lib.layout.hierarchical.step2.custom.CustomConfig;
import vg.lib.layout.hierarchical.step2.custom.CustomExtractChains;
import vg.lib.layout.hierarchical.step2.custom.CustomExtractTraps;
import vg.lib.layout.hierarchical.step2.custom.CustomSplitVerticesIntoGroups;
import vg.lib.layout.hierarchical.step2.data.CrossingReductionOperationResult;
import vg.lib.operation.Operation;
import vg.lib.operation.ProcedureWithOneArg;

public class CustomCrossingReductionForOneGroupOperation
implements Operation<CrossingReductionOperationResult> {
    private static final Logger log = LoggerFactory.getLogger(CustomCrossingReductionForOneGroupOperation.class);
    private final List<UUID> vertexIds;
    private final Map<UUID, Map.Entry<UUID, UUID>> edgeIdToNodeIds;
    private final Map<UUID, Map.Entry<Integer, Integer>> edgeIdToPortIndices;
    private final Map<UUID, Integer> vertexIdToLayer;
    private final List<UUID> dummyVertexIds;
    private final Map<UUID, Integer> vertexIdToInitialOrder;
    private final Map<UUID, String> vertexIdToName;
    private int numberOfVertices;
    private UUID[] vertexIndexToId;
    private boolean[] vertexIndexToIsDummy;
    private boolean[] vertexIndexToIsFixed;
    private boolean[] vertexIndexToDisabled;
    private int[] vertexIndexToType;
    private int[] vertexIndexToWeight;
    private int[][] weightToVertexIndices;
    private int[] weightToDirection;
    private int[] vertexIndexToLayer;
    private int[] cycleVertexIndexToParentVertexIndex;
    private int[][] layerToVertexIndices;
    private int numberOfEdges;
    private int[] edgeIndexToType;
    private int[] edgeIndexToSrcVertexIndex;
    private int[] edgeIndexToTrgVertexIndex;
    private int[] edgeIndexToSrcPortIndex;
    private int[] edgeIndexToTrgPortIndex;
    private int[][] vertexIndexToInputEdgeIndices;
    private int[][] vertexIndexToOutputEdgeIndices;
    private int[][] vertexIndexToInputVertexIndices;
    private int[][] vertexIndexToOutputVertexIndices;
    private int[][] layerToInputEdgeIndices;
    private int[][] layerToOutputEdgeIndices;
    private int maxLayer;
    private int numberOfLayers;
    private int numberOfChains;
    private int[] chainIndexToStartVertexIndex;
    private int[] chainIndexToFinishVertexIndex;
    private int[] edgeIndexToChainIndex;
    private long[][] layerToChainIndicesWithVertexIndices;
    private int[][][] layerToTopTrapGroupsWithVertexIndices;
    private int[][][] layerToBottomTrapGroupsWithVertexIndices;
    private int[][] layerToTopTrapVertexIndices;
    private int[][] layerToBottomTrapVertexIndices;
    private int[] vertexIndexToOrder;
    private int[][] layerToOrderToVertexIndices;
    private int[][] layerToOrderToVertexIndicesBestSolution;
    private int[][] layerToOrderToVertexIndicesTemp1;
    private int[][] layerToOrderToVertexIndicesTemp2;
    private int[][] layerToVertexIndicesWithPriority;
    private boolean[] _countChainsCrossesWithTrapsVertexIndexToBoolean;
    private int[] _orderLayerVertexIndicesStack;
    private boolean enableDiagnosticMode;
    private long countCrossesTime;
    private long countChainsCrossesWithTrapsTime;
    private long countNeighborhoodAnomaliesTime;
    private long orderLayerUnsuccessfulSwap;
    private long orderLayerSuccessfulSwap;

    public CustomCrossingReductionForOneGroupOperation(List<UUID> vertexIds, Map<UUID, Map.Entry<UUID, UUID>> edgeIdToNodeIds, Map<UUID, Map.Entry<Integer, Integer>> edgeIdToPortIndices, Map<UUID, Integer> vertexIdToLayer, List<UUID> dummyVertexIds, Map<UUID, Integer> vertexIdToInitialOrder, Map<UUID, String> vertexIdToName) {
        this.vertexIds = vertexIds;
        this.edgeIdToNodeIds = edgeIdToNodeIds;
        this.edgeIdToPortIndices = edgeIdToPortIndices;
        this.vertexIdToLayer = vertexIdToLayer;
        this.dummyVertexIds = dummyVertexIds;
        this.vertexIdToInitialOrder = vertexIdToInitialOrder;
        this.vertexIdToName = vertexIdToName;
    }

    @Override
    public CrossingReductionOperationResult execute() {
        this.init();
        int numberOfCrossesBefore = this.countCrosses();
        this.enableDiagnosticMode = VGConfigSettings.DIAGNOSTIC_MODE;
        long[] layerToNumberOfCrossesFromTopToBottomBefore = this.countLayerToNumberOfCrossesFromTopToBottom();
        long[] layerToNumberOfCrossesFromBottomToTopBefore = this.countLayerToNumberOfCrossesFromBottomToTop();
        long[] layerToNumberOfChainCrossesWithTopTrapsBefore = this.countLayerToNumberOfCrossesBetweenChainsAndTopTraps();
        long[] layerToNumberOfChainCrossesWithBottomTrapsBefore = this.countLayerToNumberOfCrossesBetweenChainsAndBottomTraps();
        long[] layerToNumberOfNeighborhoodAnomaliesBefore = this.countLayerToNumberOfNeighborhoodAnomalies();
        this.enableDiagnosticMode = false;
        long[][] prevLayerWeights = new long[][]{{1L, 50000L}, {4L, 1L}};
        long[][] prevLayerAndChainsWeights = new long[][]{{1L, 50000000000000L}, {3L, 500000000L}, {2L, 50000L}, {4L, 1L}};
        long[][] prevAndNextLayersWeights = new long[][]{{1L, 1000000000L}, {2L, 1000000000L}, {3L, 50000L}, {4L, 1L}};
        CustomSplitVerticesIntoGroups.Result splitVerticesIntoGroupsResult = new CustomSplitVerticesIntoGroups(this.numberOfVertices, this.vertexIndexToType, this.vertexIndexToInputVertexIndices, this.vertexIndexToOutputVertexIndices, this.vertexIndexToInputEdgeIndices, this.vertexIndexToOutputEdgeIndices, this.vertexIndexToLayer, this.numberOfEdges, this.edgeIndexToSrcVertexIndex, this.edgeIndexToTrgVertexIndex, this.edgeIndexToChainIndex, this.numberOfLayers, this.layerToVertexIndices, this.numberOfChains, this.chainIndexToStartVertexIndex, this.chainIndexToFinishVertexIndex, this.cycleVertexIndexToParentVertexIndex).execute();
        this.weightToVertexIndices = splitVerticesIntoGroupsResult.weightToVertexIndices();
        this.weightToDirection = splitVerticesIntoGroupsResult.weightToDirection();
        this.vertexIndexToWeight = splitVerticesIntoGroupsResult.vertexIndexToWeight();
        this.diagnosticPrintGroups();
        long startTime = System.currentTimeMillis();
        this.orderLayers(prevLayerWeights, prevLayerAndChainsWeights, prevAndNextLayersWeights);
        int crossesAfterOrderLayers = this.countCrosses();
        long orderLayersTime = System.currentTimeMillis() - startTime;
        log.debug("\nCrosses after order layers = {},\ncountCrossesTime = {}ms\ncountChainsCrossesWithTrapsTime = {}ms\ncountNeighborhoodAnomaliesTime = {}ms\norderLayersTime={}ms\n\norderLayerSuccessfulSwap={}, orderLayerUnsuccessfulSwap={}, percent={}", new Object[]{crossesAfterOrderLayers, this.countCrossesTime, this.countChainsCrossesWithTrapsTime, this.countNeighborhoodAnomaliesTime, orderLayersTime, this.orderLayerSuccessfulSwap, this.orderLayerUnsuccessfulSwap, Float.valueOf((float)this.orderLayerSuccessfulSwap / (float)(this.orderLayerSuccessfulSwap + this.orderLayerUnsuccessfulSwap + 1L) * 100.0f)});
        int numberOfCrosses = this.countCrosses();
        return CrossingReductionOperationResult.builder().numberOfVertices(this.numberOfVertices).vertexIndexToId(this.vertexIndexToId).vertexIndexToOrder(this.vertexIndexToOrder).numberOfCrosses(numberOfCrosses).vertexIndexToWeight(this.vertexIndexToWeight).weightToVertexIndices(this.weightToVertexIndices).edgeIndexToType(this.edgeIndexToType).cycleVertexIndexToParentVertexIndex(this.cycleVertexIndexToParentVertexIndex).chainIndexToStartVertexIndex(this.chainIndexToStartVertexIndex).chainIndexToFinishVertexIndex(this.chainIndexToFinishVertexIndex).layerToChainIndicesWithVertexIndices(this.layerToChainIndicesWithVertexIndices).layerToTopTrapGroupsWithVertexIndices(this.layerToTopTrapGroupsWithVertexIndices).layerToBottomTrapGroupsWithVertexIndices(this.layerToBottomTrapGroupsWithVertexIndices).layerToTopTrapVertexIndices(this.layerToTopTrapVertexIndices).layerToBottomTrapVertexIndices(this.layerToBottomTrapVertexIndices).numberOfCrossesBefore(numberOfCrossesBefore).layerToNumberOfCrossesFromTopToBottomBefore(layerToNumberOfCrossesFromTopToBottomBefore).layerToNumberOfCrossesFromBottomToTopBefore(layerToNumberOfCrossesFromBottomToTopBefore).layerToNumberOfChainCrossesWithTopTrapsBefore(layerToNumberOfChainCrossesWithTopTrapsBefore).layerToNumberOfChainCrossesWithBottomTrapsBefore(layerToNumberOfChainCrossesWithBottomTrapsBefore).layerToNumberOfNeighborhoodAnomaliesBefore(layerToNumberOfNeighborhoodAnomaliesBefore).build();
    }

    private void saveToBestSolution() {
        for (int layer = 0; layer < this.numberOfLayers; ++layer) {
            System.arraycopy(this.layerToOrderToVertexIndices[layer], 0, this.layerToOrderToVertexIndicesBestSolution[layer], 0, this.layerToOrderToVertexIndices[layer].length);
        }
    }

    private void saveToTemp1() {
        for (int layer = 0; layer < this.numberOfLayers; ++layer) {
            System.arraycopy(this.layerToOrderToVertexIndices[layer], 0, this.layerToOrderToVertexIndicesTemp1[layer], 0, this.layerToOrderToVertexIndices[layer].length);
        }
    }

    private void saveToTemp2() {
        for (int layer = 0; layer < this.numberOfLayers; ++layer) {
            System.arraycopy(this.layerToOrderToVertexIndices[layer], 0, this.layerToOrderToVertexIndicesTemp2[layer], 0, this.layerToOrderToVertexIndices[layer].length);
        }
    }

    private void revertFromBestSolution() {
        for (int layer = 0; layer < this.numberOfLayers; ++layer) {
            for (int order = 0; order < this.layerToOrderToVertexIndicesBestSolution[layer].length; ++order) {
                int vertexIndex = this.layerToOrderToVertexIndicesBestSolution[layer][order];
                this.vertexIndexToOrder[vertexIndex] = order;
                this.layerToOrderToVertexIndices[layer][order] = this.layerToOrderToVertexIndicesBestSolution[layer][order];
            }
        }
    }

    private void revertFromTemp1() {
        for (int layer = 0; layer < this.numberOfLayers; ++layer) {
            for (int order = 0; order < this.layerToOrderToVertexIndicesTemp1[layer].length; ++order) {
                int vertexIndex = this.layerToOrderToVertexIndicesTemp1[layer][order];
                this.vertexIndexToOrder[vertexIndex] = order;
                this.layerToOrderToVertexIndices[layer][order] = this.layerToOrderToVertexIndicesTemp1[layer][order];
            }
        }
    }

    private void revertFromTemp2() {
        for (int layer = 0; layer < this.numberOfLayers; ++layer) {
            for (int order = 0; order < this.layerToOrderToVertexIndicesTemp2[layer].length; ++order) {
                int vertexIndex = this.layerToOrderToVertexIndicesTemp2[layer][order];
                this.vertexIndexToOrder[vertexIndex] = order;
                this.layerToOrderToVertexIndices[layer][order] = this.layerToOrderToVertexIndicesTemp2[layer][order];
            }
        }
    }

    private void init() {
        int layer;
        this.numberOfVertices = this.vertexIds.size();
        this.vertexIndexToId = new UUID[this.numberOfVertices];
        HashMap<UUID, Integer> vertexIdToIndex = new HashMap<UUID, Integer>();
        this.vertexIndexToLayer = new int[this.numberOfVertices];
        this.maxLayer = Integer.MIN_VALUE;
        for (int vertexIndex = 0; vertexIndex < this.numberOfVertices; ++vertexIndex) {
            UUID vertexId;
            this.vertexIndexToId[vertexIndex] = vertexId = this.vertexIds.get(vertexIndex);
            vertexIdToIndex.put(vertexId, vertexIndex);
            int layer2 = this.vertexIdToLayer.get(vertexId);
            if (layer2 > this.maxLayer) {
                this.maxLayer = layer2;
            }
            this.vertexIndexToLayer[vertexIndex] = layer2;
        }
        if (this.maxLayer == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Map 'vertexIdToLayer' contains incorrect data.");
        }
        this.numberOfLayers = this.maxLayer + 1;
        this.vertexIndexToIsDummy = this.findVertexToIsDummy(this.dummyVertexIds, vertexIdToIndex);
        this.vertexIndexToIsFixed = this.findVertexIndexToIsFixed(this.vertexIdToInitialOrder, this.vertexIndexToId);
        this.vertexIndexToDisabled = new boolean[this.numberOfVertices];
        this.numberOfEdges = this.edgeIdToNodeIds.size();
        this.edgeIndexToSrcVertexIndex = new int[this.numberOfEdges];
        this.edgeIndexToTrgVertexIndex = new int[this.numberOfEdges];
        this.edgeIndexToSrcPortIndex = new int[this.numberOfEdges];
        this.edgeIndexToTrgPortIndex = new int[this.numberOfEdges];
        HashMap tmpVertexIndexToInputVertexIndices = new HashMap();
        HashMap tmpVertexIndexToOutputVertexIndices = new HashMap();
        HashMap tmpVertexIndexToInputEdgeIndices = new HashMap();
        HashMap tmpVertexIndexToOutputEdgeIndices = new HashMap();
        HashMap<Integer, List<Object>> tmpLayerToInputEdgeIndices = new HashMap<Integer, List<Object>>();
        HashMap<Integer, List<Object>> tmpLayerToOutputEdgeIndices = new HashMap<Integer, List<Object>>();
        int edgeIndex = 0;
        for (Map.Entry<UUID, Map.Entry<UUID, UUID>> edgeToNodesEntry : this.edgeIdToNodeIds.entrySet()) {
            UUID edgeId = edgeToNodesEntry.getKey();
            UUID srcVertexId = edgeToNodesEntry.getValue().getKey();
            UUID trgVertexId = edgeToNodesEntry.getValue().getValue();
            int srcIndex = vertexIdToIndex.get(srcVertexId);
            int trgIndex = vertexIdToIndex.get(trgVertexId);
            this.edgeIndexToSrcVertexIndex[edgeIndex] = srcIndex;
            this.edgeIndexToTrgVertexIndex[edgeIndex] = trgIndex;
            tmpVertexIndexToInputVertexIndices.putIfAbsent(trgIndex, new ArrayList());
            tmpVertexIndexToOutputVertexIndices.putIfAbsent(srcIndex, new ArrayList());
            tmpVertexIndexToInputEdgeIndices.putIfAbsent(trgIndex, new ArrayList());
            tmpVertexIndexToOutputEdgeIndices.putIfAbsent(srcIndex, new ArrayList());
            ((List)tmpVertexIndexToInputVertexIndices.get(trgIndex)).add(srcIndex);
            ((List)tmpVertexIndexToOutputVertexIndices.get(srcIndex)).add(trgIndex);
            ((List)tmpVertexIndexToInputEdgeIndices.get(trgIndex)).add(edgeIndex);
            ((List)tmpVertexIndexToOutputEdgeIndices.get(srcIndex)).add(edgeIndex);
            Map.Entry portIndices = this.edgeIdToPortIndices.getOrDefault(edgeId, null);
            this.edgeIndexToSrcPortIndex[edgeIndex] = -1;
            this.edgeIndexToTrgPortIndex[edgeIndex] = -1;
            if (portIndices != null) {
                this.edgeIndexToSrcPortIndex[edgeIndex] = (Integer)portIndices.getKey();
                this.edgeIndexToTrgPortIndex[edgeIndex] = (Integer)portIndices.getValue();
            }
            int srcLayer = this.vertexIndexToLayer[srcIndex];
            int trgLayer = this.vertexIndexToLayer[trgIndex];
            tmpLayerToInputEdgeIndices.putIfAbsent(trgLayer, new ArrayList());
            tmpLayerToOutputEdgeIndices.putIfAbsent(srcLayer, new ArrayList());
            ((List)tmpLayerToInputEdgeIndices.get(trgLayer)).add(edgeIndex);
            ((List)tmpLayerToOutputEdgeIndices.get(srcLayer)).add(edgeIndex);
            ++edgeIndex;
        }
        this.vertexIndexToInputVertexIndices = new int[this.numberOfVertices][];
        this.vertexIndexToOutputVertexIndices = new int[this.numberOfVertices][];
        this.vertexIndexToInputEdgeIndices = new int[this.numberOfVertices][];
        this.vertexIndexToOutputEdgeIndices = new int[this.numberOfVertices][];
        for (int vertexIndex = 0; vertexIndex < this.numberOfVertices; ++vertexIndex) {
            this.vertexIndexToInputVertexIndices[vertexIndex] = tmpVertexIndexToInputVertexIndices.getOrDefault(vertexIndex, List.of()).stream().mapToInt(Integer::intValue).toArray();
            this.vertexIndexToOutputVertexIndices[vertexIndex] = tmpVertexIndexToOutputVertexIndices.getOrDefault(vertexIndex, List.of()).stream().mapToInt(Integer::intValue).toArray();
            this.vertexIndexToInputEdgeIndices[vertexIndex] = tmpVertexIndexToInputEdgeIndices.getOrDefault(vertexIndex, List.of()).stream().mapToInt(Integer::intValue).toArray();
            this.vertexIndexToOutputEdgeIndices[vertexIndex] = tmpVertexIndexToOutputEdgeIndices.getOrDefault(vertexIndex, List.of()).stream().mapToInt(Integer::intValue).toArray();
        }
        this.vertexIndexToType = this.findVertexIndexToType();
        this.layerToVertexIndices = this.findLayerToVertexIndices();
        this.edgeIndexToType = this.findEdgeTypes();
        this.cycleVertexIndexToParentVertexIndex = this.findCycleVertexIndexToParentVertexIndex();
        CustomExtractChains.Result extractChainsResult = new CustomExtractChains(this.vertexIndexToType, this.vertexIndexToInputEdgeIndices, this.vertexIndexToOutputEdgeIndices, this.vertexIndexToLayer, this.numberOfEdges, this.edgeIndexToType, this.edgeIndexToSrcVertexIndex, this.edgeIndexToTrgVertexIndex, this.numberOfLayers, this.layerToVertexIndices).execute();
        this.numberOfChains = extractChainsResult.numberOfChains();
        this.chainIndexToStartVertexIndex = extractChainsResult.chainIndexToStartVertexIndex();
        this.chainIndexToFinishVertexIndex = extractChainsResult.chainIndexToFinishVertexIndex();
        this.edgeIndexToChainIndex = extractChainsResult.edgeIndexToChainIndex();
        this.layerToChainIndicesWithVertexIndices = extractChainsResult.layerToChainIndicesWithVertexIndices();
        this.layerToOrderToVertexIndices = new int[this.numberOfLayers][];
        this.layerToOrderToVertexIndicesBestSolution = new int[this.numberOfLayers][];
        this.layerToOrderToVertexIndicesTemp1 = new int[this.numberOfLayers][];
        this.layerToOrderToVertexIndicesTemp2 = new int[this.numberOfLayers][];
        this.vertexIndexToOrder = new int[this.numberOfVertices];
        this.layerToVertexIndicesWithPriority = new int[this.numberOfLayers][];
        for (layer = 0; layer < this.numberOfLayers; ++layer) {
            this.layerToOrderToVertexIndices[layer] = new int[this.layerToVertexIndices[layer].length];
            this.layerToOrderToVertexIndicesBestSolution[layer] = new int[this.layerToVertexIndices[layer].length];
            this.layerToOrderToVertexIndicesTemp1[layer] = new int[this.layerToVertexIndices[layer].length];
            this.layerToOrderToVertexIndicesTemp2[layer] = new int[this.layerToVertexIndices[layer].length];
            this.layerToVertexIndicesWithPriority[layer] = new int[this.layerToVertexIndices[layer].length];
            Arrays.fill(this.layerToVertexIndicesWithPriority[layer], -1);
            int order = 0;
            while (order < this.layerToVertexIndices[layer].length) {
                int vertexIndex;
                this.layerToOrderToVertexIndices[layer][order] = vertexIndex = this.layerToVertexIndices[layer][order];
                this.vertexIndexToOrder[vertexIndex] = order++;
            }
        }
        this.layerToInputEdgeIndices = new int[this.numberOfLayers][];
        this.layerToOutputEdgeIndices = new int[this.numberOfLayers][];
        for (layer = 0; layer <= this.maxLayer; ++layer) {
            this.layerToInputEdgeIndices[layer] = tmpLayerToInputEdgeIndices.getOrDefault(layer, Collections.emptyList()).stream().mapToInt(Integer::intValue).toArray();
            this.layerToOutputEdgeIndices[layer] = tmpLayerToOutputEdgeIndices.getOrDefault(layer, Collections.emptyList()).stream().mapToInt(Integer::intValue).toArray();
        }
        CustomExtractTraps.Result extractTraps = new CustomExtractTraps(this.numberOfVertices, this.vertexIndexToInputVertexIndices, this.vertexIndexToOutputVertexIndices, this.vertexIndexToLayer, this.numberOfLayers, this.layerToVertexIndices).execute();
        this.layerToTopTrapGroupsWithVertexIndices = extractTraps.layerToTopTrapGroupsWithVertexIndices();
        this.layerToBottomTrapGroupsWithVertexIndices = extractTraps.layerToBottomTrapGroupsWithVertexIndices();
        this.layerToTopTrapVertexIndices = extractTraps.layerToTopTrapVertexIndices();
        this.layerToBottomTrapVertexIndices = extractTraps.layerToBottomTrapVertexIndices();
        this._countChainsCrossesWithTrapsVertexIndexToBoolean = new boolean[this.numberOfVertices];
        this._orderLayerVertexIndicesStack = new int[this.numberOfVertices];
        this.vertexIndexToWeight = new int[this.numberOfVertices];
        Arrays.fill(this.vertexIndexToWeight, 1);
    }

    private int tryToFindBetterSolution(long[][] weights) {
        this.saveToTemp1();
        TryToFindBetterSolutionResult fromTopToBottom = this.tryToFindBetterSolution(1, weights);
        this.saveToTemp2();
        this.revertFromTemp1();
        TryToFindBetterSolutionResult fromBottomToTop = this.tryToFindBetterSolution(2, weights);
        Validate.isTrue((fromTopToBottom.crossesBefore == fromBottomToTop.crossesBefore ? 1 : 0) != 0);
        if (fromTopToBottom.crossesAfter >= fromTopToBottom.crossesBefore && fromBottomToTop.crossesAfter >= fromBottomToTop.crossesBefore) {
            this.revertFromTemp1();
            return fromTopToBottom.crossesBefore;
        }
        if (fromBottomToTop.crossesAfter <= fromTopToBottom.crossesAfter) {
            return fromBottomToTop.crossesAfter;
        }
        this.revertFromTemp2();
        return fromTopToBottom.crossesAfter;
    }

    private TryToFindBetterSolutionResult tryToFindBetterSolution(int startDirection, long[][] weights) {
        int crossesBefore;
        assert (startDirection == 1 || startDirection == 2);
        this.saveToBestSolution();
        int crossesAfter = crossesBefore = this.countCrosses();
        int currentDirection = startDirection;
        int currentIteration = 0;
        while (true) {
            this.doPassage(currentDirection, weights);
            currentDirection = currentDirection == 1 ? 2 : 1;
            int crosses = this.countCrosses();
            if (crosses < crossesAfter) {
                crossesAfter = crosses;
                this.saveToBestSolution();
                continue;
            }
            if (currentIteration > 1) break;
            ++currentIteration;
        }
        this.revertFromBestSolution();
        return new TryToFindBetterSolutionResult(crossesBefore, crossesAfter);
    }

    private void orderLayers(long[][] prevLayerWeights, long[][] prevLayerAndChainsWeights, long[][] prevAndNextLayersWeights) {
        int maxWeight;
        this.orderLayerSuccessfulSwap = 0L;
        this.orderLayerUnsuccessfulSwap = 0L;
        boolean[] originalVertexIndexToIsFixed = Arrays.copyOf(this.vertexIndexToIsFixed, this.vertexIndexToIsFixed.length);
        Arrays.fill(this.vertexIndexToDisabled, true);
        int lastNumberOfCrosses = 0;
        ProcedureWithOneArg<Integer> markHandledVerticesAsFixed = weight -> {
            for (int vertexIndex = 0; vertexIndex < this.numberOfVertices; ++vertexIndex) {
                if (this.vertexIndexToWeight[vertexIndex] < weight) continue;
                this.vertexIndexToIsFixed[vertexIndex] = true;
            }
        };
        ProcedureWithOneArg<Integer> markHandledVerticesAsNotFixed = weight -> {
            for (int vertexIndex = 0; vertexIndex < this.numberOfVertices; ++vertexIndex) {
                if (this.vertexIndexToWeight[vertexIndex] != weight || originalVertexIndexToIsFixed[vertexIndex]) continue;
                this.vertexIndexToIsFixed[vertexIndex] = false;
            }
        };
        for (int weight2 = maxWeight = this.weightToVertexIndices.length - 1; weight2 >= 0; --weight2) {
            log.debug("Enable {}/{} group of vertices, number of vertices in the group = {}.", new Object[]{maxWeight - weight2, maxWeight, this.weightToVertexIndices[weight2].length});
            int direction = this.weightToDirection[weight2];
            int count = 0;
            if (direction == 1) {
                for (layer = 0; layer < this.numberOfLayers; ++layer) {
                    count += this.enableSuitableVertices(layer, 1, weight2, prevLayerAndChainsWeights);
                }
            } else if (direction == 2) {
                for (layer = this.numberOfLayers - 1; layer >= 0; --layer) {
                    count += this.enableSuitableVertices(layer, 2, weight2, prevLayerAndChainsWeights);
                }
            } else {
                for (layer = this.numberOfLayers - 1; layer >= 0; --layer) {
                    count += this.enableSuitableVertices(layer, 2, weight2, prevLayerAndChainsWeights);
                }
            }
            Validate.isTrue((this.weightToVertexIndices[weight2].length == count ? 1 : 0) != 0);
            markHandledVerticesAsNotFixed.execute(weight2);
            int fastCrosses0 = this.tryToFindBetterSolution(prevLayerWeights);
            int fastCrosses1 = this.tryToFindBetterSolution(prevLayerAndChainsWeights);
            int fastCrosses2 = this.tryToFindBetterSolution(prevAndNextLayersWeights);
            if (fastCrosses2 <= lastNumberOfCrosses) {
                log.debug("Skip slow finding better solution which better than current, weight = {}.", (Object)weight2);
                lastNumberOfCrosses = fastCrosses2;
                markHandledVerticesAsFixed.execute(weight2);
                continue;
            }
            System.arraycopy(originalVertexIndexToIsFixed, 0, this.vertexIndexToIsFixed, 0, this.vertexIndexToIsFixed.length);
            int slowCrosses0 = this.tryToFindBetterSolution(prevLayerWeights);
            int slowCrosses1 = this.tryToFindBetterSolution(prevLayerAndChainsWeights);
            int slowCrosses2 = this.tryToFindBetterSolution(prevAndNextLayersWeights);
            markHandledVerticesAsFixed.execute(weight2);
            log.debug("weight = {}, fast crosses = {} -> {} -> {}, slow crosses = {} -> {} -> {}", new Object[]{weight2, fastCrosses0, fastCrosses1, fastCrosses2, slowCrosses0, slowCrosses1, slowCrosses2});
            lastNumberOfCrosses = slowCrosses2;
        }
        System.arraycopy(originalVertexIndexToIsFixed, 0, this.vertexIndexToIsFixed, 0, this.vertexIndexToIsFixed.length);
    }

    private int enableSuitableVertices(int layer, int direction, int currentWeight, long[][] weights) {
        int parentVertexIndex;
        int currentOrder = this.layerToFirstDisabledVertexOrder(layer);
        int parentLayer = layer - 1;
        if (direction == 2) {
            parentLayer = layer + 1;
        }
        int[] parentVertexIndices = parentLayer < 0 || parentLayer >= this.numberOfLayers ? new int[]{} : this.layerToOrderToVertexIndices[parentLayer];
        int result = 0;
        while ((parentVertexIndex = this.findNextParentVertexIndexForEnabling(parentVertexIndices, direction, currentWeight)) >= 0) {
            int vertexIndex;
            int[] vertexIndices = direction == 1 ? this.vertexIndexToOutputVertexIndices[parentVertexIndex] : this.vertexIndexToInputVertexIndices[parentVertexIndex];
            while ((vertexIndex = this.findNextVertexIndexForEnabling(vertexIndices, currentWeight)) >= 0) {
                int fromVertexOrder = this.vertexIndexToOrder[vertexIndex];
                int toVertexOrder = this.findVertexOrderForEnabling(vertexIndex, layer, currentOrder);
                this.move(layer, fromVertexOrder, toVertexOrder);
                this.vertexIndexToDisabled[vertexIndex] = false;
                this.layerToVertexIndicesWithPriority[layer][currentOrder] = vertexIndex;
                this.orderLayer(layer, direction, weights, Integer.MAX_VALUE);
                this.vertexIndexToIsFixed[vertexIndex] = true;
                ++currentOrder;
                ++result;
            }
        }
        for (int vertexIndex : this.layerToOrderToVertexIndices[layer]) {
            if (!this.vertexIndexToDisabled[vertexIndex] || this.vertexIndexToWeight[vertexIndex] != currentWeight) continue;
            int fromVertexOrder = this.vertexIndexToOrder[vertexIndex];
            int toVertexOrder = this.findVertexOrderForEnabling(vertexIndex, layer, currentOrder);
            this.move(layer, fromVertexOrder, toVertexOrder);
            this.vertexIndexToDisabled[vertexIndex] = false;
            this.layerToVertexIndicesWithPriority[layer][currentOrder] = vertexIndex;
            this.orderLayer(layer, direction, weights, Integer.MAX_VALUE);
            this.vertexIndexToIsFixed[vertexIndex] = true;
            ++currentOrder;
            ++result;
        }
        return result;
    }

    private int findNextParentVertexIndexForEnabling(int[] parentVertexIndices, int direction, int currentWeight) {
        int suitableParentVertexIndex = -1;
        int suitableParentVertexIndexToWeight = Integer.MIN_VALUE;
        for (int parentVertexIndex : parentVertexIndices) {
            if (this.vertexIndexToDisabled[parentVertexIndex]) continue;
            int[] vertexIndices = direction == 1 ? this.vertexIndexToOutputVertexIndices[parentVertexIndex] : this.vertexIndexToInputVertexIndices[parentVertexIndex];
            int weight = 0;
            boolean check = false;
            for (int vertexIndex : vertexIndices) {
                if (!this.vertexIndexToDisabled[vertexIndex]) {
                    weight += 1000;
                    continue;
                }
                if (this.vertexIndexToWeight[vertexIndex] != currentWeight) continue;
                ++weight;
                check = true;
            }
            if (!check || weight <= suitableParentVertexIndexToWeight) continue;
            suitableParentVertexIndexToWeight = weight;
            suitableParentVertexIndex = parentVertexIndex;
        }
        return suitableParentVertexIndex;
    }

    private int findNextVertexIndexForEnabling(int[] vertexIndices, int currentWeight) {
        int suitableVertexIndex = -1;
        int suitableVertexIndexToWeight = Integer.MIN_VALUE;
        for (int vertexIndex : vertexIndices) {
            if (!this.vertexIndexToDisabled[vertexIndex] || this.vertexIndexToWeight[vertexIndex] != currentWeight) continue;
            int weightInput = 0;
            for (int inputVertexIndex : this.vertexIndexToInputVertexIndices[vertexIndex]) {
                if (this.vertexIndexToDisabled[inputVertexIndex]) continue;
                weightInput += this.vertexIndexToWeight[inputVertexIndex];
            }
            int weightOutput = 0;
            for (int outputVertexIndex : this.vertexIndexToOutputVertexIndices[vertexIndex]) {
                if (this.vertexIndexToDisabled[outputVertexIndex]) continue;
                weightOutput += this.vertexIndexToWeight[outputVertexIndex];
            }
            int weight = weightInput + weightOutput;
            if (weight <= suitableVertexIndexToWeight) continue;
            suitableVertexIndexToWeight = weight;
            suitableVertexIndex = vertexIndex;
        }
        return suitableVertexIndex;
    }

    private int findVertexOrderForEnabling(int vertexIndex, int layer, int maxVertexOrder) {
        if (!this.vertexIndexToIsFixed[vertexIndex]) {
            return maxVertexOrder;
        }
        UUID vertexId = this.vertexIndexToId[vertexIndex];
        Integer initialVertexOrder = this.vertexIdToInitialOrder.get(vertexId);
        assert (initialVertexOrder != null && initialVertexOrder >= 0);
        int result = maxVertexOrder;
        for (int vertexOrder = maxVertexOrder; vertexOrder >= 0; --vertexOrder) {
            int itVertexIndex = this.layerToOrderToVertexIndices[layer][vertexOrder];
            UUID itVertexId = this.vertexIndexToId[itVertexIndex];
            Integer itInitialVertexOrder = this.vertexIdToInitialOrder.get(itVertexId);
            if (itInitialVertexOrder == null || itInitialVertexOrder < 0 || itInitialVertexOrder <= initialVertexOrder) continue;
            result = vertexOrder;
        }
        return result;
    }

    private void doPassage(int direction, long[][] weights) {
        assert (direction == 1 || direction == 2);
        if (direction == 1) {
            for (int layer = 0; layer < this.numberOfLayers; ++layer) {
                this.orderLayer(layer, direction, weights, 5);
            }
        } else {
            for (int layer = this.maxLayer; layer >= 0; --layer) {
                this.orderLayer(layer, direction, weights, 5);
            }
        }
    }

    private void orderLayer(int layer, int direction, long[][] weights, int numberOfFailedMoves) {
        assert (direction == 1 || direction == 2);
        if (direction == 1) {
            this.orderLayer(layer, this.layerToInputEdgeIndices[layer], this.layerToOutputEdgeIndices[layer], weights, numberOfFailedMoves);
        } else {
            this.orderLayer(layer, this.layerToOutputEdgeIndices[layer], this.layerToInputEdgeIndices[layer], weights, numberOfFailedMoves);
        }
    }

    private void orderLayer(int layer, int[] edgeIndices, int[] additionalEdgeIndices, long[][] weights, int numberOfFailedMoves) {
        long currCost = this.calculateCost(layer, edgeIndices, additionalEdgeIndices, weights);
        if (currCost == 0L) {
            return;
        }
        int maxRightVertexOrder = this.layerToFirstDisabledVertexOrder(layer);
        if (maxRightVertexOrder <= 1) {
            return;
        }
        int currNumberOfFails = 0;
        boolean isFoundBetterSolution = true;
        while (isFoundBetterSolution) {
            isFoundBetterSolution = false;
            int _orderLayerVertexIndicesStackIndex = 0;
            for (int initialVertexOrder = 0; initialVertexOrder < maxRightVertexOrder; ++initialVertexOrder) {
                int initialVertexIndex = this.layerToVertexIndicesWithPriority[layer][initialVertexOrder];
                assert (initialVertexIndex != -1);
                assert (!this.vertexIndexToDisabled[initialVertexIndex]);
                if (this.vertexIndexToIsFixed[initialVertexIndex]) continue;
                this._orderLayerVertexIndicesStack[_orderLayerVertexIndicesStackIndex++] = initialVertexIndex;
            }
            block2: while (_orderLayerVertexIndicesStackIndex > 0) {
                long costAfterSwapping;
                int order;
                int initialVertexOrder;
                int vertexIndex = this._orderLayerVertexIndicesStack[--_orderLayerVertexIndicesStackIndex];
                int vertexOrder = initialVertexOrder = this.vertexIndexToOrder[vertexIndex];
                currNumberOfFails = 0;
                for (order = initialVertexOrder + 1; order < maxRightVertexOrder; ++order) {
                    this.move(layer, vertexOrder, order);
                    costAfterSwapping = this.calculateCost(layer, edgeIndices, additionalEdgeIndices, weights, currCost);
                    if (costAfterSwapping < currCost) {
                        ++this.orderLayerSuccessfulSwap;
                        currCost = costAfterSwapping;
                        isFoundBetterSolution = true;
                        vertexOrder = order;
                        continue;
                    }
                    ++this.orderLayerUnsuccessfulSwap;
                    this.move(layer, order, vertexOrder);
                    if (++currNumberOfFails >= numberOfFailedMoves) break;
                }
                if (isFoundBetterSolution) continue;
                currNumberOfFails = 0;
                for (order = initialVertexOrder - 1; order >= 0; --order) {
                    this.move(layer, vertexOrder, order);
                    costAfterSwapping = this.calculateCost(layer, edgeIndices, additionalEdgeIndices, weights, currCost);
                    if (costAfterSwapping < currCost) {
                        ++this.orderLayerSuccessfulSwap;
                        currCost = costAfterSwapping;
                        isFoundBetterSolution = true;
                        vertexOrder = order;
                        continue;
                    }
                    ++this.orderLayerUnsuccessfulSwap;
                    this.move(layer, order, vertexOrder);
                    if (++currNumberOfFails >= numberOfFailedMoves) continue block2;
                }
            }
            if (currCost != 0L) continue;
            break;
        }
    }

    private void swap(int layer, int vertexOrder1, int vertexOrder2) {
        int vertexIndex1 = this.layerToOrderToVertexIndices[layer][vertexOrder1];
        int vertexIndex2 = this.layerToOrderToVertexIndices[layer][vertexOrder2];
        this.vertexIndexToOrder[vertexIndex1] = vertexOrder2;
        this.vertexIndexToOrder[vertexIndex2] = vertexOrder1;
        this.layerToOrderToVertexIndices[layer][vertexOrder1] = vertexIndex2;
        this.layerToOrderToVertexIndices[layer][vertexOrder2] = vertexIndex1;
    }

    private void move(int layer, int fromVertexOrder, int toVertexOrder) {
        if (fromVertexOrder < toVertexOrder) {
            for (int order = fromVertexOrder; order < toVertexOrder; ++order) {
                this.swap(layer, order, order + 1);
            }
        } else {
            for (int order = fromVertexOrder; order > toVertexOrder; --order) {
                this.swap(layer, order, order - 1);
            }
        }
    }

    private long calculateCost(int layer, int[] edgeIndices, int[] additionalEdgeIndices, long[][] weights) {
        return this.calculateCost(layer, edgeIndices, additionalEdgeIndices, weights, Long.MAX_VALUE);
    }

    private long calculateCost(int layer, int[] edgeIndices, int[] additionalEdgeIndices, long[][] weights, long currentCost) {
        long result = 0L;
        for (long[] weight : weights) {
            long l = weight[1];
            long re = Math.multiplyExact(l, switch ((int)weight[0]) {
                case 1 -> this.countCrosses(edgeIndices);
                case 2 -> this.countCrosses(additionalEdgeIndices);
                case 3 -> this.countChainsCrossesWithTraps(layer, 3);
                case 4 -> this.countNeighborhoodAnomalies(layer);
                default -> throw new IllegalStateException("Unexpected value: " + weight[0]);
            });
            result = Math.addExact(result, re);
            if (result > currentCost) break;
        }
        return result;
    }

    private int countChainsCrossesWithTraps(int layer, int direction) {
        long startTime = System.currentTimeMillis();
        int result = 0;
        for (long chainIndexWithVertexIndex : this.layerToChainIndicesWithVertexIndices[layer]) {
            int[] bottomTrapGroupIndexToTrapVertexIndex;
            int chainIndex = (int)(chainIndexWithVertexIndex / 10000L);
            int chainVertexIndex = (int)(chainIndexWithVertexIndex % 10000L);
            if (this.vertexIndexToDisabled[chainVertexIndex]) continue;
            int chainVertexOrder = this.vertexIndexToOrder[chainVertexIndex];
            int[] topTrapGroupIndexToTrapVertexIndex = this.layerToTopTrapVertexIndices[layer];
            if (topTrapGroupIndexToTrapVertexIndex != null && topTrapGroupIndexToTrapVertexIndex.length > 0 && (direction & 2) > 0) {
                int[][] topTrapGroupsWithVertexIndices = this.layerToTopTrapGroupsWithVertexIndices[layer];
                Arrays.fill(this._countChainsCrossesWithTrapsVertexIndexToBoolean, false);
                result += this.countChainCrossesWithTraps(layer, 2, chainIndex, chainVertexOrder, topTrapGroupIndexToTrapVertexIndex, topTrapGroupsWithVertexIndices, this._countChainsCrossesWithTrapsVertexIndexToBoolean);
            }
            if ((bottomTrapGroupIndexToTrapVertexIndex = this.layerToBottomTrapVertexIndices[layer]) == null || bottomTrapGroupIndexToTrapVertexIndex.length <= 0 || (direction & 1) <= 0) continue;
            int[][] bottomTrapGroupsWithVertexIndices = this.layerToBottomTrapGroupsWithVertexIndices[layer];
            Arrays.fill(this._countChainsCrossesWithTrapsVertexIndexToBoolean, false);
            result += this.countChainCrossesWithTraps(layer, 1, chainIndex, chainVertexOrder, bottomTrapGroupIndexToTrapVertexIndex, bottomTrapGroupsWithVertexIndices, this._countChainsCrossesWithTrapsVertexIndexToBoolean);
        }
        this.countChainsCrossesWithTrapsTime += System.currentTimeMillis() - startTime;
        return result;
    }

    private int countChainCrossesWithTraps(int layer, int direction, int chainIndex, int chainVertexOrder, int[] trapGroupIndexToTrapVertexIndex, int[][] trapGroupsWithVertexIndices, boolean[] _vertexIndexToIsVisited) {
        int result = 0;
        for (int trapGroupIndex = 0; trapGroupIndex < trapGroupIndexToTrapVertexIndex.length; ++trapGroupIndex) {
            int[] trapGroupVertexIndices;
            int trapVertexIndex = trapGroupIndexToTrapVertexIndex[trapGroupIndex];
            int trapVertexType = this.vertexIndexToType[trapVertexIndex];
            int trapVertexLayer = this.vertexIndexToLayer[trapVertexIndex];
            if (direction == 1 && trapVertexLayer < layer || direction == 2 && trapVertexLayer > layer || (trapGroupVertexIndices = trapGroupsWithVertexIndices[trapGroupIndex]).length < 2) continue;
            int startChainVertexIndex = this.chainIndexToStartVertexIndex[chainIndex];
            int finishChainVertexIndex = this.chainIndexToFinishVertexIndex[chainIndex];
            int startChainVertexLayer = this.vertexIndexToLayer[startChainVertexIndex];
            int finishChainVertexLayer = this.vertexIndexToLayer[finishChainVertexIndex];
            if (trapVertexLayer < startChainVertexLayer || trapVertexLayer > finishChainVertexLayer || startChainVertexIndex == trapVertexIndex || finishChainVertexIndex == trapVertexIndex) continue;
            if (trapVertexType == 1 || trapVertexType == 2) {
                int parentTrapVertexIndex = this.cycleVertexIndexToParentVertexIndex[trapVertexIndex];
                int parentStartChainVertexIndex = this.cycleVertexIndexToParentVertexIndex[startChainVertexIndex];
                int parentFinishChainVertexIndex = this.cycleVertexIndexToParentVertexIndex[finishChainVertexIndex];
                if (parentTrapVertexIndex == parentStartChainVertexIndex || parentTrapVertexIndex == parentFinishChainVertexIndex) continue;
            }
            if (!this.isChainIntersectedWithTrap(chainIndex, chainVertexOrder, trapGroupVertexIndices, _vertexIndexToIsVisited)) continue;
            ++result;
            if (!this.enableDiagnosticMode) continue;
            log.debug("Chain {} ({} -> {}) has been intersected with trap {} on layer {}, direction {}.", new Object[]{chainIndex, startChainVertexIndex, finishChainVertexIndex, trapVertexIndex, layer, CustomConfig.directionToString(direction)});
        }
        return result;
    }

    private boolean isChainIntersectedWithTrap(int chainIndex, int chainVertexOrder, int[] trapGroupVertexIndices, boolean[] _vertexIndexToIsVisited) {
        boolean left = false;
        boolean right = false;
        for (int vertexIndex : trapGroupVertexIndices) {
            if (_vertexIndexToIsVisited[vertexIndex] || this.vertexIndexToDisabled[vertexIndex]) continue;
            int vertexOrder = this.vertexIndexToOrder[vertexIndex];
            int vertexType = this.vertexIndexToType[vertexIndex];
            if (vertexType == 1 || vertexType == 2) {
                int parentVertexIndex = this.cycleVertexIndexToParentVertexIndex[vertexIndex];
                int startChainVertexIndex = this.chainIndexToStartVertexIndex[chainIndex];
                int finishChainVertexIndex = this.chainIndexToFinishVertexIndex[chainIndex];
                int parentStartChainVertexIndex = this.cycleVertexIndexToParentVertexIndex[startChainVertexIndex];
                int parentFinishChainVertexIndex = this.cycleVertexIndexToParentVertexIndex[finishChainVertexIndex];
                if (parentVertexIndex == parentStartChainVertexIndex || parentVertexIndex == parentFinishChainVertexIndex) continue;
            }
            if (chainVertexOrder < vertexOrder) {
                right = true;
            }
            if (chainVertexOrder > vertexOrder) {
                left = true;
            }
            if (chainVertexOrder != vertexOrder && left && right) break;
        }
        if (left && right) {
            for (int vertexIndex : trapGroupVertexIndices) {
                _vertexIndexToIsVisited[vertexIndex] = true;
            }
        }
        return left && right;
    }

    private long[] countLayerToNumberOfCrossesBetweenChainsAndBottomTraps() {
        log.debug("[STARTED] Count layer -> number of crosses between chains and bottom traps.");
        long[] result = new long[this.numberOfLayers];
        for (int layer = 0; layer <= this.maxLayer; ++layer) {
            result[layer] = this.countChainsCrossesWithTraps(layer, 1);
        }
        log.debug("[FINISHED] Count layer -> number of crosses between chains and bottom traps.");
        return result;
    }

    private long[] countLayerToNumberOfCrossesBetweenChainsAndTopTraps() {
        log.debug("[STARTED] Count layer -> number of crosses between chains and top traps.");
        long[] result = new long[this.numberOfLayers];
        for (int layer = this.maxLayer; layer >= 0; --layer) {
            result[layer] = this.countChainsCrossesWithTraps(layer, 2);
        }
        log.debug("[FINISHED] Count layer -> number of crosses between chains and top traps.");
        return result;
    }

    private long[] countLayerToNumberOfNeighborhoodAnomalies() {
        long[] layerToNumberOfNeighborhoodAnomalies = new long[this.numberOfLayers];
        for (int layer = 0; layer <= this.maxLayer; ++layer) {
            layerToNumberOfNeighborhoodAnomalies[layer] = this.countNeighborhoodAnomalies(layer);
        }
        return layerToNumberOfNeighborhoodAnomalies;
    }

    private long countNeighborhoodAnomalies(int layer) {
        int order;
        int number;
        int minOrder;
        int maxOrder;
        long startTime = System.currentTimeMillis();
        int result = 0;
        if (layer - 1 >= 0) {
            for (int vertexIndex : this.layerToVertexIndices[layer - 1]) {
                if (this.vertexIndexToDisabled[vertexIndex]) continue;
                int[] outputVertexIndices = this.vertexIndexToOutputVertexIndices[vertexIndex];
                maxOrder = Integer.MIN_VALUE;
                minOrder = Integer.MAX_VALUE;
                number = 0;
                for (int outputVertexIndex : outputVertexIndices) {
                    if (this.vertexIndexToDisabled[outputVertexIndex]) continue;
                    order = this.vertexIndexToOrder[outputVertexIndex];
                    if (order < minOrder) {
                        minOrder = order;
                    }
                    if (order > maxOrder) {
                        maxOrder = order;
                    }
                    ++number;
                }
                if (number <= 1) continue;
                result += (maxOrder - minOrder - number + 1) * this.vertexIndexToWeight[vertexIndex];
            }
        }
        if (layer + 1 <= this.maxLayer) {
            for (int vertexIndex : this.layerToVertexIndices[layer + 1]) {
                if (this.vertexIndexToDisabled[vertexIndex]) continue;
                int[] inputVertexIndices = this.vertexIndexToInputVertexIndices[vertexIndex];
                maxOrder = Integer.MIN_VALUE;
                minOrder = Integer.MAX_VALUE;
                number = 0;
                for (int inputVertexIndex : inputVertexIndices) {
                    if (this.vertexIndexToDisabled[inputVertexIndex]) continue;
                    order = this.vertexIndexToOrder[inputVertexIndex];
                    if (order < minOrder) {
                        minOrder = order;
                    }
                    if (order > maxOrder) {
                        maxOrder = order;
                    }
                    ++number;
                }
                if (number <= 1) continue;
                result += (maxOrder - minOrder - number + 1) * this.vertexIndexToWeight[vertexIndex];
            }
        }
        this.countNeighborhoodAnomaliesTime += System.currentTimeMillis() - startTime;
        if (result >= 50000) {
            log.warn("countNeighborhoodAnomalies result = {}", (Object)result);
            result = 49999;
        }
        return result;
    }

    private int countCrosses() {
        int crosses = 0;
        for (int layer = 0; layer < this.maxLayer; ++layer) {
            crosses += this.countCrosses(this.layerToOutputEdgeIndices[layer]);
        }
        return crosses;
    }

    private long[] countLayerToNumberOfCrossesFromTopToBottom() {
        long[] result = new long[this.numberOfLayers];
        for (int layer = 0; layer <= this.maxLayer; ++layer) {
            result[layer] = this.countCrosses(this.layerToInputEdgeIndices[layer]);
        }
        return result;
    }

    private long[] countLayerToNumberOfCrossesFromBottomToTop() {
        long[] result = new long[this.numberOfLayers];
        for (int layer = 0; layer <= this.maxLayer; ++layer) {
            result[layer] = this.countCrosses(this.layerToOutputEdgeIndices[layer]);
        }
        return result;
    }

    private int countCrosses(int[] edgeIndices) {
        long startTime = System.currentTimeMillis();
        int result = 0;
        for (int i = 0; i < edgeIndices.length; ++i) {
            int edgeIndex1 = edgeIndices[i];
            for (int j = i + 1; j < edgeIndices.length; ++j) {
                int edgeIndex2 = edgeIndices[j];
                int srcVertexIndex1 = this.edgeIndexToSrcVertexIndex[edgeIndex1];
                int trgVertexIndex1 = this.edgeIndexToTrgVertexIndex[edgeIndex1];
                int srcPortIndex1 = this.edgeIndexToSrcPortIndex[edgeIndex1];
                int trgPortIndex1 = this.edgeIndexToTrgPortIndex[edgeIndex1];
                int srcVertexOrder1 = this.vertexIndexToOrder[srcVertexIndex1];
                int trgVertexOrder1 = this.vertexIndexToOrder[trgVertexIndex1];
                int srcVertexIndex2 = this.edgeIndexToSrcVertexIndex[edgeIndex2];
                int trgVertexIndex2 = this.edgeIndexToTrgVertexIndex[edgeIndex2];
                int srcPortIndex2 = this.edgeIndexToSrcPortIndex[edgeIndex2];
                int trgPortIndex2 = this.edgeIndexToTrgPortIndex[edgeIndex2];
                int srcVertexOrder2 = this.vertexIndexToOrder[srcVertexIndex2];
                int trgVertexOrder2 = this.vertexIndexToOrder[trgVertexIndex2];
                if (this.vertexIndexToDisabled[srcVertexIndex1] || this.vertexIndexToDisabled[srcVertexIndex2] || this.vertexIndexToDisabled[trgVertexIndex1] || this.vertexIndexToDisabled[trgVertexIndex2] || (this.edgeIndexToType[edgeIndex1] == 8 || this.edgeIndexToType[edgeIndex2] == 8) && this.cycleVertexIndexToParentVertexIndex[srcVertexIndex1] == this.cycleVertexIndexToParentVertexIndex[srcVertexIndex2] && this.cycleVertexIndexToParentVertexIndex[srcVertexIndex1] >= 0 || (this.edgeIndexToType[edgeIndex1] == 4 || this.edgeIndexToType[edgeIndex2] == 4) && this.cycleVertexIndexToParentVertexIndex[trgVertexIndex1] == this.cycleVertexIndexToParentVertexIndex[trgVertexIndex2] && this.cycleVertexIndexToParentVertexIndex[trgVertexIndex1] >= 0) continue;
                if (srcVertexIndex1 == srcVertexIndex2 && trgVertexIndex1 == trgVertexIndex2) {
                    if (srcPortIndex1 < 0 || srcPortIndex2 < 0 || trgPortIndex1 < 0 || trgPortIndex2 < 0 || srcPortIndex1 == srcPortIndex2 || trgPortIndex1 == trgPortIndex2) continue;
                    if (srcPortIndex1 < srcPortIndex2 && trgPortIndex1 > trgPortIndex2) {
                        ++result;
                        continue;
                    }
                    if (srcPortIndex1 <= srcPortIndex2 || trgPortIndex1 >= trgPortIndex2) continue;
                    ++result;
                    continue;
                }
                if (srcVertexIndex1 == srcVertexIndex2 && srcPortIndex1 >= 0 && srcPortIndex2 >= 0) {
                    if (srcPortIndex1 == srcPortIndex2) continue;
                    if (srcPortIndex1 < srcPortIndex2 && trgVertexOrder1 > trgVertexOrder2) {
                        ++result;
                        continue;
                    }
                    if (srcPortIndex1 > srcPortIndex2 && trgVertexOrder1 < trgVertexOrder2) {
                        ++result;
                        continue;
                    }
                }
                if (trgVertexIndex1 == trgVertexIndex2 && trgPortIndex1 >= 0 && trgPortIndex2 >= 0) {
                    if (trgPortIndex1 == trgPortIndex2) continue;
                    if (srcVertexOrder1 < srcVertexOrder2 && trgPortIndex1 > trgPortIndex2) {
                        ++result;
                        continue;
                    }
                    if (srcVertexOrder1 > srcVertexOrder2 && trgPortIndex1 < trgPortIndex2) {
                        ++result;
                        continue;
                    }
                }
                if (srcVertexIndex1 == srcVertexIndex2 || trgVertexIndex1 == trgVertexIndex2 || srcVertexOrder1 < srcVertexOrder2 && trgVertexOrder1 < trgVertexOrder2 || srcVertexOrder1 > srcVertexOrder2 && trgVertexOrder1 > trgVertexOrder2) continue;
                ++result;
            }
        }
        this.countCrossesTime += System.currentTimeMillis() - startTime;
        return result;
    }

    private int[][] findLayerToVertexIndices() {
        int layer;
        int[] layerToNumberOfVertices = new int[this.numberOfLayers];
        for (int vertexIndex = 0; vertexIndex < this.numberOfVertices; ++vertexIndex) {
            int n = layer = this.vertexIndexToLayer[vertexIndex];
            layerToNumberOfVertices[n] = layerToNumberOfVertices[n] + 1;
        }
        int[][] layerToVertexIndices = new int[this.numberOfLayers][];
        for (layer = 0; layer < this.numberOfLayers; ++layer) {
            layerToVertexIndices[layer] = new int[layerToNumberOfVertices[layer]];
        }
        int[] layerToCurrentNumberOfVertices = new int[this.numberOfLayers];
        int vertexIndex = 0;
        while (vertexIndex < this.numberOfVertices) {
            int layer2;
            int n = layer2 = this.vertexIndexToLayer[vertexIndex];
            layerToCurrentNumberOfVertices[n] = layerToCurrentNumberOfVertices[n] + 1;
            layerToVertexIndices[layer2][currentNumberOfVertices] = vertexIndex++;
        }
        return layerToVertexIndices;
    }

    private int[] findVertexIndexToType() {
        int[] result = new int[this.numberOfVertices];
        for (int vertexIndex = 0; vertexIndex < this.numberOfVertices; ++vertexIndex) {
            result[vertexIndex] = 4;
            if (!this.vertexIndexToIsDummy[vertexIndex]) continue;
            result[vertexIndex] = 3;
            if (this.vertexIndexToOutputEdgeIndices[vertexIndex].length == 2 && this.vertexIndexToInputEdgeIndices[vertexIndex].length == 0) {
                result[vertexIndex] = 2;
            }
            if (this.vertexIndexToOutputEdgeIndices[vertexIndex].length != 0 || this.vertexIndexToInputEdgeIndices[vertexIndex].length != 2) continue;
            result[vertexIndex] = 1;
        }
        return result;
    }

    private int[] findEdgeTypes() {
        int[] result = new int[this.numberOfEdges];
        for (int edgeIndex = 0; edgeIndex < this.numberOfEdges; ++edgeIndex) {
            result[edgeIndex] = 48;
            int srcVertexIndex = this.edgeIndexToSrcVertexIndex[edgeIndex];
            int trgVertexIndex = this.edgeIndexToTrgVertexIndex[edgeIndex];
            if (!this.vertexIndexToIsDummy[srcVertexIndex] && !this.vertexIndexToIsDummy[trgVertexIndex]) {
                if (this.vertexIndexToInputEdgeIndices[trgVertexIndex].length <= 1 && this.vertexIndexToOutputEdgeIndices[trgVertexIndex].length <= 1) {
                    result[edgeIndex] = 16;
                    continue;
                }
                if (this.vertexIndexToInputEdgeIndices[srcVertexIndex].length <= 1 && this.vertexIndexToOutputEdgeIndices[srcVertexIndex].length <= 1) {
                    result[edgeIndex] = 16;
                    continue;
                }
            }
            if (this.vertexIndexToIsDummy[srcVertexIndex] || this.vertexIndexToIsDummy[trgVertexIndex]) {
                result[edgeIndex] = 15;
            }
            if (!this.vertexIndexToIsDummy[srcVertexIndex] && this.vertexIndexToIsDummy[trgVertexIndex]) {
                int[] trgInputEdgeIndices = this.vertexIndexToInputEdgeIndices[trgVertexIndex];
                int[] trgOutputEdgeIndices = this.vertexIndexToOutputEdgeIndices[trgVertexIndex];
                if (trgInputEdgeIndices.length == 1 && trgOutputEdgeIndices.length == 0) {
                    result[edgeIndex] = 1;
                }
                if (trgInputEdgeIndices.length == 2 && trgOutputEdgeIndices.length == 0) {
                    int inputEdgeIndex0 = trgInputEdgeIndices[0];
                    int inputEdgeIndex1 = trgInputEdgeIndices[1];
                    int srcVertexIndex0 = this.edgeIndexToSrcVertexIndex[inputEdgeIndex0];
                    int srcVertexIndex1 = this.edgeIndexToSrcVertexIndex[inputEdgeIndex1];
                    if (this.vertexIndexToIsDummy[srcVertexIndex0] && !this.vertexIndexToIsDummy[srcVertexIndex1] || !this.vertexIndexToIsDummy[srcVertexIndex0] && this.vertexIndexToIsDummy[srcVertexIndex1]) {
                        result[edgeIndex] = 4;
                    }
                }
            }
            if (!this.vertexIndexToIsDummy[srcVertexIndex] || this.vertexIndexToIsDummy[trgVertexIndex]) continue;
            int[] srcOutputEdgeIndices = this.vertexIndexToOutputEdgeIndices[srcVertexIndex];
            int[] srcInputEdgeIndices = this.vertexIndexToInputEdgeIndices[srcVertexIndex];
            if (srcOutputEdgeIndices.length == 1 && srcInputEdgeIndices.length == 0) {
                result[edgeIndex] = 2;
            }
            if (srcOutputEdgeIndices.length != 2 || srcInputEdgeIndices.length != 0) continue;
            int outputEdgeIndex0 = srcOutputEdgeIndices[0];
            int outputEdgeIndex1 = srcOutputEdgeIndices[1];
            int trgVertexIndex0 = this.edgeIndexToTrgVertexIndex[outputEdgeIndex0];
            int trgVertexIndex1 = this.edgeIndexToTrgVertexIndex[outputEdgeIndex1];
            if ((!this.vertexIndexToIsDummy[trgVertexIndex0] || this.vertexIndexToIsDummy[trgVertexIndex1]) && (this.vertexIndexToIsDummy[trgVertexIndex0] || !this.vertexIndexToIsDummy[trgVertexIndex1])) continue;
            result[edgeIndex] = 8;
        }
        return result;
    }

    private int[] findCycleVertexIndexToParentVertexIndex() {
        int[] result = new int[this.numberOfVertices];
        Arrays.fill(result, -1);
        for (int vertexIndex = 0; vertexIndex < this.numberOfVertices; ++vertexIndex) {
            if (this.vertexIndexToType[vertexIndex] == 1) {
                int[] inputEdgeIndices = this.vertexIndexToInputEdgeIndices[vertexIndex];
                int inputEdgeIndex0 = inputEdgeIndices[0];
                int inputEdgeIndex1 = inputEdgeIndices[1];
                int srcVertexIndex0 = this.edgeIndexToSrcVertexIndex[inputEdgeIndex0];
                int srcVertexIndex1 = this.edgeIndexToSrcVertexIndex[inputEdgeIndex1];
                if (this.vertexIndexToType[srcVertexIndex0] == 4 && this.vertexIndexToType[srcVertexIndex1] == 3) {
                    result[vertexIndex] = srcVertexIndex0;
                }
                if (this.vertexIndexToType[srcVertexIndex1] == 4 && this.vertexIndexToType[srcVertexIndex0] == 3) {
                    result[vertexIndex] = srcVertexIndex1;
                }
            }
            if (this.vertexIndexToType[vertexIndex] != 2) continue;
            int[] outputEdgeIndices = this.vertexIndexToOutputEdgeIndices[vertexIndex];
            int outputEdgeIndex0 = outputEdgeIndices[0];
            int outputEdgeIndex1 = outputEdgeIndices[1];
            int trgVertexIndex0 = this.edgeIndexToTrgVertexIndex[outputEdgeIndex0];
            int trgVertexIndex1 = this.edgeIndexToTrgVertexIndex[outputEdgeIndex1];
            if (this.vertexIndexToType[trgVertexIndex0] == 4 && this.vertexIndexToType[trgVertexIndex1] == 3) {
                result[vertexIndex] = trgVertexIndex0;
            }
            if (this.vertexIndexToType[trgVertexIndex1] != 4 || this.vertexIndexToType[trgVertexIndex0] != 3) continue;
            result[vertexIndex] = trgVertexIndex1;
        }
        return result;
    }

    private boolean[] findVertexIndexToIsFixed(Map<UUID, Integer> vertexIdToInitialOrder, UUID[] vertexIndexToId) {
        boolean[] result = new boolean[vertexIndexToId.length];
        for (int vertexIndex = 0; vertexIndex < vertexIndexToId.length; ++vertexIndex) {
            UUID vertexId = vertexIndexToId[vertexIndex];
            Integer initialVertexOrder = vertexIdToInitialOrder.get(vertexId);
            if (initialVertexOrder == null || initialVertexOrder < 0) continue;
            result[vertexIndex] = true;
        }
        return result;
    }

    private boolean[] findVertexToIsDummy(List<UUID> dummyVertices, Map<UUID, Integer> vertexIdToIndex) {
        boolean[] result = new boolean[this.numberOfVertices];
        for (UUID dummyVertex : dummyVertices) {
            Integer vertexIndex = vertexIdToIndex.get(dummyVertex);
            result[vertexIndex.intValue()] = true;
        }
        return result;
    }

    private int layerToFirstDisabledVertexOrder(int layer) {
        int currentOrder = 0;
        for (int vertexIndex : this.layerToOrderToVertexIndices[layer]) {
            if (this.vertexIndexToDisabled[vertexIndex]) break;
            ++currentOrder;
        }
        assert (this.verticesAreDisabled(layer, currentOrder));
        return currentOrder;
    }

    @Deprecated
    private void diagnosticPrintGroups() {
        int maxWeight;
        for (int weight = maxWeight = this.weightToVertexIndices.length - 1; weight >= 0; --weight) {
            log.debug("=====================================");
            log.debug("Weight = {}, direction = {}.", (Object)weight, (Object)CustomConfig.directionToString(this.weightToDirection[weight]));
            for (int vertexIndex = 0; vertexIndex < this.numberOfVertices; ++vertexIndex) {
                if (this.vertexIndexToWeight[vertexIndex] != weight) continue;
                log.debug(this.vertexIdToName.get(this.vertexIndexToId[vertexIndex]) + "   LAYER = " + this.vertexIndexToLayer[vertexIndex]);
            }
            log.debug("=====================================");
        }
    }

    private boolean verticesAreDisabled(int layer, int startVertexOrder) {
        for (int order = startVertexOrder; order < this.layerToOrderToVertexIndices[layer].length; ++order) {
            int vertexIndex = this.layerToOrderToVertexIndices[layer][order];
            if (this.vertexIndexToDisabled[vertexIndex]) continue;
            return false;
        }
        return true;
    }

    private record TryToFindBetterSolutionResult(int crossesBefore, int crossesAfter) {
    }
}

