/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.step2;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vg.lib.layout.hierarchical.data.HierarchicalGraph;
import vg.lib.layout.hierarchical.data.HierarchicalVertex;
import vg.lib.operation.Procedure;

public class SetOrderForVerticesByDefaultCrossingReductionProcedure
implements Procedure {
    private static final Logger log = LoggerFactory.getLogger(SetOrderForVerticesByDefaultCrossingReductionProcedure.class);
    private final HierarchicalGraph graph;

    public SetOrderForVerticesByDefaultCrossingReductionProcedure(HierarchicalGraph graph) {
        this.graph = graph;
    }

    @Override
    public void execute() {
        log.debug("Set order for vertices by default in the crossing reduction operation...");
        this.graph.getVertices().forEach(x -> x.setOrder(-1));
        HierarchicalVertex.setupDefaultOrderForElements(this.graph.getInputPorts());
        HierarchicalVertex.setupDefaultOrderForElements(this.graph.getOutputPorts());
        HierarchicalVertex.setupDefaultOrderForElements(this.graph.getFirstRow());
        int prevGroupOrder = 0;
        Map<Integer, TreeMap<Integer, List<HierarchicalVertex>>> detailedGroups = this.graph.getDetailedGroups();
        log.debug("Amount of detailed groups '{}'.", (Object)detailedGroups.size());
        for (Map.Entry<Integer, TreeMap<Integer, List<HierarchicalVertex>>> detailedGroupEntry : detailedGroups.entrySet()) {
            log.debug("Handle detailed group '{}'.", (Object)detailedGroupEntry.getKey());
            Map.Entry<Integer, List<HierarchicalVertex>> parentEntry = null;
            for (Map.Entry<Integer, List<HierarchicalVertex>> levelEntry : detailedGroupEntry.getValue().entrySet()) {
                log.debug("Handle level '{}' of detailed group '{}'.", (Object)levelEntry.getKey(), (Object)detailedGroupEntry.getKey());
                if (parentEntry != null) {
                    HierarchicalVertex.setupDefaultOrderForElements(levelEntry.getValue());
                } else {
                    for (int i = 0; i < levelEntry.getValue().size(); ++i) {
                        levelEntry.getValue().get(i).setOrder(i);
                    }
                }
                parentEntry = levelEntry;
            }
            prevGroupOrder = HierarchicalGraph.shiftOrderForDetailedGroup(prevGroupOrder, (Map<Integer, List<HierarchicalVertex>>)detailedGroupEntry.getValue()) + 1;
        }
        log.debug("Crossing reduction operation was finished.");
    }
}

