/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.step1;

import java.util.ArrayList;
import java.util.UUID;
import vg.lib.layout.hierarchical.data.HierarchicalBackwardEdge;
import vg.lib.layout.hierarchical.data.HierarchicalGraph;
import vg.lib.layout.hierarchical.data.HierarchicalVertex;
import vg.lib.layout.hierarchical.data.VertexType;
import vg.lib.operation.Procedure;

public class InsertBeaconsProcedure
implements Procedure {
    private final HierarchicalGraph graph;

    public InsertBeaconsProcedure(HierarchicalGraph graph) {
        this.graph = graph;
    }

    @Override
    public void execute() {
        ArrayList<UUID> topEdgeIds = new ArrayList<UUID>();
        for (HierarchicalBackwardEdge backwardEdge : this.graph.getBackwardEdges().values()) {
            topEdgeIds.add(backwardEdge.getTopEdgeId());
        }
        ArrayList<UUID> bottomEdgeIds = new ArrayList<UUID>();
        for (HierarchicalBackwardEdge backwardEdge : this.graph.getBackwardEdges().values()) {
            bottomEdgeIds.add(backwardEdge.getBottomEdgeId());
        }
        for (HierarchicalBackwardEdge backwardEdge : this.graph.getBackwardEdges().values()) {
            HierarchicalVertex trgVertex;
            HierarchicalVertex srcVertex = backwardEdge.getSrcVertex();
            if (bottomEdgeIds.containsAll(srcVertex.getOutputEdges())) {
                HierarchicalVertex beacon = this.graph.addFakeVertex(backwardEdge.getSrcCompanionVertex().getLevel(), srcVertex.getGroupId(), String.format("BB: %s", srcVertex.getName()));
                beacon.setType(VertexType.BOTTOM_BEACON_VERTEX_TYPE);
                this.graph.addFakeEdge(srcVertex, beacon);
            }
            if (!topEdgeIds.containsAll((trgVertex = backwardEdge.getTrgVertex()).getInputEdges())) continue;
            HierarchicalVertex beacon = this.graph.addFakeVertex(backwardEdge.getTrgCompanionVertex().getLevel(), trgVertex.getGroupId(), String.format("TB: %s", trgVertex.getName()));
            beacon.setType(VertexType.TOP_BEACON_VERTEX_TYPE);
            this.graph.addFakeEdge(beacon, trgVertex);
        }
        this.graph.reCalculateRoots();
    }
}

